/*
#	Le livre de Java 1er langage
#	A. Tasso
#	Chapitre 12 : Créer une interface graphique
#	Section  : Projet
#	Fichier  : Main.java
#	Class    : Main
*/

// Le fichier Main.java se trouve dans le répertoire 
// Sources/Projet/Chapitre12/NetBeansProjects/ProjetChapitre12/src/Projet

package Projet;

import javax.swing.ImageIcon;

public class Main extends javax.swing.JFrame {
     // Définition des propriétés
     String choixAction = "Creer";
     String numeroCompte = " " ;
 

    public Main() {
        initComponents();
        this.setBounds(100, 100,500, 600);
        // Affichage d'une image en fond de fenêtre
        ImageIcon iconPhoto = new ImageIcon("Ressources/FondMain.png");
        photoFond.setIcon(iconPhoto);
        
        // Créer un groupe de boutons
        creerGroupeBox();
      
        
    }
    private void creerGroupeBox() {   
         groupeBtn.add(creerRdBtn);
         groupeBtn.add(modifierRdBtn);
         groupeBtn.add(editerRdBtn);
         creerRdBtn.setSelected(true);
    }

    /**
     * This method is called from within the constructor to initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is always
     * regenerated by the Form Editor.
     */
    @SuppressWarnings("unchecked")
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {

        groupeBtn = new javax.swing.ButtonGroup();
        grandeBoite = new javax.swing.JPanel();
        boiteMenu = new javax.swing.JPanel();
        creerRdBtn = new javax.swing.JRadioButton();
        modifierRdBtn = new javax.swing.JRadioButton();
        editerRdBtn = new javax.swing.JRadioButton();
        boiteSaisie = new javax.swing.JPanel();
        numeroAsaisir = new javax.swing.JTextField();
        btnOK = new javax.swing.JButton();
        photoFond = new javax.swing.JLabel();
        barreMenu = new javax.swing.JMenuBar();
        menuMichier = new javax.swing.JMenu();
        quitter = new javax.swing.JMenuItem();

        setDefaultCloseOperation(javax.swing.WindowConstants.EXIT_ON_CLOSE);

        boiteMenu.setBorder(javax.swing.BorderFactory.createTitledBorder("   Comptes   "));

        creerRdBtn.setText("Créer");
        creerRdBtn.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                creerRdBtnActionPerformed(evt);
            }
        });

        modifierRdBtn.setText("Ajouter une ligne comptable");
        modifierRdBtn.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                modifierRdBtnActionPerformed(evt);
            }
        });

        editerRdBtn.setText("Éditer");
        editerRdBtn.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                editerRdBtnActionPerformed(evt);
            }
        });

        javax.swing.GroupLayout boiteMenuLayout = new javax.swing.GroupLayout(boiteMenu);
        boiteMenu.setLayout(boiteMenuLayout);
        boiteMenuLayout.setHorizontalGroup(
            boiteMenuLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(boiteMenuLayout.createSequentialGroup()
                .addGap(100, 100, 100)
                .addGroup(boiteMenuLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addComponent(editerRdBtn)
                    .addComponent(creerRdBtn)
                    .addComponent(modifierRdBtn))
                .addContainerGap(108, Short.MAX_VALUE))
        );
        boiteMenuLayout.setVerticalGroup(
            boiteMenuLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(boiteMenuLayout.createSequentialGroup()
                .addGap(12, 12, 12)
                .addComponent(creerRdBtn)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.UNRELATED)
                .addComponent(modifierRdBtn)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.UNRELATED)
                .addComponent(editerRdBtn)
                .addContainerGap(18, Short.MAX_VALUE))
        );

        boiteSaisie.setBorder(javax.swing.BorderFactory.createTitledBorder("  Numéro :   "));

        numeroAsaisir.setHorizontalAlignment(javax.swing.JTextField.RIGHT);

        btnOK.setText("OK");
        btnOK.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                btnOKActionPerformed(evt);
            }
        });

        javax.swing.GroupLayout boiteSaisieLayout = new javax.swing.GroupLayout(boiteSaisie);
        boiteSaisie.setLayout(boiteSaisieLayout);
        boiteSaisieLayout.setHorizontalGroup(
            boiteSaisieLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(boiteSaisieLayout.createSequentialGroup()
                .addGap(95, 95, 95)
                .addComponent(numeroAsaisir, javax.swing.GroupLayout.PREFERRED_SIZE, 93, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addGap(86, 86, 86)
                .addComponent(btnOK)
                .addContainerGap(javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
        );
        boiteSaisieLayout.setVerticalGroup(
            boiteSaisieLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(boiteSaisieLayout.createSequentialGroup()
                .addGroup(boiteSaisieLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(numeroAsaisir, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                    .addComponent(btnOK))
                .addContainerGap(javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
        );

        javax.swing.GroupLayout grandeBoiteLayout = new javax.swing.GroupLayout(grandeBoite);
        grandeBoite.setLayout(grandeBoiteLayout);
        grandeBoiteLayout.setHorizontalGroup(
            grandeBoiteLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(grandeBoiteLayout.createSequentialGroup()
                .addContainerGap()
                .addGroup(grandeBoiteLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING, false)
                    .addComponent(boiteSaisie, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                    .addComponent(boiteMenu, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
                .addContainerGap())
        );
        grandeBoiteLayout.setVerticalGroup(
            grandeBoiteLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(javax.swing.GroupLayout.Alignment.TRAILING, grandeBoiteLayout.createSequentialGroup()
                .addContainerGap(20, Short.MAX_VALUE)
                .addComponent(boiteMenu, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(boiteSaisie, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
        );

        getContentPane().add(grandeBoite, java.awt.BorderLayout.PAGE_START);

        photoFond.setText("photoDuFond");
        photoFond.setVerticalAlignment(javax.swing.SwingConstants.BOTTOM);
        photoFond.setVerticalTextPosition(javax.swing.SwingConstants.BOTTOM);
        getContentPane().add(photoFond, java.awt.BorderLayout.CENTER);

        menuMichier.setText("Fichier");

        quitter.setAccelerator(javax.swing.KeyStroke.getKeyStroke(java.awt.event.KeyEvent.VK_Q, java.awt.event.InputEvent.CTRL_MASK));
        quitter.setText("Quitter");
        quitter.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                quitterActionPerformed(evt);
            }
        });
        menuMichier.add(quitter);

        barreMenu.add(menuMichier);

        setJMenuBar(barreMenu);

        pack();
    }// </editor-fold>//GEN-END:initComponents

    private void quitterActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_quitterActionPerformed
        // Quitter l'application
        System.exit(0);
    }//GEN-LAST:event_quitterActionPerformed

    private void creerRdBtnActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_creerRdBtnActionPerformed
        // Initialiser l'action à "Creer"
        choixAction = "Creer";
    }//GEN-LAST:event_creerRdBtnActionPerformed

    private void modifierRdBtnActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_modifierRdBtnActionPerformed
        // Initialiser l'action à "Modifier"
        choixAction = "Modifier";
    }//GEN-LAST:event_modifierRdBtnActionPerformed

    private void editerRdBtnActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_editerRdBtnActionPerformed
        // Initialiser l'action à "Modifier"
        choixAction = "Editer";
    }//GEN-LAST:event_editerRdBtnActionPerformed

    private void btnOKActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_btnOKActionPerformed
        // Récupérer le numéro du compte
        numeroCompte = numeroAsaisir.getText();
        // Si l'action est "Creer"
        if(choixAction.equals("Creer")){
            // Ouvrir la boite de dialogue CompteDaliogue
            new CompteDialogue(numeroCompte);

        }
        // Si l'action est "Modifier"
        else  if(choixAction.equals("Modifier")){
            // Lire le fichier associé au compte
            FichierCompte fc = new FichierCompte();
            if (fc.ouvrir("Comptes/"+numeroCompte+".dat","R")) {
                // Si le fichier existe, stocker les informations lues dans un objet unCompte
                Compte unCompte = fc.lire();
                fc.fermer();
                // Ouvrir la boite de dialogue LigneDialogue en passant en paramètre les informations lues
                new LigneDialogue(unCompte);
            }
            // Si le fichier n'existe pas, afficher un message d'alerte
            else new Message("Le compte : ", numeroCompte , " n'existe pas");
        }
        // Si l'action est "Editer"
        else  if(choixAction.equals("Editer")){
            // Lire le fichier associé au compte
            FichierCompte fc = new FichierCompte();
            if (fc.ouvrir("Comptes/"+numeroCompte+".dat","R")){
                // Si le fichier existe, stocker les informations lues dans un objet unCompte
                Compte unCompte = fc.lire();
                fc.fermer();
                // Ouvrir la boite de dialogue CompteEdit en passant en paramètre les informations lues
                new CompteEdit(unCompte);
            }
            // Si le fichier n'existe pas, afficher un message d'alerte
            else new Message("Le compte : ", numeroCompte , " n'existe pas");
        }

    }//GEN-LAST:event_btnOKActionPerformed

    /**
     * @param args the command line arguments
     */
    public static void main(String args[]) {
        /* Set the Nimbus look and feel */
        //<editor-fold defaultstate="collapsed" desc=" Look and feel setting code (optional) ">
        /* If Nimbus (introduced in Java SE 6) is not available, stay with the default look and feel.
         * For details see http://download.oracle.com/javase/tutorial/uiswing/lookandfeel/plaf.html 
         */
        try {
            for (javax.swing.UIManager.LookAndFeelInfo info : javax.swing.UIManager.getInstalledLookAndFeels()) {
                if ("Nimbus".equals(info.getName())) {
                    javax.swing.UIManager.setLookAndFeel(info.getClassName());
                    break;
                }
            }
        } catch (ClassNotFoundException ex) {
            java.util.logging.Logger.getLogger(Main.class.getName()).log(java.util.logging.Level.SEVERE, null, ex);
        } catch (InstantiationException ex) {
            java.util.logging.Logger.getLogger(Main.class.getName()).log(java.util.logging.Level.SEVERE, null, ex);
        } catch (IllegalAccessException ex) {
            java.util.logging.Logger.getLogger(Main.class.getName()).log(java.util.logging.Level.SEVERE, null, ex);
        } catch (javax.swing.UnsupportedLookAndFeelException ex) {
            java.util.logging.Logger.getLogger(Main.class.getName()).log(java.util.logging.Level.SEVERE, null, ex);
        }
        //</editor-fold>

        /* Create and display the form */
        java.awt.EventQueue.invokeLater(new Runnable() {
            public void run() {
                new Main().setVisible(true);
            }
        });
    }

    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JMenuBar barreMenu;
    private javax.swing.JPanel boiteMenu;
    private javax.swing.JPanel boiteSaisie;
    private javax.swing.JButton btnOK;
    private javax.swing.JRadioButton creerRdBtn;
    private javax.swing.JRadioButton editerRdBtn;
    private javax.swing.JPanel grandeBoite;
    private javax.swing.ButtonGroup groupeBtn;
    private javax.swing.JMenu menuMichier;
    private javax.swing.JRadioButton modifierRdBtn;
    private javax.swing.JTextField numeroAsaisir;
    private javax.swing.JLabel photoFond;
    private javax.swing.JMenuItem quitter;
    // End of variables declaration//GEN-END:variables
}
