/*
#	Le livre de Java 1er langage
#	A. Tasso
#	Chapitre 12 : Créer une interface graphique
#	Section  : Projet
#	Fichier  : CompteEdit.java
#	Class    : CompteEdit
*/

// Le fichier CompteEdit.java se trouve dans le répertoire 
// Sources/Projet/Chapitre12/NetBeansProjects/ProjetChapitre12/src/Projet

package Projet;

import java.awt.Color;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.border.Border;

public class CompteEdit extends javax.swing.JFrame {

    public CompteEdit(Compte cpt) {
      initComponents();
      // Afficher le type, le numéro et le solde du compte dans le cadre du composant
      Border cadre = BorderFactory.createTitledBorder("   Compte " +  cpt.getType()+ "  n°  " + cpt.getNumero()+ "  : " +  cpt.getSolde()+ " Euros  ");
      entete.setBorder(cadre);
      setBounds(500, 230,500, 600);
      setVisible(true);
      // Afficher d'une image en fond de fenêtre
      ImageIcon iconPhoto = new ImageIcon("Ressources/FondEdit.png");
      photoFond.setIcon(iconPhoto);
      // Récupérer le contenu des lignes comptables
      ArrayList<LigneComptable> tmp = cpt.getLigne();
      int nbLignes = tmp.size();
      // Récupérer le solde du compte
      double solde = cpt.getSolde();
      // Si le solde est négatif l'afficher en rouge
      if (solde < 0) soldeValeur.setForeground(Color.RED);
      // Sinon l'afficher en noir
      else soldeValeur.setForeground(Color.BLACK);
      soldeValeur.setText(Double.toString(cpt.getSolde()));
      
      if (nbLignes > 0) {
 	for (LigneComptable lc : tmp){
            // Pour chaque ligne comptable ,créer un objet de type LigneEdit
            // Ajoutr l'objet au conteneur boiteLigne.
              boiteLigne.add(new LigneEdit(lc));
        }
      }
      else {
 	System.out.println("La liste des formes est vide  ");
      }
    }

    /**
     * This method is called from within the constructor to initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is always
     * regenerated by the Form Editor.
     */
    @SuppressWarnings("unchecked")
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {

        photoFond = new javax.swing.JLabel();
        entete = new javax.swing.JPanel();
        labelMotif = new javax.swing.JLabel();
        labelTransaction = new javax.swing.JLabel();
        labelSolde1 = new javax.swing.JLabel();
        boiteLigne = new javax.swing.JPanel();
        btnOK = new javax.swing.JButton();
        labelSolde = new javax.swing.JLabel();
        jSeparator1 = new javax.swing.JSeparator();
        soldeValeur = new javax.swing.JLabel();
        labelEuros = new javax.swing.JLabel();

        setDefaultCloseOperation(javax.swing.WindowConstants.EXIT_ON_CLOSE);

        photoFond.setText("jLabel1");

        entete.setPreferredSize(new java.awt.Dimension(400, 40));
        entete.setLayout(new java.awt.GridLayout(1, 3));

        labelMotif.setHorizontalAlignment(javax.swing.SwingConstants.LEFT);
        labelMotif.setText("Motif");
        entete.add(labelMotif);

        labelTransaction.setHorizontalAlignment(javax.swing.SwingConstants.LEFT);
        labelTransaction.setText("Transaction");
        labelTransaction.setHorizontalTextPosition(javax.swing.SwingConstants.LEFT);
        entete.add(labelTransaction);

        labelSolde1.setHorizontalAlignment(javax.swing.SwingConstants.RIGHT);
        labelSolde1.setText("Valeur ");
        entete.add(labelSolde1);

        boiteLigne.setAlignmentX(0.0F);
        boiteLigne.setOpaque(false);
        boiteLigne.setPreferredSize(new java.awt.Dimension(200, 100));
        boiteLigne.setRequestFocusEnabled(false);
        boiteLigne.setLayout(new java.awt.GridLayout(5, 0));

        btnOK.setText("OK");
        btnOK.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                btnOKActionPerformed(evt);
            }
        });

        labelSolde.setBackground(new java.awt.Color(240, 240, 240));
        labelSolde.setText("Solde :");

        soldeValeur.setBackground(new java.awt.Color(250, 250, 250));
        soldeValeur.setText("0");

        labelEuros.setBackground(new java.awt.Color(240, 240, 240));
        labelEuros.setText("Euros");

        javax.swing.GroupLayout layout = new javax.swing.GroupLayout(getContentPane());
        getContentPane().setLayout(layout);
        layout.setHorizontalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(layout.createSequentialGroup()
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addComponent(photoFond)
                    .addGroup(layout.createSequentialGroup()
                        .addContainerGap()
                        .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.TRAILING, false)
                            .addComponent(boiteLigne, javax.swing.GroupLayout.Alignment.LEADING, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                            .addComponent(entete, javax.swing.GroupLayout.Alignment.LEADING, javax.swing.GroupLayout.DEFAULT_SIZE, 417, Short.MAX_VALUE)))
                    .addGroup(layout.createSequentialGroup()
                        .addContainerGap()
                        .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.TRAILING)
                            .addComponent(jSeparator1, javax.swing.GroupLayout.PREFERRED_SIZE, 425, javax.swing.GroupLayout.PREFERRED_SIZE)
                            .addComponent(btnOK)))
                    .addGroup(layout.createSequentialGroup()
                        .addGap(248, 248, 248)
                        .addComponent(labelSolde, javax.swing.GroupLayout.PREFERRED_SIZE, 60, javax.swing.GroupLayout.PREFERRED_SIZE)
                        .addGap(30, 30, 30)
                        .addComponent(soldeValeur, javax.swing.GroupLayout.PREFERRED_SIZE, 65, javax.swing.GroupLayout.PREFERRED_SIZE)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addComponent(labelEuros, javax.swing.GroupLayout.PREFERRED_SIZE, 60, javax.swing.GroupLayout.PREFERRED_SIZE)))
                .addContainerGap(javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
        );
        layout.setVerticalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(layout.createSequentialGroup()
                .addGap(41, 41, 41)
                .addComponent(entete, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(boiteLigne, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addGap(26, 26, 26)
                .addComponent(jSeparator1, javax.swing.GroupLayout.PREFERRED_SIZE, 10, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.CENTER)
                    .addComponent(labelEuros)
                    .addComponent(labelSolde)
                    .addComponent(soldeValeur))
                .addGap(107, 107, 107)
                .addComponent(btnOK)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                .addComponent(photoFond))
        );

        pack();
    }// </editor-fold>//GEN-END:initComponents

    private void btnOKActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_btnOKActionPerformed
        // Fermer la fenêtre en cours sans quitter l’application
        this.dispose();
    }//GEN-LAST:event_btnOKActionPerformed

  

    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JPanel boiteLigne;
    private javax.swing.JButton btnOK;
    private javax.swing.JPanel entete;
    private javax.swing.JSeparator jSeparator1;
    private javax.swing.JLabel labelEuros;
    private javax.swing.JLabel labelMotif;
    private javax.swing.JLabel labelSolde;
    private javax.swing.JLabel labelSolde1;
    private javax.swing.JLabel labelTransaction;
    private javax.swing.JLabel photoFond;
    private javax.swing.JLabel soldeValeur;
    // End of variables declaration//GEN-END:variables
}
