/*
#	Le livre de Java 1er langage
#	A. Tasso
#	Chapitre 12 : Créer une interface graphique
#	Section  : Projet
#	Fichier  : CompteDialogue.java
#	Class    : CompteDialogue
*/

// Le fichier CompteDialogue.java se trouve dans le répertoire 
// Sources/Projet/Chapitre12/NetBeansProjects/ProjetChapitre12/src/Projet

package Projet;

import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.border.Border;

public class CompteDialogue extends javax.swing.JFrame {
  // Définition des propriétés
  String typeCompte="Courant";
  String numeroCompte = " " ;

    public CompteDialogue(String cpt) {
        initComponents();
        // Afficher le numéro de compte dans le cadre du composant
        Border cadre = BorderFactory.createTitledBorder("   Compte n° : " + cpt + "   " );
        boiteMenu.setBorder(cadre);
        setBounds(500, 130,470, 390);
        setVisible(true);
        // Afficher une image en fond de fenêtre
        ImageIcon iconPhoto = new ImageIcon("Ressources/FondCompte.png");
        photoFond.setIcon(iconPhoto);
        creerGroupeBox();
        numeroCompte = cpt;
    }
    
    private void creerGroupeBox() {   
       compteGrp.add(entreprise);
       compteGrp.add(courant);
       courant.setSelected(true);
    }

    /**
     * This method is called from within the constructor to initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is always
     * regenerated by the Form Editor.
     */
    @SuppressWarnings("unchecked")
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {

        compteGrp = new javax.swing.ButtonGroup();
        boiteMenu = new javax.swing.JPanel();
        courant = new javax.swing.JCheckBox();
        entreprise = new javax.swing.JCheckBox();
        valeurAsaisir = new javax.swing.JTextField();
        btnOK = new javax.swing.JButton();
        labelSolde = new javax.swing.JLabel();
        labelEuros = new javax.swing.JLabel();
        photoFond = new javax.swing.JLabel();

        setDefaultCloseOperation(javax.swing.WindowConstants.EXIT_ON_CLOSE);

        boiteMenu.setBorder(javax.swing.BorderFactory.createTitledBorder("   Comptes   "));

        courant.setText("Compte Courant");
        courant.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                courantActionPerformed(evt);
            }
        });

        entreprise.setText("Compte Entreprise");
        entreprise.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                entrepriseActionPerformed(evt);
            }
        });

        valeurAsaisir.setHorizontalAlignment(javax.swing.JTextField.RIGHT);
        valeurAsaisir.setText("0");

        btnOK.setText("OK");
        btnOK.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                btnOKActionPerformed(evt);
            }
        });

        labelSolde.setText("Solde :");

        labelEuros.setText("Euros");

        javax.swing.GroupLayout boiteMenuLayout = new javax.swing.GroupLayout(boiteMenu);
        boiteMenu.setLayout(boiteMenuLayout);
        boiteMenuLayout.setHorizontalGroup(
            boiteMenuLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(boiteMenuLayout.createSequentialGroup()
                .addContainerGap()
                .addGroup(boiteMenuLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING, false)
                    .addGroup(boiteMenuLayout.createSequentialGroup()
                        .addComponent(labelSolde)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addComponent(valeurAsaisir, javax.swing.GroupLayout.PREFERRED_SIZE, 77, javax.swing.GroupLayout.PREFERRED_SIZE)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addComponent(labelEuros)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                        .addComponent(btnOK))
                    .addGroup(boiteMenuLayout.createSequentialGroup()
                        .addComponent(courant)
                        .addGap(40, 40, 40)
                        .addComponent(entreprise)))
                .addContainerGap(36, Short.MAX_VALUE))
        );
        boiteMenuLayout.setVerticalGroup(
            boiteMenuLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(boiteMenuLayout.createSequentialGroup()
                .addContainerGap()
                .addGroup(boiteMenuLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(courant)
                    .addComponent(entreprise))
                .addGap(37, 37, 37)
                .addGroup(boiteMenuLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.CENTER)
                    .addComponent(labelSolde)
                    .addComponent(labelEuros)
                    .addComponent(valeurAsaisir, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                    .addComponent(btnOK))
                .addContainerGap(javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
        );

        photoFond.setText("jLabel1");

        javax.swing.GroupLayout layout = new javax.swing.GroupLayout(getContentPane());
        getContentPane().setLayout(layout);
        layout.setHorizontalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(layout.createSequentialGroup()
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addGroup(layout.createSequentialGroup()
                        .addGap(145, 145, 145)
                        .addComponent(photoFond))
                    .addGroup(layout.createSequentialGroup()
                        .addContainerGap()
                        .addComponent(boiteMenu, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)))
                .addContainerGap(17, Short.MAX_VALUE))
        );
        layout.setVerticalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(layout.createSequentialGroup()
                .addContainerGap()
                .addComponent(boiteMenu, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(photoFond)
                .addContainerGap(147, Short.MAX_VALUE))
        );

        pack();
    }// </editor-fold>//GEN-END:initComponents

    private void courantActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_courantActionPerformed
        // Initialiser le type du compte à "Courant"
        typeCompte="Courant";
    }//GEN-LAST:event_courantActionPerformed

    private void entrepriseActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_entrepriseActionPerformed
        // Initialiser le type du compte à "Entreprise"
        typeCompte="Entreprise";
    }//GEN-LAST:event_entrepriseActionPerformed

    private void btnOKActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_btnOKActionPerformed
        // Récupérer la valeur du montant déposé à l’ouverture du compte
        double valeurInitiale = Double.parseDouble(valeurAsaisir.getText());
        // Créer un objet de type Compte à l’aide de son constructeur.
        System.out.println("----------------------"+numeroCompte);
        Compte unCompte = new Compte(numeroCompte, typeCompte, valeurInitiale) ;
        // unCompte.afficher();
        // Enregistrer le compte dans un fichier objet dont le nom porte le numéro du compte suivi de l’extension .dat
        FichierCompte fc = new FichierCompte();
        fc.ouvrir("Comptes/"+numeroCompte+".dat","W");
        fc.ecrire(unCompte);
        fc.fermer();
        // Fermer la fenêtre en cours sans quitter l’application.
        this.dispose();
    }//GEN-LAST:event_btnOKActionPerformed


    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JPanel boiteMenu;
    private javax.swing.JButton btnOK;
    private javax.swing.ButtonGroup compteGrp;
    private javax.swing.JCheckBox courant;
    private javax.swing.JCheckBox entreprise;
    private javax.swing.JLabel labelEuros;
    private javax.swing.JLabel labelSolde;
    private javax.swing.JLabel photoFond;
    private javax.swing.JTextField valeurAsaisir;
    // End of variables declaration//GEN-END:variables
}
