/*
#	Le livre de Java 1er langage
#	A. Tasso
#	Chapitre 12 : Créer une interface graphique
#	Section  : Gestion de bulletins de notes
#	Fichier  : BulletinNotes.java
#	Class    : BulletinNotes
*/

// Le fichier BulletinNotes.java se trouve dans le répertoire 
// Sources/Exemples/Chapitre12/NetBeansProjects/GestionClasseExemple/src/Introduction
package introduction;
// Pour traiter l'affichage d'une photo
import javax.swing.ImageIcon;
 // La classe BulletinNotes hérite des propriétés et méthodes de la la classe JFRame
public class BulletinNotes extends javax.swing.JFrame {
    // Propriété de la classe BulletinNotes
  private  Etudiant etudiant;
    
  public BulletinNotes(Etudiant tmp) {
   // Rendre le panneau visible
   setVisible(true);
   // Mettre en place les composants créés dans la fenêtre Design
   initComponents();
   // Définir la position et la taille du panneau, à l’écran
   this.setBounds(100, 100,522, 669);
   // Initialiser la propriété etudiant, a l’étudiant passé en paramètre
   etudiant = tmp;
   // Afficher les noms et prénoms de l’étudiant
   nomEtudiant.setText(etudiant.getNom());
   prenomEtudiant.setText(etudiant.getPrenom());
   // Afficher le semestre de validation
   semestre.setText(etudiant.getSemestre());
   // Récupérer la liste des matières 
   String [] listeMatieres = etudiant.getMatieres() ;
   // Afficher chaque matière dans le composant qui lui correspond
   matiereLue1.setText(listeMatieres[0]);
   matiereLue2.setText(listeMatieres[1]);
   matiereLue3.setText(listeMatieres[2]);
   matiereLue4.setText(listeMatieres[3]);
   matiereLue5.setText(listeMatieres[4]);
   // Récupérer la moyenne de l’étudiant pour chaque matière. 
   // La première fois le moyenne est forcément nulle
   double [] listeMoyenne = etudiant.getMoyenne() ;
   // Afficher chaque moyenne dans le composant qui lui correspond
   moyenne1.setText(Double.toString(listeMoyenne[0]));
   moyenne2.setText(Double.toString(listeMoyenne[1]));
   moyenne3.setText(Double.toString(listeMoyenne[2]));
   moyenne4.setText(Double.toString(listeMoyenne[3]));
   moyenne5.setText(Double.toString(listeMoyenne[4]));
   //  Afficher la photo de l’étudiant
   ImageIcon iconPhoto = new ImageIcon(etudiant.getPhoto());
   photoEtudiant.setIcon(iconPhoto); 
  }

    /**
     * This method is called from within the constructor to initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is always
     * regenerated by the Form Editor.
     */
    @SuppressWarnings("unchecked")
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {

        BoiteInfos = new javax.swing.JPanel();
        labelNom = new javax.swing.JLabel();
        labelPrenom = new javax.swing.JLabel();
        labelPreirode = new javax.swing.JLabel();
        nomEtudiant = new javax.swing.JLabel();
        prenomEtudiant = new javax.swing.JLabel();
        semestre = new javax.swing.JLabel();
        photoEtudiant = new javax.swing.JLabel();
        boiteNotes = new javax.swing.JPanel();
        matiereLue1 = new javax.swing.JLabel();
        moyenne1 = new javax.swing.JTextField();
        matiereLue2 = new javax.swing.JLabel();
        moyenne2 = new javax.swing.JTextField();
        matiereLue3 = new javax.swing.JLabel();
        moyenne3 = new javax.swing.JTextField();
        matiereLue4 = new javax.swing.JLabel();
        moyenne4 = new javax.swing.JTextField();
        matiereLue5 = new javax.swing.JLabel();
        moyenne5 = new javax.swing.JTextField();
        unTrait = new javax.swing.JSeparator();
        labelMoyenne = new javax.swing.JLabel();
        moyenneGenerale = new javax.swing.JLabel();
        boiteBoutons = new javax.swing.JPanel();
        calculerBtn = new javax.swing.JButton();
        enregistrerBtn = new javax.swing.JButton();
        fermerBtn = new javax.swing.JButton();

        setDefaultCloseOperation(javax.swing.WindowConstants.EXIT_ON_CLOSE);
        setTitle("Bulletin de Notes");

        labelNom.setText("Nom : ");

        labelPrenom.setText("Prénom : ");

        labelPreirode.setText("Période : ");

        prenomEtudiant.setText("       ");

        semestre.setText("         ");

        photoEtudiant.setText(" ");

        javax.swing.GroupLayout BoiteInfosLayout = new javax.swing.GroupLayout(BoiteInfos);
        BoiteInfos.setLayout(BoiteInfosLayout);
        BoiteInfosLayout.setHorizontalGroup(
            BoiteInfosLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(BoiteInfosLayout.createSequentialGroup()
                .addGap(51, 51, 51)
                .addComponent(photoEtudiant, javax.swing.GroupLayout.PREFERRED_SIZE, 99, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addGap(60, 60, 60)
                .addGroup(BoiteInfosLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addComponent(labelNom)
                    .addComponent(labelPrenom)
                    .addComponent(labelPreirode))
                .addGap(60, 60, 60)
                .addGroup(BoiteInfosLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addComponent(nomEtudiant, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                    .addComponent(prenomEtudiant, javax.swing.GroupLayout.DEFAULT_SIZE, 69, Short.MAX_VALUE)
                    .addComponent(semestre, javax.swing.GroupLayout.PREFERRED_SIZE, 82, javax.swing.GroupLayout.PREFERRED_SIZE))
                .addContainerGap(javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
        );

        BoiteInfosLayout.linkSize(javax.swing.SwingConstants.HORIZONTAL, new java.awt.Component[] {labelNom, labelPreirode, labelPrenom, nomEtudiant, prenomEtudiant, semestre});

        BoiteInfosLayout.setVerticalGroup(
            BoiteInfosLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(BoiteInfosLayout.createSequentialGroup()
                .addGroup(BoiteInfosLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.TRAILING)
                    .addGroup(BoiteInfosLayout.createSequentialGroup()
                        .addContainerGap()
                        .addComponent(photoEtudiant, javax.swing.GroupLayout.PREFERRED_SIZE, 84, javax.swing.GroupLayout.PREFERRED_SIZE))
                    .addGroup(javax.swing.GroupLayout.Alignment.LEADING, BoiteInfosLayout.createSequentialGroup()
                        .addGap(37, 37, 37)
                        .addGroup(BoiteInfosLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                            .addComponent(labelNom)
                            .addComponent(nomEtudiant, javax.swing.GroupLayout.PREFERRED_SIZE, 16, javax.swing.GroupLayout.PREFERRED_SIZE))
                        .addGap(18, 18, 18)
                        .addGroup(BoiteInfosLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                            .addComponent(labelPrenom)
                            .addComponent(prenomEtudiant, javax.swing.GroupLayout.PREFERRED_SIZE, 16, javax.swing.GroupLayout.PREFERRED_SIZE))
                        .addGap(18, 18, 18)
                        .addGroup(BoiteInfosLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                            .addComponent(labelPreirode)
                            .addComponent(semestre))))
                .addContainerGap(31, Short.MAX_VALUE))
        );

        BoiteInfosLayout.linkSize(javax.swing.SwingConstants.VERTICAL, new java.awt.Component[] {labelNom, labelPreirode, labelPrenom, nomEtudiant, prenomEtudiant, semestre});

        matiereLue1.setText("Communication :");

        moyenne1.setText("      ");

        matiereLue2.setHorizontalAlignment(javax.swing.SwingConstants.LEFT);
        matiereLue2.setText("Anglais :");

        moyenne2.setText("      ");

        matiereLue3.setHorizontalAlignment(javax.swing.SwingConstants.LEFT);
        matiereLue3.setText("Algorithmique :");

        moyenne3.setText("      ");

        matiereLue4.setHorizontalAlignment(javax.swing.SwingConstants.LEFT);
        matiereLue4.setText("Programmation :");

        moyenne4.setText("      ");

        matiereLue5.setHorizontalAlignment(javax.swing.SwingConstants.LEFT);
        matiereLue5.setText("Mathématique :");

        moyenne5.setText("      ");

        labelMoyenne.setHorizontalAlignment(javax.swing.SwingConstants.LEFT);
        labelMoyenne.setText("Moyenne générale :");

        moyenneGenerale.setText("      ");

        javax.swing.GroupLayout boiteNotesLayout = new javax.swing.GroupLayout(boiteNotes);
        boiteNotes.setLayout(boiteNotesLayout);
        boiteNotesLayout.setHorizontalGroup(
            boiteNotesLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(boiteNotesLayout.createSequentialGroup()
                .addGroup(boiteNotesLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addGroup(boiteNotesLayout.createSequentialGroup()
                        .addGap(85, 85, 85)
                        .addGroup(boiteNotesLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING, false)
                            .addComponent(matiereLue1, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                            .addComponent(matiereLue2, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                            .addComponent(matiereLue4, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                            .addComponent(matiereLue5, javax.swing.GroupLayout.Alignment.TRAILING, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                            .addGroup(boiteNotesLayout.createSequentialGroup()
                                .addComponent(matiereLue3, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                                .addGap(156, 156, 156)))
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addGroup(boiteNotesLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                            .addComponent(moyenne5, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                            .addComponent(moyenne4, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                            .addComponent(moyenne2, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                            .addComponent(moyenne1, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                            .addComponent(moyenne3, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)))
                    .addGroup(boiteNotesLayout.createSequentialGroup()
                        .addContainerGap()
                        .addComponent(unTrait, javax.swing.GroupLayout.PREFERRED_SIZE, 532, javax.swing.GroupLayout.PREFERRED_SIZE))
                    .addGroup(boiteNotesLayout.createSequentialGroup()
                        .addGap(86, 86, 86)
                        .addComponent(labelMoyenne)
                        .addGap(107, 107, 107)
                        .addComponent(moyenneGenerale, javax.swing.GroupLayout.PREFERRED_SIZE, 39, javax.swing.GroupLayout.PREFERRED_SIZE)))
                .addContainerGap(javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
        );
        boiteNotesLayout.setVerticalGroup(
            boiteNotesLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(boiteNotesLayout.createSequentialGroup()
                .addGap(15, 15, 15)
                .addGroup(boiteNotesLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.CENTER)
                    .addComponent(matiereLue1)
                    .addComponent(moyenne1, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.UNRELATED)
                .addGroup(boiteNotesLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.CENTER)
                    .addComponent(matiereLue2)
                    .addComponent(moyenne2, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.UNRELATED)
                .addGroup(boiteNotesLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(matiereLue3)
                    .addComponent(moyenne3, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
                .addGap(11, 11, 11)
                .addGroup(boiteNotesLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.CENTER)
                    .addComponent(matiereLue4)
                    .addComponent(moyenne4, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.UNRELATED)
                .addGroup(boiteNotesLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(matiereLue5)
                    .addComponent(moyenne5, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
                .addGap(22, 22, 22)
                .addComponent(unTrait, javax.swing.GroupLayout.PREFERRED_SIZE, 10, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addGroup(boiteNotesLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addGroup(boiteNotesLayout.createSequentialGroup()
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.UNRELATED, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                        .addComponent(labelMoyenne)
                        .addGap(30, 30, 30))
                    .addGroup(boiteNotesLayout.createSequentialGroup()
                        .addGap(18, 18, 18)
                        .addComponent(moyenneGenerale)
                        .addContainerGap(javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))))
        );

        boiteNotesLayout.linkSize(javax.swing.SwingConstants.VERTICAL, new java.awt.Component[] {matiereLue1, matiereLue2, matiereLue3, matiereLue4, matiereLue5, moyenne1, moyenne2, moyenne3, moyenne4, moyenne5});

        calculerBtn.setText("Moyenne ?");
        calculerBtn.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                calculerBtnActionPerformed(evt);
            }
        });

        enregistrerBtn.setText("Enregistrer");
        enregistrerBtn.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                enregistrerBtnActionPerformed(evt);
            }
        });

        fermerBtn.setText("Fermer");
        fermerBtn.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                fermerBtnActionPerformed(evt);
            }
        });

        javax.swing.GroupLayout boiteBoutonsLayout = new javax.swing.GroupLayout(boiteBoutons);
        boiteBoutons.setLayout(boiteBoutonsLayout);
        boiteBoutonsLayout.setHorizontalGroup(
            boiteBoutonsLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(boiteBoutonsLayout.createSequentialGroup()
                .addGap(75, 75, 75)
                .addComponent(calculerBtn)
                .addGap(76, 76, 76)
                .addComponent(enregistrerBtn)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                .addComponent(fermerBtn)
                .addGap(39, 39, 39))
        );
        boiteBoutonsLayout.setVerticalGroup(
            boiteBoutonsLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(boiteBoutonsLayout.createSequentialGroup()
                .addGap(26, 26, 26)
                .addGroup(boiteBoutonsLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(calculerBtn)
                    .addComponent(enregistrerBtn)
                    .addComponent(fermerBtn))
                .addContainerGap(45, Short.MAX_VALUE))
        );

        javax.swing.GroupLayout layout = new javax.swing.GroupLayout(getContentPane());
        getContentPane().setLayout(layout);
        layout.setHorizontalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addComponent(BoiteInfos, javax.swing.GroupLayout.Alignment.TRAILING, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
            .addGroup(javax.swing.GroupLayout.Alignment.TRAILING, layout.createSequentialGroup()
                .addContainerGap()
                .addComponent(boiteNotes, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                .addContainerGap())
            .addComponent(boiteBoutons, javax.swing.GroupLayout.Alignment.TRAILING, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
        );
        layout.setVerticalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(layout.createSequentialGroup()
                .addComponent(BoiteInfos, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(boiteNotes, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(boiteBoutons, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addGap(0, 0, Short.MAX_VALUE))
        );

        pack();
    }// </editor-fold>//GEN-END:initComponents

    private void calculerBtnActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_calculerBtnActionPerformed
        // Récupérer la première  moyenne
  String moyenneTxt = moyenne1.getText();
  // Transformer la chaîne de caractère en valeur numérique 
  float m1 = Float.parseFloat(moyenneTxt);
  // Mémoriser la nouvelle moyenne de l’etudiant en cours de traitement
  etudiant.setMoyenne(m1, 0);
  // Récupérer la seconde  moyenne
  moyenneTxt = moyenne2.getText();
  // Transformer la chaîne de caractère en valeur numérique 
  float m2 = Float.parseFloat(moyenneTxt); 
  // Mémoriser la nouvelle moyenne de l’etudiant en cours de traitement
  etudiant.setMoyenne(m2,1);
  // Récupérer la troisième moyenne
  moyenneTxt = moyenne3.getText();
  // Transformer la chaîne de caractère en valeur numérique 
  float m3 = Float.parseFloat(moyenneTxt); 
  // Mémoriser la nouvelle moyenne de l’etudiant en cours de traitement
  etudiant.setMoyenne(m3, 2);
  // Récupérer la quatrième  moyenne
  moyenneTxt = moyenne4.getText();
  // Transformer la chaîne de caractère en valeur numérique 
  float m4 = Float.parseFloat(moyenneTxt); 
  // Mémoriser la nouvelle moyenne de l’etudiant en cours de traitement
  etudiant.setMoyenne(m4, 3);
  // Récupérer la cinquième  moyenne
  moyenneTxt = moyenne5.getText();
  // Transformer la chaîne de caractère en valeur numérique 
  float m5 = Float.parseFloat(moyenne5.getText());
  // Mémoriser la nouvelle moyenne de l’etudiant en cours de traitement
  etudiant.setMoyenne(m5, 4);
  // calculer la moyenne générale
  float resultat = (m1 + m2 + m3 + m4 + m5)/5;
  // Afficher le résultat dans le composant moyenneGenerale
  moyenneGenerale.setText(Float.toString(resultat)); 
    }//GEN-LAST:event_calculerBtnActionPerformed

    private void enregistrerBtnActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_enregistrerBtnActionPerformed
       // Créer un cursus
  Cursus promo= new Cursus();
  // Créer un fichier d’étudiants
  FichierEtudiant F = new FichierEtudiant();
  // Si le fichier s’ouvre en lecture
  if (F.ouvrir("L")) {
      // Lire les données et les mémoriser dans l’objet
      promo = F.lire(); 
      // Fermer le fichier
      F.fermer();
  }
  // Ajouter l’étudiant en cours de traitement à la promo
  promo.ajouteUnEtudiant(etudiant.getNom(), etudiant.getPrenom(), etudiant.getPhoto(), etudiant.getMatieres(), etudiant.getSemestre(), etudiant.moyenne);
  // Ouvrir le fichier en écriture
  F.ouvrir("W"); 
  // Enregistrer la promo avec l’étudiant supplémentaire
  F.ecrire(promo);
  // fermer le fichier
  F.fermer();
    }//GEN-LAST:event_enregistrerBtnActionPerformed

    private void fermerBtnActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_fermerBtnActionPerformed
        // Fermer la fenêtre sans quitter l'application
    this.dispose();
    }//GEN-LAST:event_fermerBtnActionPerformed

   

    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JPanel BoiteInfos;
    private javax.swing.JPanel boiteBoutons;
    private javax.swing.JPanel boiteNotes;
    private javax.swing.JButton calculerBtn;
    private javax.swing.JButton enregistrerBtn;
    private javax.swing.JButton fermerBtn;
    private javax.swing.JLabel labelMoyenne;
    private javax.swing.JLabel labelNom;
    private javax.swing.JLabel labelPreirode;
    private javax.swing.JLabel labelPrenom;
    private javax.swing.JLabel matiereLue1;
    private javax.swing.JLabel matiereLue2;
    private javax.swing.JLabel matiereLue3;
    private javax.swing.JLabel matiereLue4;
    private javax.swing.JLabel matiereLue5;
    private javax.swing.JTextField moyenne1;
    private javax.swing.JTextField moyenne2;
    private javax.swing.JTextField moyenne3;
    private javax.swing.JTextField moyenne4;
    private javax.swing.JTextField moyenne5;
    private javax.swing.JLabel moyenneGenerale;
    private javax.swing.JLabel nomEtudiant;
    private javax.swing.JLabel photoEtudiant;
    private javax.swing.JLabel prenomEtudiant;
    private javax.swing.JLabel semestre;
    private javax.swing.JSeparator unTrait;
    // End of variables declaration//GEN-END:variables
}
