/*
#	Le livre de Java 1er langage
#	A. Tasso
#	Chapitre 12 : Créer une interface graphique
#	Section  : Exercice 12.4 à 12.7
#	Fichier  : ClasseSwing.java
#	Class    : ClasseSwing
*/

// Le fichier ClasseSwing.java se trouve dans le répertoire 
// Sources/Exercices/Chapitre12/NetBeansProjects/GestionClasseExercice/src/Introduction
package introduction;

import java.io.File;
import javax.swing.JFileChooser;

public class CursusSwing extends javax.swing.JFrame {
    // Initialiser la photo par défaut à celle d'une silhouette
    // Modifier l'url d'accès au fichier Inconnu.jpg selon votre système d'exploitation
    // Les photos se trouvent dans le répertoire 
    // Sources/Exemples/Chapitre12/NetBeansProjects/GestionClasseExemple/Photos
    private String urlPhoto="/Users/VotreCompte/Photos/Inconnu.jpg";
    private String periode ;
    private String [] listeMatieres;

    // 12.6.a  Gestion du survol de la JComboBox, déclaration et initialisation du drapeau
    private boolean etatComboBox = false; 

    
     // 12.4.d   La propriété choixAction est initialisée à "Creer"
     private String choixAction="Creer";
    
    public CursusSwing() {
        initComponents();
         this.setBounds(100, 100, 450, 500);
         // 12.4.c  Ajouter les boutons au groupe groupeRadioBtn
        groupeBtn.add(creerRadioBtn);
        groupeBtn.add(modifierRadioBtn);
        groupeBtn.add(supprimerRadioBtn);
        // 12.4.c  Le bouton creerRadioBtn est sélectionné par défaut
        creerRadioBtn.setSelected(true);
        info.setText("  Créer : Tous les champs doivent être renseignés !");
     
    }

    /**
     * This method is called from within the constructor to initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is always
     * regenerated by the Form Editor.
     */
    @SuppressWarnings("unchecked")
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {

        groupeBtn = new javax.swing.ButtonGroup();
        PanelTitre = new javax.swing.JPanel();
        labelTitre = new javax.swing.JLabel();
        PanelMenu = new javax.swing.JPanel();
        creerRadioBtn = new javax.swing.JRadioButton();
        modifierRadioBtn = new javax.swing.JRadioButton();
        supprimerRadioBtn = new javax.swing.JRadioButton();
        jSeparator1 = new javax.swing.JSeparator();
        jSeparator2 = new javax.swing.JSeparator();
        labelPrenom = new javax.swing.JLabel();
        labelPeriode = new javax.swing.JLabel();
        choixPeriode = new javax.swing.JComboBox();
        nomAsaisir = new javax.swing.JTextField();
        prenomAsaisir = new javax.swing.JTextField();
        labelPhoto = new javax.swing.JLabel();
        rechercherBtn = new javax.swing.JButton();
        labelNom = new javax.swing.JLabel();
        validerBtn = new javax.swing.JButton();
        info = new javax.swing.JLabel();
        fermerBtn = new javax.swing.JButton();

        setDefaultCloseOperation(javax.swing.WindowConstants.EXIT_ON_CLOSE);
        setTitle("Gestion des Etudiants");
        setPreferredSize(new java.awt.Dimension(500, 518));
        addMouseListener(new java.awt.event.MouseAdapter() {
            public void mouseEntered(java.awt.event.MouseEvent evt) {
                formMouseEntered(evt);
            }
        });

        labelTitre.setFont(new java.awt.Font("Arial", 0, 18)); // NOI18N
        labelTitre.setHorizontalAlignment(javax.swing.SwingConstants.CENTER);
        labelTitre.setText("Étudiant  ");

        javax.swing.GroupLayout PanelTitreLayout = new javax.swing.GroupLayout(PanelTitre);
        PanelTitre.setLayout(PanelTitreLayout);
        PanelTitreLayout.setHorizontalGroup(
            PanelTitreLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(javax.swing.GroupLayout.Alignment.TRAILING, PanelTitreLayout.createSequentialGroup()
                .addContainerGap(106, Short.MAX_VALUE)
                .addComponent(labelTitre, javax.swing.GroupLayout.PREFERRED_SIZE, 197, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addGap(55, 55, 55))
        );
        PanelTitreLayout.setVerticalGroup(
            PanelTitreLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(javax.swing.GroupLayout.Alignment.TRAILING, PanelTitreLayout.createSequentialGroup()
                .addContainerGap(20, Short.MAX_VALUE)
                .addComponent(labelTitre)
                .addContainerGap())
        );

        creerRadioBtn.setText("Créer");
        creerRadioBtn.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                creerRadioBtnActionPerformed(evt);
            }
        });
        creerRadioBtn.addMouseListener(new java.awt.event.MouseAdapter() {
            public void mouseEntered(java.awt.event.MouseEvent evt) {
                creerRadioBtnMouseEntered(evt);
            }
        });

        modifierRadioBtn.setSelected(true);
        modifierRadioBtn.setText("Modifier");
        modifierRadioBtn.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                modifierRadioBtnActionPerformed(evt);
            }
        });
        modifierRadioBtn.addMouseListener(new java.awt.event.MouseAdapter() {
            public void mouseEntered(java.awt.event.MouseEvent evt) {
                modifierRadioBtnMouseEntered(evt);
            }
        });

        supprimerRadioBtn.setText("Supprimer");
        supprimerRadioBtn.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                supprimerRadioBtnActionPerformed(evt);
            }
        });
        supprimerRadioBtn.addMouseListener(new java.awt.event.MouseAdapter() {
            public void mouseEntered(java.awt.event.MouseEvent evt) {
                supprimerRadioBtnMouseEntered(evt);
            }
        });

        javax.swing.GroupLayout PanelMenuLayout = new javax.swing.GroupLayout(PanelMenu);
        PanelMenu.setLayout(PanelMenuLayout);
        PanelMenuLayout.setHorizontalGroup(
            PanelMenuLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(PanelMenuLayout.createSequentialGroup()
                .addContainerGap()
                .addComponent(creerRadioBtn)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED, 80, Short.MAX_VALUE)
                .addComponent(modifierRadioBtn)
                .addGap(45, 45, 45)
                .addComponent(supprimerRadioBtn)
                .addGap(38, 38, 38))
        );
        PanelMenuLayout.setVerticalGroup(
            PanelMenuLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(javax.swing.GroupLayout.Alignment.TRAILING, PanelMenuLayout.createSequentialGroup()
                .addGroup(PanelMenuLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(creerRadioBtn)
                    .addComponent(supprimerRadioBtn)
                    .addComponent(modifierRadioBtn))
                .addContainerGap(9, Short.MAX_VALUE))
        );

        labelPrenom.setText("Prénom :");

        labelPeriode.setText("Période :");

        choixPeriode.setModel(new javax.swing.DefaultComboBoxModel(new String[] { "Quel semestre ?", "Semestre 1", "Semestre 2", "Semestre 3", "Semestre 4" }));
        choixPeriode.addPopupMenuListener(new javax.swing.event.PopupMenuListener() {
            public void popupMenuCanceled(javax.swing.event.PopupMenuEvent evt) {
            }
            public void popupMenuWillBecomeInvisible(javax.swing.event.PopupMenuEvent evt) {
                choixPeriodePopupMenuWillBecomeInvisible(evt);
            }
            public void popupMenuWillBecomeVisible(javax.swing.event.PopupMenuEvent evt) {
                choixPeriodePopupMenuWillBecomeVisible(evt);
            }
        });
        choixPeriode.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                choixPeriodeActionPerformed(evt);
            }
        });

        nomAsaisir.setDragEnabled(false);
        nomAsaisir.addMouseListener(new java.awt.event.MouseAdapter() {
            public void mouseEntered(java.awt.event.MouseEvent evt) {
                nomAsaisirMouseEntered(evt);
            }
        });

        prenomAsaisir.addMouseListener(new java.awt.event.MouseAdapter() {
            public void mouseEntered(java.awt.event.MouseEvent evt) {
                prenomAsaisirMouseEntered(evt);
            }
        });

        labelPhoto.setText("Photo :");

        rechercherBtn.setText("Rechercher");
        rechercherBtn.addMouseListener(new java.awt.event.MouseAdapter() {
            public void mouseEntered(java.awt.event.MouseEvent evt) {
                rechercherBtnMouseEntered(evt);
            }
        });
        rechercherBtn.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                rechercherBtnActionPerformed(evt);
            }
        });

        labelNom.setText("Nom :");

        validerBtn.setText("Valider");
        validerBtn.addMouseListener(new java.awt.event.MouseAdapter() {
            public void mouseEntered(java.awt.event.MouseEvent evt) {
                validerBtnMouseEntered(evt);
            }
        });
        validerBtn.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                validerBtnActionPerformed(evt);
            }
        });

        info.setBackground(new java.awt.Color(250, 250, 250));
        info.setFont(new java.awt.Font("Arial", 2, 13)); // NOI18N
        info.setForeground(new java.awt.Color(120, 120, 120));
        info.setText(" info :");
        info.setBorder(javax.swing.BorderFactory.createEtchedBorder());
        info.setOpaque(true);

        fermerBtn.setText("Fermer");
        fermerBtn.addMouseListener(new java.awt.event.MouseAdapter() {
            public void mouseEntered(java.awt.event.MouseEvent evt) {
                fermerBtnMouseEntered(evt);
            }
        });
        fermerBtn.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                fermerBtnActionPerformed(evt);
            }
        });

        javax.swing.GroupLayout layout = new javax.swing.GroupLayout(getContentPane());
        getContentPane().setLayout(layout);
        layout.setHorizontalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addComponent(jSeparator2, javax.swing.GroupLayout.DEFAULT_SIZE, 655, Short.MAX_VALUE)
            .addGroup(javax.swing.GroupLayout.Alignment.TRAILING, layout.createSequentialGroup()
                .addContainerGap(235, Short.MAX_VALUE)
                .addComponent(PanelMenu, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addContainerGap())
            .addComponent(jSeparator1, javax.swing.GroupLayout.Alignment.TRAILING, javax.swing.GroupLayout.DEFAULT_SIZE, 655, Short.MAX_VALUE)
            .addComponent(info, javax.swing.GroupLayout.DEFAULT_SIZE, 655, Short.MAX_VALUE)
            .addGroup(layout.createSequentialGroup()
                .addGap(35, 35, 35)
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addComponent(labelPrenom, javax.swing.GroupLayout.PREFERRED_SIZE, 79, javax.swing.GroupLayout.PREFERRED_SIZE)
                    .addComponent(labelPeriode, javax.swing.GroupLayout.PREFERRED_SIZE, 71, javax.swing.GroupLayout.PREFERRED_SIZE)
                    .addComponent(labelPhoto, javax.swing.GroupLayout.PREFERRED_SIZE, 60, javax.swing.GroupLayout.PREFERRED_SIZE)
                    .addComponent(labelNom, javax.swing.GroupLayout.DEFAULT_SIZE, 312, Short.MAX_VALUE))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addComponent(nomAsaisir, javax.swing.GroupLayout.PREFERRED_SIZE, 166, javax.swing.GroupLayout.PREFERRED_SIZE)
                    .addComponent(prenomAsaisir, javax.swing.GroupLayout.PREFERRED_SIZE, 163, javax.swing.GroupLayout.PREFERRED_SIZE)
                    .addComponent(rechercherBtn)
                    .addComponent(choixPeriode, javax.swing.GroupLayout.PREFERRED_SIZE, 193, javax.swing.GroupLayout.PREFERRED_SIZE))
                .addGap(109, 109, 109))
            .addGroup(layout.createSequentialGroup()
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addGroup(layout.createSequentialGroup()
                        .addGap(12, 12, 12)
                        .addComponent(PanelTitre, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
                    .addGroup(layout.createSequentialGroup()
                        .addGap(86, 86, 86)
                        .addComponent(validerBtn)
                        .addGap(73, 73, 73)
                        .addComponent(fermerBtn)))
                .addContainerGap(javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
        );
        layout.setVerticalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(layout.createSequentialGroup()
                .addComponent(PanelTitre, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addGap(3, 3, 3)
                .addComponent(jSeparator2, javax.swing.GroupLayout.PREFERRED_SIZE, 12, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addGap(18, 18, 18)
                .addComponent(PanelMenu, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addGap(2, 2, 2)
                .addComponent(jSeparator1, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addGap(42, 42, 42)
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addGroup(layout.createSequentialGroup()
                        .addGap(107, 107, 107)
                        .addComponent(rechercherBtn))
                    .addGroup(layout.createSequentialGroup()
                        .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                            .addComponent(nomAsaisir, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                            .addComponent(labelNom, javax.swing.GroupLayout.PREFERRED_SIZE, 28, javax.swing.GroupLayout.PREFERRED_SIZE))
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addComponent(prenomAsaisir, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addComponent(choixPeriode, javax.swing.GroupLayout.PREFERRED_SIZE, 28, javax.swing.GroupLayout.PREFERRED_SIZE))
                    .addGroup(layout.createSequentialGroup()
                        .addGap(36, 36, 36)
                        .addComponent(labelPrenom, javax.swing.GroupLayout.PREFERRED_SIZE, 28, javax.swing.GroupLayout.PREFERRED_SIZE)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addComponent(labelPeriode, javax.swing.GroupLayout.PREFERRED_SIZE, 28, javax.swing.GroupLayout.PREFERRED_SIZE)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addComponent(labelPhoto, javax.swing.GroupLayout.PREFERRED_SIZE, 29, javax.swing.GroupLayout.PREFERRED_SIZE)))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED, 85, Short.MAX_VALUE)
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(validerBtn)
                    .addComponent(fermerBtn))
                .addGap(18, 18, 18)
                .addComponent(info, javax.swing.GroupLayout.PREFERRED_SIZE, 37, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addGap(44, 44, 44))
        );

        pack();
    }// </editor-fold>//GEN-END:initComponents

    private void formMouseEntered(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_formMouseEntered
       // Afficher un texte dans la zone info
        info.setText("  Info : Tous les champs doivent être renseignés !");

    }//GEN-LAST:event_formMouseEntered

    private void creerRadioBtnActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_creerRadioBtnActionPerformed
        // 12.4.e La propriété choixAction est initialisée à "Creer"
        choixAction = "Creer";
    }//GEN-LAST:event_creerRadioBtnActionPerformed

    private void creerRadioBtnMouseEntered(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_creerRadioBtnMouseEntered
        // 12.5 Aide contextuelle
        // 12.6c Gestion du survol de la JComboBox
        if(etatComboBox){
            info.setText("  Info : Choisir la période de validation des notes");
        }
        else  info.setText("  Créer : Tous les champs doivent être renseignés !");
    }//GEN-LAST:event_creerRadioBtnMouseEntered

    private void modifierRadioBtnActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_modifierRadioBtnActionPerformed
        // 12.4.e La propriété choixAction est initialisée à "Modifier"
        choixAction = "Modifier";
    }//GEN-LAST:event_modifierRadioBtnActionPerformed

    private void modifierRadioBtnMouseEntered(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_modifierRadioBtnMouseEntered
        // 12.5 Aide contextuelle
        // 12.6.c Gestion du survol de la JComboBox
        if(etatComboBox){
            info.setText("  Info : Choisir la période de validation des notes");
        }
        else info.setText("  Modifier un étudiant, vous devez connaître son nom et son prénom");
    }//GEN-LAST:event_modifierRadioBtnMouseEntered

    private void supprimerRadioBtnActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_supprimerRadioBtnActionPerformed
        // 12.4.e La propriété choixAction est initialisée à "Supprimer"
        choixAction = "Supprimer";

    }//GEN-LAST:event_supprimerRadioBtnActionPerformed

    private void supprimerRadioBtnMouseEntered(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_supprimerRadioBtnMouseEntered
        // 12.5 Aide contextuelle
        // 12.6.c Gestion du survol de la JComboBox
        if(etatComboBox){
            info.setText("  Info : Choisir la période de validation des notes");
        }
        else info.setText("  Supprimer un étudiant, vous devez connaître son nom et son prénom ");
    }//GEN-LAST:event_supprimerRadioBtnMouseEntered

    private void choixPeriodePopupMenuWillBecomeInvisible(javax.swing.event.PopupMenuEvent evt) {//GEN-FIRST:event_choixPeriodePopupMenuWillBecomeInvisible
        // 12.6.c Gestion du survol de la JComboBox
        etatComboBox = false;
        info.setText("  Info : Tous les champs doivent être renseignés !");
    }//GEN-LAST:event_choixPeriodePopupMenuWillBecomeInvisible

    private void choixPeriodePopupMenuWillBecomeVisible(javax.swing.event.PopupMenuEvent evt) {//GEN-FIRST:event_choixPeriodePopupMenuWillBecomeVisible
        // 12.6.b Gestion du survol de la JComboBox
        etatComboBox = true;
        info.setText("  Info : Choisir la période de validation des notes");
    }//GEN-LAST:event_choixPeriodePopupMenuWillBecomeVisible

    private void choixPeriodeActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_choixPeriodeActionPerformed
        // Récupérer le semestre sélectionné
        periode = (String) choixPeriode.getSelectedItem();
        // Rechercher la liste des matières en fonction du semestre
        rechercherMatiere(periode);
    }//GEN-LAST:event_choixPeriodeActionPerformed

    private void nomAsaisirMouseEntered(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_nomAsaisirMouseEntered
        // 12.5 Aide contextuelle
        // 12.6.c Gestion du survol de la JComboBox
        if(etatComboBox){
            info.setText("  Info : Choisir la période de validation des notes");
        }
        else info.setText("  Info : Entrer le nom de l'étudiant ");
    }//GEN-LAST:event_nomAsaisirMouseEntered

    private void prenomAsaisirMouseEntered(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_prenomAsaisirMouseEntered
        // 12.5 Aide contextuelle
        // 12.6.c Gestion du survol de la JComboBox
        if(etatComboBox){
            info.setText("  Info : Choisir la période de validation des notes");
        }
        else info.setText("  Info : Entrer le prénom de l'étudiant ");
    }//GEN-LAST:event_prenomAsaisirMouseEntered

    private void rechercherBtnMouseEntered(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_rechercherBtnMouseEntered
        // 12.5 Aide contextuelle
        // 12.6.c Gestion du survol de la JComboBox
        if(etatComboBox){
            info.setText("  Info : Choisir la période de de validation des notes");
        }
        else info.setText("  Info : Choisir la photo de l'étudiant ");
    }//GEN-LAST:event_rechercherBtnMouseEntered

    private void rechercherBtnActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_rechercherBtnActionPerformed
        File fichierPhoto;
        // Création d’un composant JFileChooser
        JFileChooser fichierArechercher= new JFileChooser();
        //  Ouvrir une boite de dialogue qui permet la recherche d’un fichier
        int etatRetour = fichierArechercher.showOpenDialog(CursusSwing.this);
        //  Si l’utilisateur a sélectionné un fichier
        if (etatRetour == JFileChooser.APPROVE_OPTION) {
            //  Récupérer le fichier sélectionné
            fichierPhoto = fichierArechercher.getSelectedFile();
            //  Stocker le chemin d’accès au fichier dans urlPhoto
            urlPhoto  = fichierPhoto.toString();
        }
    }//GEN-LAST:event_rechercherBtnActionPerformed

    private void validerBtnMouseEntered(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_validerBtnMouseEntered
        // 12.5 Aide contextuelle
        // 12.6.c Gestion du survol de la JComboBox
        if(etatComboBox){
            info.setText("  Info : Choisir la période de validation des notes");
        }
        else info.setText("  Info : Afficher le bulletin de notes de l'étudiant ");
    }//GEN-LAST:event_validerBtnMouseEntered

    private void validerBtnActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_validerBtnActionPerformed
        // 12.4.f Tester l'action à réaliser
        String nom = nomAsaisir.getText();
        String prenom = prenomAsaisir.getText();
        if (choixAction.equalsIgnoreCase("Creer")){
            creerUnEtudiant (nom, prenom) ;
        }
        else if (choixAction.equals("Modifier")){
            modifierUnEtudiant(nom, prenom);
        }
        else if (choixAction.equals("Supprimer")){
            supprimerUnEtudiant(nom, prenom);
        }
    }//GEN-LAST:event_validerBtnActionPerformed

    private void fermerBtnMouseEntered(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_fermerBtnMouseEntered
        // 12.5 Aide contextuelle
        // 12.6.c Gestion du survol de la JComboBox
        if(etatComboBox){
            info.setText("  Info : Choisir la période de validation des notes");
        }
        else  info.setText("  Info : Quitter l'application ");
    }//GEN-LAST:event_fermerBtnMouseEntered

    private void fermerBtnActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_fermerBtnActionPerformed
        // Cesser l'exécution de l'application
        System.exit(0);
    }//GEN-LAST:event_fermerBtnActionPerformed
    private void rechercherMatiere(String quelSemestre){    
         Fichier fichierTxt = new Fichier(); 
        listeMatieres = new String [5];
         String [] tousLesmots = new String[6];
        // Modifier l'url d'accès au fichier Inconnu.jpg selon votre système d'exploitation
        // Le fichier Ressources.txt se trouve dans le répertoire 
        // Sources/Exemples/Chapitre12/NetBeansProjects/GestionClasseExemple/Ressources
        if (fichierTxt.ouvrir("/Users/VotreCompte/Ressources/Ressources.txt", "R")){
              // Voir chapitre 10, corrigé de l'exercice 10.5
             do {
                tousLesmots = fichierTxt.lire();
                if (tousLesmots[0].equalsIgnoreCase(quelSemestre)){
                 for (int i=1; i < tousLesmots.length; i++){
                      listeMatieres[i-1] = tousLesmots[i]; 
                    }
                break;
                }
             } while (tousLesmots[0]!= null);
            fichierTxt.fermer();
        }
        else {
            listeMatieres[0]="Communication";
            listeMatieres[1]= "Anglais";
            listeMatieres[2]="Algoritmique;";
            listeMatieres[3]= "Programmation";
            listeMatieres[4]= "Mathématiques" ;
        }
    }
    
    // 12.4.f fonction creerUnEtudiant()
private void creerUnEtudiant(String nn, String np){
    double [] moyenne = new double[listeMatieres.length];
    for (int i=0; i < moyenne.length; i++) moyenne[i]=0;
    Etudiant eleve = new Etudiant(nn, np, urlPhoto, listeMatieres, periode, moyenne);
    BulletinNotes bn = new BulletinNotes(eleve);
    
}
// 12.4.f fonction supprimerUnEtudiant()
private void supprimerUnEtudiant(String nn, String np){
    // Lire la liste des étudiants dans le fichier objet 
    Cursus C = new Cursus();
    FichierEtudiant F = new FichierEtudiant();
    F.ouvrir("R");
    C = F.lire();
    F.fermer();
     // C.afficheLesEtudiants();
    Message msg; 
    String text =  nn+ " " + np;
    // Supprimer l'étudiant selon son nom et son prénom
    if( C.supprimeUnEtudiant(nn, np)) {
        // 12.7.e Si l'étudiant est supprimé l'indiquer par une boite de dialogue
        msg = new Message("L'etudiant(e) " ,text," a été supprimé(e) de la classe ");
    }
    // 12.7.e Si l'étudiant n'est pas supprimé l'indiquer par une boite de dialogue
    else msg = new Message("L'etudiant(e) " ,text, "est inconnu(e) !");
    // Enregistrer la suppression
    F.ouvrir("W"); 
    F.ecrire(C);
    F.fermer(); 
}
private void modifierUnEtudiant(String nn, String np){
    // Lire la liste des étudiants dans le fichier objet 
    Cursus C = new Cursus();
    FichierEtudiant F = new FichierEtudiant();
    F.ouvrir("R");
    C = F.lire();
    F.fermer();
    //  C.afficheLesEtudiants();
    // Rechercher l'étudiant par son nom et son prénom 
    Etudiant eleve = C.rechercheUnEtudiant(nn, np) ;
   
    if( eleve != null) {
        // Si l'étudiant existe, afficher son bulletin de notes
        BulletinNotes bn = new BulletinNotes(eleve);
        // Supprimer l'étdudiant de la liste et enregistrer cette supression
        C.supprimeUnEtudiant(nn, np);
        F.ouvrir("W"); 
        F.ecrire(C);
        F.fermer();
        eleve=null;
        // L'étdudiant sera à nouveau enregistré par le bouton enregistré du bulletin de notes
    }       
    else {
        // 12.7.e Si l'étudiant n'existe pas l'indiquer par une boite de dialogue
        Message msg;
        String text =  nn+ " " + np;
        msg = new Message("L'etudiant(e) " ,text, "est inconnu(e) !");
    }
}

    /**
     * @param args the command line arguments
     */
    public static void main(String args[]) {
        /* Set the Nimbus look and feel */
        //<editor-fold defaultstate="collapsed" desc=" Look and feel setting code (optional) ">
        /* If Nimbus (introduced in Java SE 6) is not available, stay with the default look and feel.
         * For details see http://download.oracle.com/javase/tutorial/uiswing/lookandfeel/plaf.html 
         */
        try {
            for (javax.swing.UIManager.LookAndFeelInfo info : javax.swing.UIManager.getInstalledLookAndFeels()) {
                if ("Nimbus".equals(info.getName())) {
                    javax.swing.UIManager.setLookAndFeel(info.getClassName());
                    break;
                }
            }
        } catch (ClassNotFoundException ex) {
            java.util.logging.Logger.getLogger(CursusSwing.class.getName()).log(java.util.logging.Level.SEVERE, null, ex);
        } catch (InstantiationException ex) {
            java.util.logging.Logger.getLogger(CursusSwing.class.getName()).log(java.util.logging.Level.SEVERE, null, ex);
        } catch (IllegalAccessException ex) {
            java.util.logging.Logger.getLogger(CursusSwing.class.getName()).log(java.util.logging.Level.SEVERE, null, ex);
        } catch (javax.swing.UnsupportedLookAndFeelException ex) {
            java.util.logging.Logger.getLogger(CursusSwing.class.getName()).log(java.util.logging.Level.SEVERE, null, ex);
        }
        //</editor-fold>

        /* Create and display the form */
        java.awt.EventQueue.invokeLater(new Runnable() {
            public void run() {
                new CursusSwing().setVisible(true);
            }
        });
    }

    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JPanel PanelMenu;
    private javax.swing.JPanel PanelTitre;
    private javax.swing.JComboBox choixPeriode;
    private javax.swing.JRadioButton creerRadioBtn;
    private javax.swing.JButton fermerBtn;
    private javax.swing.ButtonGroup groupeBtn;
    private javax.swing.JLabel info;
    private javax.swing.JSeparator jSeparator1;
    private javax.swing.JSeparator jSeparator2;
    private javax.swing.JLabel labelNom;
    private javax.swing.JLabel labelPeriode;
    private javax.swing.JLabel labelPhoto;
    private javax.swing.JLabel labelPrenom;
    private javax.swing.JLabel labelTitre;
    private javax.swing.JRadioButton modifierRadioBtn;
    private javax.swing.JTextField nomAsaisir;
    private javax.swing.JTextField prenomAsaisir;
    private javax.swing.JButton rechercherBtn;
    private javax.swing.JRadioButton supprimerRadioBtn;
    private javax.swing.JButton validerBtn;
    // End of variables declaration//GEN-END:variables
}
