/*
#	Le livre de Java 1er langage
#	A. Tasso
#	Chapitre 12 : Créer une interface graphique
#	Section  : Exercice 12.1 à 12.3
#	Fichier  : Main.java
#	Class    : Main
*/
// Le fichier Main.java se trouve dans le répertoire 
// Sources/Exercices/Chapitre12/NetBeansProjects/EditeurExemple/src/Exercices
package Exercices;

public class Main extends javax.swing.JFrame {

      // 12.2.d La propriété choixAction est initialisée à "Heure"
    private String choixAction="Metre"; 

    public Main() {
        initComponents();
        this.setBounds(100, 100,359, 290);
        // 12.2.a  Ajouter les boutons au groupe groupeRadioBtn
        groupeRadioBtn.add(metreBtn); 
        groupeRadioBtn.add(litreBtn);
        groupeRadioBtn.add(heureBtn);
        // 12.2.b Le bouton metreBtn est sélectionné par défaut
         metreBtn.setSelected(true);
    }
// 12.1 Mise en place des éléments graphiques (voir page Design)
    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    @SuppressWarnings("unchecked")
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {

        groupeRadioBtn = new javax.swing.ButtonGroup();
        outilChoix = new javax.swing.JPanel();
        metreBtn = new javax.swing.JRadioButton();
        litreBtn = new javax.swing.JRadioButton();
        heureBtn = new javax.swing.JRadioButton();
        jSeparator1 = new javax.swing.JSeparator();
        OutilDonnees = new javax.swing.JPanel();
        combien = new javax.swing.JTextField();
        resultat = new javax.swing.JLabel();
        uniteInit = new javax.swing.JLabel();
        uniteFinal = new javax.swing.JLabel();
        calculerBtn = new javax.swing.JButton();

        setDefaultCloseOperation(javax.swing.WindowConstants.EXIT_ON_CLOSE);

        metreBtn.setText("Mètre");
        metreBtn.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                metreBtnActionPerformed(evt);
            }
        });

        litreBtn.setText("Litre");
        litreBtn.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                litreBtnActionPerformed(evt);
            }
        });

        heureBtn.setText("Heure");
        heureBtn.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                heureBtnActionPerformed(evt);
            }
        });

        javax.swing.GroupLayout outilChoixLayout = new javax.swing.GroupLayout(outilChoix);
        outilChoix.setLayout(outilChoixLayout);
        outilChoixLayout.setHorizontalGroup(
            outilChoixLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(outilChoixLayout.createSequentialGroup()
                .addGap(49, 49, 49)
                .addComponent(metreBtn)
                .addGap(33, 33, 33)
                .addComponent(litreBtn)
                .addGap(46, 46, 46)
                .addComponent(heureBtn)
                .addContainerGap(64, Short.MAX_VALUE))
            .addGroup(javax.swing.GroupLayout.Alignment.TRAILING, outilChoixLayout.createSequentialGroup()
                .addContainerGap(107, Short.MAX_VALUE)
                .addComponent(jSeparator1, javax.swing.GroupLayout.PREFERRED_SIZE, 281, javax.swing.GroupLayout.PREFERRED_SIZE))
        );
        outilChoixLayout.setVerticalGroup(
            outilChoixLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(outilChoixLayout.createSequentialGroup()
                .addGroup(outilChoixLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(metreBtn)
                    .addComponent(litreBtn)
                    .addComponent(heureBtn))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                .addComponent(jSeparator1, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
        );

        combien.setHorizontalAlignment(javax.swing.JTextField.RIGHT);
        combien.setText("0");

        resultat.setHorizontalAlignment(javax.swing.SwingConstants.RIGHT);
        resultat.setText("0");

        uniteInit.setText("Mètre(s)");

        uniteFinal.setText("Centimètre(s)");

        javax.swing.GroupLayout OutilDonneesLayout = new javax.swing.GroupLayout(OutilDonnees);
        OutilDonnees.setLayout(OutilDonneesLayout);
        OutilDonneesLayout.setHorizontalGroup(
            OutilDonneesLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(OutilDonneesLayout.createSequentialGroup()
                .addGap(29, 29, 29)
                .addGroup(OutilDonneesLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addGroup(OutilDonneesLayout.createSequentialGroup()
                        .addGap(10, 10, 10)
                        .addComponent(resultat, javax.swing.GroupLayout.PREFERRED_SIZE, 71, javax.swing.GroupLayout.PREFERRED_SIZE)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addComponent(uniteFinal))
                    .addGroup(OutilDonneesLayout.createSequentialGroup()
                        .addComponent(combien, javax.swing.GroupLayout.PREFERRED_SIZE, 81, javax.swing.GroupLayout.PREFERRED_SIZE)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addComponent(uniteInit)))
                .addContainerGap(106, Short.MAX_VALUE))
        );
        OutilDonneesLayout.setVerticalGroup(
            OutilDonneesLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(javax.swing.GroupLayout.Alignment.TRAILING, OutilDonneesLayout.createSequentialGroup()
                .addContainerGap(javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                .addGroup(OutilDonneesLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(uniteInit)
                    .addComponent(combien, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
                .addGap(31, 31, 31)
                .addGroup(OutilDonneesLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(uniteFinal)
                    .addComponent(resultat))
                .addGap(94, 94, 94))
        );

        calculerBtn.setText("Calculer");
        calculerBtn.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                calculerBtnActionPerformed(evt);
            }
        });

        javax.swing.GroupLayout layout = new javax.swing.GroupLayout(getContentPane());
        getContentPane().setLayout(layout);
        layout.setHorizontalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(layout.createSequentialGroup()
                .addContainerGap()
                .addComponent(outilChoix, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                .addContainerGap())
            .addGroup(layout.createSequentialGroup()
                .addGap(150, 150, 150)
                .addComponent(calculerBtn)
                .addContainerGap(javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
            .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                .addGroup(layout.createSequentialGroup()
                    .addGap(47, 47, 47)
                    .addComponent(OutilDonnees, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                    .addContainerGap(47, Short.MAX_VALUE)))
        );
        layout.setVerticalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(layout.createSequentialGroup()
                .addGap(49, 49, 49)
                .addComponent(outilChoix, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED, 140, Short.MAX_VALUE)
                .addComponent(calculerBtn)
                .addGap(41, 41, 41))
            .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                .addGroup(layout.createSequentialGroup()
                    .addGap(97, 97, 97)
                    .addComponent(OutilDonnees, javax.swing.GroupLayout.PREFERRED_SIZE, 106, javax.swing.GroupLayout.PREFERRED_SIZE)
                    .addContainerGap(97, Short.MAX_VALUE)))
        );

        pack();
    }// </editor-fold>//GEN-END:initComponents

    private void metreBtnActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_metreBtnActionPerformed
        // 12.2.c Lorsque l'utilisateur sélectionne la bouton metreBtn
        // Les textes Mètre(s) et Centimètre(s) s'affichent au bon endroit
        uniteInit.setText("Mètre(s)");
        uniteFinal.setText("Centimètre(s)");
        resultat.setText("0") ;
        combien.setText("0") ;
        // 12.2.d La propriété choixAction est initialisée à "Metre"
        choixAction = "Metre";
    }//GEN-LAST:event_metreBtnActionPerformed

    private void litreBtnActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_litreBtnActionPerformed
        // 12.2.c Lorsque l'utilisateur sélectionne la bouton litreBtn
        // Les textes Litres(s) et Décilitre(s) s'affichent au bon endroit
        uniteInit.setText("Litre(s)");
        uniteFinal.setText("Décilitre(s)");
        resultat.setText("0") ;
        combien.setText("0") ;
        // 12.2.d La propriété choixAction est initialisée à "Litre"
        choixAction = "Litre";

    }//GEN-LAST:event_litreBtnActionPerformed

    private void heureBtnActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_heureBtnActionPerformed
        // 12.2.c Lorsque l'utilisateur sélectionne la bouton heureBtn
        // Les textes Heure(s) et Seconde(s) s'affichent au bon endroit
        uniteInit.setText("Heure(s)");
        uniteFinal.setText("Seconde(s)");
        resultat.setText("0") ;
        combien.setText("0") ;
        // 12.2.d La propriété choixAction est initialisée à "Heure"
        choixAction = "Heure";

    }//GEN-LAST:event_heureBtnActionPerformed

    private void calculerBtnActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_calculerBtnActionPerformed
        // 12.3.a Récupérer le contenu du champ de saisie combien
        float valeur = Float.parseFloat(combien.getText());
        // 12.3.b selon la valeur de choixAction, réaliser la conversion demandée
        if (choixAction.equalsIgnoreCase("Metre")){
            // 12.3.c Afficher le résultat sous forme de centimetre
            resultat.setText(convertirMetre (valeur)) ;
        }
        else if (choixAction.equals("Litre")){
            // 12.3.c Afficher le résultat sous forme de décilitre
            resultat.setText(convertirLitre(valeur));
        }
        else if (choixAction.equals("Heure")){
            // 12.3.c Afficher le résultat sous forme de seconde
            resultat.setText( convertirHeure(valeur));
        }
    }//GEN-LAST:event_calculerBtnActionPerformed

    // 12.3.b fonction de convertion de mètre en centimètre
private String convertirMetre(float val){
    float centimetre = val * 100;
    return Float.toString(centimetre);  
}
// 12.3.b fonction de convertion d'heure en seconde
private String convertirHeure(float val){
    float seconde = val * 3600;
    return Float.toString(seconde);  
}
// 12.3.b fonction de convertion de litre en décilitre
private String convertirLitre(float val){
    float decilitre = val * 10;
    return Float.toString(decilitre);
    
}
    /**
     * @param args the command line arguments
     */
    public static void main(String args[]) {
        /* Set the Nimbus look and feel */
        //<editor-fold defaultstate="collapsed" desc=" Look and feel setting code (optional) ">
        /* If Nimbus (introduced in Java SE 6) is not available, stay with the default look and feel.
         * For details see http://download.oracle.com/javase/tutorial/uiswing/lookandfeel/plaf.html 
         */
        try {
            for (javax.swing.UIManager.LookAndFeelInfo info : javax.swing.UIManager.getInstalledLookAndFeels()) {
                if ("Nimbus".equals(info.getName())) {
                    javax.swing.UIManager.setLookAndFeel(info.getClassName());
                    break;
                }
            }
        } catch (ClassNotFoundException ex) {
            java.util.logging.Logger.getLogger(Main.class.getName()).log(java.util.logging.Level.SEVERE, null, ex);
        } catch (InstantiationException ex) {
            java.util.logging.Logger.getLogger(Main.class.getName()).log(java.util.logging.Level.SEVERE, null, ex);
        } catch (IllegalAccessException ex) {
            java.util.logging.Logger.getLogger(Main.class.getName()).log(java.util.logging.Level.SEVERE, null, ex);
        } catch (javax.swing.UnsupportedLookAndFeelException ex) {
            java.util.logging.Logger.getLogger(Main.class.getName()).log(java.util.logging.Level.SEVERE, null, ex);
        }
        //</editor-fold>

        /* Create and display the form */
        java.awt.EventQueue.invokeLater(new Runnable() {
            public void run() {
                new Main().setVisible(true);
            }
        });
    }

    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JPanel OutilDonnees;
    private javax.swing.JButton calculerBtn;
    private javax.swing.JTextField combien;
    private javax.swing.ButtonGroup groupeRadioBtn;
    private javax.swing.JRadioButton heureBtn;
    private javax.swing.JSeparator jSeparator1;
    private javax.swing.JRadioButton litreBtn;
    private javax.swing.JRadioButton metreBtn;
    private javax.swing.JPanel outilChoix;
    private javax.swing.JLabel resultat;
    private javax.swing.JLabel uniteFinal;
    private javax.swing.JLabel uniteInit;
    // End of variables declaration//GEN-END:variables

}
