/*
#	Le livre de Java 1er langage
#	A. Tasso
#	Chapitre 12 : Créer une interface graphique
#	Section  : Gestion de bulletins de notes
#	Fichier  : ClasseSwing.java
#	Class    : ClasseSwing
*/

// Le fichier ClasseSwing.java se trouve dans le répertoire 
// Sources/Exemples/Chapitre12/NetBeansProjects/GestionClasseExemple/src/Introduction
package introduction;
// Pour traiter les opérations sur les fichiers
// Pour traiter les opérations sur les fichiers
import java.io.File;
// Pour rechercher un fichier dans votre système de fichiers
import javax.swing.JFileChooser;
/**
 *
 * @author Anne Tasso
 */
// La classe ClasseSwing hérite des propriétés et méthodes de la la classe JFRame
public class CursusSwing extends javax.swing.JFrame {

   // Initialiser la photo par défaut à celle d'une silhouette
    // Modifier l'url d'accès au fichier Inconnu.jpg selon votre système d'exploitation
    // Les photos se trouvent dans le répertoire 
    // Sources/Exemples/Chapitre12/NetBeansProjects/GestionClasseExemple/Photos
    private String urlPhoto="/Users/VotreCompte/Photos/Inconnu.jpg";
    private String periode ;
    private String [] listeMatieres;

    public CursusSwing() {
         // Afficher les composants graphiques tels qu'ils sont placés dans le fenêtre Design
        initComponents();
        // Placer la fenêtre en 100, 100 par rapport au coin supérieur gauche de l'écran
        // largeur 450, hauteur 500
        setBounds(100, 100, 450, 500);
        // Afficher un texte dans la zone info
        info.setText("  Créer : Tous les champs doivent être renseignés !");

    }

    /**
     * This method is called from within the constructor to initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is always
     * regenerated by the Form Editor.
     */
    @SuppressWarnings("unchecked")
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {

        labelTitre = new javax.swing.JLabel();
        separationTitre = new javax.swing.JSeparator();
        labelNom = new javax.swing.JLabel();
        nomAsaisir = new javax.swing.JTextField();
        labelPrenom = new javax.swing.JLabel();
        prenomAsaisir = new javax.swing.JTextField();
        labelPeriode = new javax.swing.JLabel();
        choixPeriode = new javax.swing.JComboBox<>();
        labelPhoto = new javax.swing.JLabel();
        rechercherBtn = new javax.swing.JButton();
        validerBtn = new javax.swing.JButton();
        fermerBtn = new javax.swing.JButton();
        info = new javax.swing.JLabel();

        setDefaultCloseOperation(javax.swing.WindowConstants.EXIT_ON_CLOSE);
        setTitle("Gestion des Etudiants");
        setPreferredSize(new java.awt.Dimension(500, 518));
        addMouseListener(new java.awt.event.MouseAdapter() {
            public void mouseEntered(java.awt.event.MouseEvent evt) {
                formMouseEntered(evt);
            }
        });

        labelTitre.setFont(new java.awt.Font("Lucida Grande", 1, 14)); // NOI18N
        labelTitre.setText("Etudiant");

        labelNom.setText("Nom :");

        nomAsaisir.setHorizontalAlignment(javax.swing.JTextField.RIGHT);
        nomAsaisir.setText(" ");
        nomAsaisir.addMouseListener(new java.awt.event.MouseAdapter() {
            public void mouseEntered(java.awt.event.MouseEvent evt) {
                nomAsaisirMouseEntered(evt);
            }
        });

        labelPrenom.setText("Prénom :");

        prenomAsaisir.setHorizontalAlignment(javax.swing.JTextField.RIGHT);
        prenomAsaisir.setText(" ");
        prenomAsaisir.addMouseListener(new java.awt.event.MouseAdapter() {
            public void mouseEntered(java.awt.event.MouseEvent evt) {
                prenomAsaisirMouseEntered(evt);
            }
        });
        prenomAsaisir.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                prenomAsaisirActionPerformed(evt);
            }
        });

        labelPeriode.setText("Période :");

        choixPeriode.setModel(new javax.swing.DefaultComboBoxModel<>(new String[] { "Quel semestre ?", "Semestre 1", "Semestre 2", "Semestre 3", "Semestre 4" }));
        choixPeriode.addMouseListener(new java.awt.event.MouseAdapter() {
            public void mouseEntered(java.awt.event.MouseEvent evt) {
                choixPeriodeMouseEntered(evt);
            }
        });
        choixPeriode.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                choixPeriodeActionPerformed(evt);
            }
        });

        labelPhoto.setText("Photo :");

        rechercherBtn.setText("Rechercher...");
        rechercherBtn.addMouseListener(new java.awt.event.MouseAdapter() {
            public void mouseEntered(java.awt.event.MouseEvent evt) {
                rechercherBtnMouseEntered(evt);
            }
        });
        rechercherBtn.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                rechercherBtnActionPerformed(evt);
            }
        });

        validerBtn.setText("Valider");
        validerBtn.addMouseListener(new java.awt.event.MouseAdapter() {
            public void mouseEntered(java.awt.event.MouseEvent evt) {
                validerBtnMouseEntered(evt);
            }
        });
        validerBtn.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                validerBtnActionPerformed(evt);
            }
        });

        fermerBtn.setText("Quitter");
        fermerBtn.addMouseListener(new java.awt.event.MouseAdapter() {
            public void mouseEntered(java.awt.event.MouseEvent evt) {
                fermerBtnMouseEntered(evt);
            }
        });
        fermerBtn.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                fermerBtnActionPerformed(evt);
            }
        });

        info.setFont(new java.awt.Font("Arial", 2, 13)); // NOI18N
        info.setForeground(new java.awt.Color(120, 120, 120));
        info.setText("Info :");

        javax.swing.GroupLayout layout = new javax.swing.GroupLayout(getContentPane());
        getContentPane().setLayout(layout);
        layout.setHorizontalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(layout.createSequentialGroup()
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addGroup(layout.createSequentialGroup()
                        .addGap(80, 80, 80)
                        .addComponent(validerBtn)
                        .addGap(116, 116, 116)
                        .addComponent(fermerBtn))
                    .addGroup(layout.createSequentialGroup()
                        .addGap(64, 64, 64)
                        .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                            .addGroup(layout.createSequentialGroup()
                                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                                    .addComponent(labelPrenom)
                                    .addComponent(labelNom)
                                    .addComponent(labelPeriode)
                                    .addComponent(labelPhoto))
                                .addGap(74, 74, 74)
                                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                                    .addComponent(rechercherBtn)
                                    .addComponent(choixPeriode, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                                    .addComponent(nomAsaisir, javax.swing.GroupLayout.PREFERRED_SIZE, 156, javax.swing.GroupLayout.PREFERRED_SIZE)
                                    .addComponent(prenomAsaisir, javax.swing.GroupLayout.PREFERRED_SIZE, 156, javax.swing.GroupLayout.PREFERRED_SIZE)))
                            .addComponent(info, javax.swing.GroupLayout.PREFERRED_SIZE, 386, javax.swing.GroupLayout.PREFERRED_SIZE)))
                    .addGroup(layout.createSequentialGroup()
                        .addContainerGap()
                        .addComponent(separationTitre, javax.swing.GroupLayout.PREFERRED_SIZE, 643, javax.swing.GroupLayout.PREFERRED_SIZE))
                    .addGroup(layout.createSequentialGroup()
                        .addGap(202, 202, 202)
                        .addComponent(labelTitre)))
                .addContainerGap(javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
        );
        layout.setVerticalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(layout.createSequentialGroup()
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addGroup(layout.createSequentialGroup()
                        .addGap(27, 27, 27)
                        .addComponent(labelTitre)
                        .addGap(49, 49, 49)
                        .addComponent(separationTitre, javax.swing.GroupLayout.PREFERRED_SIZE, 23, javax.swing.GroupLayout.PREFERRED_SIZE)
                        .addGap(18, 18, 18)
                        .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                            .addComponent(labelNom)
                            .addComponent(nomAsaisir, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
                        .addGap(18, 18, 18)
                        .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                            .addComponent(labelPrenom)
                            .addComponent(prenomAsaisir, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
                        .addGap(28, 28, 28)
                        .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                            .addComponent(labelPeriode)
                            .addComponent(choixPeriode, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
                        .addGap(36, 36, 36)
                        .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                            .addComponent(labelPhoto)
                            .addComponent(rechercherBtn))
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED, 119, Short.MAX_VALUE))
                    .addGroup(layout.createSequentialGroup()
                        .addContainerGap(javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                        .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                            .addComponent(validerBtn)
                            .addComponent(fermerBtn))
                        .addGap(37, 37, 37)))
                .addComponent(info)
                .addGap(59, 59, 59))
        );

        pack();
    }// </editor-fold>//GEN-END:initComponents

    private void prenomAsaisirActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_prenomAsaisirActionPerformed
        // TODO add your handling code here:
    }//GEN-LAST:event_prenomAsaisirActionPerformed

    private void validerBtnActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_validerBtnActionPerformed
       //  Enregistrer les nom et prénom de l’étudiant
  String nom = nomAsaisir.getText();
  String prenom = prenomAsaisir.getText();
  //    Créer et initialiser à 0 le tableau des moyennes
  double [] moyenne = new double[listeMatieres.length];
  for (int i=0; i < moyenne.length; i++) moyenne[i]=0;
  //  Créer un étudiant 
  Etudiant eleve = new Etudiant(nom, prenom, urlPhoto, listeMatieres, periode, moyenne);
  //  Créer un bulletin de notes 
  BulletinNotes bn = new BulletinNotes(eleve);
    }//GEN-LAST:event_validerBtnActionPerformed

    private void fermerBtnActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_fermerBtnActionPerformed
      // Sortir de l'application
        System.exit(0);
    }//GEN-LAST:event_fermerBtnActionPerformed

    private void nomAsaisirMouseEntered(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_nomAsaisirMouseEntered
       // Afficher un texte dans la zone info
        info.setText("  Info : Saisir le nom de l'étudiant" );
    }//GEN-LAST:event_nomAsaisirMouseEntered

    private void prenomAsaisirMouseEntered(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_prenomAsaisirMouseEntered
        // Afficher un texte dans la zone info
        info.setText("  Info : Saisir le prénom de l'étudiant" );
    }//GEN-LAST:event_prenomAsaisirMouseEntered

    private void rechercherBtnMouseEntered(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_rechercherBtnMouseEntered
       // Afficher un texte dans la zone info
        info.setText("  Info : Rechercher la photo de l'étudiant" );
    }//GEN-LAST:event_rechercherBtnMouseEntered

    private void validerBtnMouseEntered(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_validerBtnMouseEntered
       // Afficher un texte dans la zone info
        info.setText("  Info : Afficher le bulletin de notes de l'étudiant" );
    }//GEN-LAST:event_validerBtnMouseEntered

    private void fermerBtnMouseEntered(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_fermerBtnMouseEntered
       // Afficher un texte dans la zone info
        info.setText("  Info : Quitter l'application " );

    }//GEN-LAST:event_fermerBtnMouseEntered

    private void formMouseEntered(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_formMouseEntered
       // Afficher un texte dans la zone info
        info.setText("  Info : Tous les champs doivent être renseignés !");

    }//GEN-LAST:event_formMouseEntered

    private void rechercherBtnActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_rechercherBtnActionPerformed
       // Création d’un objet de type File
    File fichierPhoto;
    // Création d’un composant JFileChooser 
    JFileChooser fichierArechercher= new JFileChooser();
    //  Ouvrir une boite de dialogue qui permet la recherche d’un fichier
    int etatRetour = fichierArechercher.showOpenDialog(CursusSwing.this);
     //  Si l’utilisateur a sélectionné un fichier
    if (etatRetour == JFileChooser.APPROVE_OPTION) {
         //  Récupérer le fichier sélectionné
         fichierPhoto = fichierArechercher.getSelectedFile();
         //  Stocker le chemin d’accès au fichier dans urlPhoto
         urlPhoto  = fichierPhoto.toString();
     } 
    }//GEN-LAST:event_rechercherBtnActionPerformed

    private void choixPeriodeActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_choixPeriodeActionPerformed
         // Récupérer le semestre sélectionné
        periode = (String) choixPeriode.getSelectedItem();
        // Rechercher la liste des matières en fonction du semestre
        rechercherMatiere(periode);
    }//GEN-LAST:event_choixPeriodeActionPerformed

    private void choixPeriodeMouseEntered(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_choixPeriodeMouseEntered
        // Afficher un texte dans la zone info
        info.setText("  Info : Sélectionner le semestre souhiaté");
    }//GEN-LAST:event_choixPeriodeMouseEntered
    private void rechercherMatiere(String quelSemestre){    
         Fichier fichierTxt = new Fichier(); 
        listeMatieres = new String [5];
         String [] tousLesmots = new String[6];
        // Modifier l'url d'accès au fichier Inconnu.jpg selon votre système d'exploitation
        // Le fichier Ressources.txt se trouve dans le répertoire 
        // Sources/Exemples/Chapitre12/NetBeansProjects/GestionClasseExemple/Ressources
        if (fichierTxt.ouvrir("/Users/VotreCompte/Ressources/Ressources.txt", "R")){
              // Voir chapitre 10, corrigé de l'exercice 10.5
             do {
                tousLesmots = fichierTxt.lire();
                if (tousLesmots[0].equalsIgnoreCase(quelSemestre)){
                 for (int i=1; i < tousLesmots.length; i++){
                      listeMatieres[i-1] = tousLesmots[i]; 
                    }
                break;
                }
             } while (tousLesmots[0]!= null);
            fichierTxt.fermer();
        }
        else {
            listeMatieres[0]="Communication";
            listeMatieres[1]= "Anglais";
            listeMatieres[2]="Algoritmique;";
            listeMatieres[3]= "Programmation";
            listeMatieres[4]= "Mathématiques" ;
        }
    }

    /**
     * @param args the command line arguments
     */
    public static void main(String args[]) {
        /* Set the Nimbus look and feel */
        //<editor-fold defaultstate="collapsed" desc=" Look and feel setting code (optional) ">
        /* If Nimbus (introduced in Java SE 6) is not available, stay with the default look and feel.
         * For details see http://download.oracle.com/javase/tutorial/uiswing/lookandfeel/plaf.html 
         */
        try {
            for (javax.swing.UIManager.LookAndFeelInfo info : javax.swing.UIManager.getInstalledLookAndFeels()) {
                if ("Nimbus".equals(info.getName())) {
                    javax.swing.UIManager.setLookAndFeel(info.getClassName());
                    break;
                }
            }
        } catch (ClassNotFoundException ex) {
            java.util.logging.Logger.getLogger(CursusSwing.class.getName()).log(java.util.logging.Level.SEVERE, null, ex);
        } catch (InstantiationException ex) {
            java.util.logging.Logger.getLogger(CursusSwing.class.getName()).log(java.util.logging.Level.SEVERE, null, ex);
        } catch (IllegalAccessException ex) {
            java.util.logging.Logger.getLogger(CursusSwing.class.getName()).log(java.util.logging.Level.SEVERE, null, ex);
        } catch (javax.swing.UnsupportedLookAndFeelException ex) {
            java.util.logging.Logger.getLogger(CursusSwing.class.getName()).log(java.util.logging.Level.SEVERE, null, ex);
        }
        //</editor-fold>

        /* Create and display the form */
        java.awt.EventQueue.invokeLater(new Runnable() {
            public void run() {
                new CursusSwing().setVisible(true);
            }
        });
    }

    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JComboBox<String> choixPeriode;
    private javax.swing.JButton fermerBtn;
    private javax.swing.JLabel info;
    private javax.swing.JLabel labelNom;
    private javax.swing.JLabel labelPeriode;
    private javax.swing.JLabel labelPhoto;
    private javax.swing.JLabel labelPrenom;
    private javax.swing.JLabel labelTitre;
    private javax.swing.JTextField nomAsaisir;
    private javax.swing.JTextField prenomAsaisir;
    private javax.swing.JButton rechercherBtn;
    private javax.swing.JSeparator separationTitre;
    private javax.swing.JButton validerBtn;
    // End of variables declaration//GEN-END:variables
}
