/*
 * Decompiled with CFR 0.152.
 */
package Projet;

import Projet.Compte;
import Projet.FichierCompte;
import Projet.LigneComptable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.border.TitledBorder;

public class LigneDialogue
extends JFrame {
    private String motif = "Divers";
    private String transaction = "C.B.";
    private Compte compte;
    private JPanel boiteMenu;
    private JComboBox choixMotif;
    private JComboBox choixTransaction;
    private JButton creditBtn;
    private JButton debitBtn;
    private JLabel labelEuros;
    private JLabel labelMotif;
    private JLabel labelSolde;
    private JLabel labelTransaction;
    private JLabel photoFond;
    private JTextField valeurAsaisir;

    public LigneDialogue(Compte cpt) {
        this.initComponents();
        this.compte = cpt;
        TitledBorder cadre = BorderFactory.createTitledBorder("   Compte " + cpt.getType() + "  n\u00b0  " + cpt.getNumero() + "  : " + cpt.getSolde() + " Euros  ");
        this.boiteMenu.setBorder(cadre);
        this.setBounds(200, 320, 500, 485);
        this.setVisible(true);
        ImageIcon iconPhoto = new ImageIcon("Ressources/FondCompte.png");
        this.photoFond.setIcon(iconPhoto);
    }

    private void initComponents() {
        this.boiteMenu = new JPanel();
        this.valeurAsaisir = new JTextField();
        this.debitBtn = new JButton();
        this.labelSolde = new JLabel();
        this.labelEuros = new JLabel();
        this.creditBtn = new JButton();
        this.choixMotif = new JComboBox();
        this.choixTransaction = new JComboBox();
        this.labelTransaction = new JLabel();
        this.labelMotif = new JLabel();
        this.photoFond = new JLabel();
        this.setDefaultCloseOperation(3);
        this.boiteMenu.setBorder(BorderFactory.createTitledBorder("   Ligne comptable   "));
        this.valeurAsaisir.setHorizontalAlignment(4);
        this.valeurAsaisir.setText("0.0");
        this.debitBtn.setText("D\u00e9bit");
        this.debitBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LigneDialogue.this.debitBtnActionPerformed(evt);
            }
        });
        this.labelSolde.setText("Valeur :");
        this.labelEuros.setText("Euros");
        this.creditBtn.setText("Cr\u00e9dit");
        this.creditBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LigneDialogue.this.creditBtnActionPerformed(evt);
            }
        });
        this.choixMotif.setModel(new DefaultComboBoxModel<String>(new String[]{"Choisir ...", "Salaire", "Loyer", "Alimentation", "\u00c9nergie", "Taxes", "Divers"}));
        this.choixMotif.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LigneDialogue.this.choixMotifActionPerformed(evt);
            }
        });
        this.choixTransaction.setModel(new DefaultComboBoxModel<String>(new String[]{"Choisir ...", "C.B.", "Virement", "Ch\u00e8que"}));
        this.choixTransaction.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LigneDialogue.this.choixTransactionActionPerformed(evt);
            }
        });
        this.labelTransaction.setText("Transaction :");
        this.labelMotif.setText("Motif : ");
        GroupLayout boiteMenuLayout = new GroupLayout(this.boiteMenu);
        this.boiteMenu.setLayout(boiteMenuLayout);
        boiteMenuLayout.setHorizontalGroup(boiteMenuLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(boiteMenuLayout.createSequentialGroup().addContainerGap().addGroup(boiteMenuLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(boiteMenuLayout.createSequentialGroup().addComponent(this.labelSolde).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.valeurAsaisir, -2, 77, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.labelEuros)).addGroup(boiteMenuLayout.createParallelGroup(GroupLayout.Alignment.TRAILING, false).addGroup(GroupLayout.Alignment.LEADING, boiteMenuLayout.createSequentialGroup().addComponent(this.debitBtn).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.creditBtn)).addGroup(GroupLayout.Alignment.LEADING, boiteMenuLayout.createSequentialGroup().addGroup(boiteMenuLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.labelTransaction).addComponent(this.labelMotif)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(boiteMenuLayout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.choixTransaction, -2, -1, -2).addComponent(this.choixMotif, -2, -1, -2))))).addContainerGap(209, Short.MAX_VALUE)));
        boiteMenuLayout.setVerticalGroup(boiteMenuLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(boiteMenuLayout.createSequentialGroup().addContainerGap().addGroup(boiteMenuLayout.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(this.labelSolde).addComponent(this.labelEuros).addComponent(this.valeurAsaisir, -2, -1, -2)).addGap(18, 18, 18).addGroup(boiteMenuLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.labelMotif).addComponent(this.choixMotif, -2, -1, -2)).addGap(18, 18, 18).addGroup(boiteMenuLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.labelTransaction).addComponent(this.choixTransaction, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 31, Short.MAX_VALUE).addGroup(boiteMenuLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.debitBtn).addComponent(this.creditBtn)).addGap(27, 27, 27)));
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGap(131, 131, 131).addComponent(this.photoFond)).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.boiteMenu, -2, -1, -2))).addContainerGap(78, Short.MAX_VALUE)));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.boiteMenu, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.photoFond).addContainerGap(55, Short.MAX_VALUE)));
        this.pack();
    }

    private void debitBtnActionPerformed(ActionEvent evt) {
        double valeur = -Double.parseDouble(this.valeurAsaisir.getText());
        LigneComptable tmp = new LigneComptable(valeur, this.motif, this.transaction);
        this.compte.setLigne(tmp);
        FichierCompte fc = new FichierCompte();
        fc.ouvrir("Comptes/" + this.compte.getNumero() + ".dat", "W");
        fc.ecrire(this.compte);
        fc.fermer();
        this.dispose();
    }

    private void creditBtnActionPerformed(ActionEvent evt) {
        double valeur = Double.parseDouble(this.valeurAsaisir.getText());
        LigneComptable tmp = new LigneComptable(valeur, this.motif, this.transaction);
        this.compte.setLigne(tmp);
        FichierCompte fc = new FichierCompte();
        fc.ouvrir("Comptes/" + this.compte.getNumero() + ".dat", "W");
        fc.ecrire(this.compte);
        fc.fermer();
        this.dispose();
    }

    private void choixMotifActionPerformed(ActionEvent evt) {
        this.motif = (String)this.choixMotif.getSelectedItem();
    }

    private void choixTransactionActionPerformed(ActionEvent evt) {
        this.transaction = (String)this.choixTransaction.getSelectedItem();
    }
}

