/*
 * Decompiled with CFR 0.152.
 */
package introduction;

import introduction.BulletinNotes;
import introduction.Cursus;
import introduction.Etudiant;
import introduction.Fichier;
import introduction.FichierEtudiant;
import introduction.Message;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;

public class CursusSwing
extends JFrame {
    private String urlPhoto = "/Users/VotreCompte/Photos/Inconnu.jpg";
    private String periode;
    private String[] listeMatieres;
    private boolean etatComboBox = false;
    private String choixAction = "Creer";
    private JPanel PanelMenu;
    private JPanel PanelTitre;
    private JComboBox choixPeriode;
    private JRadioButton creerRadioBtn;
    private JButton fermerBtn;
    private ButtonGroup groupeBtn;
    private JLabel info;
    private JSeparator jSeparator1;
    private JSeparator jSeparator2;
    private JLabel labelNom;
    private JLabel labelPeriode;
    private JLabel labelPhoto;
    private JLabel labelPrenom;
    private JLabel labelTitre;
    private JRadioButton modifierRadioBtn;
    private JTextField nomAsaisir;
    private JTextField prenomAsaisir;
    private JButton rechercherBtn;
    private JRadioButton supprimerRadioBtn;
    private JButton validerBtn;

    public CursusSwing() {
        this.initComponents();
        this.setBounds(100, 100, 450, 500);
        this.groupeBtn.add(this.creerRadioBtn);
        this.groupeBtn.add(this.modifierRadioBtn);
        this.groupeBtn.add(this.supprimerRadioBtn);
        this.creerRadioBtn.setSelected(true);
        this.info.setText("  Cr\u00e9er : Tous les champs doivent \u00eatre renseign\u00e9s !");
    }

    private void initComponents() {
        this.groupeBtn = new ButtonGroup();
        this.PanelTitre = new JPanel();
        this.labelTitre = new JLabel();
        this.PanelMenu = new JPanel();
        this.creerRadioBtn = new JRadioButton();
        this.modifierRadioBtn = new JRadioButton();
        this.supprimerRadioBtn = new JRadioButton();
        this.jSeparator1 = new JSeparator();
        this.jSeparator2 = new JSeparator();
        this.labelPrenom = new JLabel();
        this.labelPeriode = new JLabel();
        this.choixPeriode = new JComboBox();
        this.nomAsaisir = new JTextField();
        this.prenomAsaisir = new JTextField();
        this.labelPhoto = new JLabel();
        this.rechercherBtn = new JButton();
        this.labelNom = new JLabel();
        this.validerBtn = new JButton();
        this.info = new JLabel();
        this.fermerBtn = new JButton();
        this.setDefaultCloseOperation(3);
        this.setTitle("Gestion des Etudiants");
        this.setPreferredSize(new Dimension(500, 518));
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent evt) {
                CursusSwing.this.formMouseEntered(evt);
            }
        });
        this.labelTitre.setFont(new Font("Arial", 0, 18));
        this.labelTitre.setHorizontalAlignment(0);
        this.labelTitre.setText("\u00c9tudiant  ");
        GroupLayout PanelTitreLayout = new GroupLayout(this.PanelTitre);
        this.PanelTitre.setLayout(PanelTitreLayout);
        PanelTitreLayout.setHorizontalGroup(PanelTitreLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, PanelTitreLayout.createSequentialGroup().addContainerGap(106, Short.MAX_VALUE).addComponent(this.labelTitre, -2, 197, -2).addGap(55, 55, 55)));
        PanelTitreLayout.setVerticalGroup(PanelTitreLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, PanelTitreLayout.createSequentialGroup().addContainerGap(20, Short.MAX_VALUE).addComponent(this.labelTitre).addContainerGap()));
        this.creerRadioBtn.setText("Cr\u00e9er");
        this.creerRadioBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CursusSwing.this.creerRadioBtnActionPerformed(evt);
            }
        });
        this.creerRadioBtn.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent evt) {
                CursusSwing.this.creerRadioBtnMouseEntered(evt);
            }
        });
        this.modifierRadioBtn.setSelected(true);
        this.modifierRadioBtn.setText("Modifier");
        this.modifierRadioBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CursusSwing.this.modifierRadioBtnActionPerformed(evt);
            }
        });
        this.modifierRadioBtn.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent evt) {
                CursusSwing.this.modifierRadioBtnMouseEntered(evt);
            }
        });
        this.supprimerRadioBtn.setText("Supprimer");
        this.supprimerRadioBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CursusSwing.this.supprimerRadioBtnActionPerformed(evt);
            }
        });
        this.supprimerRadioBtn.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent evt) {
                CursusSwing.this.supprimerRadioBtnMouseEntered(evt);
            }
        });
        GroupLayout PanelMenuLayout = new GroupLayout(this.PanelMenu);
        this.PanelMenu.setLayout(PanelMenuLayout);
        PanelMenuLayout.setHorizontalGroup(PanelMenuLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(PanelMenuLayout.createSequentialGroup().addContainerGap().addComponent(this.creerRadioBtn).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 80, Short.MAX_VALUE).addComponent(this.modifierRadioBtn).addGap(45, 45, 45).addComponent(this.supprimerRadioBtn).addGap(38, 38, 38)));
        PanelMenuLayout.setVerticalGroup(PanelMenuLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, PanelMenuLayout.createSequentialGroup().addGroup(PanelMenuLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.creerRadioBtn).addComponent(this.supprimerRadioBtn).addComponent(this.modifierRadioBtn)).addContainerGap(9, Short.MAX_VALUE)));
        this.labelPrenom.setText("Pr\u00e9nom :");
        this.labelPeriode.setText("P\u00e9riode :");
        this.choixPeriode.setModel(new DefaultComboBoxModel<String>(new String[]{"Quel semestre ?", "Semestre 1", "Semestre 2", "Semestre 3", "Semestre 4"}));
        this.choixPeriode.addPopupMenuListener(new PopupMenuListener(){

            @Override
            public void popupMenuCanceled(PopupMenuEvent evt) {
            }

            @Override
            public void popupMenuWillBecomeInvisible(PopupMenuEvent evt) {
                CursusSwing.this.choixPeriodePopupMenuWillBecomeInvisible(evt);
            }

            @Override
            public void popupMenuWillBecomeVisible(PopupMenuEvent evt) {
                CursusSwing.this.choixPeriodePopupMenuWillBecomeVisible(evt);
            }
        });
        this.choixPeriode.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CursusSwing.this.choixPeriodeActionPerformed(evt);
            }
        });
        this.nomAsaisir.setDragEnabled(false);
        this.nomAsaisir.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent evt) {
                CursusSwing.this.nomAsaisirMouseEntered(evt);
            }
        });
        this.prenomAsaisir.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent evt) {
                CursusSwing.this.prenomAsaisirMouseEntered(evt);
            }
        });
        this.labelPhoto.setText("Photo :");
        this.rechercherBtn.setText("Rechercher");
        this.rechercherBtn.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent evt) {
                CursusSwing.this.rechercherBtnMouseEntered(evt);
            }
        });
        this.rechercherBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CursusSwing.this.rechercherBtnActionPerformed(evt);
            }
        });
        this.labelNom.setText("Nom :");
        this.validerBtn.setText("Valider");
        this.validerBtn.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent evt) {
                CursusSwing.this.validerBtnMouseEntered(evt);
            }
        });
        this.validerBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CursusSwing.this.validerBtnActionPerformed(evt);
            }
        });
        this.info.setBackground(new Color(250, 250, 250));
        this.info.setFont(new Font("Arial", 2, 13));
        this.info.setForeground(new Color(120, 120, 120));
        this.info.setText(" info :");
        this.info.setBorder(BorderFactory.createEtchedBorder());
        this.info.setOpaque(true);
        this.fermerBtn.setText("Fermer");
        this.fermerBtn.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent evt) {
                CursusSwing.this.fermerBtnMouseEntered(evt);
            }
        });
        this.fermerBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CursusSwing.this.fermerBtnActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jSeparator2, -1, 655, Short.MAX_VALUE).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap(235, Short.MAX_VALUE).addComponent(this.PanelMenu, -2, -1, -2).addContainerGap()).addComponent(this.jSeparator1, GroupLayout.Alignment.TRAILING, -1, 655, Short.MAX_VALUE).addComponent(this.info, -1, 655, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addGap(35, 35, 35).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.labelPrenom, -2, 79, -2).addComponent(this.labelPeriode, -2, 71, -2).addComponent(this.labelPhoto, -2, 60, -2).addComponent(this.labelNom, -1, 312, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.nomAsaisir, -2, 166, -2).addComponent(this.prenomAsaisir, -2, 163, -2).addComponent(this.rechercherBtn).addComponent(this.choixPeriode, -2, 193, -2)).addGap(109, 109, 109)).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGap(12, 12, 12).addComponent(this.PanelTitre, -2, -1, -2)).addGroup(layout.createSequentialGroup().addGap(86, 86, 86).addComponent(this.validerBtn).addGap(73, 73, 73).addComponent(this.fermerBtn))).addContainerGap(-1, Short.MAX_VALUE)));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.PanelTitre, -2, -1, -2).addGap(3, 3, 3).addComponent(this.jSeparator2, -2, 12, -2).addGap(18, 18, 18).addComponent(this.PanelMenu, -2, -1, -2).addGap(2, 2, 2).addComponent(this.jSeparator1, -2, -1, -2).addGap(42, 42, 42).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGap(107, 107, 107).addComponent(this.rechercherBtn)).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.nomAsaisir, -2, -1, -2).addComponent(this.labelNom, -2, 28, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.prenomAsaisir, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.choixPeriode, -2, 28, -2)).addGroup(layout.createSequentialGroup().addGap(36, 36, 36).addComponent(this.labelPrenom, -2, 28, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.labelPeriode, -2, 28, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.labelPhoto, -2, 29, -2))).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 85, Short.MAX_VALUE).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.validerBtn).addComponent(this.fermerBtn)).addGap(18, 18, 18).addComponent(this.info, -2, 37, -2).addGap(44, 44, 44)));
        this.pack();
    }

    private void formMouseEntered(MouseEvent evt) {
        this.info.setText("  Info : Tous les champs doivent \u00eatre renseign\u00e9s !");
    }

    private void creerRadioBtnActionPerformed(ActionEvent evt) {
        this.choixAction = "Creer";
    }

    private void creerRadioBtnMouseEntered(MouseEvent evt) {
        if (this.etatComboBox) {
            this.info.setText("  Info : Choisir la p\u00e9riode de validation des notes");
        } else {
            this.info.setText("  Cr\u00e9er : Tous les champs doivent \u00eatre renseign\u00e9s !");
        }
    }

    private void modifierRadioBtnActionPerformed(ActionEvent evt) {
        this.choixAction = "Modifier";
    }

    private void modifierRadioBtnMouseEntered(MouseEvent evt) {
        if (this.etatComboBox) {
            this.info.setText("  Info : Choisir la p\u00e9riode de validation des notes");
        } else {
            this.info.setText("  Modifier un \u00e9tudiant, vous devez conna\u00eetre son nom et son pr\u00e9nom");
        }
    }

    private void supprimerRadioBtnActionPerformed(ActionEvent evt) {
        this.choixAction = "Supprimer";
    }

    private void supprimerRadioBtnMouseEntered(MouseEvent evt) {
        if (this.etatComboBox) {
            this.info.setText("  Info : Choisir la p\u00e9riode de validation des notes");
        } else {
            this.info.setText("  Supprimer un \u00e9tudiant, vous devez conna\u00eetre son nom et son pr\u00e9nom ");
        }
    }

    private void choixPeriodePopupMenuWillBecomeInvisible(PopupMenuEvent evt) {
        this.etatComboBox = false;
        this.info.setText("  Info : Tous les champs doivent \u00eatre renseign\u00e9s !");
    }

    private void choixPeriodePopupMenuWillBecomeVisible(PopupMenuEvent evt) {
        this.etatComboBox = true;
        this.info.setText("  Info : Choisir la p\u00e9riode de validation des notes");
    }

    private void choixPeriodeActionPerformed(ActionEvent evt) {
        this.periode = (String)this.choixPeriode.getSelectedItem();
        this.rechercherMatiere(this.periode);
    }

    private void nomAsaisirMouseEntered(MouseEvent evt) {
        if (this.etatComboBox) {
            this.info.setText("  Info : Choisir la p\u00e9riode de validation des notes");
        } else {
            this.info.setText("  Info : Entrer le nom de l'\u00e9tudiant ");
        }
    }

    private void prenomAsaisirMouseEntered(MouseEvent evt) {
        if (this.etatComboBox) {
            this.info.setText("  Info : Choisir la p\u00e9riode de validation des notes");
        } else {
            this.info.setText("  Info : Entrer le pr\u00e9nom de l'\u00e9tudiant ");
        }
    }

    private void rechercherBtnMouseEntered(MouseEvent evt) {
        if (this.etatComboBox) {
            this.info.setText("  Info : Choisir la p\u00e9riode de de validation des notes");
        } else {
            this.info.setText("  Info : Choisir la photo de l'\u00e9tudiant ");
        }
    }

    private void rechercherBtnActionPerformed(ActionEvent evt) {
        JFileChooser fichierArechercher = new JFileChooser();
        int etatRetour = fichierArechercher.showOpenDialog(this);
        if (etatRetour == 0) {
            File fichierPhoto = fichierArechercher.getSelectedFile();
            this.urlPhoto = fichierPhoto.toString();
        }
    }

    private void validerBtnMouseEntered(MouseEvent evt) {
        if (this.etatComboBox) {
            this.info.setText("  Info : Choisir la p\u00e9riode de validation des notes");
        } else {
            this.info.setText("  Info : Afficher le bulletin de notes de l'\u00e9tudiant ");
        }
    }

    private void validerBtnActionPerformed(ActionEvent evt) {
        String nom = this.nomAsaisir.getText();
        String prenom = this.prenomAsaisir.getText();
        if (this.choixAction.equalsIgnoreCase("Creer")) {
            this.creerUnEtudiant(nom, prenom);
        } else if (this.choixAction.equals("Modifier")) {
            this.modifierUnEtudiant(nom, prenom);
        } else if (this.choixAction.equals("Supprimer")) {
            this.supprimerUnEtudiant(nom, prenom);
        }
    }

    private void fermerBtnMouseEntered(MouseEvent evt) {
        if (this.etatComboBox) {
            this.info.setText("  Info : Choisir la p\u00e9riode de validation des notes");
        } else {
            this.info.setText("  Info : Quitter l'application ");
        }
    }

    private void fermerBtnActionPerformed(ActionEvent evt) {
        System.exit(0);
    }

    private void rechercherMatiere(String quelSemestre) {
        Fichier fichierTxt = new Fichier();
        this.listeMatieres = new String[5];
        String[] tousLesmots = new String[6];
        if (fichierTxt.ouvrir("/Users/VotreCompte/Ressources/Ressources.txt", "R")) {
            do {
                if (!(tousLesmots = fichierTxt.lire())[0].equalsIgnoreCase(quelSemestre)) continue;
                for (int i = 1; i < tousLesmots.length; ++i) {
                    this.listeMatieres[i - 1] = tousLesmots[i];
                }
                break;
            } while (tousLesmots[0] != null);
            fichierTxt.fermer();
        } else {
            this.listeMatieres[0] = "Communication";
            this.listeMatieres[1] = "Anglais";
            this.listeMatieres[2] = "Algoritmique;";
            this.listeMatieres[3] = "Programmation";
            this.listeMatieres[4] = "Math\u00e9matiques";
        }
    }

    private void creerUnEtudiant(String nn, String np) {
        double[] moyenne = new double[this.listeMatieres.length];
        for (int i = 0; i < moyenne.length; ++i) {
            moyenne[i] = 0.0;
        }
        Etudiant eleve = new Etudiant(nn, np, this.urlPhoto, this.listeMatieres, this.periode, moyenne);
        BulletinNotes bn = new BulletinNotes(eleve);
    }

    private void supprimerUnEtudiant(String nn, String np) {
        Cursus C = new Cursus();
        FichierEtudiant F = new FichierEtudiant();
        F.ouvrir("R");
        C = F.lire();
        F.fermer();
        String text = nn + " " + np;
        if (C.supprimeUnEtudiant(nn, np)) {
            Message msg = new Message("L'etudiant(e) ", text, " a \u00e9t\u00e9 supprim\u00e9(e) de la classe ");
        } else {
            Message msg = new Message("L'etudiant(e) ", text, "est inconnu(e) !");
        }
        F.ouvrir("W");
        F.ecrire(C);
        F.fermer();
    }

    private void modifierUnEtudiant(String nn, String np) {
        Cursus C = new Cursus();
        FichierEtudiant F = new FichierEtudiant();
        F.ouvrir("R");
        C = F.lire();
        F.fermer();
        Etudiant eleve = C.rechercheUnEtudiant(nn, np);
        if (eleve != null) {
            BulletinNotes bn = new BulletinNotes(eleve);
            C.supprimeUnEtudiant(nn, np);
            F.ouvrir("W");
            F.ecrire(C);
            F.fermer();
            eleve = null;
        } else {
            String text = nn + " " + np;
            Message message = new Message("L'etudiant(e) ", text, "est inconnu(e) !");
        }
    }

    public static void main(String[] args) {
        try {
            for (UIManager.LookAndFeelInfo info : UIManager.getInstalledLookAndFeels()) {
                if (!"Nimbus".equals(info.getName())) continue;
                UIManager.setLookAndFeel(info.getClassName());
                break;
            }
        }
        catch (ClassNotFoundException ex) {
            Logger.getLogger(CursusSwing.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (InstantiationException ex) {
            Logger.getLogger(CursusSwing.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (IllegalAccessException ex) {
            Logger.getLogger(CursusSwing.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (UnsupportedLookAndFeelException ex) {
            Logger.getLogger(CursusSwing.class.getName()).log(Level.SEVERE, null, ex);
        }
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                new CursusSwing().setVisible(true);
            }
        });
    }
}

