/*
#	Le livre de Java 1er langage
#	A. Tasso
#	Chapitre 12 : Créer une interface graphique
#	Section  : Exercice 12.1 à 12.3
#	Fichier  : Main.java
#	Class    : Main
*/
// Le fichier Main.java se trouve dans le répertoire 
// Sources/Exercices/Chapitre12/NetBeansProjects/EditeurExemple/src/Exercices
package Exercices;


public class Main extends javax.swing.JFrame {
      // 12.2.d La propriété choixAction est initialisée à "Heure"
    private String choixAction="Metre"; 

    public Main() {
        initComponents();
        this.setBounds(100, 100,359, 290);
        // 12.2.a  Ajouter les boutons au groupe groupeRadioBtn
        groupeRadioBtn.add(metreBtn); 
        groupeRadioBtn.add(litreBtn);
        groupeRadioBtn.add(heureBtn);
        // 12.2.b Le bouton metreBtn est sélectionné par défaut
         metreBtn.setSelected(true);
    }
// 12.1 Mise en place des éléments graphiques (voir page Design)
    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    @SuppressWarnings("unchecked")
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {

        groupeRadioBtn = new javax.swing.ButtonGroup();
        outilChoix = new javax.swing.JPanel();
        metreBtn = new javax.swing.JRadioButton();
        litreBtn = new javax.swing.JRadioButton();
        heureBtn = new javax.swing.JRadioButton();
        jSeparator1 = new javax.swing.JSeparator();
        OutilDonnees = new javax.swing.JPanel();
        combien = new javax.swing.JTextField();
        resultat = new javax.swing.JLabel();
        uniteInit = new javax.swing.JLabel();
        uniteFinal = new javax.swing.JLabel();
        calculerBtn = new javax.swing.JButton();

        setDefaultCloseOperation(javax.swing.WindowConstants.EXIT_ON_CLOSE);
        setTitle("Convertir");

        metreBtn.setText("Mètre");
        metreBtn.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                metreBtnActionPerformed(evt);
            }
        });

        litreBtn.setText("Litre");
        litreBtn.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                litreBtnActionPerformed(evt);
            }
        });

        heureBtn.setText("Heure");
        heureBtn.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                heureBtnActionPerformed(evt);
            }
        });

        org.jdesktop.layout.GroupLayout outilChoixLayout = new org.jdesktop.layout.GroupLayout(outilChoix);
        outilChoix.setLayout(outilChoixLayout);
        outilChoixLayout.setHorizontalGroup(
            outilChoixLayout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(outilChoixLayout.createSequentialGroup()
                .add(49, 49, 49)
                .add(metreBtn)
                .add(33, 33, 33)
                .add(litreBtn)
                .add(46, 46, 46)
                .add(heureBtn)
                .addContainerGap(172, Short.MAX_VALUE))
            .add(org.jdesktop.layout.GroupLayout.TRAILING, outilChoixLayout.createSequentialGroup()
                .addContainerGap(191, Short.MAX_VALUE)
                .add(jSeparator1, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, 281, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE))
        );
        outilChoixLayout.setVerticalGroup(
            outilChoixLayout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(outilChoixLayout.createSequentialGroup()
                .add(outilChoixLayout.createParallelGroup(org.jdesktop.layout.GroupLayout.BASELINE)
                    .add(metreBtn)
                    .add(litreBtn)
                    .add(heureBtn))
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                .add(jSeparator1, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE))
        );

        combien.setHorizontalAlignment(javax.swing.JTextField.RIGHT);
        combien.setText("0");

        resultat.setHorizontalAlignment(javax.swing.SwingConstants.RIGHT);
        resultat.setText("0");

        uniteInit.setText("Mètre(s)");

        uniteFinal.setText("Centimètre(s)");

        org.jdesktop.layout.GroupLayout OutilDonneesLayout = new org.jdesktop.layout.GroupLayout(OutilDonnees);
        OutilDonnees.setLayout(OutilDonneesLayout);
        OutilDonneesLayout.setHorizontalGroup(
            OutilDonneesLayout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(OutilDonneesLayout.createSequentialGroup()
                .add(29, 29, 29)
                .add(OutilDonneesLayout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
                    .add(OutilDonneesLayout.createSequentialGroup()
                        .add(10, 10, 10)
                        .add(resultat, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, 71, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                        .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                        .add(uniteFinal))
                    .add(OutilDonneesLayout.createSequentialGroup()
                        .add(combien, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, 81, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                        .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                        .add(uniteInit)))
                .addContainerGap(106, Short.MAX_VALUE))
        );
        OutilDonneesLayout.setVerticalGroup(
            OutilDonneesLayout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(org.jdesktop.layout.GroupLayout.TRAILING, OutilDonneesLayout.createSequentialGroup()
                .addContainerGap(20, Short.MAX_VALUE)
                .add(OutilDonneesLayout.createParallelGroup(org.jdesktop.layout.GroupLayout.BASELINE)
                    .add(uniteInit)
                    .add(combien, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE))
                .add(31, 31, 31)
                .add(OutilDonneesLayout.createParallelGroup(org.jdesktop.layout.GroupLayout.BASELINE)
                    .add(uniteFinal)
                    .add(resultat))
                .add(94, 94, 94))
        );

        calculerBtn.setText("Calculer");
        calculerBtn.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                calculerBtnActionPerformed(evt);
            }
        });

        org.jdesktop.layout.GroupLayout layout = new org.jdesktop.layout.GroupLayout(getContentPane());
        getContentPane().setLayout(layout);
        layout.setHorizontalGroup(
            layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(layout.createSequentialGroup()
                .addContainerGap()
                .add(layout.createParallelGroup(org.jdesktop.layout.GroupLayout.CENTER)
                    .add(outilChoix, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                    .add(OutilDonnees, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                    .add(calculerBtn))
                .addContainerGap())
        );
        layout.setVerticalGroup(
            layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(layout.createSequentialGroup()
                .add(32, 32, 32)
                .add(outilChoix, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.UNRELATED)
                .add(OutilDonnees, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, 106, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                .add(18, 18, 18)
                .add(calculerBtn)
                .addContainerGap(48, Short.MAX_VALUE))
        );

        pack();
    }// </editor-fold>//GEN-END:initComponents

private void litreBtnActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_litreBtnActionPerformed
    // 12.2.c Lorsque l'utilisateur sélectionne la bouton litreBtn
    // Les textes Litres(s) et Décilitre(s) s'affichent au bon endroit
    uniteInit.setText("Litre(s)");
    uniteFinal.setText("Décilitre(s)");
    resultat.setText("0") ;
    combien.setText("0") ;
    // 12.2.d La propriété choixAction est initialisée à "Litre"
    choixAction = "Litre";
    
}//GEN-LAST:event_litreBtnActionPerformed

private void metreBtnActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_metreBtnActionPerformed
    // 12.2.c Lorsque l'utilisateur sélectionne la bouton metreBtn
    // Les textes Mètre(s) et Centimètre(s) s'affichent au bon endroit
    uniteInit.setText("Mètre(s)");
    uniteFinal.setText("Centimètre(s)");
    resultat.setText("0") ;
    combien.setText("0") ;
    // 12.2.d La propriété choixAction est initialisée à "Metre"
    choixAction = "Metre";
}//GEN-LAST:event_metreBtnActionPerformed

private void heureBtnActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_heureBtnActionPerformed
    // 12.2.c Lorsque l'utilisateur sélectionne la bouton heureBtn
    // Les textes Heure(s) et Seconde(s) s'affichent au bon endroit    
      uniteInit.setText("Heure(s)");
      uniteFinal.setText("Seconde(s)");
      resultat.setText("0") ;
      combien.setText("0") ;
       // 12.2.d La propriété choixAction est initialisée à "Heure"
      choixAction = "Heure";
    
}//GEN-LAST:event_heureBtnActionPerformed

private void calculerBtnActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_calculerBtnActionPerformed
    // 12.3.a Récupérer le contenu du champ de saisie combien
    float valeur = Float.parseFloat(combien.getText()); 
    // 12.3.b selon la valeur de choixAction, réaliser la conversion demandée
    if (choixAction.equalsIgnoreCase("Metre")){   
       // 12.3.c Afficher le résultat sous forme de centimetre
       resultat.setText(convertirMetre (valeur)) ;
     }
    else if (choixAction.equals("Litre")){
        // 12.3.c Afficher le résultat sous forme de décilitre
      resultat.setText(convertirLitre(valeur));
     }
    else if (choixAction.equals("Heure")){
        // 12.3.c Afficher le résultat sous forme de seconde
     resultat.setText( convertirHeure(valeur));
    }
}//GEN-LAST:event_calculerBtnActionPerformed

// 12.3.b fonction de convertion de mètre en centimètre
private String convertirMetre(float val){
    float centimetre = val * 100;
    return Float.toString(centimetre);  
}
// 12.3.b fonction de convertion d'heure en seconde
private String convertirHeure(float val){
    float seconde = val * 3600;
    return Float.toString(seconde);  
}
// 12.3.b fonction de convertion de litre en décilitre
private String convertirLitre(float val){
    float decilitre = val * 10;
    return Float.toString(decilitre);
    
}

    /**
    * @param args the command line arguments
    */
    public static void main(String args[]) {
        java.awt.EventQueue.invokeLater(new Runnable() {
            public void run() {
                new Main().setVisible(true);
            }
        });
    }

    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JPanel OutilDonnees;
    private javax.swing.JButton calculerBtn;
    private javax.swing.JTextField combien;
    private javax.swing.ButtonGroup groupeRadioBtn;
    private javax.swing.JRadioButton heureBtn;
    private javax.swing.JSeparator jSeparator1;
    private javax.swing.JRadioButton litreBtn;
    private javax.swing.JRadioButton metreBtn;
    private javax.swing.JPanel outilChoix;
    private javax.swing.JLabel resultat;
    private javax.swing.JLabel uniteFinal;
    private javax.swing.JLabel uniteInit;
    // End of variables declaration//GEN-END:variables

}
