<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" 
                xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" 
                version="1.0">

  <xsl:output indent="yes"/>

  <xsl:template match="@*|node()">
    <xsl:copy>
      <xsl:apply-templates select="@*|node()"/>
    </xsl:copy>
  </xsl:template>

  <xsl:template match="toplink-command">
    <toplink-command xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance">
      <xsl:apply-templates select="@*|node()"/>      
    </toplink-command>
  </xsl:template>  
  
  <xsl:template match="@xsi:noNamespaceSchemaLocation"/>  

  <xsl:template match="change-record">
    <xsl:element name="change-record">
      <xsl:attribute name="xsi:type">
        <xsl:value-of select="type"/>
      </xsl:attribute>
      <xsl:apply-templates select="@*|node()"/>
    </xsl:element>
  </xsl:template>

  <xsl:template match="type"></xsl:template>

  <xsl:template match="change-sets">
    <xsl:element name="change-sets">
      <xsl:apply-templates select="object-change-set" mode="keyref"/>
    </xsl:element>
  </xsl:template>

  <xsl:template match="added-objects">
    <xsl:element name="added-objects">
      <xsl:choose>
        <xsl:when test="object-change-set">
          <xsl:apply-templates select="object-change-set" mode="keyref"/>
        </xsl:when>
        <xsl:otherwise>
          <xsl:apply-templates select="@*|node()"/>     
        </xsl:otherwise>
      </xsl:choose>
    </xsl:element>
  </xsl:template>

  <xsl:template match="removed-objects">
    <xsl:element name="removed-objects">
      <xsl:choose>
        <xsl:when test="object-change-set">
          <xsl:apply-templates select="object-change-set" mode="keyref"/>
        </xsl:when>
        <xsl:otherwise>
          <xsl:apply-templates select="@*|node()"/>     
        </xsl:otherwise>
      </xsl:choose>
    </xsl:element>
  </xsl:template>

  <xsl:template match="aggregate-objects">
    <xsl:element name="aggregate-objects">
      <xsl:choose>
        <xsl:when test="object-change-set">
          <xsl:apply-templates select="object-change-set" mode="keyref"/>
        </xsl:when>
        <xsl:otherwise>
          <xsl:apply-templates select="@*|node()"/>     
        </xsl:otherwise>
      </xsl:choose>
    </xsl:element>
  </xsl:template>

  <xsl:template match="object-change-set" mode="keyref">
    <xsl:element name="object-change-set">
      <xsl:attribute name="ref-object-change-set-id">
        <xsl:value-of select="id"/>
      </xsl:attribute>
    </xsl:element>
  </xsl:template>

  <xsl:template match="object-change-set-id">
    <xsl:element name="object-change-set">
      <xsl:attribute name="ref-object-change-set-id">
        <xsl:value-of select="text()"/>
      </xsl:attribute>
    </xsl:element>
  </xsl:template>

  <xsl:template match="object-change-set">
    <xsl:element name="object-change-set">
      <xsl:attribute name="object-change-set-id">
        <xsl:value-of select="id"/>
      </xsl:attribute>
      <xsl:apply-templates select="@*|node()"/>
    </xsl:element>
  </xsl:template>

  <xsl:template match="id"></xsl:template>


</xsl:stylesheet>

