<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" 
                xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"
                exclude-result-prefixes="yes"
                version="1.0">

  <xsl:output indent="yes"/>

  <xsl:template match="*">
      <!-- remove element prefix (if any) -->
      <xsl:element name="{local-name()}">
        <!-- process attributes -->
        <xsl:for-each select="@*">
          <!-- remove attribute prefix (if any) -->
          <xsl:attribute name="{local-name()}">
            <xsl:value-of select="."/>
          </xsl:attribute>
        </xsl:for-each>
        <xsl:apply-templates/>
      </xsl:element>
  </xsl:template>


  <xsl:template match="toplink-command">
    <xsl:element name="toplink-command">
      <xsl:apply-templates select="@*|node()"/>      
    </xsl:element>
  </xsl:template>

  <xsl:template match="@xsi:noNamespaceSchemaLocation"/>

  <xsl:template match="change-record">
    <xsl:element name="change-record">
      <xsl:apply-templates select="node()"/>
      <xsl:element name="type" namespace="">
        <xsl:value-of select="@xsi:type"/>
      </xsl:element>
    </xsl:element>
  </xsl:template>

  <xsl:template match="change-sets">
    <xsl:element name="change-sets">
      <xsl:apply-templates select="object-change-set" mode="keyref"/>
    </xsl:element>
  </xsl:template>

  <xsl:template match="added-objects">
    <xsl:element name="added-objects">
      <xsl:choose>
        <xsl:when test="object-change-set">
          <xsl:apply-templates select="object-change-set" mode="keyref"/>
        </xsl:when>
        <xsl:otherwise>
          <xsl:apply-templates select="@*|node()"/>     
        </xsl:otherwise>
      </xsl:choose>
    </xsl:element>
  </xsl:template>

  <xsl:template match="removed-objects">
    <xsl:element name="removed-objects">
      <xsl:choose>
        <xsl:when test="object-change-set">
          <xsl:apply-templates select="object-change-set" mode="keyref"/>
        </xsl:when>
        <xsl:otherwise>
          <xsl:apply-templates select="@*|node()"/>     
        </xsl:otherwise>
      </xsl:choose>
    </xsl:element>
  </xsl:template>

  <xsl:template match="aggregate-objects">
    <xsl:element name="aggregate-objects">
      <xsl:choose>
        <xsl:when test="object-change-set">
          <xsl:apply-templates select="object-change-set" mode="keyref"/>
        </xsl:when>
        <xsl:otherwise>
          <xsl:apply-templates select="@*|node()"/>     
        </xsl:otherwise>
      </xsl:choose>
    </xsl:element>
  </xsl:template>

  <xsl:template match="object-change-set" mode="keyref">
    <xsl:element name="object-change-set">
      <xsl:element name="id">
        <xsl:value-of select="@ref-object-change-set-id"/>
      </xsl:element>
    </xsl:element>
  </xsl:template>

  <xsl:template match="object-change-set">
    <xsl:choose>
      <xsl:when test="name(..)='change-record'">
        <xsl:element name="object-change-set-id">
          <xsl:value-of select="@ref-object-change-set-id"/>
        </xsl:element>
      </xsl:when>
      <xsl:otherwise>
        <xsl:element name="object-change-set">
          <xsl:element name="id">
            <xsl:value-of select="@object-change-set-id"/>
          </xsl:element>
          <xsl:apply-templates select="node()"/>
        </xsl:element>
      </xsl:otherwise>
    </xsl:choose>
  </xsl:template>

</xsl:stylesheet>

