/*
 * Decompiled with CFR 0.152.
 */
package oracle.toplink.xml;

import oracle.toplink.exceptions.TopLinkException;
import oracle.toplink.sequencing.DefaultSequence;
import oracle.toplink.sequencing.Sequence;
import oracle.toplink.sessions.DatabaseSession;
import oracle.toplink.tools.schemaframework.DatabaseObjectDefinition;
import oracle.toplink.tools.schemaframework.SchemaManager;
import oracle.toplink.tools.schemaframework.SequenceDefinition;
import oracle.toplink.tools.schemaframework.TableDefinition;
import oracle.toplink.xml.XMLAccessor;
import oracle.toplink.xml.XMLSequence;
import oracle.toplink.xml.XMLSequenceDefinition;

public class XMLSchemaManager
extends SchemaManager {
    public XMLSchemaManager(oracle.toplink.publicinterface.DatabaseSession databaseSession) {
        super(databaseSession);
    }

    public XMLSchemaManager(DatabaseSession databaseSession) {
        super(databaseSession);
    }

    protected SequenceDefinition buildSequenceDefinition(Sequence sequence) {
        if (sequence instanceof DefaultSequence) {
            String string = sequence.getName();
            int n = sequence.getPreallocationSize();
            sequence = this.getSession().getDatasourcePlatform().getDefaultSequence();
            if (sequence instanceof XMLSequence) {
                XMLSequence xMLSequence = (XMLSequence)sequence;
                return new XMLSequenceDefinition(string, xMLSequence);
            }
            return null;
        }
        if (sequence instanceof XMLSequence) {
            XMLSequence xMLSequence = (XMLSequence)sequence;
            return new XMLSequenceDefinition(xMLSequence);
        }
        return null;
    }

    public void createObject(DatabaseObjectDefinition databaseObjectDefinition) throws TopLinkException {
        if (this.shouldWriteToDatabase()) {
            if (databaseObjectDefinition instanceof TableDefinition) {
                this.createStreamSource((TableDefinition)databaseObjectDefinition);
            } else if (databaseObjectDefinition instanceof XMLSequenceDefinition) {
                databaseObjectDefinition.createOnDatabase(this.getSession());
            }
        }
    }

    public void dropObject(DatabaseObjectDefinition databaseObjectDefinition) throws TopLinkException {
        if (this.shouldWriteToDatabase() && databaseObjectDefinition instanceof TableDefinition) {
            this.dropStreamSource((TableDefinition)databaseObjectDefinition);
        }
    }

    protected void createStreamSource(TableDefinition tableDefinition) throws TopLinkException {
        XMLAccessor xMLAccessor = (XMLAccessor)this.getSession().getAccessor();
        xMLAccessor.createStreamSource(tableDefinition.getName());
    }

    protected void dropStreamSource(TableDefinition tableDefinition) {
        XMLAccessor xMLAccessor = (XMLAccessor)this.getSession().getAccessor();
        xMLAccessor.dropStreamSource(tableDefinition.getName());
    }
}

