/*
 * Decompiled with CFR 0.152.
 */
package oracle.toplink.xml;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Enumeration;
import java.util.Vector;
import oracle.toplink.internal.databaseaccess.Accessor;
import oracle.toplink.internal.helper.Helper;
import oracle.toplink.internal.localization.ToStringLocalization;
import oracle.toplink.publicinterface.DatabaseRow;
import oracle.toplink.xml.XMLDataStoreException;
import oracle.toplink.xml.XMLStreamPolicy;

public class XMLFileStreamPolicy
implements XMLStreamPolicy {
    private File file;
    private Enumeration files;
    public static int MAX_READ_BUFFER_SIZE = 32768;
    public static int MIN_WRITE_BUFFER_SIZE = 1024;
    public static int MAX_WRITE_BUFFER_SIZE = 32768;

    protected XMLFileStreamPolicy() {
    }

    public XMLFileStreamPolicy(File file) {
        this();
        this.file = file;
    }

    public XMLFileStreamPolicy(String string) {
        this(new File(string));
    }

    public XMLFileStreamPolicy(Enumeration enumeration) {
        this();
        this.files = enumeration;
    }

    protected Reader buildReadStream() {
        return this.buildReadStream(this.getFile());
    }

    protected Reader buildReadStream(File file) {
        int n = this.calculateReadBufferSize(file);
        try {
            return new BufferedReader(new FileReader(file), n);
        }
        catch (FileNotFoundException fileNotFoundException) {
            return null;
        }
    }

    protected Enumeration buildReadStreams() throws XMLDataStoreException {
        return new Enumeration(){

            public boolean hasMoreElements() {
                return XMLFileStreamPolicy.this.getFiles().hasMoreElements();
            }

            public Object nextElement() {
                return XMLFileStreamPolicy.this.buildReadStream((File)XMLFileStreamPolicy.this.getFiles().nextElement());
            }
        };
    }

    protected int calculateReadBufferSize(File file) {
        int n = MAX_READ_BUFFER_SIZE;
        long l = file.length();
        if (l < (long)n && l != 0L) {
            n = (int)l;
        }
        return n;
    }

    protected int calculateWriteBufferSize(File file, boolean bl) {
        int n = MAX_WRITE_BUFFER_SIZE;
        if (bl) {
            long l = file.length() * 2L;
            if (l < (long)n && l != 0L) {
                n = (int)l;
            }
            if (n < MIN_WRITE_BUFFER_SIZE) {
                n = MIN_WRITE_BUFFER_SIZE;
            }
        }
        return n;
    }

    public Integer deleteStream(String string, DatabaseRow databaseRow, Vector vector, Accessor accessor) throws XMLDataStoreException {
        if (this.getFile().exists()) {
            this.getFile().delete();
            return new Integer(1);
        }
        return new Integer(0);
    }

    public Reader getExistenceCheckStream(String string, DatabaseRow databaseRow, Vector vector, Accessor accessor) throws XMLDataStoreException {
        return this.getReadStream(string, databaseRow, vector, accessor);
    }

    public Writer getExistingWriteStream(String string, DatabaseRow databaseRow, Vector vector, Accessor accessor) throws XMLDataStoreException {
        return this.getWriteStream(true);
    }

    protected File getFile() {
        return this.file;
    }

    protected Enumeration getFiles() {
        return this.files;
    }

    public Writer getNewWriteStream(String string, DatabaseRow databaseRow, Vector vector, Accessor accessor) throws XMLDataStoreException {
        return this.getWriteStream(false);
    }

    public Reader getReadStream(String string, DatabaseRow databaseRow, Vector vector, Accessor accessor) throws XMLDataStoreException {
        return this.buildReadStream();
    }

    public Enumeration getReadStreams(String string, Vector vector, Vector vector2, Accessor accessor) throws XMLDataStoreException {
        return this.buildReadStreams();
    }

    public Enumeration getReadStreams(String string, Accessor accessor) throws XMLDataStoreException {
        return this.buildReadStreams();
    }

    protected Writer getWriteStream(boolean bl) throws XMLDataStoreException {
        boolean bl2 = this.getFile().exists();
        if (bl != bl2) {
            if (bl2) {
                throw XMLDataStoreException.fileAlreadyExists(this.getFile());
            }
            throw XMLDataStoreException.fileNotFound(this.getFile(), null);
        }
        int n = this.calculateWriteBufferSize(this.getFile(), bl2);
        try {
            return new BufferedWriter(new FileWriter(this.getFile()), n);
        }
        catch (IOException iOException) {
            throw XMLDataStoreException.unableToCreateWriteStream(this.getFile(), iOException);
        }
    }

    public String toString() {
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        printWriter.write(Helper.getShortClassName(this));
        printWriter.write("(");
        if (this.getFile() == null && this.getFiles() == null) {
            printWriter.write(ToStringLocalization.buildMessage("no_files", null));
        } else if (this.getFile() == null) {
            printWriter.write(ToStringLocalization.buildMessage("mulitple_files", null));
        } else {
            printWriter.write(this.getFile().toString());
        }
        printWriter.write(")");
        return stringWriter.toString();
    }
}

