/*
 * Decompiled with CFR 0.152.
 */
package oracle.toplink.xml;

import java.io.PrintWriter;
import java.io.Reader;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import oracle.toplink.internal.databaseaccess.Accessor;
import oracle.toplink.internal.helper.DatabaseField;
import oracle.toplink.internal.localization.TraceLocalization;
import oracle.toplink.publicinterface.DatabaseRow;
import oracle.toplink.sessions.DatabaseRecord;
import oracle.toplink.xml.XMLDataCall;
import oracle.toplink.xml.XMLDataStoreException;

public class XMLDataReadCall
extends XMLDataCall {
    private Vector resultElements;
    private Hashtable resultElementTypes;

    protected void addResultElement(DatabaseField databaseField) {
        this.getResultElements().addElement(databaseField);
    }

    public void addResultElementName(String string) {
        this.addResultElement(new DatabaseField(string, this.getRootElement()));
    }

    public void addResultElementType(String string, Class clazz) {
        this.getResultElementTypes().put(new DatabaseField(string, this.getRootElement()), clazz);
    }

    protected void clearResultElements() {
        this.getResultElements().removeAllElements();
    }

    public Object execute(DatabaseRow databaseRow, Accessor accessor) throws XMLDataStoreException {
        Reader reader;
        Vector<Object> vector;
        Enumeration enumeration = null;
        if (this.getOrderedPrimaryKeyElements().isEmpty()) {
            enumeration = this.getStreamPolicy().getReadStreams(this.getRootElementName(), accessor);
        } else {
            vector = new Vector<Object>(1);
            reader = this.getStreamPolicy().getReadStream(this.getRootElementName(), databaseRow, this.getOrderedPrimaryKeyElements(), accessor);
            if (reader != null) {
                vector.addElement(reader);
            }
            enumeration = vector.elements();
        }
        vector = new Vector();
        while (enumeration.hasMoreElements()) {
            reader = (Reader)enumeration.nextElement();
            if (reader == null) continue;
            DatabaseRow databaseRow2 = this.getXMLTranslator().read(reader);
            databaseRow2 = this.getFieldTranslator().translateForRead(databaseRow2);
            databaseRow2 = this.extractResultElements(databaseRow2);
            vector.addElement(databaseRow2);
        }
        return vector;
    }

    protected DatabaseRow extractResultElements(DatabaseRow databaseRow) {
        Object object;
        Object object2;
        Object object3;
        DatabaseRow databaseRow2 = null;
        if (this.getResultElements().isEmpty()) {
            databaseRow2 = databaseRow;
        } else {
            databaseRow2 = new DatabaseRecord(this.getResultElements().size());
            object3 = this.getResultElements().elements();
            while (object3.hasMoreElements()) {
                object2 = (DatabaseField)object3.nextElement();
                object = databaseRow.get((DatabaseField)object2);
                databaseRow2.put((DatabaseField)object2, object);
            }
        }
        object3 = new DatabaseRecord(databaseRow2.size());
        object2 = databaseRow2.getFields().elements();
        while (object2.hasMoreElements()) {
            object = (DatabaseField)object2.nextElement();
            Object object4 = databaseRow2.get((DatabaseField)object);
            Class clazz = (Class)this.getResultElementTypes().get(object);
            if (clazz != null) {
                object4 = this.getSession().getDatasourcePlatform().convertObject(object4, clazz);
            }
            ((DatabaseRow)object3).put((DatabaseField)object, object4);
        }
        return object3;
    }

    protected Vector getResultElements() {
        return this.resultElements;
    }

    protected Hashtable getResultElementTypes() {
        return this.resultElementTypes;
    }

    protected void initialize() {
        super.initialize();
        this.resultElements = new Vector();
        this.resultElementTypes = new Hashtable(10);
    }

    protected void setResultElement(DatabaseField databaseField) {
        this.clearResultElements();
        this.addResultElement(databaseField);
    }

    public void setResultElementName(String string) {
        this.clearResultElements();
        this.addResultElementName(string);
    }

    public void setResultElementNames(String[] stringArray) {
        this.clearResultElements();
        for (int i = 0; i < stringArray.length; ++i) {
            this.addResultElementName(stringArray[i]);
        }
    }

    public void setResultElementNames(Vector vector) {
        this.clearResultElements();
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            this.addResultElementName((String)enumeration.nextElement());
        }
    }

    protected void setResultElements(Vector vector) {
        this.resultElements = vector;
    }

    protected void writeLogDescription(PrintWriter printWriter) {
        printWriter.write(TraceLocalization.buildMessage("XML_data_read", null));
    }
}

