/*
 * Decompiled with CFR 0.152.
 */
package oracle.toplink.transaction;

import java.util.Hashtable;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import oracle.toplink.exceptions.DatabaseException;
import oracle.toplink.exceptions.TransactionException;
import oracle.toplink.publicinterface.Session;
import oracle.toplink.publicinterface.UnitOfWork;
import oracle.toplink.sessions.ExternalTransactionController;
import oracle.toplink.transaction.AbstractSynchronizationListener;
import oracle.toplink.transaction.SynchronizationListenerFactory;

public abstract class AbstractTransactionController
implements ExternalTransactionController {
    protected Hashtable unitsOfWork = new Hashtable();
    protected Session session;
    protected SynchronizationListenerFactory listenerFactory;
    protected ThreadLocal activeUnitOfWorkThreadLocal = new ThreadLocal();

    public void bindToCurrentTransaction(UnitOfWork unitOfWork, Session session) {
        Object object = this.getTransactionStatus();
        this.logTxStateTrace(unitOfWork, "TX_bind", object);
        try {
            Object object2 = this.getTransaction();
            if (object2 == null) {
                unitOfWork.beginTransaction();
                object2 = this.getTransaction();
            }
            if (object2 == null) {
                throw TransactionException.externalTransactionNotActive();
            }
            AbstractSynchronizationListener abstractSynchronizationListener = this.getListenerFactory().newSynchronizationListener(unitOfWork, session, object2, this);
            this.registerSynchronization_impl(abstractSynchronizationListener, object2);
            unitOfWork.setSynchronized();
        }
        catch (Exception exception) {
            throw TransactionException.errorBindingToExternalTransaction(exception);
        }
    }

    public void beginTransaction(Session session) {
        try {
            Object object = this.getTransactionStatus();
            this.logTxStateTrace(session, "TX_begin", object);
            if (this.canBeginTransaction_impl(object)) {
                this.logTxTrace(session, "TX_beginningTxn", null);
                this.beginTransaction_impl();
                session.setWasJTSTransactionInternallyStarted(true);
            }
        }
        catch (Exception exception) {
            throw TransactionException.errorBeginningExternalTransaction(exception);
        }
    }

    public void commitTransaction(Session session) {
        try {
            Object object = this.getTransactionStatus();
            this.logTxStateTrace(session, "TX_commit", object);
            if (this.canCommitTransaction_impl(object)) {
                this.logTxTrace(session, "TX_committingTxn", null);
                session.setWasJTSTransactionInternallyStarted(false);
                this.commitTransaction_impl();
            }
        }
        catch (Exception exception) {
            throw TransactionException.errorCommittingExternalTransaction(exception);
        }
    }

    public void rollbackTransaction(Session session) {
        try {
            Object object = this.getTransactionStatus();
            this.logTxStateTrace(session, "TX_rollback", object);
            session.setWasJTSTransactionInternallyStarted(false);
            if (this.canRollbackTransaction_impl(object) && this.getTransaction() != null) {
                this.logTxTrace(session, "TX_rollingBackTxn", null);
                this.rollbackTransaction_impl();
            }
        }
        catch (Exception exception) {
            throw TransactionException.errorRollingBackExternalTransaction(exception);
        }
    }

    public void markTransactionForRollback() {
        try {
            this.markTransactionForRollback_impl();
        }
        catch (Exception exception) {
            throw TransactionException.errorMarkingTransactionForRollback(exception);
        }
    }

    public Object getTransaction() {
        try {
            return this.getTransaction_impl();
        }
        catch (Exception exception) {
            throw TransactionException.errorGettingExternalTransaction(exception);
        }
    }

    public Object getTransactionKey(Object object) {
        try {
            return this.getTransactionKey_impl(object);
        }
        catch (Exception exception) {
            throw TransactionException.errorGettingExternalTransaction(exception);
        }
    }

    public Object getTransactionStatus() {
        try {
            return this.getTransactionStatus_impl();
        }
        catch (Exception exception) {
            throw TransactionException.errorGettingExternalTransactionStatus(exception);
        }
    }

    public boolean noTransactionOrRolledBackOrCommited() {
        try {
            Object object = this.getTransactionStatus();
            return this.canBeginTransaction_impl(object) || this.canMergeUnitOfWork_impl(object) || this.isRolledBack_impl(object);
        }
        catch (Exception exception) {
            throw TransactionException.errorGettingExternalTransactionStatus(exception);
        }
    }

    public abstract boolean isRolledBack_impl(Object var1);

    public boolean hasActiveUnitOfWork() {
        return this.lookupActiveUnitOfWork() != null;
    }

    public UnitOfWork getActiveUnitOfWork() {
        Object object = this.getTransaction();
        if (object == null) {
            return null;
        }
        UnitOfWork unitOfWork = this.lookupActiveUnitOfWork(object);
        if (unitOfWork == null) {
            unitOfWork = this.getSession().acquireUnitOfWork();
            Object object2 = this.getTransactionKey(object);
            this.addUnitOfWork(object2, unitOfWork);
            unitOfWork.setTransaction(object);
            this.activeUnitOfWorkThreadLocal.set(unitOfWork);
        }
        return unitOfWork;
    }

    public UnitOfWork lookupActiveUnitOfWork() {
        return this.lookupActiveUnitOfWork(this.getTransaction());
    }

    public UnitOfWork lookupActiveUnitOfWork(Object object) {
        if (object == null) {
            return null;
        }
        Object object2 = this.getTransactionKey(object);
        UnitOfWork unitOfWork = (UnitOfWork)this.activeUnitOfWorkThreadLocal.get();
        if (unitOfWork != null && object == unitOfWork.getTransaction()) {
            return unitOfWork;
        }
        unitOfWork = (UnitOfWork)this.getUnitsOfWork().get(object2);
        if (unitOfWork != null) {
            unitOfWork.setTransaction(object);
        }
        this.activeUnitOfWorkThreadLocal.set(unitOfWork);
        return unitOfWork;
    }

    public void addUnitOfWork(Object object, UnitOfWork unitOfWork) {
        this.activeUnitOfWorkThreadLocal.set(null);
        this.getUnitsOfWork().put(object, unitOfWork);
    }

    public void removeUnitOfWork(Object object) {
        if (object != null) {
            this.getUnitsOfWork().remove(object);
        }
        this.activeUnitOfWorkThreadLocal.set(null);
    }

    public Session getSession() {
        return this.session;
    }

    public void setSession(Session session) {
        this.session = session;
    }

    public Hashtable getUnitsOfWork() {
        return this.unitsOfWork;
    }

    protected void setUnitsOfWork(Hashtable hashtable) {
        this.unitsOfWork = hashtable;
    }

    public SynchronizationListenerFactory getListenerFactory() {
        return this.listenerFactory;
    }

    public void setListenerFactory(SynchronizationListenerFactory synchronizationListenerFactory) {
        this.listenerFactory = synchronizationListenerFactory;
    }

    public void registerSynchronizationListener(UnitOfWork unitOfWork, Session session) throws DatabaseException {
        this.bindToCurrentTransaction(unitOfWork, session);
    }

    public Object jndiLookup(String string) {
        InitialContext initialContext = null;
        Object object = null;
        try {
            initialContext = new InitialContext();
            object = initialContext.lookup(string);
        }
        catch (NamingException namingException) {
            throw TransactionException.jndiLookupException(string, namingException);
        }
        finally {
            try {
                initialContext.close();
            }
            catch (Exception exception) {}
        }
        return object;
    }

    public void logTxTrace(Session session, String string, Object[] objectArray) {
        session.log(2, "transaction", string, objectArray);
    }

    public void logTxStateTrace(Session session, String string, Object object) {
        if (session.shouldLog(2, "transaction")) {
            String string2 = this.statusToString_impl(object);
            Object[] objectArray = new Object[]{string2};
            session.log(2, "transaction", string, objectArray);
        }
    }

    protected abstract void registerSynchronization_impl(AbstractSynchronizationListener var1, Object var2) throws Exception;

    protected abstract Object getTransaction_impl() throws Exception;

    protected abstract Object getTransactionKey_impl(Object var1) throws Exception;

    protected abstract Object getTransactionStatus_impl() throws Exception;

    protected abstract void beginTransaction_impl() throws Exception;

    protected abstract void commitTransaction_impl() throws Exception;

    protected abstract void rollbackTransaction_impl() throws Exception;

    protected abstract void markTransactionForRollback_impl() throws Exception;

    protected abstract boolean canBeginTransaction_impl(Object var1);

    protected abstract boolean canCommitTransaction_impl(Object var1);

    protected abstract boolean canRollbackTransaction_impl(Object var1);

    protected abstract boolean canIssueSQLToDatabase_impl(Object var1);

    protected abstract boolean canMergeUnitOfWork_impl(Object var1);

    protected abstract String statusToString_impl(Object var1);
}

