/*
 * Decompiled with CFR 0.152.
 */
package oracle.toplink.tools.workbench.expressions;

import oracle.toplink.expressions.Expression;
import oracle.toplink.internal.expressions.ConstantExpression;
import oracle.toplink.internal.expressions.FunctionExpression;
import oracle.toplink.internal.expressions.ParameterExpression;
import oracle.toplink.internal.expressions.QueryKeyExpression;
import oracle.toplink.internal.expressions.RelationExpression;
import oracle.toplink.tools.workbench.expressions.BasicExpressionRepresentation;
import oracle.toplink.tools.workbench.expressions.ExpressionArgumentRepresentation;
import oracle.toplink.tools.workbench.expressions.LiteralArgumentRepresentation;
import oracle.toplink.tools.workbench.expressions.ParameterArgumentRepresentation;
import oracle.toplink.tools.workbench.expressions.QueryableArgumentRepresentation;

public final class BinaryExpressionRepresentation
extends BasicExpressionRepresentation {
    public static final String EQUAL = "Equal";
    public static final String EQUALS_IGNORE_CASE = "Equals Ignore Case";
    public static final String GREATER_THAN = "Greater Than";
    public static final String GREATER_THAN_EQUAL = "Greater Than Equal";
    public static final String LESS_THAN = "Less Than";
    public static final String LESS_THAN_EQUAL = "Less Than Equal";
    public static final String LIKE = "Like";
    public static final String LIKE_IGNORE_CASE = "Like Ignore Case";
    public static final String NOT_EQUAL = "Not Equal";
    public static final String NOT_LIKE = "Not Like";
    private ExpressionArgumentRepresentation secondArgument;

    public BinaryExpressionRepresentation() {
    }

    public BinaryExpressionRepresentation(String string) {
        super(string);
    }

    public String displayString() {
        String string = super.displayString();
        string = string + " " + this.getSecondArgument().displayString();
        return string;
    }

    public ExpressionArgumentRepresentation getSecondArgument() {
        return this.secondArgument;
    }

    public boolean isBinaryExpression() {
        return true;
    }

    private void setSecondArgument(ExpressionArgumentRepresentation expressionArgumentRepresentation) {
        ExpressionArgumentRepresentation expressionArgumentRepresentation2 = this.getSecondArgument();
        this.secondArgument = expressionArgumentRepresentation;
    }

    public Expression convertToRuntime(Expression expression) {
        Expression expression2 = this.getFirstArgument().convertToRuntime(expression);
        Expression expression3 = this.getSecondArgument().convertToRuntime(expression);
        String string = this.getOperatorType();
        if (string == EQUAL) {
            return expression2.equal(expression3);
        }
        if (string == GREATER_THAN) {
            return expression2.greaterThan(expression3);
        }
        if (string == GREATER_THAN_EQUAL) {
            return expression2.greaterThanEqual(expression3);
        }
        if (string == LESS_THAN) {
            return expression2.lessThan(expression3);
        }
        if (string == LESS_THAN_EQUAL) {
            return expression2.lessThanEqual(expression3);
        }
        if (string == NOT_EQUAL) {
            return expression2.notEqual(expression3);
        }
        if (string == EQUALS_IGNORE_CASE) {
            return expression2.equalsIgnoreCase(expression3);
        }
        if (string == LIKE) {
            return expression2.like(expression3);
        }
        if (string == LIKE_IGNORE_CASE) {
            return expression2.likeIgnoreCase(expression3);
        }
        return expression2.notLike(expression3);
    }

    public BasicExpressionRepresentation convertFromRuntimeDirectly(Expression expression) {
        Expression expression2 = ((RelationExpression)expression).getFirstChild();
        if (expression2.isFunctionExpression()) {
            expression2 = ((FunctionExpression)expression2).getBaseExpression();
            if (this.getOperatorType() == EQUAL) {
                this.setOperatorType(EQUALS_IGNORE_CASE);
            } else {
                this.setOperatorType(LIKE_IGNORE_CASE);
            }
        }
        this.setFirstArgument(QueryableArgumentRepresentation.convertFromRuntime((QueryKeyExpression)expression2));
        Expression expression3 = ((RelationExpression)expression).getSecondChild();
        if (expression3.isFunctionExpression()) {
            expression3 = ((FunctionExpression)expression3).getBaseExpression();
        }
        if (expression3.isQueryKeyExpression()) {
            this.setSecondArgument(QueryableArgumentRepresentation.convertFromRuntime((QueryKeyExpression)expression3));
        } else if (expression3.isConstantExpression()) {
            this.setSecondArgument(LiteralArgumentRepresentation.convertFromRuntime((ConstantExpression)expression3));
        } else if (expression3.isParameterExpression()) {
            this.setSecondArgument(ParameterArgumentRepresentation.convertFromRuntime((ParameterExpression)expression3));
        }
        return this;
    }

    public String convertToRuntimeString(String string) {
        String string2 = this.getFirstArgument().convertToRuntimeString(string);
        String string3 = this.getSecondArgument().convertToRuntimeString(string);
        String string4 = this.getOperatorType();
        String string5 = string4 == EQUAL ? "equal" : (string4 == GREATER_THAN ? "greaterThan" : (string4 == GREATER_THAN_EQUAL ? "greaterThanEqual" : (string4 == LESS_THAN ? "lessThan" : (string4 == LESS_THAN_EQUAL ? "lessThanEqual" : (string4 == NOT_EQUAL ? "notEqual" : (string4 == EQUALS_IGNORE_CASE ? "equalsIgnoreCase" : (string4 == LIKE ? "like" : (string4 == LIKE_IGNORE_CASE ? "likeIgnoreCase" : "notLike"))))))));
        return string2 + "." + string5 + "(" + string3 + ")";
    }
}

