/*
 * Decompiled with CFR 0.152.
 */
package oracle.toplink.tools.workbench;

import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import oracle.toplink.exceptions.ValidationException;
import oracle.toplink.ox.XMLContext;
import oracle.toplink.ox.XMLMarshaller;
import oracle.toplink.sessions.Project;
import oracle.toplink.tools.workbench.MissingDescriptorListener;
import oracle.toplink.tools.workbench.ObjectPersistenceWorkbenchXMLProject;

public class XMLProjectWriter {
    public static void write(Project project, String string) {
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(string);
            OutputStreamWriter outputStreamWriter = new OutputStreamWriter((OutputStream)fileOutputStream, "UTF-8");
            XMLProjectWriter.write(project, outputStreamWriter);
            ((Writer)outputStreamWriter).close();
        }
        catch (IOException iOException) {
            throw ValidationException.fileError(iOException);
        }
    }

    public static void write(Project project, Writer writer) {
        XMLContext xMLContext = new XMLContext(new ObjectPersistenceWorkbenchXMLProject());
        xMLContext.getSession(project).getEventManager().addListener(new MissingDescriptorListener());
        XMLMarshaller xMLMarshaller = xMLContext.createMarshaller();
        xMLMarshaller.marshal((Object)project, writer);
        try {
            writer.flush();
        }
        catch (IOException iOException) {
            throw ValidationException.fileError(iOException);
        }
    }

    public static void write(String string, Project project) {
        XMLProjectWriter.write(project, string);
    }

    public static void write(String string, Project project, Writer writer) {
        if (writer != null) {
            XMLProjectWriter.write(project, writer);
        } else {
            XMLProjectWriter.write(project, string);
        }
    }
}

