/*
 * Decompiled with CFR 0.152.
 */
package oracle.toplink.tools.sessionmanagement;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import oracle.toplink.exceptions.ValidationException;
import oracle.toplink.internal.helper.Helper;
import oracle.toplink.internal.security.PrivilegedAccessController;
import oracle.toplink.logging.AbstractSessionLog;
import oracle.toplink.publicinterface.Session;
import oracle.toplink.sessionbroker.SessionBroker;
import oracle.toplink.sessions.DatabaseSession;
import oracle.toplink.tools.sessionconfiguration.SessionBrokerPlaceHolder;
import oracle.toplink.tools.sessionconfiguration.WASXMLLoader;
import oracle.toplink.tools.sessionconfiguration.WASXMLSessionConfigLoader;
import oracle.toplink.tools.sessionconfiguration.XMLLoader;
import oracle.toplink.tools.sessionconfiguration.XMLSessionConfigLoader;
import oracle.toplink.tools.sessionconfiguration.model.TopLinkSessions;

public class SessionManager {
    protected static boolean shouldUseSchemaValidation = true;
    protected static SessionManager manager;
    protected Session defaultSession;
    protected Hashtable sessions = new Hashtable(5);
    protected XMLLoader lastLoaderUsed;
    protected static boolean shouldPerformDTDValidation;

    public static boolean shouldUseSchemaValidation() {
        return shouldUseSchemaValidation;
    }

    public static void setShouldUseSchemaValidation(boolean bl) {
        shouldUseSchemaValidation = bl;
    }

    public void addSession(oracle.toplink.sessions.Session session) {
        this.getSessions().put(session.getName(), session);
    }

    public void addSession(String string, oracle.toplink.sessions.Session session) {
        session.setName(string);
        this.getSessions().put(string, session);
    }

    public oracle.toplink.sessions.Session getDefaultSession() {
        if (this.defaultSession == null) {
            this.defaultSession = this.getSession("default");
        }
        return this.defaultSession;
    }

    public void destroySession(String string) {
        DatabaseSession databaseSession = (DatabaseSession)this.getSessions().get(string);
        if (databaseSession != null) {
            this.destroy(databaseSession);
        } else {
            this.logAndThrowException(6, ValidationException.noSessionRegisteredForName(string));
        }
    }

    private void destroy(DatabaseSession databaseSession) {
        if (databaseSession.isConnected()) {
            databaseSession.logout();
        }
        this.sessions.remove(databaseSession.getName());
        databaseSession = null;
    }

    public void destroyAllSessions() {
        Enumeration enumeration = this.getSessions().elements();
        while (enumeration.hasMoreElements()) {
            this.destroy((DatabaseSession)enumeration.nextElement());
        }
    }

    public synchronized TopLinkSessions getInternalMWConfigObjects(String string, ClassLoader classLoader) {
        return this.getInternalMWConfigObjects(string, classLoader, true);
    }

    public synchronized TopLinkSessions getInternalMWConfigObjects(String string, ClassLoader classLoader, boolean bl) {
        return new XMLSessionConfigLoader(string).loadConfigsForMappingWorkbench(classLoader, bl);
    }

    public XMLLoader getLastLoaderUsed() {
        if (this.lastLoaderUsed == null) {
            this.lastLoaderUsed = new XMLLoader();
        }
        return this.lastLoaderUsed;
    }

    public static synchronized SessionManager getManager() {
        if (manager == null) {
            manager = new SessionManager();
        }
        return manager;
    }

    public Session getSession(String string) {
        return this.getSession(new XMLSessionConfigLoader(), string, PrivilegedAccessController.getClassLoaderForClass(this.getClass()), true, false, false);
    }

    public Session getSession(String string, boolean bl) {
        return this.getSession(new XMLSessionConfigLoader(), string, PrivilegedAccessController.getClassLoaderForClass(this.getClass()), bl, false, false);
    }

    public Session getSession(String string, boolean bl, boolean bl2) {
        return this.getSession(new XMLSessionConfigLoader(), string, PrivilegedAccessController.getClassLoaderForClass(this.getClass()), bl, bl2, false);
    }

    public Session getSession(String string, Object object) {
        return this.getSession(new XMLSessionConfigLoader(), string, PrivilegedAccessController.getClassLoaderForClass(object.getClass()));
    }

    public Session getSession(String string, String string2) {
        return this.getSession(new XMLSessionConfigLoader(string2), string, PrivilegedAccessController.getClassLoaderForClass(this.getClass()), true, false, false);
    }

    public Session getSession(String string, ClassLoader classLoader) {
        return this.getSession(new XMLSessionConfigLoader(), string, classLoader, true, false, false);
    }

    public Session getSession(XMLLoader xMLLoader, String string, ClassLoader classLoader) {
        return this.getSession(xMLLoader, string, classLoader, true, false);
    }

    public Session getSession(XMLSessionConfigLoader xMLSessionConfigLoader, String string, ClassLoader classLoader) {
        return this.getSession(xMLSessionConfigLoader, string, classLoader, true, false, true);
    }

    public synchronized Session getSession(XMLLoader xMLLoader, String string, ClassLoader classLoader, boolean bl, boolean bl2) {
        Session session;
        if (xMLLoader == null) {
            xMLLoader = this.getLastLoaderUsed();
        }
        if ((session = (Session)this.getSessions().get(string)) == null || bl2) {
            if (session != null) {
                if (session.isDatabaseSession() && session.isConnected()) {
                    ((DatabaseSession)((Object)session)).logout();
                }
                this.getSessions().remove(string);
            }
            xMLLoader.load(this, classLoader, bl, bl2);
            bl2 = false;
            session = (Session)this.getSessions().get(string);
        }
        if (session instanceof SessionBrokerPlaceHolder && (session = this.processSessionBrokerPlaceHolder((SessionBrokerPlaceHolder)session, xMLLoader, classLoader, bl, bl2)) != null) {
            this.getSessions().put(string, session);
        }
        if (session == null) {
            AbstractSessionLog.getLog().log(6, "no_session_found", string, xMLLoader.getResourceName());
        } else if (bl && !session.isConnected()) {
            ((DatabaseSession)((Object)session)).login();
        }
        return session;
    }

    public synchronized Session getSession(XMLSessionConfigLoader xMLSessionConfigLoader, String string, ClassLoader classLoader, boolean bl, boolean bl2) {
        return this.getSession(xMLSessionConfigLoader, string, classLoader, bl, bl2, false);
    }

    public synchronized Session getSession(XMLSessionConfigLoader xMLSessionConfigLoader, String string, ClassLoader classLoader, boolean bl, boolean bl2, boolean bl3) {
        Session session = (Session)this.getSessions().get(string);
        if (bl3 && session != null && !session.getDatasourcePlatform().getConversionManager().getLoader().equals(classLoader)) {
            bl2 = true;
        }
        if (session == null || bl2) {
            if (session != null) {
                if (session.isDatabaseSession() && session.isConnected()) {
                    ((DatabaseSession)((Object)session)).logout();
                }
                this.getSessions().remove(string);
            }
            if (xMLSessionConfigLoader.load(this, classLoader)) {
                session = (Session)this.getSessions().get(string);
            } else {
                return this.getSession(new XMLLoader(xMLSessionConfigLoader.getResourceName()), string, classLoader, bl, bl2);
            }
        }
        if (session == null) {
            this.logAndThrowException(6, ValidationException.noSessionFound(string, xMLSessionConfigLoader.getResourcePath()));
        } else if (bl && !session.isConnected()) {
            ((DatabaseSession)((Object)session)).login();
        }
        return session;
    }

    public synchronized Session getWASSession(WASXMLSessionConfigLoader wASXMLSessionConfigLoader, ClassLoader classLoader) {
        Session session = null;
        if (wASXMLSessionConfigLoader.load(this, classLoader)) {
            session = wASXMLSessionConfigLoader.getLoadedSession();
        } else {
            try {
                WASXMLLoader wASXMLLoader = new WASXMLLoader(wASXMLSessionConfigLoader.getResourceName());
                session = wASXMLLoader.load(this, classLoader);
                if (session instanceof SessionBrokerPlaceHolder) {
                    session = this.processSessionBrokerPlaceHolder((SessionBrokerPlaceHolder)session, wASXMLLoader, classLoader, false, false);
                }
            }
            catch (ValidationException validationException) {
                this.logAndThrowException(7, validationException);
            }
            catch (Exception exception) {
                this.logAndThrowException(7, ValidationException.errorInSessionsXML(Helper.printStackTraceToString(exception)));
            }
        }
        return session;
    }

    private void logAndThrowException(int n, RuntimeException runtimeException) throws RuntimeException {
        AbstractSessionLog.getLog().logThrowable(n, runtimeException);
        throw runtimeException;
    }

    public SessionBroker processSessionBrokerPlaceHolder(SessionBrokerPlaceHolder sessionBrokerPlaceHolder, XMLLoader xMLLoader, ClassLoader classLoader, boolean bl, boolean bl2) {
        Object object;
        Object object2;
        Iterator iterator = sessionBrokerPlaceHolder.getSessionNamesRequired().iterator();
        while (iterator.hasNext()) {
            object2 = (String)iterator.next();
            object = this.getSession(xMLLoader, (String)object2, classLoader, false, bl2);
            if (object != null) {
                iterator.remove();
                sessionBrokerPlaceHolder.getSessionCompleted().add(object);
                continue;
            }
            return null;
        }
        object2 = new SessionBroker();
        ((Session)object2).setName(sessionBrokerPlaceHolder.getName());
        object = sessionBrokerPlaceHolder.getSessionCompleted().iterator();
        while (object.hasNext()) {
            oracle.toplink.sessions.Session session = (oracle.toplink.sessions.Session)object.next();
            ((SessionBroker)object2).registerSession(session.getName(), session);
        }
        ((Session)object2).setCacheSynchronizationManager(sessionBrokerPlaceHolder.getCacheSynchronizationManager());
        ((Session)object2).setEventManager(sessionBrokerPlaceHolder.getEventManager());
        ((Session)object2).setExceptionHandler(sessionBrokerPlaceHolder.getExceptionHandler());
        ((SessionBroker)object2).setProfiler(sessionBrokerPlaceHolder.getProfiler());
        ((Session)object2).setExternalTransactionController(sessionBrokerPlaceHolder.getExternalTransactionController());
        ((SessionBroker)object2).setSessionLog(sessionBrokerPlaceHolder.getSessionLog());
        return object2;
    }

    public void setSessions(Hashtable hashtable) {
        this.sessions = hashtable;
    }

    public Hashtable getSessions() {
        return this.sessions;
    }

    public void setDefaultSession(oracle.toplink.sessions.Session session) {
        this.defaultSession = (Session)session;
        this.addSession("default", session);
    }

    public static void setManager(SessionManager sessionManager) {
        manager = sessionManager;
    }

    public static boolean shouldPerformDTDValidation() {
        return shouldPerformDTDValidation;
    }

    public static void setShouldPerformDTDValidation(boolean bl) {
        shouldPerformDTDValidation = bl;
    }
}

