/*
 * Decompiled with CFR 0.152.
 */
package oracle.toplink.tools.schemaframework;

import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Vector;
import oracle.toplink.exceptions.DatabaseException;
import oracle.toplink.exceptions.TopLinkException;
import oracle.toplink.exceptions.ValidationException;
import oracle.toplink.internal.databaseaccess.DatabaseAccessor;
import oracle.toplink.internal.sequencing.Sequencing;
import oracle.toplink.publicinterface.Descriptor;
import oracle.toplink.publicinterface.Session;
import oracle.toplink.sequencing.DefaultSequence;
import oracle.toplink.sequencing.NativeSequence;
import oracle.toplink.sequencing.Sequence;
import oracle.toplink.sequencing.TableSequence;
import oracle.toplink.sequencing.UnaryTableSequence;
import oracle.toplink.sessions.DatabaseSession;
import oracle.toplink.tools.schemaframework.DatabaseObjectDefinition;
import oracle.toplink.tools.schemaframework.DefaultTableGenerator;
import oracle.toplink.tools.schemaframework.OracleSequenceDefinition;
import oracle.toplink.tools.schemaframework.SequenceDefinition;
import oracle.toplink.tools.schemaframework.StoredProcedureGenerator;
import oracle.toplink.tools.schemaframework.TableDefinition;
import oracle.toplink.tools.schemaframework.TableSequenceDefinition;
import oracle.toplink.tools.schemaframework.TimesTenSequenceDefinition;
import oracle.toplink.tools.schemaframework.UnaryTableSequenceDefinition;

public class SchemaManager {
    protected oracle.toplink.publicinterface.DatabaseSession session;
    protected Writer schemaWriter;

    public SchemaManager(oracle.toplink.publicinterface.DatabaseSession databaseSession) {
        this.session = databaseSession;
    }

    public SchemaManager(DatabaseSession databaseSession) {
        this.session = (oracle.toplink.publicinterface.DatabaseSession)databaseSession;
    }

    public void appendToDDLWriter(String string) {
        if (this.schemaWriter == null) {
            return;
        }
        try {
            this.schemaWriter.write(string);
            this.schemaWriter.flush();
        }
        catch (IOException iOException) {
            throw ValidationException.fileError(iOException);
        }
    }

    public void buildFieldTypes(TableDefinition tableDefinition) {
        tableDefinition.buildFieldTypes(this.getSession());
    }

    public void closeDDLWriter() {
        if (this.schemaWriter == null) {
            return;
        }
        try {
            this.schemaWriter.flush();
            this.schemaWriter.close();
        }
        catch (IOException iOException) {
            throw ValidationException.fileError(iOException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createConstraints(TableDefinition tableDefinition) throws TopLinkException {
        boolean bl = false;
        if (this.getSession().getPlatform().usesBatchWriting()) {
            bl = true;
            this.getSession().getPlatform().setUsesBatchWriting(false);
        }
        try {
            if (this.shouldWriteToDatabase()) {
                tableDefinition.createConstraintsOnDatabase(this.getSession());
            } else {
                tableDefinition.createConstraints(this.getSession(), this.schemaWriter);
            }
        }
        finally {
            if (bl) {
                this.getSession().getPlatform().setUsesBatchWriting(true);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createObject(DatabaseObjectDefinition databaseObjectDefinition) throws TopLinkException {
        boolean bl = false;
        if (this.getSession().getPlatform().usesBatchWriting()) {
            bl = true;
            this.getSession().getPlatform().setUsesBatchWriting(false);
        }
        try {
            if (this.shouldWriteToDatabase()) {
                databaseObjectDefinition.createOnDatabase(this.getSession());
            } else {
                databaseObjectDefinition.createObject(this.getSession(), this.schemaWriter);
                this.appendToDDLWriter(this.getSession().getPlatform().getStoredProcedureTerminationToken());
                this.appendToDDLWriter("\n");
            }
        }
        finally {
            if (bl) {
                this.getSession().getPlatform().setUsesBatchWriting(true);
            }
        }
    }

    public void createSequences() throws TopLinkException {
        this.createOrReplaceSequences(true);
    }

    public void replaceSequences() throws TopLinkException {
        this.createOrReplaceSequences(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void createOrReplaceSequences(boolean bl) throws TopLinkException {
        Object object;
        Object object2;
        Sequencing sequencing = this.getSession().getSequencing();
        if (sequencing == null || sequencing.whenShouldAcquireValueForAll() == 1) {
            return;
        }
        HashMap<String, TableDefinition> hashMap = new HashMap<String, TableDefinition>();
        HashSet<SequenceDefinition> hashSet = new HashSet<SequenceDefinition>();
        HashSet<Object> hashSet2 = new HashSet<Object>();
        Iterator iterator = this.getSession().getDescriptors().values().iterator();
        while (iterator.hasNext()) {
            String string;
            TableDefinition tableDefinition;
            SequenceDefinition sequenceDefinition;
            object2 = (Descriptor)iterator.next();
            if (!((Descriptor)object2).usesSequenceNumbers()) continue;
            object = ((Descriptor)object2).getSequenceNumberName();
            if (object == null) {
                object = this.getSession().getDatasourcePlatform().getDefaultSequence().getName();
            }
            if (hashSet2.contains(object)) continue;
            hashSet2.add(object);
            Sequence sequence = this.getSession().getDatasourcePlatform().getSequence((String)object);
            if (sequence.shouldAcquireValueAfterInsert() || (sequenceDefinition = this.buildSequenceDefinition(sequence)) == null) continue;
            hashSet.add(sequenceDefinition);
            TableDefinition tableDefinition2 = sequenceDefinition.buildTableDefinition();
            if (tableDefinition2 == null || (tableDefinition = (TableDefinition)hashMap.get(string = tableDefinition2.getName())) != null) continue;
            hashMap.put(string, tableDefinition2);
        }
        object2 = hashMap.values().iterator();
        while (object2.hasNext()) {
            object = (TableDefinition)object2.next();
            boolean bl2 = this.session.getSessionLog().shouldLogExceptionStackTrace();
            if (bl2) {
                this.session.getSessionLog().setShouldLogExceptionStackTrace(false);
            }
            if (bl) {
                try {
                    this.createObject((DatabaseObjectDefinition)object);
                }
                catch (DatabaseException databaseException) {}
                continue;
                finally {
                    if (bl2) {
                        this.session.getSessionLog().setShouldLogExceptionStackTrace(true);
                    }
                    continue;
                }
            }
            try {
                this.dropObject((DatabaseObjectDefinition)object);
            }
            catch (DatabaseException databaseException) {
            }
            finally {
                if (bl2) {
                    this.session.getSessionLog().setShouldLogExceptionStackTrace(true);
                }
            }
            this.createObject((DatabaseObjectDefinition)object);
        }
        object = hashSet.iterator();
        while (object.hasNext()) {
            SequenceDefinition sequenceDefinition = (SequenceDefinition)object.next();
            if (!bl) {
                try {
                    this.dropObject(sequenceDefinition);
                }
                catch (DatabaseException databaseException) {
                    // empty catch block
                }
            }
            this.createObject(sequenceDefinition);
        }
    }

    protected SequenceDefinition buildSequenceDefinition(Sequence sequence) {
        if (sequence instanceof DefaultSequence) {
            String string = sequence.getName();
            int n = sequence.getPreallocationSize();
            sequence = this.getSession().getDatasourcePlatform().getDefaultSequence();
            if (sequence instanceof TableSequence) {
                TableSequence tableSequence = (TableSequence)sequence;
                return new TableSequenceDefinition(string, tableSequence);
            }
            if (sequence instanceof UnaryTableSequence) {
                UnaryTableSequence unaryTableSequence = (UnaryTableSequence)sequence;
                return new UnaryTableSequenceDefinition(string, unaryTableSequence);
            }
            if (sequence instanceof NativeSequence) {
                if (this.getSession().getDatasourcePlatform().isOracle()) {
                    return new OracleSequenceDefinition(string, n);
                }
                if (this.getSession().getDatasourcePlatform().isTimesTen()) {
                    return new TimesTenSequenceDefinition(string, n);
                }
                return null;
            }
            return null;
        }
        if (sequence instanceof TableSequence) {
            TableSequence tableSequence = (TableSequence)sequence;
            return new TableSequenceDefinition(tableSequence);
        }
        if (sequence instanceof UnaryTableSequence) {
            UnaryTableSequence unaryTableSequence = (UnaryTableSequence)sequence;
            return new UnaryTableSequenceDefinition(unaryTableSequence);
        }
        if (sequence instanceof NativeSequence) {
            if (this.getSession().getDatasourcePlatform().isOracle()) {
                NativeSequence nativeSequence = (NativeSequence)sequence;
                return new OracleSequenceDefinition(nativeSequence);
            }
            return null;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dropConstraints(TableDefinition tableDefinition) throws TopLinkException {
        boolean bl = false;
        if (this.getSession().getPlatform().usesBatchWriting()) {
            bl = true;
            this.getSession().getPlatform().setUsesBatchWriting(false);
        }
        try {
            if (this.shouldWriteToDatabase()) {
                tableDefinition.dropConstraintsOnDatabase(this.getSession());
            } else {
                tableDefinition.dropConstraints(this.getSession(), this.schemaWriter);
            }
        }
        finally {
            if (bl) {
                this.getSession().getPlatform().setUsesBatchWriting(true);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dropObject(DatabaseObjectDefinition databaseObjectDefinition) throws TopLinkException {
        boolean bl = false;
        if (this.getSession().getPlatform().usesBatchWriting()) {
            bl = true;
            this.getSession().getPlatform().setUsesBatchWriting(false);
        }
        try {
            if (this.shouldWriteToDatabase()) {
                databaseObjectDefinition.dropFromDatabase(this.getSession());
            } else {
                databaseObjectDefinition.dropObject(this.getSession(), this.schemaWriter);
                this.appendToDDLWriter(this.getSession().getPlatform().getStoredProcedureTerminationToken());
                this.appendToDDLWriter("\n");
            }
        }
        finally {
            if (bl) {
                this.getSession().getPlatform().setUsesBatchWriting(true);
            }
        }
    }

    public void dropTable(String string) throws TopLinkException {
        TableDefinition tableDefinition = new TableDefinition();
        tableDefinition.setName(string);
        this.dropObject(tableDefinition);
    }

    public void finalize() {
        try {
            this.closeDDLWriter();
        }
        catch (ValidationException validationException) {
            // empty catch block
        }
    }

    public void generateStoredProcedures() throws TopLinkException {
        new StoredProcedureGenerator(this).generateStoredProcedures();
    }

    public void generateStoredProcedures(Writer writer) throws TopLinkException {
        new StoredProcedureGenerator(this).generateStoredProcedures(writer);
    }

    public void generateStoredProceduresAndAmendmentClass(Writer writer, String string) throws TopLinkException {
        String string2 = string.substring(string.lastIndexOf(46) + 1);
        String string3 = string.substring(0, string.lastIndexOf(46));
        StoredProcedureGenerator storedProcedureGenerator = new StoredProcedureGenerator(this);
        storedProcedureGenerator.generateStoredProcedures();
        storedProcedureGenerator.generateAmendmentClass(writer, string3, string2);
    }

    public void generateStoredProceduresAndAmendmentClass(String string, String string2) throws TopLinkException {
        try {
            StoredProcedureGenerator storedProcedureGenerator = new StoredProcedureGenerator(this);
            if (!string.endsWith("\\") && !string.endsWith("/")) {
                string = string + "\\";
            }
            String string3 = string2.substring(string2.lastIndexOf(46) + 1);
            String string4 = string2.substring(0, string2.lastIndexOf(46));
            String string5 = string + string3 + ".java";
            FileWriter fileWriter = new FileWriter(string5);
            storedProcedureGenerator.generateStoredProcedures();
            storedProcedureGenerator.generateAmendmentClass(fileWriter, string4, string3);
            fileWriter.close();
        }
        catch (IOException iOException) {
            throw ValidationException.fileError(iOException);
        }
    }

    protected DatabaseAccessor getAccessor() {
        return (DatabaseAccessor)this.getSession().getAccessor();
    }

    public Vector getAllColumnNames(String string) throws DatabaseException {
        return this.getAccessor().getColumnInfo(null, null, string, null, this.getSession());
    }

    public Vector getAllColumnNames(String string, String string2) throws DatabaseException {
        return this.getAccessor().getColumnInfo(null, string, string2, null, this.getSession());
    }

    public Vector getAllTableNames() throws DatabaseException {
        return this.getAccessor().getTableInfo(null, null, null, null, this.getSession());
    }

    public Vector getAllTableNames(String string) throws DatabaseException {
        return this.getAccessor().getTableInfo(null, string, null, null, this.getSession());
    }

    public Vector getColumnInfo(String string, String string2, String string3, String string4) throws DatabaseException {
        return this.getAccessor().getColumnInfo(string, string2, string3, string4, this.getSession());
    }

    public Session getSession() {
        return this.session;
    }

    public Vector getTableInfo(String string, String string2, String string3, String[] stringArray) throws DatabaseException {
        return this.getAccessor().getTableInfo(string, string2, string3, stringArray, this.getSession());
    }

    public void outputDDLToDatabase() {
        this.schemaWriter = null;
    }

    public void outputDDLToFile(String string) {
        try {
            this.schemaWriter = new FileWriter(string);
        }
        catch (IOException iOException) {
            throw ValidationException.fileError(iOException);
        }
    }

    public void outputDDLToWriter(Writer writer) {
        this.schemaWriter = writer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void replaceObject(DatabaseObjectDefinition databaseObjectDefinition) throws TopLinkException {
        boolean bl = this.getSession().getSessionLog().shouldLogExceptionStackTrace();
        if (bl) {
            this.getSession().getSessionLog().setShouldLogExceptionStackTrace(false);
        }
        try {
            this.dropObject(databaseObjectDefinition);
        }
        catch (DatabaseException databaseException) {
        }
        finally {
            if (bl) {
                this.getSession().getSessionLog().setShouldLogExceptionStackTrace(true);
            }
        }
        this.createObject(databaseObjectDefinition);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createDefaultTables() {
        Iterator iterator = new DefaultTableGenerator(this.session.getProject()).generateDefaultTableCreator().getTableDefinitions().iterator();
        while (iterator.hasNext()) {
            TableDefinition tableDefinition = (TableDefinition)iterator.next();
            boolean bl = this.getSession().getSessionLog().shouldLogExceptionStackTrace();
            this.getSession().getSessionLog().setShouldLogExceptionStackTrace(false);
            try {
                this.createObject(tableDefinition);
                this.session.getSessionLog().log(1, "default_tables_created", tableDefinition.getFullName());
            }
            catch (DatabaseException databaseException) {
                this.session.getSessionLog().log(1, "default_tables_already_existed", tableDefinition.getFullName());
            }
            finally {
                this.getSession().getSessionLog().setShouldLogExceptionStackTrace(bl);
            }
        }
        this.createSequences();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void replaceDefaultTables() throws TopLinkException {
        boolean bl = this.getSession().getSessionLog().shouldLogExceptionStackTrace();
        this.getSession().getSessionLog().setShouldLogExceptionStackTrace(false);
        try {
            DefaultTableGenerator defaultTableGenerator = new DefaultTableGenerator(this.session.getProject());
            defaultTableGenerator.generateDefaultTableCreator().replaceTables(this.session);
        }
        catch (DatabaseException databaseException) {
        }
        finally {
            this.getSession().getSessionLog().setShouldLogExceptionStackTrace(bl);
        }
    }

    public void setSession(oracle.toplink.publicinterface.DatabaseSession databaseSession) {
        this.session = databaseSession;
    }

    public boolean shouldWriteToDatabase() {
        return this.schemaWriter == null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void alterSequence(SequenceDefinition sequenceDefinition) throws TopLinkException {
        if (!sequenceDefinition.isAlterSupported()) {
            return;
        }
        boolean bl = false;
        if (this.getSession().getPlatform().usesBatchWriting()) {
            bl = true;
            this.getSession().getPlatform().setUsesBatchWriting(false);
        }
        try {
            if (this.shouldWriteToDatabase()) {
                sequenceDefinition.alterOnDatabase(this.getSession());
            } else {
                sequenceDefinition.alter(this.getSession(), this.schemaWriter);
            }
        }
        finally {
            if (bl) {
                this.getSession().getPlatform().setUsesBatchWriting(true);
            }
        }
    }
}

