/*
 * Decompiled with CFR 0.152.
 */
package oracle.toplink.tools.schemaframework;

import java.io.IOException;
import java.io.Writer;
import java.util.Enumeration;
import java.util.Vector;
import oracle.toplink.exceptions.ValidationException;
import oracle.toplink.internal.databaseaccess.DatabasePlatform;
import oracle.toplink.publicinterface.Session;
import oracle.toplink.tools.schemaframework.DatabaseObjectDefinition;
import oracle.toplink.tools.schemaframework.StoredProcedureDefinition;

public class PackageDefinition
extends DatabaseObjectDefinition {
    protected Vector statements = new Vector();
    protected Vector procedures = new Vector();

    public void addProcedures(StoredProcedureDefinition storedProcedureDefinition) {
        this.getProcedures().addElement(storedProcedureDefinition);
    }

    public void addStatement(String string) {
        this.getStatements().addElement(string);
    }

    public Writer buildCreationWriter(Session session, Writer writer) throws ValidationException {
        try {
            DatabasePlatform databasePlatform = session.getPlatform();
            writer.write("CREATE PACKAGE " + this.getFullName());
            writer.write(" AS");
            writer.write("\n");
            Enumeration enumeration = this.getStatements().elements();
            while (enumeration.hasMoreElements()) {
                writer.write((String)enumeration.nextElement());
                writer.write(databasePlatform.getBatchDelimiterString());
                writer.write("\n");
            }
            enumeration = this.getProcedures().elements();
            while (enumeration.hasMoreElements()) {
                writer.write("\n");
                String string = ((StoredProcedureDefinition)enumeration.nextElement()).buildCreationWriter(session, writer).toString();
                writer.write(string.substring(7, string.length()));
                writer.write("\n");
            }
            writer.write(databasePlatform.getBatchEndString());
            writer.write("\n" + session.getPlatform().getStoredProcedureTerminationToken());
        }
        catch (IOException iOException) {
            throw ValidationException.fileError(iOException);
        }
        return writer;
    }

    public Writer buildDeletionWriter(Session session, Writer writer) throws ValidationException {
        try {
            writer.write("DROP PACKAGE " + this.getFullName());
        }
        catch (IOException iOException) {
            throw ValidationException.fileError(iOException);
        }
        return writer;
    }

    public Vector getProcedures() {
        return this.procedures;
    }

    public Vector getStatements() {
        return this.statements;
    }

    public void setProcedures(Vector vector) {
        this.procedures = vector;
    }

    public void setStatements(Vector vector) {
        this.statements = vector;
    }
}

