/*
 * Decompiled with CFR 0.152.
 */
package oracle.toplink.tools.schemaframework;

import java.io.Serializable;
import java.io.StringWriter;
import java.io.Writer;
import oracle.toplink.exceptions.TopLinkException;
import oracle.toplink.exceptions.ValidationException;
import oracle.toplink.internal.helper.Helper;
import oracle.toplink.publicinterface.Session;
import oracle.toplink.queryframework.SQLCall;

public abstract class DatabaseObjectDefinition
implements Cloneable,
Serializable {
    public String name = "";
    public String qualifier = "";

    public abstract Writer buildCreationWriter(Session var1, Writer var2) throws ValidationException;

    public abstract Writer buildDeletionWriter(Session var1, Writer var2) throws ValidationException;

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return null;
        }
    }

    public void createObject(Session session, Writer writer) throws TopLinkException {
        if (writer == null) {
            this.createOnDatabase(session);
        } else {
            this.buildCreationWriter(session, writer);
        }
    }

    public void createOnDatabase(Session session) throws TopLinkException {
        session.executeNonSelectingCall(new SQLCall(this.buildCreationWriter(session, new StringWriter()).toString()));
    }

    public void dropFromDatabase(Session session) throws TopLinkException {
        session.executeNonSelectingCall(new SQLCall(this.buildDeletionWriter(session, new StringWriter()).toString()));
    }

    public void dropObject(Session session, Writer writer) throws TopLinkException {
        if (writer == null) {
            this.dropFromDatabase(session);
        } else {
            this.buildDeletionWriter(session, writer);
        }
    }

    public String getFullName() {
        if (this.getQualifier().equals("")) {
            return this.getName();
        }
        return this.getQualifier() + "." + this.getName();
    }

    public String getName() {
        return this.name;
    }

    public String getQualifier() {
        return this.qualifier;
    }

    public void setName(String string) {
        this.name = string;
    }

    public void setQualifier(String string) {
        this.qualifier = string;
    }

    public String toString() {
        return Helper.getShortClassName(this.getClass()) + "(" + this.getFullName() + ")";
    }
}

