/*
 * Decompiled with CFR 0.152.
 */
package oracle.toplink.tools.profiler;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import oracle.dms.instrument.DMSConsole;
import oracle.dms.instrument.Event;
import oracle.dms.instrument.Noun;
import oracle.dms.instrument.PhaseEvent;
import oracle.dms.instrument.Sensor;
import oracle.dms.instrument.State;
import oracle.dms.spy.ConfigurationError;
import oracle.dms.spy.PublisherError;
import oracle.dms.spy.Spy;
import oracle.toplink.internal.localization.DMSLocalization;
import oracle.toplink.publicinterface.DatabaseRow;
import oracle.toplink.publicinterface.Session;
import oracle.toplink.queryframework.DatabaseQuery;
import oracle.toplink.queryframework.DeleteAllQuery;
import oracle.toplink.sessions.SessionProfiler;
import oracle.toplink.threetier.ServerSession;

public class DMSPerformanceProfiler
implements Serializable,
Cloneable,
SessionProfiler {
    protected Session session;
    protected Noun root;
    protected Map normalWeightSensors;
    protected Map heavyWeightSensors;
    protected Map allWeightSensors;
    protected Map normalAndHeavyWeightSensors;
    protected Map normalHeavyAndAllWeightSensors;
    protected Map normalWeightNouns;
    protected Map heavyWeightNouns;
    protected Map allWeightNouns;
    protected Map operationStartTokenByThread;
    protected static boolean isDMSSpyInitialized;
    protected int weight;

    public DMSPerformanceProfiler(oracle.toplink.sessions.Session session) {
        this.session = (Session)session;
        this.normalWeightNouns = new HashMap(1);
        this.heavyWeightNouns = new HashMap(5);
        this.allWeightNouns = new HashMap(1);
        this.normalWeightSensors = new HashMap(4);
        this.heavyWeightSensors = new HashMap();
        this.allWeightSensors = new HashMap(22);
        this.normalAndHeavyWeightSensors = new HashMap();
        this.normalHeavyAndAllWeightSensors = new HashMap();
        this.operationStartTokenByThread = new HashMap();
        this.weight = DMSConsole.getSensorWeight();
        if (!isDMSSpyInitialized) {
            isDMSSpyInitialized = true;
            this.initSpy();
        }
    }

    protected void initializeNounTree(int n) {
        if (n == 0) {
            this.destroyNounsByWeight(5);
            this.destroyNounsByWeight(10);
            this.destroyNounsByWeight(Integer.MAX_VALUE);
            if (this.root != null) {
                this.root.destroy();
            }
            return;
        }
        if (n == 5) {
            if (this.getProfileWeight() == 0) {
                this.initializeNormalWeightSensors();
            } else if (this.getProfileWeight() == 10) {
                this.destroyNounsByWeight(10);
            } else if (this.getProfileWeight() == Integer.MAX_VALUE) {
                this.destroyNounsByWeight(10);
                this.destroyNounsByWeight(Integer.MAX_VALUE);
            }
        }
        if (n == 10) {
            if (this.getProfileWeight() == 0) {
                this.initializeNormalWeightSensors();
                this.initializeHeavyWeightSensors();
            } else if (this.getProfileWeight() == 5) {
                this.initializeHeavyWeightSensors();
            } else if (this.getProfileWeight() == Integer.MAX_VALUE) {
                this.destroyNounsByWeight(Integer.MAX_VALUE);
            }
        }
        if (n == Integer.MAX_VALUE) {
            if (this.getProfileWeight() == 0) {
                this.initializeNormalWeightSensors();
                this.initializeHeavyWeightSensors();
                this.initializeAllWeightSensors();
            } else if (this.getProfileWeight() == 5) {
                this.initializeHeavyWeightSensors();
                this.initializeAllWeightSensors();
            } else if (this.getProfileWeight() == 10) {
                this.initializeAllWeightSensors();
            }
        }
    }

    public void setProfileWeight(int n) {
        if (n != this.weight) {
            this.getSession().setIsInProfile(n != 0);
            if (this.getNormalWeightNouns().isEmpty()) {
                this.weight = 0;
            }
            this.initializeNounTree(n);
            this.weight = n;
        }
    }

    public void initialize() {
        this.weight = 0;
        this.initializeNounTree(DMSConsole.getSensorWeight());
        this.weight = DMSConsole.getSensorWeight();
    }

    public int getProfileWeight() {
        return this.weight;
    }

    public void startOperationProfile(String string) {
        if (this.getProfileWeight() == 5) {
            return;
        }
        Sensor sensor = this.getSensorByName(string);
        if (sensor != null) {
            Long l = new Long(((PhaseEvent)sensor).start());
            this.getPhaseEventStartToken().put(string, l);
        }
    }

    public void endOperationProfile(String string) {
        if (this.getProfileWeight() == 5) {
            return;
        }
        Sensor sensor = this.getSensorByName(string);
        if (sensor != null) {
            Long l = (Long)this.getPhaseEventStartToken().get(string);
            ((PhaseEvent)sensor).stop(l.longValue());
        }
    }

    public void update(String string, Object object) {
        Sensor sensor = this.getSensorByName(string);
        if (sensor != null) {
            ((State)sensor).update(object);
        }
    }

    public void occurred(String string) {
        Sensor sensor = this.getSensorByName(string);
        if (sensor != null) {
            ((Event)sensor).occurred();
        }
    }

    protected Sensor getSensorByName(String string) {
        Sensor sensor = null;
        if (this.getProfileWeight() == 5) {
            sensor = (Sensor)this.getNormalWeightSensors().get(string);
        } else if (this.getProfileWeight() == 10) {
            sensor = (Sensor)this.getNormalAndHeavyWeightSensors().get(string);
        } else if (this.getProfileWeight() == Integer.MAX_VALUE) {
            sensor = (Sensor)this.getNormalHeavyAndAllWeightSensors().get(string);
        }
        return sensor;
    }

    protected void createRootNoun() {
        this.root = Noun.create((String)"/TopLink");
    }

    protected void initializeNormalWeightSensors() {
        this.createRootNoun();
        Noun noun = Noun.create((Noun)this.root, (String)("Session" + this.getSessionName()), (String)"TopLink Session");
        State state = State.create((Noun)noun, (String)"SessionName", (String)"", (String)DMSLocalization.buildMessage("session_name"), (Object)(this.getSession().getName() == "" ? "session name not specified" : this.getSession().getName()));
        State state2 = State.create((Noun)noun, (String)"loginTime", (String)"", (String)DMSLocalization.buildMessage("session_login_time"), (Object)"not available");
        this.getNormalWeightSensors().put("loginTime", state2);
        this.getNormalWeightNouns().put("TopLink Session", noun);
    }

    protected void initializeHeavyWeightSensors() {
        State state;
        String string;
        Object object;
        Noun noun = (Noun)this.getNormalWeightNouns().get("TopLink Session");
        Event event = Event.create((Noun)noun, (String)"ClientSession", (String)DMSLocalization.buildMessage("client_session_count"));
        this.getHeavyWeightSensors().put("ClientSession", event);
        Event event2 = Event.create((Noun)noun, (String)"UnitOfWork", (String)DMSLocalization.buildMessage("unitofwork_count"));
        this.getHeavyWeightSensors().put("UnitOfWork", event2);
        Noun noun2 = Noun.create((Noun)this.root, (String)("Transaction" + this.getSessionName()), (String)"TopLink Transaction");
        this.getHeavyWeightNouns().put("TopLink Transaction", noun2);
        PhaseEvent phaseEvent = PhaseEvent.create((Noun)noun2, (String)"UnitOfWorkCommits", (String)DMSLocalization.buildMessage("unitofwork_commit"));
        phaseEvent.deriveMetric(511);
        this.getHeavyWeightSensors().put("UnitOfWorkCommits", phaseEvent);
        Event event3 = Event.create((Noun)noun2, (String)"UnitOfWorkRollbacks", (String)DMSLocalization.buildMessage("unitofwork_rollback"));
        this.getHeavyWeightSensors().put("UnitOfWorkRollbacks", event3);
        Event event4 = Event.create((Noun)noun2, (String)"OptimisticLocks", (String)DMSLocalization.buildMessage("optimistic_lock"));
        this.getHeavyWeightSensors().put("OptimisticLocks", event4);
        Noun noun3 = Noun.create((Noun)this.root, (String)("Query" + this.getSessionName()), (String)"Toplink Queries");
        this.getHeavyWeightNouns().put("Toplink Queries", noun3);
        PhaseEvent phaseEvent2 = PhaseEvent.create((Noun)noun3, (String)"ReadQueries", (String)DMSLocalization.buildMessage("read_query"));
        phaseEvent2.deriveMetric(511);
        this.getHeavyWeightSensors().put("ReadQueries", phaseEvent2);
        PhaseEvent phaseEvent3 = PhaseEvent.create((Noun)noun3, (String)"WriteQueries", (String)DMSLocalization.buildMessage("write_query"));
        phaseEvent3.deriveMetric(511);
        this.getHeavyWeightSensors().put("WriteQueries", phaseEvent3);
        PhaseEvent phaseEvent4 = PhaseEvent.create((Noun)noun3, (String)"DeleteQueries", (String)DMSLocalization.buildMessage("delete_query"));
        phaseEvent4.deriveMetric(511);
        this.getHeavyWeightSensors().put("DeleteQueries", phaseEvent4);
        Noun noun4 = Noun.create((Noun)this.root, (String)("RCM" + this.getSessionName()), (String)"Toplink RCM");
        this.getHeavyWeightNouns().put("Toplink RCM", noun4);
        State state2 = State.create((Noun)noun4, (String)"RCMStatus", (String)"", (String)DMSLocalization.buildMessage("rcm_status"), (Object)"not available");
        this.getHeavyWeightSensors().put("RCMStatus", state2);
        Event event5 = Event.create((Noun)noun4, (String)"MessagesReceived", (String)DMSLocalization.buildMessage("rcm_message_received"));
        this.getHeavyWeightSensors().put("MessagesReceived", event5);
        Event event6 = Event.create((Noun)noun4, (String)"MessagesSent", (String)DMSLocalization.buildMessage("rcm_message_sent"));
        this.getHeavyWeightSensors().put("MessagesSent", event6);
        Event event7 = Event.create((Noun)noun4, (String)"RemoteChangeSets", (String)DMSLocalization.buildMessage("remote_change_set"));
        this.getHeavyWeightSensors().put("RemoteChangeSets", event7);
        Noun noun5 = Noun.create((Noun)this.root, (String)("Connection" + this.getSessionName()), (String)"TopLink Connections");
        this.getHeavyWeightNouns().put("TopLink Connections", noun5);
        if (this.getSession().isServerSession()) {
            object = ((ServerSession)this.getSession()).getConnectionPools().keySet().iterator();
            while (object.hasNext()) {
                string = (String)object.next();
                state = State.create((Noun)noun5, (String)("ConnectionsInUse(" + string + ")"), (String)"", (String)DMSLocalization.buildMessage("connection_in_used"), (Object)"not available");
                this.getHeavyWeightSensors().put(string, state);
            }
        }
        object = Event.create((Noun)noun5, (String)"ConnectCalls", (String)DMSLocalization.buildMessage("connect_call"));
        this.getHeavyWeightSensors().put("ConnectCalls", object);
        string = Event.create((Noun)noun5, (String)"DisconnectCalls", (String)DMSLocalization.buildMessage("disconnect_call"));
        this.getHeavyWeightSensors().put("DisconnectCalls", string);
        state = Noun.create((Noun)this.root, (String)("Cache" + this.getSessionName()), (String)"TopLink Cache");
        this.getHeavyWeightNouns().put("TopLink Cache", state);
        Event event8 = Event.create((Noun)state, (String)"CacheHits", (String)DMSLocalization.buildMessage("cache_hits"));
        this.getHeavyWeightSensors().put("CacheHits", event8);
        Event event9 = Event.create((Noun)state, (String)"CacheMisses", (String)DMSLocalization.buildMessage("cache_misses"));
        this.getHeavyWeightSensors().put("CacheMisses", event9);
        this.getNormalAndHeavyWeightSensors().putAll(this.getNormalWeightSensors());
        this.getNormalAndHeavyWeightSensors().putAll(this.getHeavyWeightSensors());
    }

    protected void initializeAllWeightSensors() {
        Noun noun = (Noun)this.getHeavyWeightNouns().get("Toplink Queries");
        PhaseEvent phaseEvent = PhaseEvent.create((Noun)noun, (String)"SqlPrepare", (String)DMSLocalization.buildMessage("sql_prepare"));
        phaseEvent.deriveMetric(511);
        this.getAllWeightSensors().put("sql prepare", phaseEvent);
        PhaseEvent phaseEvent2 = PhaseEvent.create((Noun)noun, (String)"QueryPreparation", (String)DMSLocalization.buildMessage("query_prepareation"));
        phaseEvent2.deriveMetric(511);
        this.getAllWeightSensors().put("query prepare", phaseEvent2);
        PhaseEvent phaseEvent3 = PhaseEvent.create((Noun)noun, (String)"SqlGeneration", (String)DMSLocalization.buildMessage("sql_generation"));
        phaseEvent3.deriveMetric(511);
        this.getAllWeightSensors().put("sql generation", phaseEvent3);
        PhaseEvent phaseEvent4 = PhaseEvent.create((Noun)noun, (String)"DatabaseExecute", (String)DMSLocalization.buildMessage("database_execute"));
        phaseEvent4.deriveMetric(511);
        this.getAllWeightSensors().put("sql execute", phaseEvent4);
        PhaseEvent phaseEvent5 = PhaseEvent.create((Noun)noun, (String)"RowFetch", (String)DMSLocalization.buildMessage("row_fetch"));
        phaseEvent5.deriveMetric(511);
        this.getAllWeightSensors().put("row fetch", phaseEvent5);
        PhaseEvent phaseEvent6 = PhaseEvent.create((Noun)noun, (String)"ObjectBuilding", (String)DMSLocalization.buildMessage("object_building"));
        phaseEvent6.deriveMetric(511);
        this.getAllWeightSensors().put("object building", phaseEvent6);
        Noun noun2 = (Noun)this.getHeavyWeightNouns().get("TopLink Transaction");
        PhaseEvent phaseEvent7 = PhaseEvent.create((Noun)noun2, (String)"MergeTime", (String)DMSLocalization.buildMessage("merge_time"));
        phaseEvent7.deriveMetric(511);
        this.getAllWeightSensors().put("merge", phaseEvent7);
        PhaseEvent phaseEvent8 = PhaseEvent.create((Noun)noun2, (String)"TXAfterCompletion", (String)DMSLocalization.buildMessage("jts_aftercompletion"));
        phaseEvent8.deriveMetric(511);
        this.getAllWeightSensors().put("TXAfterCompletion", phaseEvent8);
        PhaseEvent phaseEvent9 = PhaseEvent.create((Noun)noun2, (String)"TXBeforeCompletion", (String)DMSLocalization.buildMessage("jts_beforecompletion"));
        phaseEvent9.deriveMetric(511);
        this.getAllWeightSensors().put("TXBeforeCompletion", phaseEvent9);
        PhaseEvent phaseEvent10 = PhaseEvent.create((Noun)noun2, (String)"UnitOfWorkRegister", (String)DMSLocalization.buildMessage("unitofwork_register"));
        phaseEvent10.deriveMetric(511);
        this.getAllWeightSensors().put("register", phaseEvent10);
        PhaseEvent phaseEvent11 = PhaseEvent.create((Noun)noun2, (String)"DistributedMerge", (String)DMSLocalization.buildMessage("distributed_merge"));
        phaseEvent11.deriveMetric(511);
        this.getAllWeightSensors().put("distributed merge", phaseEvent11);
        Event event = Event.create((Noun)noun2, (String)"deleted object", (String)DMSLocalization.buildMessage("deleted_object"));
        this.getAllWeightSensors().put("deleted object", event);
        PhaseEvent phaseEvent12 = PhaseEvent.create((Noun)noun2, (String)"Sequencing", (String)DMSLocalization.buildMessage("assigning_sequence_numbers"));
        phaseEvent12.deriveMetric(511);
        this.getAllWeightSensors().put("assign sequence", phaseEvent12);
        Noun noun3 = (Noun)this.getHeavyWeightNouns().get("TopLink Cache");
        PhaseEvent phaseEvent13 = PhaseEvent.create((Noun)noun3, (String)"Caching", (String)DMSLocalization.buildMessage("caching"));
        phaseEvent13.deriveMetric(511);
        this.getAllWeightSensors().put("cache", phaseEvent13);
        Noun noun4 = (Noun)this.getHeavyWeightNouns().get("TopLink Connections");
        PhaseEvent phaseEvent14 = PhaseEvent.create((Noun)noun4, (String)"ConnectionManagement", (String)DMSLocalization.buildMessage("connection"));
        phaseEvent14.deriveMetric(511);
        this.getAllWeightSensors().put("connect", phaseEvent14);
        Noun noun5 = (Noun)this.getHeavyWeightNouns().get("Toplink RCM");
        Event event2 = Event.create((Noun)noun5, (String)"ChangesProcessed", (String)DMSLocalization.buildMessage("change_set_processed"));
        this.getAllWeightSensors().put("ChangesProcessed", event2);
        Event event3 = Event.create((Noun)noun5, (String)"ChangesNotProcessed", (String)DMSLocalization.buildMessage("change_set_not_processed"));
        this.getAllWeightSensors().put("ChangesNotProcessed", event3);
        Noun noun6 = Noun.create((Noun)this.root, (String)("Miscellaneous" + this.getSessionName()), (String)"TopLink Miscellaneous");
        this.getAllWeightNouns().put("TopLink Miscellaneous", noun6);
        PhaseEvent phaseEvent15 = PhaseEvent.create((Noun)noun6, (String)"DistributedMerge", (String)DMSLocalization.buildMessage("logging"));
        phaseEvent15.deriveMetric(511);
        this.getAllWeightSensors().put("logging", phaseEvent15);
        PhaseEvent phaseEvent16 = PhaseEvent.create((Noun)noun6, (String)"wrapping", (String)DMSLocalization.buildMessage("wrapping"));
        phaseEvent16.deriveMetric(511);
        this.getAllWeightSensors().put("wrapping", phaseEvent16);
        PhaseEvent phaseEvent17 = PhaseEvent.create((Noun)noun6, (String)"DescriptorEvents", (String)DMSLocalization.buildMessage("descriptor_event"));
        phaseEvent17.deriveMetric(511);
        this.getAllWeightSensors().put("DescriptorEvents", phaseEvent17);
        PhaseEvent phaseEvent18 = PhaseEvent.create((Noun)noun6, (String)"SessionEvents", (String)DMSLocalization.buildMessage("session_event"));
        phaseEvent18.deriveMetric(511);
        this.getAllWeightSensors().put("SessionEvents", phaseEvent18);
        this.getNormalHeavyAndAllWeightSensors().putAll(this.getNormalAndHeavyWeightSensors());
        this.getNormalHeavyAndAllWeightSensors().putAll(this.getAllWeightSensors());
    }

    protected void initSpy() {
        try {
            Spy.init((String)"TopLink", null);
        }
        catch (PublisherError publisherError) {
            this.getSession().log(6, "dms", "an_error_occured_initializing_dms_listener");
            this.getSession().logThrowable(6, "dms", publisherError);
            this.setProfileWeight(0);
        }
        catch (ConfigurationError configurationError) {
            this.getSession().log(6, "dms", "an_error_occured_initializing_dms_listener");
            this.getSession().logThrowable(6, "dms", configurationError);
            this.setProfileWeight(0);
        }
    }

    protected void destroySensorsByWeight(int n) {
        Iterator iterator = null;
        if (n == 10) {
            iterator = this.getHeavyWeightSensors().values().iterator();
        } else if (n == Integer.MAX_VALUE) {
            iterator = this.getAllWeightSensors().values().iterator();
        }
        if (iterator != null) {
            while (iterator.hasNext()) {
                ((Sensor)iterator.next()).destroy();
            }
        }
    }

    protected void destroyNounsByWeight(int n) {
        Iterator iterator;
        if (n == 5) {
            iterator = this.getNormalWeightNouns().values().iterator();
            while (iterator.hasNext()) {
                ((Noun)iterator.next()).destroy();
            }
            this.getNormalWeightNouns().clear();
            this.getNormalWeightSensors().clear();
        }
        if (n == 10) {
            iterator = this.getHeavyWeightNouns().values().iterator();
            while (iterator.hasNext()) {
                ((Noun)iterator.next()).destroy();
            }
            this.getHeavyWeightNouns().clear();
            this.destroySensorsByWeight(10);
            this.getNormalAndHeavyWeightSensors().clear();
            this.getHeavyWeightSensors().clear();
        }
        if (n == Integer.MAX_VALUE) {
            iterator = this.getAllWeightNouns().values().iterator();
            while (iterator.hasNext()) {
                ((Noun)iterator.next()).destroy();
            }
            this.getAllWeightNouns().clear();
            this.destroySensorsByWeight(Integer.MAX_VALUE);
            this.getNormalHeavyAndAllWeightSensors().clear();
            this.getAllWeightSensors().clear();
        }
    }

    protected HashMap getPhaseEventStartToken() {
        Integer n = new Integer(Thread.currentThread().hashCode());
        if (this.getOperationStartTokenByThread().get(n) == null) {
            this.getOperationStartTokenByThread().put(n, new HashMap());
        }
        return (HashMap)this.getOperationStartTokenByThread().get(n);
    }

    protected Map getNormalWeightSensors() {
        return this.normalWeightSensors;
    }

    protected Map getHeavyWeightSensors() {
        return this.heavyWeightSensors;
    }

    protected Map getAllWeightSensors() {
        return this.allWeightSensors;
    }

    protected Map getNormalAndHeavyWeightSensors() {
        return this.normalAndHeavyWeightSensors;
    }

    protected Map getNormalHeavyAndAllWeightSensors() {
        return this.normalHeavyAndAllWeightSensors;
    }

    protected Map getNormalWeightNouns() {
        return this.normalWeightNouns;
    }

    protected Map getHeavyWeightNouns() {
        return this.heavyWeightNouns;
    }

    protected Map getAllWeightNouns() {
        return this.allWeightNouns;
    }

    protected Map getOperationStartTokenByThread() {
        return this.operationStartTokenByThread;
    }

    public Session getSession() {
        return this.session;
    }

    public String getSessionName() {
        if (this.getSession().getName() != "") {
            return "(" + this.getSession().getName() + ")";
        }
        return this.getSession().getName();
    }

    public void setSession(oracle.toplink.sessions.Session session) {
        this.session = (Session)session;
    }

    public Object profileExecutionOfQuery(DatabaseQuery databaseQuery, DatabaseRow databaseRow, Session session) {
        String string = null;
        if (databaseQuery.isReadQuery()) {
            string = "ReadQueries";
        } else if (databaseQuery.isWriteObjectQuery()) {
            string = "WriteQueries";
        } else if (databaseQuery.isDeleteObjectQuery() || databaseQuery instanceof DeleteAllQuery) {
            string = "DeleteQueries";
        }
        session.startOperationProfile(string);
        Object object = session.internalExecuteQuery(databaseQuery, databaseRow);
        session.endOperationProfile(string);
        return object;
    }
}

