/*
 * Decompiled with CFR 0.152.
 */
package oracle.toplink.tools.ejbjar;

import java.util.Enumeration;
import java.util.HashSet;
import java.util.Map;
import java.util.Vector;
import oracle.toplink.exceptions.i18n.ExceptionMessageGenerator;
import oracle.toplink.tools.ejbjar.EjbJar;
import oracle.toplink.tools.ejbjar.EjbJarError;
import oracle.toplink.tools.ejbjar.EjbJarXMLDocument;
import oracle.toplink.tools.ejbjar.EnterpriseObject;
import oracle.toplink.tools.ejbjar.Entity;
import oracle.toplink.tools.ejbjar.ListMap;
import oracle.toplink.tools.ejbjar.Query;
import oracle.toplink.tools.ejbjar.QueryMethod;
import oracle.toplink.tools.ejbjar.Relationship;
import oracle.toplink.tools.ejbjar.RelationshipRole;
import oracle.toplink.tools.ejbjar.RelationshipRoleSource;
import oracle.toplink.tools.ejbjar.Relationships;

public class ValidationManager {
    static /* synthetic */ Class class$oracle$toplink$exceptions$EJBJarXMLException;

    public static ListMap validateEjbJar(EjbJar ejbJar) {
        ListMap listMap = new ListMap();
        if (ejbJar == null) {
            return listMap;
        }
        ValidationManager.validateRequiredAttribute(ejbJar.getEnterpriseObjects(), "enterprise-beans", "ejb-jar", listMap);
        listMap.putAll((Map)ValidationManager.validateEnterpiseObjects(ejbJar.getEnterpriseObjects()));
        listMap.putAll((Map)ValidationManager.validateRelationships(ejbJar.getRelationships()));
        listMap.putAll((Map)ValidationManager.validateEjbNameFromRelationRoleSources(ejbJar.getRelationships(), ejbJar.getEntities()));
        return listMap;
    }

    public static ListMap validateEjbJarXMLDocument(EjbJarXMLDocument ejbJarXMLDocument) {
        if (ejbJarXMLDocument != null) {
            return ValidationManager.validateEjbJar(ejbJarXMLDocument.getEjbJar());
        }
        return new ListMap();
    }

    private static ListMap validateEjbNameFromRelationRoleSources(Relationships relationships, Vector vector) {
        String string;
        ListMap listMap = new ListMap();
        HashSet<String> hashSet = new HashSet<String>();
        if (relationships == null || relationships.getRelationships() == null || vector == null) {
            return listMap;
        }
        Object object = vector.elements();
        while (object.hasMoreElements()) {
            string = ((Entity)object.nextElement()).getEjbName();
            if (string == null) continue;
            hashSet.add(string.trim());
        }
        Enumeration enumeration = relationships.getRelationships().elements();
        while (enumeration.hasMoreElements()) {
            EjbJarError ejbJarError;
            Object[] objectArray;
            Relationship relationship = (Relationship)enumeration.nextElement();
            if (relationship.getRole1() != null && relationship.getRole1().getRelationshipRoleSource() != null && relationship.getRole1().getRelationshipRoleSource().getEjbName() != null && !hashSet.contains(string = relationship.getRole1().getRelationshipRoleSource().getEjbName().trim())) {
                objectArray = new Object[]{string, relationship.getRole1().getRoleName()};
                object = ExceptionMessageGenerator.buildMessage(class$oracle$toplink$exceptions$EJBJarXMLException == null ? ValidationManager.class$("oracle.toplink.exceptions.EJBJarXMLException") : class$oracle$toplink$exceptions$EJBJarXMLException, 72014, objectArray);
                ejbJarError = new EjbJarError((String)object);
                listMap.put(ejbJarError, (Object)ejbJarError);
            }
            if (relationship.getRole2() == null || relationship.getRole2().getRelationshipRoleSource() == null || relationship.getRole2().getRelationshipRoleSource().getEjbName() == null || hashSet.contains(string = relationship.getRole2().getRelationshipRoleSource().getEjbName().trim())) continue;
            objectArray = new Object[]{string, relationship.getRole2().getRoleName()};
            object = ExceptionMessageGenerator.buildMessage(class$oracle$toplink$exceptions$EJBJarXMLException == null ? ValidationManager.class$("oracle.toplink.exceptions.EJBJarXMLException") : class$oracle$toplink$exceptions$EJBJarXMLException, 72014, objectArray);
            ejbJarError = new EjbJarError((String)object);
            listMap.put(ejbJarError, (Object)ejbJarError);
        }
        return listMap;
    }

    private static ListMap validateEnterpiseObjects(Vector vector) {
        ListMap listMap = new ListMap();
        Vector<EnterpriseObject> vector2 = new Vector<EnterpriseObject>();
        Vector<String> vector3 = new Vector<String>();
        if (vector == null) {
            return listMap;
        }
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            EnterpriseObject enterpriseObject = (EnterpriseObject)enumeration.nextElement();
            if (enterpriseObject.getEjbName() != null) {
                if (vector3.contains(enterpriseObject.getEjbName().trim())) {
                    Object[] objectArray = new Object[]{enterpriseObject.getEjbName()};
                    String string = ExceptionMessageGenerator.buildMessage(class$oracle$toplink$exceptions$EJBJarXMLException == null ? ValidationManager.class$("oracle.toplink.exceptions.EJBJarXMLException") : class$oracle$toplink$exceptions$EJBJarXMLException, 72012, objectArray);
                    EjbJarError ejbJarError = new EjbJarError(string);
                    listMap.put(ejbJarError, (Object)ejbJarError);
                } else {
                    vector3.add(enterpriseObject.getEjbName().trim());
                }
            }
            if (!enterpriseObject.isEntity()) continue;
            vector2.add(enterpriseObject);
        }
        listMap.putAll((Map)ValidationManager.validateEntities(vector2));
        return listMap;
    }

    private static ListMap validateEntities(Vector vector) {
        ListMap listMap = new ListMap();
        String string = null;
        String string2 = null;
        EjbJarError ejbJarError = null;
        if (vector == null) {
            return listMap;
        }
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            EjbJarError ejbJarError2;
            String string3;
            Object[] objectArray;
            Entity entity = (Entity)enumeration.nextElement();
            ValidationManager.validateRequiredAttribute(entity.getCmpVersion(), "cmp-version", "entity", listMap);
            ValidationManager.validateRequiredAttribute(entity.getPersistenceType(), "persistence-type", "entity", listMap);
            ValidationManager.validateRequiredAttribute(entity.getEjbName(), "ejb-name", "entity", listMap);
            ValidationManager.validateRequiredAttribute(entity.getEjbClass(), "ejb-class", "entity", listMap);
            ValidationManager.validateRequiredAttribute(entity.getPrimaryKeyClass(), "prim-key-class", "entity", listMap);
            ValidationManager.validateRequiredAttribute(entity.getQueries(), "query", "entity", listMap);
            if (string == null) {
                string = entity.getPersistenceType();
            }
            if (string2 == null) {
                string2 = entity.getCmpVersion();
            }
            if (entity.getCmpVersion() != null && !entity.getCmpVersion().equalsIgnoreCase("1.x") && !entity.getCmpVersion().equalsIgnoreCase("2.x")) {
                objectArray = new Object[]{entity.getEjbName()};
                string3 = ExceptionMessageGenerator.buildMessage(class$oracle$toplink$exceptions$EJBJarXMLException == null ? ValidationManager.class$("oracle.toplink.exceptions.EJBJarXMLException") : class$oracle$toplink$exceptions$EJBJarXMLException, 72013, objectArray);
                ejbJarError2 = new EjbJarError(string3);
                listMap.put(ejbJarError2, (Object)ejbJarError2);
            }
            if (entity.getPersistenceType() != null && !entity.getPersistenceType().equalsIgnoreCase("Bean") && !entity.getPersistenceType().equalsIgnoreCase("Container")) {
                objectArray = new Object[]{entity.getEjbName()};
                string3 = ExceptionMessageGenerator.buildMessage(class$oracle$toplink$exceptions$EJBJarXMLException == null ? ValidationManager.class$("oracle.toplink.exceptions.EJBJarXMLException") : class$oracle$toplink$exceptions$EJBJarXMLException, 72016, objectArray);
                ejbJarError2 = new EjbJarError(string3);
                listMap.put(ejbJarError2, (Object)ejbJarError2);
            }
            if (!(string2 == null || string == null || string.equalsIgnoreCase(entity.getPersistenceType()) && string2.equalsIgnoreCase(entity.getCmpVersion()))) {
                objectArray = new Object[]{};
                string3 = ExceptionMessageGenerator.buildMessage(class$oracle$toplink$exceptions$EJBJarXMLException == null ? ValidationManager.class$("oracle.toplink.exceptions.EJBJarXMLException") : class$oracle$toplink$exceptions$EJBJarXMLException, 72018, objectArray);
                ejbJarError = new EjbJarError(string3);
                listMap.put(ejbJarError, (Object)ejbJarError);
            }
            if (entity.getQueries() == null) continue;
            listMap.putAll((Map)ValidationManager.validateQueries(entity.getQueries()));
        }
        return listMap;
    }

    private static ListMap validateQueries(Vector vector) {
        ListMap listMap = new ListMap();
        if (vector == null) {
            return listMap;
        }
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            Query query = (Query)enumeration.nextElement();
            ValidationManager.validateRequiredAttribute(query.getQueryMethod(), "query-method", "query", listMap);
            listMap.putAll((Map)ValidationManager.validateQueryMethod(query.getQueryMethod()));
        }
        return listMap;
    }

    private static ListMap validateQueryMethod(QueryMethod queryMethod) {
        ListMap listMap = new ListMap();
        ValidationManager.validateRequiredAttribute(queryMethod.getMethodName(), "method-name", "query-method", listMap);
        ValidationManager.validateRequiredAttribute(queryMethod.getParams(), "method-params", "query-method", listMap);
        String string = queryMethod.getMethodName();
        if (string != null && !string.trim().startsWith("find") && !string.trim().startsWith("ejbSelect")) {
            Object[] objectArray = new Object[]{string};
            String string2 = ExceptionMessageGenerator.buildMessage(class$oracle$toplink$exceptions$EJBJarXMLException == null ? (class$oracle$toplink$exceptions$EJBJarXMLException = ValidationManager.class$("oracle.toplink.exceptions.EJBJarXMLException")) : class$oracle$toplink$exceptions$EJBJarXMLException, 72017, objectArray);
            EjbJarError ejbJarError = new EjbJarError(string2);
            listMap.put(ejbJarError, (Object)ejbJarError);
        }
        return listMap;
    }

    private static ListMap validateRelationRoleSource(RelationshipRoleSource relationshipRoleSource) {
        ListMap listMap = new ListMap();
        if (relationshipRoleSource == null) {
            return listMap;
        }
        ValidationManager.validateRequiredAttribute(relationshipRoleSource.getEjbName(), "ejb-name", "relationship-role-sourcerelationship-role-source", listMap);
        return listMap;
    }

    private static ListMap validateRelations(Vector vector) {
        ListMap listMap = new ListMap();
        if (vector == null) {
            return listMap;
        }
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            Relationship relationship = (Relationship)enumeration.nextElement();
            ValidationManager.validateRequiredAttribute(relationship.getRole1(), "ejb-relationship-role", "ejb-relation", listMap);
            ValidationManager.validateRequiredAttribute(relationship.getRole2(), "ejb-relationship-role", "ejb-relation", listMap);
            listMap.putAll((Map)ValidationManager.validateRelationshipRole(relationship.getRole1()));
            listMap.putAll((Map)ValidationManager.validateRelationshipRole(relationship.getRole2()));
        }
        return listMap;
    }

    private static ListMap validateRelationshipRole(RelationshipRole relationshipRole) {
        ListMap listMap = new ListMap();
        if (relationshipRole == null) {
            return listMap;
        }
        ValidationManager.validateRequiredAttribute(relationshipRole.getMultiplicity(), "multiplicity", "ejb-relationship-role", listMap);
        ValidationManager.validateRequiredAttribute(relationshipRole.getRelationshipRoleSource(), "relationship-role-sourcerelationship-role-source", "ejb-relationship-role", listMap);
        if (!relationshipRole.getMultiplicity().equalsIgnoreCase("One") && !relationshipRole.getMultiplicity().equalsIgnoreCase("Many")) {
            String string = relationshipRole.getRoleName();
            if (string == null && relationshipRole.getRelationshipRoleSource() != null) {
                string = relationshipRole.getRelationshipRoleSource().getEjbName();
            }
            Object[] objectArray = new Object[]{string};
            String string2 = ExceptionMessageGenerator.buildMessage(class$oracle$toplink$exceptions$EJBJarXMLException == null ? (class$oracle$toplink$exceptions$EJBJarXMLException = ValidationManager.class$("oracle.toplink.exceptions.EJBJarXMLException")) : class$oracle$toplink$exceptions$EJBJarXMLException, 72015, objectArray);
            EjbJarError ejbJarError = new EjbJarError(string2);
            listMap.put(ejbJarError, (Object)ejbJarError);
        }
        listMap.putAll((Map)ValidationManager.validateRelationRoleSource(relationshipRole.getRelationshipRoleSource()));
        return listMap;
    }

    private static ListMap validateRelationships(Relationships relationships) {
        ListMap listMap = new ListMap();
        if (relationships == null) {
            return listMap;
        }
        ValidationManager.validateRequiredAttribute(relationships.getRelationships(), "method-params", "query-method", listMap);
        listMap.putAll((Map)ValidationManager.validateRelations(relationships.getRelationships()));
        return listMap;
    }

    private static void validateRequiredAttribute(Object object, String string, String string2, ListMap listMap) {
        Object[] objectArray = new Object[]{string, string2};
        if (object == null) {
            String string3 = ExceptionMessageGenerator.buildMessage(class$oracle$toplink$exceptions$EJBJarXMLException == null ? (class$oracle$toplink$exceptions$EJBJarXMLException = ValidationManager.class$("oracle.toplink.exceptions.EJBJarXMLException")) : class$oracle$toplink$exceptions$EJBJarXMLException, 72022, objectArray);
            EjbJarError ejbJarError = new EjbJarError(string3);
            listMap.put(ejbJarError, (Object)ejbJarError);
        } else if (object instanceof String) {
            ValidationManager.validateTextAttribute((String)object, string, string2, listMap);
        }
    }

    private static void validateTextAttribute(String string, String string2, String string3, ListMap listMap) {
        if (string != null && string.length() == 0) {
            Object[] objectArray = new Object[]{string2, string3};
            String string4 = ExceptionMessageGenerator.buildMessage(class$oracle$toplink$exceptions$EJBJarXMLException == null ? (class$oracle$toplink$exceptions$EJBJarXMLException = ValidationManager.class$("oracle.toplink.exceptions.EJBJarXMLException")) : class$oracle$toplink$exceptions$EJBJarXMLException, 72011, objectArray);
            EjbJarError ejbJarError = new EjbJarError(string4);
            listMap.put(ejbJarError, (Object)ejbJarError);
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

