/*
 * Decompiled with CFR 0.152.
 */
package oracle.toplink.tools.ejbjar;

import java.util.Iterator;
import java.util.Vector;
import oracle.toplink.tools.ejbjar.CmpField;
import oracle.toplink.tools.ejbjar.EnterpriseObject;
import oracle.toplink.tools.ejbjar.Query;
import oracle.toplink.tools.ejbjar.SecurityRoleReference;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class Entity
extends EnterpriseObject {
    protected String home;
    protected String remote;
    protected String localHome;
    protected String local;
    protected String persistenceType;
    protected String primaryKeyClass;
    protected boolean reentrant;
    protected String cmpVersion;
    protected String abstractSchemaName;
    protected Vector cmpFields;
    protected String primaryKeyField;
    protected Vector securityRoleReferences;
    protected Vector queries;

    public void addCmpField(String string) {
        if (this.cmpFields == null) {
            this.cmpFields = new Vector();
        }
        this.cmpFields.add(new CmpField(string));
    }

    public void addQuery(Query query) {
        if (this.queries == null) {
            this.queries = new Vector();
        }
        this.queries.add(query);
    }

    public String getAbstractSchemaName() {
        return this.abstractSchemaName;
    }

    public CmpField getCmpFieldNamed(String string) {
        if (this.cmpFields == null) {
            return null;
        }
        Iterator iterator = this.cmpFields.iterator();
        while (iterator.hasNext()) {
            CmpField cmpField = (CmpField)iterator.next();
            if (!string.equals(cmpField.getName())) continue;
            return cmpField;
        }
        return null;
    }

    public Vector getCmpFields() {
        return this.cmpFields;
    }

    public String getCmpVersion() {
        return this.cmpVersion;
    }

    public String getHome() {
        return this.home;
    }

    public String getLocalHome() {
        return this.localHome;
    }

    public String getLocal() {
        return this.local;
    }

    public String getPersistenceType() {
        return this.persistenceType;
    }

    public String getPrimaryKeyClass() {
        return this.primaryKeyClass;
    }

    public String getPrimaryKeyField() {
        return this.primaryKeyField;
    }

    public Vector getQueries() {
        return this.queries;
    }

    public boolean getReentrant() {
        return this.reentrant;
    }

    public String getRemote() {
        return this.remote;
    }

    public String getRemoteHome() {
        return this.getHome();
    }

    public void setRemoteHome(String string) {
        this.setHome(string);
    }

    public Vector getSecurityRoleReferences() {
        return this.securityRoleReferences;
    }

    public boolean isEntity() {
        return true;
    }

    public void setAbstractSchemaName(String string) {
        this.abstractSchemaName = string;
    }

    public void setCmpFields(Vector vector) {
        this.cmpFields = vector;
    }

    public void setCmpVersion(String string) {
        this.cmpVersion = string == null || string.equalsIgnoreCase("2.x") ? "2.x" : (string.equalsIgnoreCase("1.x") ? "1.x" : null);
    }

    public void setHome(String string) {
        this.home = string;
    }

    public void setLocal(String string) {
        this.local = string;
    }

    public void setLocalHome(String string) {
        this.localHome = string;
    }

    public void setPersistenceType(String string) {
        this.persistenceType = string.equalsIgnoreCase("Bean") ? "Bean" : (string.equalsIgnoreCase("Container") ? "Container" : null);
    }

    public void setPrimaryKeyClass(String string) {
        this.primaryKeyClass = string;
    }

    public void setPrimaryKeyField(String string) {
        this.primaryKeyField = string;
    }

    public void setQueries(Vector vector) {
        this.queries = vector;
    }

    public void setReentrant(boolean bl) {
        this.reentrant = bl;
    }

    public void setRemote(String string) {
        this.remote = string;
    }

    public void setSecurityRoleReferences(Vector vector) {
        this.securityRoleReferences = vector;
    }

    public void loadFromElement(Element element) {
        super.loadFromElement(element);
        this.home = this.optionalStringFromElement(element, "home");
        this.remote = this.optionalStringFromElement(element, "remote");
        this.localHome = this.optionalStringFromElement(element, "local-home");
        this.local = this.optionalStringFromElement(element, "local");
        this.setPersistenceType(this.stringFromElement(element, "persistence-type"));
        this.primaryKeyClass = this.stringFromElement(element, "prim-key-class");
        this.reentrant = "True".equalsIgnoreCase(this.stringFromElement(element, "reentrant"));
        this.setCmpVersion(this.optionalStringFromElement(element, "cmp-version"));
        this.abstractSchemaName = this.optionalStringFromElement(element, "abstract-schema-name");
        this.cmpFields = this.optionalObjectsFromElement(element, "cmp-field", new CmpField());
        this.primaryKeyField = this.optionalStringFromElement(element, "primkey-field");
        this.securityRoleReferences = this.optionalObjectsFromElement(element, "security-role-ref", new SecurityRoleReference());
        this.queries = this.optionalObjectsFromElement(element, "query", new Query());
    }

    public Element toElement(Document document) {
        Element element = document.createElement("entity");
        this.inheritedFields(document, element);
        this.optionallyAddText(document, element, "home", this.home);
        this.optionallyAddText(document, element, "remote", this.remote);
        this.optionallyAddText(document, element, "local-home", this.localHome);
        this.optionallyAddText(document, element, "local", this.local);
        this.addText(document, element, "ejb-class", this.ejbClass);
        this.addText(document, element, "persistence-type", this.persistenceType);
        this.addText(document, element, "prim-key-class", this.primaryKeyClass);
        String string = this.reentrant ? "True" : "False";
        String string2 = document.getDocumentElement().getAttribute("xsi:schemaLocation");
        if (string2 != null && !string2.equals("")) {
            string = String.valueOf(this.reentrant);
        }
        element.appendChild(this.createElement(document, "reentrant", string));
        this.optionallyAddText(document, element, "cmp-version", this.cmpVersion);
        this.optionallyAddText(document, element, "abstract-schema-name", this.abstractSchemaName);
        this.optionallyAddCollection(document, element, this.cmpFields);
        this.optionallyAddText(document, element, "primkey-field", this.primaryKeyField);
        this.optionallyAddCollection(document, element, this.envEntries);
        this.optionallyAddCollection(document, element, this.ejbReferences);
        this.optionallyAddCollection(document, element, this.ejbLocalReferences);
        this.optionallyAddCollection(document, element, this.securityRoleReferences);
        if (this.securityIdentity != null) {
            element.appendChild(this.securityIdentity.toElement(document));
        }
        this.optionallyAddCollection(document, element, this.resourceReferences);
        this.optionallyAddCollection(document, element, this.resourceEnvReferences);
        this.optionallyAddCollection(document, element, this.queries);
        return element;
    }

    public boolean isUnknownPkClassDefined() {
        return this.primaryKeyClass.equals("java.lang.Object");
    }
}

