/*
 * Decompiled with CFR 0.152.
 */
package oracle.toplink.tools.codegen;

import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.Vector;
import oracle.toplink.internal.helper.Helper;
import oracle.toplink.internal.helper.TOPComparison;
import oracle.toplink.internal.helper.TOPSort;
import oracle.toplink.tools.codegen.AttributeDefinition;
import oracle.toplink.tools.codegen.CodeDefinition;
import oracle.toplink.tools.codegen.CodeGenerator;
import oracle.toplink.tools.codegen.MethodDefinition;

public class ClassDefinition
extends CodeDefinition {
    protected String packageName = "";
    protected Vector imports = new Vector(3);
    protected int type = 1;
    public static final int CLASS_TYPE = 1;
    public static final int INTERFACE_TYPE = 2;
    protected String superClass;
    protected Vector interfaces = new Vector(3);
    protected Vector attributes = new Vector();
    protected Vector methods = new Vector();
    protected Vector innerClasses = new Vector(3);

    public void addAttribute(AttributeDefinition attributeDefinition) {
        this.getAttributes().addElement(attributeDefinition);
    }

    public void addImport(String string) {
        if (!this.getImports().contains(string)) {
            this.getImports().addElement(string);
        }
    }

    private void addImports(Map map) {
        Iterator iterator = map.keySet().iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            Set set = (Set)map.get(string);
            if (set.size() > 1) continue;
            Iterator iterator2 = ((Set)map.get(string)).iterator();
            while (iterator2.hasNext()) {
                String string2 = (String)iterator2.next();
                if (string2.equals("java.lang") || string2.equals(this.getPackageName()) || string2.equals("")) continue;
                this.addImport(string2 + "." + string);
            }
        }
        this.sortImports();
    }

    public void addInnerClass(ClassDefinition classDefinition) {
        this.getInnerClasses().add(classDefinition);
    }

    public void addInterface(String string) {
        this.getInterfaces().addElement(string);
    }

    public void addMethod(MethodDefinition methodDefinition) {
        this.getMethods().addElement(methodDefinition);
    }

    private void addTypeNamesToMap(HashMap hashMap) {
        ClassDefinition.putTypeNameInMap(this.getSuperClass(), hashMap);
        Iterator iterator = this.getInterfaces().iterator();
        while (iterator.hasNext()) {
            ClassDefinition.putTypeNameInMap((String)iterator.next(), hashMap);
        }
        iterator = this.getAttributes().iterator();
        while (iterator.hasNext()) {
            ((AttributeDefinition)iterator.next()).putTypeNamesInMap(hashMap);
        }
        iterator = this.getMethods().iterator();
        while (iterator.hasNext()) {
            ((MethodDefinition)iterator.next()).putTypeNamesInMap(hashMap);
        }
    }

    private void adjustTypeNames(HashMap hashMap) {
        this.setSuperClass(ClassDefinition.adjustTypeName(this.getSuperClass(), hashMap));
        Iterator iterator = new Vector(this.getInterfaces()).iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            this.replaceInterface(string, ClassDefinition.adjustTypeName(string, hashMap));
        }
        iterator = this.getAttributes().iterator();
        while (iterator.hasNext()) {
            ((AttributeDefinition)iterator.next()).adjustTypeNames(hashMap);
        }
        iterator = this.getMethods().iterator();
        while (iterator.hasNext()) {
            ((MethodDefinition)iterator.next()).adjustTypeNames(hashMap);
        }
    }

    public void calculateImports() {
        HashMap hashMap = new HashMap();
        this.addTypeNamesToMap(hashMap);
        this.adjustTypeNames(hashMap);
        this.addImports(hashMap);
    }

    public boolean containsMethod(MethodDefinition methodDefinition) {
        return this.getMethods().contains(methodDefinition);
    }

    protected Vector getAttributes() {
        return this.attributes;
    }

    protected Vector getImports() {
        return this.imports;
    }

    protected Vector getInnerClasses() {
        return this.innerClasses;
    }

    protected Vector getInterfaces() {
        return this.interfaces;
    }

    protected Vector getMethods() {
        return this.methods;
    }

    public String getPackageName() {
        return this.packageName;
    }

    public String getSuperClass() {
        return this.superClass;
    }

    public int getType() {
        return this.type;
    }

    public boolean isInterface() {
        return this.getType() == 2;
    }

    protected void replaceInterface(String string, String string2) {
        if (!string.equals(string2)) {
            this.interfaces.remove(string);
            this.interfaces.add(string2);
        }
    }

    private void setImports(Vector vector) {
        this.imports = vector;
    }

    private void setMethods(Vector vector) {
        this.methods = vector;
    }

    public void setPackageName(String string) {
        this.packageName = string;
    }

    public void setSuperClass(String string) {
        this.superClass = string;
    }

    public void setType(int n) {
        this.type = n;
    }

    protected void sortImports() {
        this.setImports(new Vector(new TreeSet(this.getImports())));
    }

    protected void sortMethods() {
        Object[] objectArray = Helper.arrayFromVector(this.getMethods());
        TOPComparison tOPComparison = new TOPComparison(){

            public int compare(Object object, Object object2) {
                if (((MethodDefinition)object).isConstructor()) {
                    return -1;
                }
                if (((MethodDefinition)object2).isConstructor()) {
                    return 1;
                }
                return ((MethodDefinition)object).getName().compareTo(((MethodDefinition)object2).getName());
            }
        };
        TOPSort.quicksort(objectArray, tOPComparison);
        Vector<Object> vector = new Vector<Object>(this.getMethods().size());
        for (int i = 0; i < objectArray.length; ++i) {
            vector.addElement(objectArray[i]);
        }
        this.setMethods(vector);
    }

    public void write(CodeGenerator codeGenerator) {
        if (this.getPackageName().length() > 0) {
            codeGenerator.write("package ");
            codeGenerator.write(this.getPackageName());
            codeGenerator.writeln(";");
            codeGenerator.cr();
        }
        Enumeration enumeration = this.getImports().elements();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            codeGenerator.write("import ");
            codeGenerator.write(string);
            codeGenerator.writeln(";");
        }
        if (!this.getImports().isEmpty()) {
            codeGenerator.cr();
        }
        super.write(codeGenerator);
    }

    public void writeBody(CodeGenerator codeGenerator) {
        this.sortMethods();
        if (this.isInterface()) {
            codeGenerator.write("interface ");
        } else {
            codeGenerator.write("class ");
        }
        codeGenerator.write(this.getName());
        if (!this.isInterface() && this.getSuperClass() != null) {
            codeGenerator.write(" extends ");
            codeGenerator.writeType(this.getSuperClass());
        }
        boolean bl = true;
        Enumeration enumeration = this.getInterfaces().elements();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            if (bl) {
                if (this.isInterface()) {
                    codeGenerator.write(" extends");
                } else {
                    codeGenerator.write(" implements");
                }
                bl = false;
            } else {
                codeGenerator.write(",");
            }
            codeGenerator.write(" ");
            codeGenerator.write(string);
        }
        codeGenerator.writeln(" {");
        codeGenerator.cr();
        enumeration = this.getAttributes().elements();
        while (enumeration.hasMoreElements()) {
            codeGenerator.tab();
            ((AttributeDefinition)enumeration.nextElement()).write(codeGenerator);
            codeGenerator.cr();
        }
        if (!this.getAttributes().isEmpty()) {
            codeGenerator.cr();
        }
        enumeration = this.getMethods().elements();
        while (enumeration.hasMoreElements()) {
            ((MethodDefinition)enumeration.nextElement()).write(codeGenerator);
            codeGenerator.cr();
            codeGenerator.cr();
        }
        enumeration = this.getInnerClasses().elements();
        while (enumeration.hasMoreElements()) {
            ((ClassDefinition)enumeration.nextElement()).write(codeGenerator);
            codeGenerator.cr();
            codeGenerator.cr();
        }
        codeGenerator.writeln("}");
    }
}

