/*
 * Decompiled with CFR 0.152.
 */
package oracle.toplink.tools.codegen;

import oracle.toplink.tools.codegen.CodeGenerator;

public class AccessLevel {
    protected int level;
    public static int PUBLIC = 1;
    public static int PROTECTED = 2;
    public static int PACKAGE = 3;
    public static int PRIVATE = 4;
    protected boolean isAbstract;
    protected boolean isFinal;
    protected boolean isNative;
    protected boolean isStatic;
    protected boolean isSynchronized;
    protected boolean isTransient;
    protected boolean isVolatile;

    public AccessLevel() {
        this.level = PUBLIC;
        this.isStatic = false;
        this.isFinal = false;
        this.isTransient = false;
    }

    public AccessLevel(int n) {
        this.level = n;
        this.isStatic = false;
        this.isFinal = false;
        this.isTransient = false;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof AccessLevel)) {
            return false;
        }
        AccessLevel accessLevel = (AccessLevel)object;
        return this.level == accessLevel.level && this.isStatic == accessLevel.isStatic && this.isFinal == accessLevel.isFinal && this.isTransient == accessLevel.isTransient;
    }

    public int getLevel() {
        return this.level;
    }

    public boolean isAbstract() {
        return this.isAbstract;
    }

    public boolean isFinal() {
        return this.isFinal;
    }

    public boolean isNative() {
        return this.isNative;
    }

    public boolean isStatic() {
        return this.isStatic;
    }

    public boolean isSynchronized() {
        return this.isSynchronized;
    }

    public boolean isTransient() {
        return this.isTransient;
    }

    public boolean isVolatile() {
        return this.isVolatile;
    }

    public void setIsAbstract(boolean bl) {
        this.isAbstract = bl;
    }

    public void setIsFinal(boolean bl) {
        this.isFinal = bl;
    }

    public void setIsNative(boolean bl) {
        this.isNative = bl;
    }

    public void setIsStatic(boolean bl) {
        this.isStatic = bl;
    }

    public void setIsSynchronized(boolean bl) {
        this.isSynchronized = bl;
    }

    public void setIsTransient(boolean bl) {
        this.isTransient = bl;
    }

    public void setIsVolatile(boolean bl) {
        this.isVolatile = bl;
    }

    public void setLevel(int n) {
        this.level = n;
    }

    public void write(CodeGenerator codeGenerator) {
        boolean bl = true;
        if (this.getLevel() == PUBLIC) {
            codeGenerator.write("public");
        } else if (this.getLevel() == PROTECTED) {
            codeGenerator.write("protected");
        } else if (this.getLevel() == PACKAGE) {
            bl = false;
        } else if (this.getLevel() == PRIVATE) {
            codeGenerator.write("private");
        }
        if (this.isAbstract()) {
            if (bl) {
                codeGenerator.write(" ");
            }
            codeGenerator.write("abstract");
            bl = true;
        }
        if (this.isStatic()) {
            if (bl) {
                codeGenerator.write(" ");
            }
            codeGenerator.write("static");
            bl = true;
        }
        if (this.isFinal()) {
            if (bl) {
                codeGenerator.write(" ");
            }
            codeGenerator.write("final");
            bl = true;
        }
        if (this.isTransient()) {
            if (bl) {
                codeGenerator.write(" ");
            }
            codeGenerator.write("transient");
            bl = true;
        }
        if (this.isVolatile()) {
            if (bl) {
                codeGenerator.write(" ");
            }
            codeGenerator.write("volatile");
            bl = true;
        }
        if (this.isNative()) {
            if (bl) {
                codeGenerator.write(" ");
            }
            codeGenerator.write("native");
            bl = true;
        }
        if (this.isSynchronized()) {
            if (bl) {
                codeGenerator.write(" ");
            }
            codeGenerator.write("synchronized");
            bl = true;
        }
    }
}

