/*
 * Decompiled with CFR 0.152.
 */
package oracle.toplink.threetier;

import java.util.Enumeration;
import java.util.Vector;
import oracle.toplink.exceptions.ConcurrencyException;
import oracle.toplink.exceptions.DatabaseException;
import oracle.toplink.internal.databaseaccess.Accessor;
import oracle.toplink.internal.helper.Helper;
import oracle.toplink.internal.localization.ToStringLocalization;
import oracle.toplink.sessions.Login;
import oracle.toplink.threetier.ServerSession;

public class ConnectionPool {
    protected boolean isConnected;
    protected int maxNumberOfConnections;
    protected int minNumberOfConnections;
    protected Vector connectionsAvailable;
    protected Vector connectionsUsed;
    protected Login login;
    protected String name;
    protected ServerSession owner;

    public ConnectionPool() {
        this.maxNumberOfConnections = 50;
        this.minNumberOfConnections = 3;
        this.resetConnections();
    }

    public ConnectionPool(String string, Login login, int n, int n2, ServerSession serverSession) {
        this.login = login;
        this.owner = serverSession;
        this.name = string;
        this.maxNumberOfConnections = n2;
        this.minNumberOfConnections = n;
        this.resetConnections();
    }

    public synchronized Accessor acquireConnection() throws ConcurrencyException {
        while (!this.hasConnectionAvailable()) {
            if (this.getTotalNumberOfConnections() < this.getMaxNumberOfConnections()) {
                Accessor accessor = this.buildConnection();
                this.getConnectionsUsed().addElement(accessor);
                return accessor;
            }
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {
                throw ConcurrencyException.waitFailureOnClientSession(interruptedException);
            }
        }
        Accessor accessor = (Accessor)this.getConnectionsAvailable().firstElement();
        this.getConnectionsAvailable().removeElement(accessor);
        this.getConnectionsUsed().addElement(accessor);
        this.getOwner().updateProfile(this.getName(), new Integer(this.getConnectionsUsed().size()));
        return accessor;
    }

    protected Accessor buildConnection() {
        Login login = (Login)this.getLogin().clone();
        Accessor accessor = login.buildAccessor();
        accessor.connect(login, this.getOwner());
        return accessor;
    }

    public Vector getConnectionsAvailable() {
        return this.connectionsAvailable;
    }

    protected Vector getConnectionsUsed() {
        return this.connectionsUsed;
    }

    public Login getLogin() {
        return this.login;
    }

    public int getMaxNumberOfConnections() {
        return this.maxNumberOfConnections;
    }

    public int getMinNumberOfConnections() {
        return this.minNumberOfConnections;
    }

    public String getName() {
        return this.name;
    }

    protected ServerSession getOwner() {
        return this.owner;
    }

    public int getTotalNumberOfConnections() {
        return this.getConnectionsUsed().size() + this.getConnectionsAvailable().size();
    }

    public boolean hasConnectionAvailable() {
        return !this.getConnectionsAvailable().isEmpty();
    }

    public boolean isConnected() {
        return this.isConnected;
    }

    public boolean isThereConflictBetweenLoginAndType() {
        return this.getLogin().shouldUseExternalConnectionPooling();
    }

    public synchronized void releaseConnection(Accessor accessor) throws DatabaseException {
        this.getConnectionsUsed().removeElement(accessor);
        if (this.getTotalNumberOfConnections() < this.getMinNumberOfConnections()) {
            this.getConnectionsAvailable().addElement(accessor);
        } else {
            accessor.disconnect(this.getOwner());
        }
        this.notify();
    }

    public void resetConnections() {
        this.connectionsUsed = new Vector();
        this.connectionsAvailable = new Vector();
    }

    protected void setConnectionsAvailable(Vector vector) {
        this.connectionsAvailable = vector;
    }

    protected void setConnectionsUsed(Vector vector) {
        this.connectionsUsed = vector;
    }

    public void setIsConnected(boolean bl) {
        this.isConnected = bl;
    }

    public void setLogin(Login login) {
        this.login = login;
    }

    public void setMaxNumberOfConnections(int n) {
        this.maxNumberOfConnections = n;
    }

    public void setMinNumberOfConnections(int n) {
        this.minNumberOfConnections = n;
    }

    public void setName(String string) {
        this.name = string;
    }

    protected void setOwner(ServerSession serverSession) {
        this.owner = serverSession;
    }

    public synchronized void shutDown() {
        this.setIsConnected(false);
        Enumeration enumeration = this.getConnectionsAvailable().elements();
        while (enumeration.hasMoreElements()) {
            try {
                ((Accessor)enumeration.nextElement()).disconnect(this.getOwner());
            }
            catch (DatabaseException databaseException) {}
        }
        enumeration = this.getConnectionsUsed().elements();
        while (enumeration.hasMoreElements()) {
            try {
                ((Accessor)enumeration.nextElement()).disconnect(this.getOwner());
            }
            catch (DatabaseException databaseException) {}
        }
        this.resetConnections();
    }

    public synchronized void startUp() {
        for (int i = this.getMinNumberOfConnections(); i > 0; --i) {
            this.getConnectionsAvailable().addElement(this.buildConnection());
        }
        this.setIsConnected(true);
    }

    public String toString() {
        Object[] objectArray = new Object[]{new Integer(this.getMinNumberOfConnections()), new Integer(this.getMaxNumberOfConnections())};
        return Helper.getShortClassName(this.getClass()) + ToStringLocalization.buildMessage("min_max", objectArray);
    }
}

