/*
 * Decompiled with CFR 0.152.
 */
package oracle.toplink.sessions;

import java.io.Serializable;
import java.util.Enumeration;
import java.util.Vector;
import oracle.toplink.internal.databaseaccess.Accessor;
import oracle.toplink.internal.databaseaccess.DatabaseCall;
import oracle.toplink.internal.databaseaccess.DatasourceCall;
import oracle.toplink.internal.helper.NonSynchronizedVector;
import oracle.toplink.internal.sessions.UnitOfWorkChangeSet;
import oracle.toplink.publicinterface.DatabaseRow;
import oracle.toplink.queryframework.DatabaseQuery;
import oracle.toplink.queryframework.ModifyQuery;
import oracle.toplink.sessions.Session;
import oracle.toplink.sessions.SessionEvent;
import oracle.toplink.sessions.SessionEventListener;
import oracle.toplink.threetier.ClientSession;

public class SessionEventManager
implements Cloneable,
Serializable {
    protected Vector listeners;
    protected Session session;

    public SessionEventManager() {
    }

    public SessionEventManager(Session session) {
        this.session = session;
    }

    public void addListener(SessionEventListener sessionEventListener) {
        this.getListeners().addElement(sessionEventListener);
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (Exception exception) {
            return null;
        }
    }

    public SessionEventManager clone(Session session) {
        SessionEventManager sessionEventManager = (SessionEventManager)this.clone();
        sessionEventManager.setSession(session);
        if (this.listeners != null) {
            sessionEventManager.setListeners((Vector)this.getListeners().clone());
        }
        return sessionEventManager;
    }

    public Vector getListeners() {
        if (this.listeners == null) {
            this.listeners = NonSynchronizedVector.newInstance();
        }
        return this.listeners;
    }

    public Session getSession() {
        return this.session;
    }

    public boolean hasListeners() {
        return this.listeners != null && !this.listeners.isEmpty();
    }

    public void missingDescriptor(Class clazz) {
        if (!this.hasListeners()) {
            return;
        }
        this.startOperationProfile();
        SessionEvent sessionEvent = new SessionEvent(32, this.getSession());
        sessionEvent.setResult(clazz);
        Enumeration enumeration = this.getListeners().elements();
        while (enumeration.hasMoreElements()) {
            ((SessionEventListener)enumeration.nextElement()).missingDescriptor(sessionEvent);
        }
        this.endOperationProfile();
    }

    public void moreRowsDetected(DatabaseCall databaseCall) {
        if (!this.hasListeners()) {
            return;
        }
        this.startOperationProfile();
        SessionEvent sessionEvent = new SessionEvent(20, this.getSession());
        sessionEvent.setResult(databaseCall);
        Enumeration enumeration = this.getListeners().elements();
        while (enumeration.hasMoreElements()) {
            ((SessionEventListener)enumeration.nextElement()).moreRowsDetected(sessionEvent);
        }
        this.endOperationProfile();
    }

    public void noRowsModified(ModifyQuery modifyQuery, Object object) {
        if (!this.hasListeners()) {
            return;
        }
        this.startOperationProfile();
        SessionEvent sessionEvent = new SessionEvent(35, this.getSession());
        sessionEvent.setQuery(modifyQuery);
        sessionEvent.setResult(object);
        Enumeration enumeration = this.getListeners().elements();
        while (enumeration.hasMoreElements()) {
            ((SessionEventListener)enumeration.nextElement()).noRowsModified(sessionEvent);
        }
        this.endOperationProfile();
    }

    public void outputParametersDetected(DatabaseRow databaseRow, DatasourceCall datasourceCall) {
        if (!this.hasListeners()) {
            return;
        }
        this.startOperationProfile();
        SessionEvent sessionEvent = new SessionEvent(19, this.getSession());
        sessionEvent.setResult(databaseRow);
        sessionEvent.setProperty("call", datasourceCall);
        sessionEvent.setQuery(datasourceCall.getQuery());
        Enumeration enumeration = this.getListeners().elements();
        while (enumeration.hasMoreElements()) {
            ((SessionEventListener)enumeration.nextElement()).outputParametersDetected(sessionEvent);
        }
        this.endOperationProfile();
    }

    public void postAcquireClientSession() {
        if (!this.hasListeners()) {
            return;
        }
        this.startOperationProfile();
        SessionEvent sessionEvent = new SessionEvent(16, this.getSession());
        Enumeration enumeration = this.getListeners().elements();
        while (enumeration.hasMoreElements()) {
            ((SessionEventListener)enumeration.nextElement()).postAcquireClientSession(sessionEvent);
        }
        this.endOperationProfile();
    }

    public void postAcquireConnection(Accessor accessor) {
        if (!this.hasListeners()) {
            return;
        }
        this.startOperationProfile();
        SessionEvent sessionEvent = new SessionEvent(22, this.getSession());
        sessionEvent.setResult(accessor);
        Enumeration enumeration = this.getListeners().elements();
        while (enumeration.hasMoreElements()) {
            ((SessionEventListener)enumeration.nextElement()).postAcquireConnection(sessionEvent);
        }
        this.endOperationProfile();
    }

    public void postAcquireExclusiveConnection(ClientSession clientSession, Accessor accessor) {
        if (!this.hasListeners()) {
            return;
        }
        SessionEvent sessionEvent = new SessionEvent(33, clientSession);
        sessionEvent.setResult(accessor);
        Enumeration enumeration = this.getListeners().elements();
        while (enumeration.hasMoreElements()) {
            ((SessionEventListener)enumeration.nextElement()).postAcquireExclusiveConnection(sessionEvent);
        }
    }

    public void postAcquireUnitOfWork() {
        if (!this.hasListeners()) {
            return;
        }
        this.startOperationProfile();
        SessionEvent sessionEvent = new SessionEvent(9, this.getSession());
        Enumeration enumeration = this.getListeners().elements();
        while (enumeration.hasMoreElements()) {
            ((SessionEventListener)enumeration.nextElement()).postAcquireUnitOfWork(sessionEvent);
        }
        this.endOperationProfile();
    }

    public void postBeginTransaction() {
        if (!this.hasListeners()) {
            return;
        }
        this.startOperationProfile();
        SessionEvent sessionEvent = new SessionEvent(4, this.getSession());
        Enumeration enumeration = this.getListeners().elements();
        while (enumeration.hasMoreElements()) {
            ((SessionEventListener)enumeration.nextElement()).postBeginTransaction(sessionEvent);
        }
        this.endOperationProfile();
    }

    public void postCommitTransaction() {
        if (!this.hasListeners()) {
            return;
        }
        this.startOperationProfile();
        SessionEvent sessionEvent = new SessionEvent(6, this.getSession());
        Enumeration enumeration = this.getListeners().elements();
        while (enumeration.hasMoreElements()) {
            ((SessionEventListener)enumeration.nextElement()).postCommitTransaction(sessionEvent);
        }
        this.endOperationProfile();
    }

    public void postCommitUnitOfWork() {
        if (!this.hasListeners()) {
            return;
        }
        this.startOperationProfile();
        SessionEvent sessionEvent = new SessionEvent(11, this.getSession());
        Enumeration enumeration = this.getListeners().elements();
        while (enumeration.hasMoreElements()) {
            ((SessionEventListener)enumeration.nextElement()).postCommitUnitOfWork(sessionEvent);
        }
        this.endOperationProfile();
    }

    public void postConnect(Accessor accessor) {
        if (!this.hasListeners()) {
            return;
        }
        this.startOperationProfile();
        SessionEvent sessionEvent = new SessionEvent(21, this.getSession());
        sessionEvent.setResult(accessor);
        Enumeration enumeration = this.getListeners().elements();
        while (enumeration.hasMoreElements()) {
            ((SessionEventListener)enumeration.nextElement()).postConnect(sessionEvent);
        }
        this.endOperationProfile();
    }

    public void postExecuteQuery(DatabaseQuery databaseQuery, Object object) {
        if (!this.hasListeners()) {
            return;
        }
        this.startOperationProfile();
        SessionEvent sessionEvent = new SessionEvent(2, this.getSession());
        sessionEvent.setQuery(databaseQuery);
        sessionEvent.setResult(object);
        Enumeration enumeration = this.getListeners().elements();
        while (enumeration.hasMoreElements()) {
            ((SessionEventListener)enumeration.nextElement()).postExecuteQuery(sessionEvent);
        }
        this.endOperationProfile();
    }

    public void postReleaseClientSession() {
        if (!this.hasListeners()) {
            return;
        }
        this.startOperationProfile();
        SessionEvent sessionEvent = new SessionEvent(18, this.getSession());
        Enumeration enumeration = this.getListeners().elements();
        while (enumeration.hasMoreElements()) {
            ((SessionEventListener)enumeration.nextElement()).postReleaseClientSession(sessionEvent);
        }
        this.endOperationProfile();
    }

    public void postReleaseUnitOfWork() {
        if (!this.hasListeners()) {
            return;
        }
        this.startOperationProfile();
        SessionEvent sessionEvent = new SessionEvent(13, this.getSession());
        Enumeration enumeration = this.getListeners().elements();
        while (enumeration.hasMoreElements()) {
            ((SessionEventListener)enumeration.nextElement()).postReleaseUnitOfWork(sessionEvent);
        }
        this.endOperationProfile();
    }

    public void postResumeUnitOfWork() {
        if (!this.hasListeners()) {
            return;
        }
        this.startOperationProfile();
        SessionEvent sessionEvent = new SessionEvent(15, this.getSession());
        Enumeration enumeration = this.getListeners().elements();
        while (enumeration.hasMoreElements()) {
            ((SessionEventListener)enumeration.nextElement()).postResumeUnitOfWork(sessionEvent);
        }
        this.endOperationProfile();
    }

    public void postRollbackTransaction() {
        if (!this.hasListeners()) {
            return;
        }
        this.startOperationProfile();
        SessionEvent sessionEvent = new SessionEvent(8, this.getSession());
        Enumeration enumeration = this.getListeners().elements();
        while (enumeration.hasMoreElements()) {
            ((SessionEventListener)enumeration.nextElement()).postRollbackTransaction(sessionEvent);
        }
        this.endOperationProfile();
    }

    public void postDistributedMergeUnitOfWorkChangeSet(UnitOfWorkChangeSet unitOfWorkChangeSet) {
        if (!this.hasListeners()) {
            return;
        }
        this.startOperationProfile();
        SessionEvent sessionEvent = new SessionEvent(29, this.getSession());
        sessionEvent.setProperty("UnitOfWorkChangeSet", unitOfWorkChangeSet);
        Enumeration enumeration = this.getListeners().elements();
        while (enumeration.hasMoreElements()) {
            ((SessionEventListener)enumeration.nextElement()).postDistributedMergeUnitOfWorkChangeSet(sessionEvent);
        }
        this.endOperationProfile();
    }

    public void postMergeUnitOfWorkChangeSet(UnitOfWorkChangeSet unitOfWorkChangeSet) {
        if (!this.hasListeners()) {
            return;
        }
        this.startOperationProfile();
        SessionEvent sessionEvent = new SessionEvent(28, this.getSession());
        sessionEvent.setProperty("UnitOfWorkChangeSet", unitOfWorkChangeSet);
        Enumeration enumeration = this.getListeners().elements();
        while (enumeration.hasMoreElements()) {
            ((SessionEventListener)enumeration.nextElement()).postMergeUnitOfWorkChangeSet(sessionEvent);
        }
        this.endOperationProfile();
    }

    public void preBeginTransaction() {
        if (!this.hasListeners()) {
            return;
        }
        this.startOperationProfile();
        SessionEvent sessionEvent = new SessionEvent(3, this.getSession());
        Enumeration enumeration = this.getListeners().elements();
        while (enumeration.hasMoreElements()) {
            ((SessionEventListener)enumeration.nextElement()).preBeginTransaction(sessionEvent);
        }
        this.endOperationProfile();
    }

    public void preCalculateUnitOfWorkChangeSet() {
        if (!this.hasListeners()) {
            return;
        }
        this.startOperationProfile();
        SessionEvent sessionEvent = new SessionEvent(30, this.getSession());
        Enumeration enumeration = this.getListeners().elements();
        while (enumeration.hasMoreElements()) {
            ((SessionEventListener)enumeration.nextElement()).preCalculateUnitOfWorkChangeSet(sessionEvent);
        }
        this.endOperationProfile();
    }

    public void postCalculateUnitOfWorkChangeSet(UnitOfWorkChangeSet unitOfWorkChangeSet) {
        if (!this.hasListeners()) {
            return;
        }
        this.startOperationProfile();
        SessionEvent sessionEvent = new SessionEvent(31, this.getSession());
        sessionEvent.setProperty("UnitOfWorkChangeSet", unitOfWorkChangeSet);
        Enumeration enumeration = this.getListeners().elements();
        while (enumeration.hasMoreElements()) {
            ((SessionEventListener)enumeration.nextElement()).postCalculateUnitOfWorkChangeSet(sessionEvent);
        }
        this.endOperationProfile();
    }

    public void preCommitTransaction() {
        if (!this.hasListeners()) {
            return;
        }
        this.startOperationProfile();
        SessionEvent sessionEvent = new SessionEvent(5, this.getSession());
        Enumeration enumeration = this.getListeners().elements();
        while (enumeration.hasMoreElements()) {
            ((SessionEventListener)enumeration.nextElement()).preCommitTransaction(sessionEvent);
        }
        this.endOperationProfile();
    }

    public void preCommitUnitOfWork() {
        if (!this.hasListeners()) {
            return;
        }
        this.startOperationProfile();
        SessionEvent sessionEvent = new SessionEvent(10, this.getSession());
        Enumeration enumeration = this.getListeners().elements();
        while (enumeration.hasMoreElements()) {
            ((SessionEventListener)enumeration.nextElement()).preCommitUnitOfWork(sessionEvent);
        }
        this.endOperationProfile();
    }

    public void preExecuteQuery(DatabaseQuery databaseQuery) {
        if (!this.hasListeners()) {
            return;
        }
        this.startOperationProfile();
        SessionEvent sessionEvent = new SessionEvent(1, this.getSession());
        sessionEvent.setQuery(databaseQuery);
        Enumeration enumeration = this.getListeners().elements();
        while (enumeration.hasMoreElements()) {
            ((SessionEventListener)enumeration.nextElement()).preExecuteQuery(sessionEvent);
        }
        this.endOperationProfile();
    }

    public void preLogin(Session session) {
        if (!this.hasListeners()) {
            return;
        }
        this.startOperationProfile();
        SessionEvent sessionEvent = new SessionEvent(24, session);
        Enumeration enumeration = this.getListeners().elements();
        while (enumeration.hasMoreElements()) {
            ((SessionEventListener)enumeration.nextElement()).preLogin(sessionEvent);
        }
        this.endOperationProfile();
    }

    public void postLogin(Session session) {
        if (!this.hasListeners()) {
            return;
        }
        this.startOperationProfile();
        SessionEvent sessionEvent = new SessionEvent(25, session);
        Enumeration enumeration = this.getListeners().elements();
        while (enumeration.hasMoreElements()) {
            ((SessionEventListener)enumeration.nextElement()).postLogin(sessionEvent);
        }
        this.endOperationProfile();
    }

    public void prepareUnitOfWork() {
        if (!this.hasListeners()) {
            return;
        }
        this.startOperationProfile();
        SessionEvent sessionEvent = new SessionEvent(14, this.getSession());
        Enumeration enumeration = this.getListeners().elements();
        while (enumeration.hasMoreElements()) {
            ((SessionEventListener)enumeration.nextElement()).prepareUnitOfWork(sessionEvent);
        }
        this.endOperationProfile();
    }

    public void preReleaseClientSession() {
        if (!this.hasListeners()) {
            return;
        }
        this.startOperationProfile();
        SessionEvent sessionEvent = new SessionEvent(17, this.getSession());
        Enumeration enumeration = this.getListeners().elements();
        while (enumeration.hasMoreElements()) {
            ((SessionEventListener)enumeration.nextElement()).preReleaseClientSession(sessionEvent);
        }
        this.endOperationProfile();
    }

    public void preReleaseConnection(Accessor accessor) {
        if (!this.hasListeners()) {
            return;
        }
        this.startOperationProfile();
        SessionEvent sessionEvent = new SessionEvent(23, this.getSession());
        sessionEvent.setResult(accessor);
        Enumeration enumeration = this.getListeners().elements();
        while (enumeration.hasMoreElements()) {
            ((SessionEventListener)enumeration.nextElement()).preReleaseConnection(sessionEvent);
        }
        this.endOperationProfile();
    }

    public void preReleaseExclusiveConnection(ClientSession clientSession, Accessor accessor) {
        if (!this.hasListeners()) {
            return;
        }
        SessionEvent sessionEvent = new SessionEvent(34, clientSession);
        sessionEvent.setResult(accessor);
        Enumeration enumeration = this.getListeners().elements();
        while (enumeration.hasMoreElements()) {
            ((SessionEventListener)enumeration.nextElement()).preReleaseExclusiveConnection(sessionEvent);
        }
    }

    public void preReleaseUnitOfWork() {
        if (!this.hasListeners()) {
            return;
        }
        this.startOperationProfile();
        SessionEvent sessionEvent = new SessionEvent(12, this.getSession());
        Enumeration enumeration = this.getListeners().elements();
        while (enumeration.hasMoreElements()) {
            ((SessionEventListener)enumeration.nextElement()).preReleaseUnitOfWork(sessionEvent);
        }
        this.endOperationProfile();
    }

    public void preRollbackTransaction() {
        if (!this.hasListeners()) {
            return;
        }
        this.startOperationProfile();
        SessionEvent sessionEvent = new SessionEvent(7, this.getSession());
        Enumeration enumeration = this.getListeners().elements();
        while (enumeration.hasMoreElements()) {
            ((SessionEventListener)enumeration.nextElement()).preRollbackTransaction(sessionEvent);
        }
        this.endOperationProfile();
    }

    public void preDistributedMergeUnitOfWorkChangeSet(UnitOfWorkChangeSet unitOfWorkChangeSet) {
        if (!this.hasListeners()) {
            return;
        }
        this.startOperationProfile();
        SessionEvent sessionEvent = new SessionEvent(27, this.getSession());
        sessionEvent.setProperty("UnitOfWorkChangeSet", unitOfWorkChangeSet);
        Enumeration enumeration = this.getListeners().elements();
        while (enumeration.hasMoreElements()) {
            ((SessionEventListener)enumeration.nextElement()).preDistributedMergeUnitOfWorkChangeSet(sessionEvent);
        }
        this.endOperationProfile();
    }

    public void preMergeUnitOfWorkChangeSet(UnitOfWorkChangeSet unitOfWorkChangeSet) {
        if (!this.hasListeners()) {
            return;
        }
        this.startOperationProfile();
        SessionEvent sessionEvent = new SessionEvent(26, this.getSession());
        sessionEvent.setProperty("UnitOfWorkChangeSet", unitOfWorkChangeSet);
        Enumeration enumeration = this.getListeners().elements();
        while (enumeration.hasMoreElements()) {
            ((SessionEventListener)enumeration.nextElement()).preMergeUnitOfWorkChangeSet(sessionEvent);
        }
        this.endOperationProfile();
    }

    public void removeListener(SessionEventListener sessionEventListener) {
        this.getListeners().removeElement(sessionEventListener);
    }

    protected void setListeners(Vector vector) {
        this.listeners = vector;
    }

    public void setSession(Session session) {
        this.session = session;
    }

    protected void startOperationProfile() {
        if (this.getSession().isInProfile()) {
            this.getSession().getProfiler().startOperationProfile("SessionEvents");
        }
    }

    protected void endOperationProfile() {
        if (this.getSession().isInProfile()) {
            this.getSession().getProfiler().endOperationProfile("SessionEvents");
        }
    }
}

