/*
 * Decompiled with CFR 0.152.
 */
package oracle.toplink.sessions;

import java.io.Serializable;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Vector;
import oracle.toplink.descriptors.ClassDescriptor;
import oracle.toplink.exceptions.ValidationException;
import oracle.toplink.internal.helper.Helper;
import oracle.toplink.internal.helper.NonSynchronizedVector;
import oracle.toplink.internal.sessions.DatabaseSessionImpl;
import oracle.toplink.publicinterface.Descriptor;
import oracle.toplink.sessions.DatabaseLogin;
import oracle.toplink.sessions.DatabaseSession;
import oracle.toplink.sessions.Login;
import oracle.toplink.threetier.ConnectionPolicy;
import oracle.toplink.threetier.Server;
import oracle.toplink.threetier.ServerSession;

public class Project
implements Serializable,
Cloneable {
    protected String name = "";
    protected Login datasourceLogin;
    protected Map descriptors = new HashMap();
    protected Vector orderedDescriptors;
    protected boolean useNativeSequencing;
    protected String sequenceTableName;
    protected Integer sequencePreallocationSize;
    protected String sequenceFieldName;
    protected String sequenceCounterName;
    protected Vector defaultReadOnlyClasses = NonSynchronizedVector.newInstance();
    protected Map aliasDescriptors;
    protected boolean hasIsolatedClasses = false;
    protected boolean hasGenericHistorySupport = false;
    protected boolean hasProxyIndirection = false;
    protected boolean isPureCMP2Project = false;
    static /* synthetic */ Class class$oracle$toplink$descriptors$ClassDescriptor;

    public Project() {
        this.orderedDescriptors = NonSynchronizedVector.newInstance();
    }

    public Project(Login login) {
        this();
        this.datasourceLogin = login;
    }

    public Project(DatabaseLogin databaseLogin) {
        this();
        this.datasourceLogin = databaseLogin;
    }

    public void addDefaultReadOnlyClass(Class clazz) {
        this.getDefaultReadOnlyClasses().addElement(clazz);
    }

    public void addDescriptor(Descriptor descriptor) {
        this.getOrderedDescriptors().add(descriptor);
        String string = descriptor.getAlias();
        if (string != null) {
            this.addAlias(string, descriptor);
        }
        if (this.descriptors != null && !this.descriptors.isEmpty()) {
            this.getDescriptors().put(descriptor.getJavaClass(), descriptor);
        }
    }

    public void addDescriptor(Descriptor descriptor, oracle.toplink.publicinterface.DatabaseSession databaseSession) {
        this.getOrderedDescriptors().add(descriptor);
        String string = descriptor.getAlias();
        if (string != null) {
            this.addAlias(string, descriptor);
        }
        if (this.descriptors != null && !this.descriptors.isEmpty()) {
            this.getDescriptors().put(descriptor.getJavaClass(), descriptor);
        }
        databaseSession.initializeDescriptorIfSessionAlive(descriptor);
    }

    public void addDescriptors(Vector vector, oracle.toplink.publicinterface.DatabaseSession databaseSession) {
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            Descriptor descriptor = (Descriptor)enumeration.nextElement();
            this.getDescriptors().put(descriptor.getJavaClass(), descriptor);
            String string = descriptor.getAlias();
            if (string == null) continue;
            this.addAlias(string, descriptor);
        }
        if (databaseSession.isConnected()) {
            databaseSession.initializeDescriptors(vector);
            databaseSession.getCommitManager().initializeCommitOrder();
        }
        this.getOrderedDescriptors().addAll(vector);
    }

    public void addDescriptors(Project project, oracle.toplink.publicinterface.DatabaseSession databaseSession) {
        Iterator iterator = project.getDescriptors().values().iterator();
        while (iterator.hasNext()) {
            Descriptor descriptor = (Descriptor)iterator.next();
            this.getDescriptors().put(descriptor.getJavaClass(), descriptor);
            String string = descriptor.getAlias();
            if (string == null) continue;
            this.addAlias(string, descriptor);
        }
        if (databaseSession.isConnected()) {
            databaseSession.initializeDescriptors(project.getDescriptors());
            databaseSession.getCommitManager().initializeCommitOrder();
        }
        this.getOrderedDescriptors().addAll(project.getOrderedDescriptors());
    }

    public void conformAllDescriptors() {
        Iterator iterator = this.getDescriptors().values().iterator();
        while (iterator.hasNext()) {
            Descriptor descriptor = (Descriptor)iterator.next();
            descriptor.setShouldAlwaysConformResultsInUnitOfWork(true);
        }
    }

    protected void applySequenceProperties(DatabaseLogin databaseLogin) {
        if (databaseLogin != null) {
            if (this.getUseNativeSequencing()) {
                databaseLogin.useNativeSequencing();
            } else {
                if (this.getSequenceTableName() != null) {
                    databaseLogin.setSequenceTableName(this.getSequenceTableName());
                }
                if (this.getSequenceFieldName() != null) {
                    databaseLogin.setSequenceNameFieldName(this.getSequenceFieldName());
                }
                if (this.getSequenceCounterName() != null) {
                    databaseLogin.setSequenceCounterFieldName(this.getSequenceCounterName());
                }
            }
            if (this.getSequencePreallocationSize() != null) {
                databaseLogin.setSequencePreallocationSize(this.getSequencePreallocationSize());
            }
        }
    }

    public void assumeExistenceForDoesExist() {
        Iterator iterator = this.getDescriptors().values().iterator();
        while (iterator.hasNext()) {
            Descriptor descriptor = (Descriptor)iterator.next();
            descriptor.getQueryManager().assumeExistenceForDoesExist();
        }
    }

    public void checkCacheForDoesExist() {
        Iterator iterator = this.getDescriptors().values().iterator();
        while (iterator.hasNext()) {
            Descriptor descriptor = (Descriptor)iterator.next();
            descriptor.getQueryManager().checkCacheForDoesExist();
        }
    }

    public void checkDatabaseForDoesExist() {
        Iterator iterator = this.getDescriptors().values().iterator();
        while (iterator.hasNext()) {
            Descriptor descriptor = (Descriptor)iterator.next();
            descriptor.getQueryManager().checkDatabaseForDoesExist();
        }
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (Exception exception) {
            return null;
        }
    }

    public DatabaseSession createDatabaseSession() {
        return new DatabaseSessionImpl(this);
    }

    public Server createServerSession() {
        return new ServerSession(this);
    }

    public Server createServerSession(int n, int n2) {
        return new ServerSession(this, n, n2);
    }

    public Server createServerSession(ConnectionPolicy connectionPolicy) {
        return new ServerSession(this, connectionPolicy);
    }

    public Vector getDefaultReadOnlyClasses() {
        return this.defaultReadOnlyClasses;
    }

    public ClassDescriptor getClassDescriptor(Class clazz) {
        Descriptor descriptor = this.getDescriptor(clazz);
        if (descriptor instanceof ClassDescriptor) {
            return (ClassDescriptor)descriptor;
        }
        throw ValidationException.cannotCastToClass(descriptor, descriptor.getClass(), class$oracle$toplink$descriptors$ClassDescriptor == null ? (class$oracle$toplink$descriptors$ClassDescriptor = Project.class$("oracle.toplink.descriptors.ClassDescriptor")) : class$oracle$toplink$descriptors$ClassDescriptor);
    }

    public Descriptor getDescriptor(Class clazz) {
        return (Descriptor)this.getDescriptors().get(clazz);
    }

    public Map getDescriptors() {
        if (this.descriptors.isEmpty() && !this.orderedDescriptors.isEmpty()) {
            Iterator iterator = this.orderedDescriptors.iterator();
            while (iterator.hasNext()) {
                Descriptor descriptor = (Descriptor)iterator.next();
                this.descriptors.put(descriptor.getJavaClass(), descriptor);
            }
        }
        return this.descriptors;
    }

    public Vector getOrderedDescriptors() {
        return this.orderedDescriptors;
    }

    public void setOrderedDescriptors(Vector vector) {
        this.orderedDescriptors = vector;
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            Descriptor descriptor = (Descriptor)enumeration.nextElement();
            String string = descriptor.getAlias();
            if (string == null) continue;
            this.addAlias(string, descriptor);
        }
    }

    public DatabaseLogin getLogin() {
        return (DatabaseLogin)this.datasourceLogin;
    }

    public Login getDatasourceLogin() {
        return this.datasourceLogin;
    }

    public String getName() {
        return this.name;
    }

    public String getSequenceCounterName() {
        return this.sequenceCounterName;
    }

    public String getSequenceFieldName() {
        return this.sequenceFieldName;
    }

    public Integer getSequencePreallocationSize() {
        return this.sequencePreallocationSize;
    }

    public String getSequenceTableName() {
        return this.sequenceTableName;
    }

    public boolean getUseNativeSequencing() {
        return this.useNativeSequencing;
    }

    public boolean hasGenericHistorySupport() {
        return this.hasGenericHistorySupport;
    }

    public void setDefaultReadOnlyClasses(Vector vector) {
        this.defaultReadOnlyClasses = (Vector)vector.clone();
    }

    public void setDescriptors(Map map) {
        this.descriptors = map;
        Iterator iterator = map.values().iterator();
        while (iterator.hasNext()) {
            Descriptor descriptor = (Descriptor)iterator.next();
            String string = descriptor.getAlias();
            if (string == null) continue;
            this.addAlias(string, descriptor);
        }
    }

    public void setDeferModificationsUntilCommit(int n) {
        Iterator iterator = this.descriptors.values().iterator();
        while (iterator.hasNext()) {
            Descriptor descriptor = (Descriptor)iterator.next();
            if (descriptor.getCMPPolicy() == null) continue;
            descriptor.getCMPPolicy().setDeferModificationsUntilCommit(n);
        }
    }

    public void setHasGenericHistorySupport(boolean bl) {
        this.hasGenericHistorySupport = bl;
    }

    public boolean isPureCMP2Project() {
        return this.isPureCMP2Project;
    }

    public void setIsPureCMP2Project(boolean bl) {
        this.isPureCMP2Project = bl;
    }

    public boolean hasIsolatedClasses() {
        return this.hasIsolatedClasses;
    }

    public void setHasIsolatedClasses(boolean bl) {
        this.hasIsolatedClasses = bl;
    }

    public boolean hasProxyIndirection() {
        return this.hasProxyIndirection;
    }

    public void setHasProxyIndirection(boolean bl) {
        this.hasProxyIndirection = bl;
    }

    public void setLogin(DatabaseLogin databaseLogin) {
        this.datasourceLogin = databaseLogin;
    }

    public void setLogin(Login login) {
        this.datasourceLogin = login;
    }

    public void setDatasourceLogin(Login login) {
        this.datasourceLogin = login;
    }

    public void setLoginAndApplySequenceProperties(DatabaseLogin databaseLogin) {
        this.applySequenceProperties(databaseLogin);
        this.setLogin(databaseLogin);
    }

    public void setName(String string) {
        this.name = string;
    }

    public void setSequenceCounterName(String string) {
        this.sequenceCounterName = string;
    }

    public void setSequenceFieldName(String string) {
        this.sequenceFieldName = string;
    }

    public void setSequencePreallocationSize(int n) {
        this.setSequencePreallocationSize(new Integer(n));
    }

    public void setSequencePreallocationSize(Integer n) {
        this.sequencePreallocationSize = n;
    }

    public void setSequenceTableName(String string) {
        this.sequenceTableName = string;
    }

    public void setUseNativeSequencing(boolean bl) {
        this.useNativeSequencing = bl;
    }

    public String toString() {
        return Helper.getShortClassName(this.getClass()) + "(" + this.getName() + ")";
    }

    public void useCacheIdentityMap() {
        Iterator iterator = this.getDescriptors().values().iterator();
        while (iterator.hasNext()) {
            Descriptor descriptor = (Descriptor)iterator.next();
            descriptor.useCacheIdentityMap();
        }
    }

    public void useCacheIdentityMap(int n) {
        Iterator iterator = this.getDescriptors().values().iterator();
        while (iterator.hasNext()) {
            Descriptor descriptor = (Descriptor)iterator.next();
            descriptor.useCacheIdentityMap();
            descriptor.setIdentityMapSize(n);
        }
    }

    public void useFullIdentityMap() {
        Iterator iterator = this.getDescriptors().values().iterator();
        while (iterator.hasNext()) {
            Descriptor descriptor = (Descriptor)iterator.next();
            descriptor.useFullIdentityMap();
        }
    }

    public void useFullIdentityMap(int n) {
        Iterator iterator = this.getDescriptors().values().iterator();
        while (iterator.hasNext()) {
            Descriptor descriptor = (Descriptor)iterator.next();
            descriptor.useFullIdentityMap();
            descriptor.setIdentityMapSize(n);
        }
    }

    public void useNoIdentityMap() {
        Iterator iterator = this.getDescriptors().values().iterator();
        while (iterator.hasNext()) {
            Descriptor descriptor = (Descriptor)iterator.next();
            descriptor.useNoIdentityMap();
        }
    }

    public void useSoftCacheWeakIdentityMap() {
        Iterator iterator = this.getDescriptors().values().iterator();
        while (iterator.hasNext()) {
            Descriptor descriptor = (Descriptor)iterator.next();
            descriptor.useSoftCacheWeakIdentityMap();
        }
    }

    public void useSoftCacheWeakIdentityMap(int n) {
        Iterator iterator = this.getDescriptors().values().iterator();
        while (iterator.hasNext()) {
            Descriptor descriptor = (Descriptor)iterator.next();
            descriptor.useSoftCacheWeakIdentityMap();
            descriptor.setIdentityMapSize(n);
        }
    }

    public boolean usesOptimisticLocking() {
        Iterator iterator = this.getDescriptors().values().iterator();
        while (iterator.hasNext()) {
            Descriptor descriptor = (Descriptor)iterator.next();
            if (!descriptor.usesOptimisticLocking()) continue;
            return true;
        }
        return false;
    }

    public boolean usesSequencing() {
        Iterator iterator = this.getDescriptors().values().iterator();
        while (iterator.hasNext()) {
            Descriptor descriptor = (Descriptor)iterator.next();
            if (!descriptor.usesSequenceNumbers()) continue;
            return true;
        }
        return false;
    }

    public void useWeakIdentityMap() {
        Iterator iterator = this.getDescriptors().values().iterator();
        while (iterator.hasNext()) {
            Descriptor descriptor = (Descriptor)iterator.next();
            descriptor.useWeakIdentityMap();
        }
    }

    public void useWeakIdentityMap(int n) {
        Iterator iterator = this.getDescriptors().values().iterator();
        while (iterator.hasNext()) {
            Descriptor descriptor = (Descriptor)iterator.next();
            descriptor.useWeakIdentityMap();
            descriptor.setIdentityMapSize(n);
        }
    }

    public void applyLogin() {
    }

    public Map getAliasDescriptors() {
        return this.aliasDescriptors;
    }

    public void addAlias(String string, Descriptor descriptor) {
        if (this.aliasDescriptors == null) {
            this.aliasDescriptors = new HashMap(10);
        }
        this.aliasDescriptors.put(string, descriptor);
    }

    public void addAliasesFromProject(Project project) {
        Iterator iterator = this.getDescriptors().values().iterator();
        while (iterator.hasNext()) {
            Descriptor descriptor = (Descriptor)iterator.next();
            if (descriptor.getAlias() == null) continue;
            this.addAlias(descriptor.getAlias(), descriptor);
        }
    }

    public ClassDescriptor getClassDescriptorForAlias(String string) {
        Descriptor descriptor = null;
        if (this.aliasDescriptors != null) {
            descriptor = (Descriptor)this.aliasDescriptors.get(string);
            if (descriptor instanceof ClassDescriptor) {
                return (ClassDescriptor)descriptor;
            }
            throw ValidationException.cannotCastToClass(descriptor, descriptor.getClass(), class$oracle$toplink$descriptors$ClassDescriptor == null ? (class$oracle$toplink$descriptors$ClassDescriptor = Project.class$("oracle.toplink.descriptors.ClassDescriptor")) : class$oracle$toplink$descriptors$ClassDescriptor);
        }
        return null;
    }

    public Descriptor getDescriptorForAlias(String string) {
        Descriptor descriptor = null;
        if (this.aliasDescriptors != null) {
            descriptor = (Descriptor)this.aliasDescriptors.get(string);
        }
        return descriptor;
    }

    public void setAliasDescriptors(Map map) {
        this.aliasDescriptors = map;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

