/*
 * Decompiled with CFR 0.152.
 */
package oracle.toplink.sessions;

import oracle.toplink.internal.helper.Helper;
import oracle.toplink.internal.helper.IdentityHashtable;
import oracle.toplink.internal.localization.ToStringLocalization;
import oracle.toplink.publicinterface.Session;

public class ObjectCopyingPolicy {
    protected boolean shouldResetPrimaryKey = true;
    protected Session session;
    protected IdentityHashtable copies = new IdentityHashtable();
    protected int depth = 2;
    public static final int NO_CASCADE = 1;
    public static final int CASCADE_PRIVATE_PARTS = 2;
    public static final int CASCADE_ALL_PARTS = 3;

    public void cascadeAllParts() {
        this.setDepth(3);
    }

    public void cascadePrivateParts() {
        this.setDepth(2);
    }

    public void dontCascade() {
        this.setDepth(1);
    }

    public IdentityHashtable getCopies() {
        return this.copies;
    }

    public int getDepth() {
        return this.depth;
    }

    public Session getSession() {
        return this.session;
    }

    public void setCopies(IdentityHashtable identityHashtable) {
        this.copies = identityHashtable;
    }

    public void setDepth(int n) {
        this.depth = n;
    }

    public void setSession(Session session) {
        this.session = session;
    }

    public void setShouldResetPrimaryKey(boolean bl) {
        this.shouldResetPrimaryKey = bl;
    }

    public boolean shouldCascade() {
        return this.getDepth() != 1;
    }

    public boolean shouldCascadeAllParts() {
        return this.getDepth() == 3;
    }

    public boolean shouldCascadePrivateParts() {
        return this.getDepth() == 2;
    }

    public boolean shouldResetPrimaryKey() {
        return this.shouldResetPrimaryKey;
    }

    public String toString() {
        String string = "";
        string = this.shouldCascadeAllParts() ? "CASCADE_ALL_PARTS" : (this.shouldCascadePrivateParts() ? "CASCADE_PRIVATE_PARTS" : "NO_CASCADING");
        Object[] objectArray = new Object[]{string, new Boolean(this.shouldResetPrimaryKey())};
        return Helper.getShortClassName(this) + ToStringLocalization.buildMessage("depth_reset_key", objectArray);
    }
}

