/*
 * Decompiled with CFR 0.152.
 */
package oracle.toplink.sessions;

import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Serializable;
import java.io.Writer;
import oracle.toplink.exceptions.ValidationException;
import oracle.toplink.internal.helper.Helper;
import oracle.toplink.logging.AbstractSessionLog;
import oracle.toplink.logging.SessionLogEntry;

public class DefaultSessionLog
extends AbstractSessionLog
implements Serializable {
    protected String fileName;

    public DefaultSessionLog() {
        this.level = 5;
    }

    public DefaultSessionLog(Writer writer) {
        this();
        this.initialize(writer);
    }

    public void dontLogDebug() {
        this.setShouldLogDebug(false);
    }

    public void dontLogExceptions() {
        this.setShouldLogExceptions(false);
    }

    public void dontLogExceptionStackTrace() {
        this.setShouldLogExceptionStackTrace(false);
    }

    public void dontPrintConnection() {
        this.setShouldPrintConnection(false);
    }

    public void dontPrintDate() {
        this.setShouldPrintDate(false);
    }

    public void dontPrintSession() {
        this.setShouldPrintSession(false);
    }

    public void dontPrintThread() {
        this.setShouldPrintThread(false);
    }

    protected void initialize() {
        this.printSession();
        this.printConnection();
    }

    protected void initialize(Writer writer) {
        this.writer = writer;
    }

    public synchronized void log(SessionLogEntry sessionLogEntry) {
        if (!this.shouldLog(sessionLogEntry.getLevel())) {
            return;
        }
        try {
            this.printPrefixString(sessionLogEntry.getLevel());
            this.getWriter().write(this.getSupplementDetailString(sessionLogEntry));
            if (sessionLogEntry.hasException()) {
                if (sessionLogEntry.getLevel() == 7) {
                    sessionLogEntry.getException().printStackTrace(new PrintWriter(this.getWriter()));
                } else if (sessionLogEntry.getLevel() <= 6) {
                    if (this.shouldLogExceptionStackTrace()) {
                        sessionLogEntry.getException().printStackTrace(new PrintWriter(this.getWriter()));
                    } else {
                        this.writeMessage(sessionLogEntry.getException().toString());
                    }
                }
            } else {
                this.writeMessage(this.formatMessage(sessionLogEntry));
            }
            this.getWriter().write(Helper.cr());
            this.getWriter().flush();
        }
        catch (IOException iOException) {
            throw ValidationException.logIOError(iOException);
        }
    }

    public void logDebug() {
        this.setShouldLogDebug(true);
    }

    public void logExceptions() {
        this.setShouldLogExceptions(true);
    }

    public void logExceptionStackTrace() {
        this.setShouldLogExceptionStackTrace(true);
    }

    public void printConnection() {
        this.setShouldPrintConnection(true);
    }

    public void printDate() {
        this.setShouldPrintDate(true);
    }

    public void printSession() {
        this.setShouldPrintSession(true);
    }

    public void printThread() {
        this.setShouldPrintThread(true);
    }

    public void setWriter(String string) {
        if (string != null) {
            try {
                this.writer = new FileWriter(string);
                this.fileName = string;
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
    }

    public String getWriterFilename() {
        return this.fileName;
    }

    protected void writeMessage(String string) throws IOException {
        this.getWriter().write(string);
    }

    protected void writeSeparator() throws IOException {
        this.getWriter().write("--");
    }
}

