/*
 * Decompiled with CFR 0.152.
 */
package oracle.toplink.sequencing;

import java.io.StringWriter;
import oracle.toplink.queryframework.DataModifyQuery;
import oracle.toplink.queryframework.ValueReadQuery;
import oracle.toplink.sequencing.QuerySequence;

public class UnaryTableSequence
extends QuerySequence {
    protected String counterFieldName = "SEQUENCE";
    protected String updateString1;
    protected String updateString2;
    protected String selectString1;
    protected String selectString2;
    protected int updateStringBufferSize;
    protected int selectStringBufferSize;

    public UnaryTableSequence() {
        super(false, true);
    }

    public UnaryTableSequence(String string) {
        super(string, false, true);
    }

    public UnaryTableSequence(String string, int n) {
        super(string, n, false, true);
    }

    public UnaryTableSequence(String string, String string2) {
        this(string);
        this.setCounterFieldName(string2);
    }

    public UnaryTableSequence(String string, int n, String string2) {
        this(string, n);
        this.setCounterFieldName(string2);
    }

    public boolean equals(Object object) {
        if (object instanceof UnaryTableSequence) {
            UnaryTableSequence unaryTableSequence = (UnaryTableSequence)object;
            if (UnaryTableSequence.equalNameAndSize(this, unaryTableSequence)) {
                return this.getCounterFieldName().equals(unaryTableSequence.getCounterFieldName());
            }
            return false;
        }
        return false;
    }

    public void setCounterFieldName(String string) {
        this.counterFieldName = string;
    }

    public String getCounterFieldName() {
        return this.counterFieldName;
    }

    public void onConnect() {
        super.onConnect();
        this.initialize();
    }

    public void onDisconnect() {
        this.clear();
        super.onDisconnect();
    }

    protected ValueReadQuery buildSelectQuery(String string, Integer n) {
        ValueReadQuery valueReadQuery = new ValueReadQuery();
        valueReadQuery.dontBindAllParameters();
        StringWriter stringWriter = new StringWriter(this.selectStringBufferSize + string.length());
        stringWriter.write(this.selectString1);
        stringWriter.write(string);
        valueReadQuery.setSQLString(stringWriter.toString());
        return valueReadQuery;
    }

    protected DataModifyQuery buildUpdateQuery(String string, Number number) {
        DataModifyQuery dataModifyQuery = new DataModifyQuery();
        dataModifyQuery.dontBindAllParameters();
        String string2 = number.toString();
        StringWriter stringWriter = new StringWriter(this.updateStringBufferSize + string.length() + string2.length());
        stringWriter.write(this.updateString1);
        stringWriter.write(string);
        stringWriter.write(this.updateString2);
        stringWriter.write(string2);
        dataModifyQuery.setSQLString(stringWriter.toString());
        return dataModifyQuery;
    }

    protected void initialize() {
        String string = this.getDatasourcePlatform().getTableQualifier();
        if (string != null) {
            string = string.length() != 0 ? string + '.' : null;
        }
        if (this.getSelectQuery() == null) {
            this.buildSelectString1(string);
            this.selectStringBufferSize = this.selectString1.length();
        }
        if (this.getUpdateQuery() == null && !this.shouldSkipUpdate()) {
            this.buildUpdateString1(string);
            this.buildUpdateString2();
            this.updateStringBufferSize = this.updateString1.length() + this.updateString2.length();
        }
    }

    protected void buildUpdateString1(String string) {
        this.updateString1 = "UPDATE ";
        if (string != null) {
            this.updateString1 = this.updateString1 + string;
        }
    }

    protected void buildUpdateString2() {
        StringWriter stringWriter = new StringWriter();
        stringWriter.write(" SET ");
        stringWriter.write(this.getCounterFieldName());
        stringWriter.write(" = ");
        stringWriter.write(this.getCounterFieldName());
        stringWriter.write(" + ");
        this.updateString2 = stringWriter.toString();
    }

    protected void buildSelectString1(String string) {
        this.selectString1 = "SELECT * FROM ";
        if (string != null) {
            this.selectString1 = this.selectString1 + string;
        }
    }

    protected void clear() {
        this.updateString1 = null;
        this.updateString2 = null;
        this.selectString1 = null;
        this.selectString2 = null;
        this.updateStringBufferSize = 0;
        this.selectStringBufferSize = 0;
    }
}

