/*
 * Decompiled with CFR 0.152.
 */
package oracle.toplink.sequencing;

import oracle.toplink.exceptions.ValidationException;
import oracle.toplink.internal.databaseaccess.DatabasePlatform;
import oracle.toplink.internal.helper.Helper;
import oracle.toplink.queryframework.ValueReadQuery;
import oracle.toplink.sequencing.QuerySequence;

public class NativeSequence
extends QuerySequence {
    public NativeSequence() {
        this.setShouldSkipUpdate(true);
    }

    public NativeSequence(String string) {
        super(string);
        this.setShouldSkipUpdate(true);
    }

    public NativeSequence(String string, int n) {
        super(string, n);
        this.setShouldSkipUpdate(true);
    }

    public boolean equals(Object object) {
        if (object instanceof NativeSequence) {
            return NativeSequence.equalNameAndSize(this, (NativeSequence)object);
        }
        return false;
    }

    protected ValueReadQuery buildSelectQuery() {
        return ((DatabasePlatform)this.getDatasourcePlatform()).buildSelectQueryForNativeSequence();
    }

    protected ValueReadQuery buildSelectQuery(String string, Integer n) {
        return ((DatabasePlatform)this.getDatasourcePlatform()).buildSelectQueryForNativeSequence(string, n);
    }

    public void onConnect() {
        DatabasePlatform databasePlatform;
        block4: {
            databasePlatform = null;
            try {
                databasePlatform = (DatabasePlatform)this.getDatasourcePlatform();
            }
            catch (ClassCastException classCastException) {
                if (this.getSelectQuery() != null) break block4;
                throw ValidationException.platformDoesNotSupportSequence(this.getName(), Helper.getShortClassName(this.getDatasourcePlatform()), Helper.getShortClassName(this));
            }
        }
        if (!databasePlatform.supportsNativeSequenceNumbers() && this.getSelectQuery() == null) {
            throw ValidationException.platformDoesNotSupportSequence(this.getName(), Helper.getShortClassName(this.getDatasourcePlatform()), Helper.getShortClassName(this));
        }
        super.onConnect();
        if (databasePlatform != null) {
            this.setShouldAcquireValueAfterInsert(databasePlatform.shouldNativeSequenceAcquireValueAfterInsert());
            this.setShouldUseTransaction(databasePlatform.shouldNativeSequenceUseTransaction());
        }
    }

    public void onDisconnect() {
        this.setShouldAcquireValueAfterInsert(false);
        this.setShouldUseTransaction(false);
        super.onDisconnect();
    }
}

