/*
 * Decompiled with CFR 0.152.
 */
package oracle.toplink.sdk;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import oracle.toplink.internal.helper.DatabaseField;
import oracle.toplink.mappings.Association;
import oracle.toplink.publicinterface.DatabaseRow;
import oracle.toplink.sdk.DefaultFieldTranslator;
import oracle.toplink.sdk.FieldTranslator;
import oracle.toplink.sdk.SDKDescriptorException;
import oracle.toplink.sdk.SDKFieldValue;
import oracle.toplink.sessions.DatabaseRecord;

public class SimpleFieldTranslator
implements FieldTranslator {
    private Hashtable readTranslations;
    private Hashtable writeTranslations;
    private FieldTranslator wrappedTranslator;

    public SimpleFieldTranslator() {
        this(new DefaultFieldTranslator());
    }

    public SimpleFieldTranslator(FieldTranslator fieldTranslator) {
        this.initialize(fieldTranslator);
    }

    public void addReadOnlyTranslation(String string, String string2) {
        this.getReadTranslations().put(string, string2);
    }

    public void addReadOnlyTranslations(String[] stringArray, String[] stringArray2) {
        if (stringArray.length != stringArray2.length) {
            throw SDKDescriptorException.sizeMismatchOfFieldTranslations();
        }
        for (int i = 0; i < stringArray.length; ++i) {
            this.addReadOnlyTranslation(stringArray[i], stringArray2[i]);
        }
    }

    public void addReadOnlyTranslations(Vector vector) {
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            Association association = (Association)enumeration.nextElement();
            this.addReadOnlyTranslation((String)association.getKey(), (String)association.getValue());
        }
    }

    public void addReadTranslation(String string, String string2) {
        this.addReadOnlyTranslation(string, string2);
        this.addWriteOnlyTranslation(string2, string);
    }

    public void addReadTranslations(String[] stringArray, String[] stringArray2) {
        this.addReadOnlyTranslations(stringArray, stringArray2);
        this.addWriteOnlyTranslations(stringArray2, stringArray);
    }

    public void addReadTranslations(Vector vector) {
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            Association association = (Association)enumeration.nextElement();
            this.addReadTranslation((String)association.getKey(), (String)association.getValue());
        }
    }

    public void addWriteOnlyTranslation(String string, String string2) {
        this.getWriteTranslations().put(string, string2);
    }

    public void addWriteOnlyTranslations(String[] stringArray, String[] stringArray2) {
        if (stringArray.length != stringArray2.length) {
            throw SDKDescriptorException.sizeMismatchOfFieldTranslations();
        }
        for (int i = 0; i < stringArray.length; ++i) {
            this.addWriteOnlyTranslation(stringArray[i], stringArray2[i]);
        }
    }

    public void addWriteOnlyTranslations(Vector vector) {
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            Association association = (Association)enumeration.nextElement();
            this.addWriteOnlyTranslation((String)association.getKey(), (String)association.getValue());
        }
    }

    public void addWriteTranslation(String string, String string2) {
        this.addReadTranslation(string2, string);
    }

    public void addWriteTranslations(String[] stringArray, String[] stringArray2) {
        this.addReadTranslations(stringArray2, stringArray);
    }

    public void addWriteTranslations(Vector vector) {
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            Association association = (Association)enumeration.nextElement();
            this.addWriteTranslation((String)association.getKey(), (String)association.getValue());
        }
    }

    protected Hashtable getReadTranslations() {
        return this.readTranslations;
    }

    public FieldTranslator getWrappedTranslator() {
        return this.wrappedTranslator;
    }

    protected Hashtable getWriteTranslations() {
        return this.writeTranslations;
    }

    protected void initialize(FieldTranslator fieldTranslator) {
        this.readTranslations = new Hashtable(10);
        this.writeTranslations = new Hashtable(10);
        this.setWrappedTranslator(fieldTranslator);
    }

    public void removeReadOnlyTranslation(String string) {
        this.getReadTranslations().remove(string);
    }

    public void removeReadTranslation(String string) {
        this.removeTranslations(string, (String)this.getReadTranslations().get(string));
    }

    protected void removeTranslations(String string, String string2) {
        this.removeReadOnlyTranslation(string);
        this.removeWriteOnlyTranslation(string2);
    }

    public void removeWriteOnlyTranslation(String string) {
        this.getWriteTranslations().remove(string);
    }

    public void removeWriteTranslation(String string) {
        this.removeTranslations((String)this.getWriteTranslations().get(string), string);
    }

    public void setWrappedTranslator(FieldTranslator fieldTranslator) {
        this.wrappedTranslator = fieldTranslator;
    }

    protected DatabaseField translate(DatabaseField databaseField, Hashtable hashtable) {
        String string = (String)hashtable.get(databaseField.getName());
        if (string == null) {
            return databaseField;
        }
        return new DatabaseField(string, databaseField.getTable());
    }

    protected DatabaseRow translate(DatabaseRow databaseRow, Hashtable hashtable) {
        if (hashtable.isEmpty()) {
            return databaseRow;
        }
        DatabaseRecord databaseRecord = new DatabaseRecord(databaseRow.size());
        Enumeration enumeration = databaseRow.getFields().elements();
        while (enumeration.hasMoreElements()) {
            DatabaseField databaseField = (DatabaseField)enumeration.nextElement();
            Object object = databaseRow.get(databaseField);
            if (object instanceof SDKFieldValue) {
                object = this.translate((SDKFieldValue)object, hashtable);
            }
            databaseRecord.put(this.translate(databaseField, hashtable), object);
        }
        return databaseRecord;
    }

    protected SDKFieldValue translate(SDKFieldValue sDKFieldValue, Hashtable hashtable) {
        if (sDKFieldValue.isDirectCollection()) {
            return sDKFieldValue;
        }
        Vector<DatabaseRow> vector = new Vector<DatabaseRow>(sDKFieldValue.getElements().size());
        Enumeration enumeration = sDKFieldValue.getElements().elements();
        while (enumeration.hasMoreElements()) {
            vector.addElement(this.translate((DatabaseRow)enumeration.nextElement(), hashtable));
        }
        return sDKFieldValue.clone(vector);
    }

    public DatabaseRow translateForRead(DatabaseRow databaseRow) {
        return this.translate(this.getWrappedTranslator().translateForRead(databaseRow), this.getReadTranslations());
    }

    public DatabaseRow translateForWrite(DatabaseRow databaseRow) {
        return this.getWrappedTranslator().translateForWrite(this.translate(databaseRow, this.getWriteTranslations()));
    }
}

