/*
 * Decompiled with CFR 0.152.
 */
package oracle.toplink.remote.rmi.iiop;

import java.io.IOException;
import java.net.InetAddress;
import java.net.MulticastSocket;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.util.Hashtable;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import oracle.toplink.exceptions.SynchronizationException;
import oracle.toplink.internal.remote.RemoteConnection;
import oracle.toplink.remote.AbstractJNDIClusteringService;
import oracle.toplink.remote.rmi.iiop.RMIConnection;
import oracle.toplink.remote.rmi.iiop.RMIRemoteSessionController;
import oracle.toplink.remote.rmi.iiop.RMIRemoteSessionControllerDispatcher;
import oracle.toplink.sessions.Session;

public class RMIJNDIClusteringService
extends AbstractJNDIClusteringService {
    private static Class DEFAULT_DISPATCHER_CLASS = class$oracle$toplink$remote$rmi$iiop$RMIRemoteSessionControllerDispatcher == null ? (class$oracle$toplink$remote$rmi$iiop$RMIRemoteSessionControllerDispatcher = RMIJNDIClusteringService.class$("oracle.toplink.remote.rmi.iiop.RMIRemoteSessionControllerDispatcher")) : class$oracle$toplink$remote$rmi$iiop$RMIRemoteSessionControllerDispatcher;
    private static Class DEFAULT_CONNECTION_CLASS = class$oracle$toplink$remote$rmi$iiop$RMIConnection == null ? (class$oracle$toplink$remote$rmi$iiop$RMIConnection = RMIJNDIClusteringService.class$("oracle.toplink.remote.rmi.iiop.RMIConnection")) : class$oracle$toplink$remote$rmi$iiop$RMIConnection;
    static /* synthetic */ Class class$oracle$toplink$remote$rmi$iiop$RMIRemoteSessionControllerDispatcher;
    static /* synthetic */ Class class$oracle$toplink$remote$rmi$iiop$RMIConnection;

    public RMIJNDIClusteringService(String string, int n, Session session) {
        super(string, n, session);
    }

    public RMIJNDIClusteringService(Session session) {
        super(session);
    }

    public void registerDispatcher() {
        try {
            this.getLocalContext().rebind(this.getSessionId(), this.getDispatcher());
        }
        catch (Exception exception) {
            this.getSession().handleException(SynchronizationException.errorBindingController(this.getSessionId(), exception));
        }
    }

    public void deregisterDispatcher() {
        try {
            this.getLocalContext().unbind(this.getSessionId());
            RMIRemoteSessionControllerDispatcher rMIRemoteSessionControllerDispatcher = (RMIRemoteSessionControllerDispatcher)this.getDispatcher();
            if (rMIRemoteSessionControllerDispatcher != null) {
                RMIRemoteSessionControllerDispatcher.unexportObject((Remote)rMIRemoteSessionControllerDispatcher);
            }
        }
        catch (Exception exception) {
            this.getSession().handleException(SynchronizationException.errorBindingController(this.getSessionId(), exception));
        }
    }

    public RemoteConnection createRemoteConnection(String string, String string2) {
        try {
            Hashtable hashtable = (Hashtable)this.getInitialContextProperties().clone();
            hashtable.put("java.naming.provider.url", string2);
            return new RMIConnection((RMIRemoteSessionController)this.getContext(hashtable).lookup(string));
        }
        catch (NamingException namingException) {
            this.getSession().handleException(SynchronizationException.errorLookingUpController(string, namingException));
            return null;
        }
    }

    public MulticastSocket getCommunicationSocket() {
        if (this.communicationSocket == null) {
            try {
                this.communicationSocket = new MulticastSocket(this.getMulticastPort());
                this.communicationSocket.setTimeToLive(this.getTimeToLive());
                this.communicationSocket.joinGroup(InetAddress.getByName(this.getMulticastGroupAddress()));
            }
            catch (IOException iOException) {
                SynchronizationException synchronizationException = SynchronizationException.errorJoiningMulticastGroup(iOException);
                this.getSession().handleException(synchronizationException);
            }
        }
        return this.communicationSocket;
    }

    public Context getContext(String string) {
        try {
            Hashtable<String, String> hashtable = new Hashtable<String, String>(2);
            hashtable.put("java.naming.provider.url", string);
            if (this.getUserName() != null) {
                hashtable.put("java.naming.security.principal", this.getUserName());
            }
            if (this.getPassword() != null) {
                hashtable.put("java.naming.security.credentials", this.getPassword());
            }
            return new InitialContext(hashtable);
        }
        catch (NamingException namingException) {
            this.getSession().handleException(SynchronizationException.errorLookingUpController(string, namingException));
            return null;
        }
    }

    public Object getDispatcher() throws RemoteException {
        if (this.dispatcher == null) {
            this.dispatcher = new RMIRemoteSessionControllerDispatcher(this.getSession());
        }
        return this.dispatcher;
    }

    public RemoteConnection getLocalRemoteConnection() {
        try {
            RMIConnection rMIConnection = new RMIConnection((RMIRemoteSessionControllerDispatcher)this.getDispatcher());
            rMIConnection.setServiceName(this.getSessionId());
            return rMIConnection;
        }
        catch (Exception exception) {
            return null;
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

