/*
 * Decompiled with CFR 0.152.
 */
package oracle.toplink.remote;

import java.util.Vector;
import oracle.toplink.exceptions.ValidationException;
import oracle.toplink.history.AsOfClause;
import oracle.toplink.internal.helper.IdentityHashtable;
import oracle.toplink.internal.queryframework.ContainerPolicy;
import oracle.toplink.internal.remote.ObjectDescriptor;
import oracle.toplink.internal.remote.RemoteConnection;
import oracle.toplink.internal.remote.RemoteUnitOfWork;
import oracle.toplink.internal.remote.RemoteValueHolder;
import oracle.toplink.internal.remote.Transporter;
import oracle.toplink.internal.sequencing.Sequencing;
import oracle.toplink.internal.sequencing.SequencingFactory;
import oracle.toplink.internal.sessions.MergeManager;
import oracle.toplink.publicinterface.Descriptor;
import oracle.toplink.publicinterface.UnitOfWork;
import oracle.toplink.queryframework.DatabaseQuery;
import oracle.toplink.queryframework.ObjectLevelReadQuery;
import oracle.toplink.remote.DistributedSession;
import oracle.toplink.sessions.DatabaseLogin;
import oracle.toplink.sessions.Login;
import oracle.toplink.sessions.Session;

public class RemoteSession
extends DistributedSession {
    protected Sequencing sequencing;
    protected boolean shouldEnableDistributedIndirectionGarbageCollection = false;

    public RemoteSession(RemoteConnection remoteConnection) {
        super(remoteConnection);
        this.initializeSequencing();
    }

    public void setShouldEnableDistributedIndirectionGarbageCollection(boolean bl) {
        this.shouldEnableDistributedIndirectionGarbageCollection = bl;
    }

    public boolean shouldEnableDistributedIndirectionGarbageCollection() {
        return this.shouldEnableDistributedIndirectionGarbageCollection;
    }

    public Session acquireHistoricalSession(AsOfClause asOfClause) throws ValidationException {
        throw ValidationException.cannotAcquireHistoricalSession();
    }

    public UnitOfWork acquireUnitOfWork() {
        this.log(2, "transaction", "acquire_unit_of_work");
        this.setNumberOfActiveUnitsOfWork(this.getNumberOfActiveUnitsOfWork() + 1);
        return new RemoteUnitOfWork(this);
    }

    public Object executeQuery(DatabaseQuery databaseQuery) {
        return databaseQuery.remoteExecute(this);
    }

    public DatabaseLogin getLogin() {
        return (DatabaseLogin)this.getDatasourceLogin();
    }

    public Login getDatasourceLogin() {
        Login login = super.getDatasourceLogin();
        if (login == null) {
            login = this.getRemoteConnection().getLogin();
            this.setDatasourceLogin(login);
        }
        return login;
    }

    public Object getObjectCorrespondingTo(Object object, IdentityHashtable identityHashtable, IdentityHashtable identityHashtable2, ObjectLevelReadQuery objectLevelReadQuery) {
        Cloneable cloneable;
        if (object == null) {
            return null;
        }
        Descriptor descriptor = this.getDescriptor(object);
        if (descriptor.isAggregateCollectionDescriptor() || objectLevelReadQuery != null && !objectLevelReadQuery.shouldMaintainCache()) {
            if (objectLevelReadQuery != null && !objectLevelReadQuery.hasPartialAttributeExpressions()) {
                descriptor.getObjectBuilder().fixObjectReferences(object, identityHashtable, identityHashtable2, objectLevelReadQuery, this);
            }
            return object;
        }
        ObjectDescriptor objectDescriptor = (ObjectDescriptor)identityHashtable.get(object);
        if (objectDescriptor == null) {
            objectDescriptor = new ObjectDescriptor();
            objectDescriptor.setKey(descriptor.getObjectBuilder().extractPrimaryKeyFromObject(object, this));
            objectDescriptor.setObject(object);
            cloneable = descriptor.getOptimisticLockingPolicy();
            if (cloneable == null) {
                objectDescriptor.setWriteLockValue(null);
            } else {
                objectDescriptor.setWriteLockValue(cloneable.getBaseValue());
            }
            identityHashtable.put(object, objectDescriptor);
        }
        cloneable = objectDescriptor.getKey();
        Object object2 = this.getIdentityMapAccessorInstance().getFromIdentityMap((Vector)cloneable, object.getClass(), descriptor);
        if (identityHashtable2.containsKey(object)) {
            if (object2 == null) {
                return object;
            }
            return object2;
        }
        identityHashtable2.put(object, object);
        if (object2 == null) {
            this.getIdentityMapAccessorInstance().putInIdentityMap(object, (Vector)cloneable, objectDescriptor.getWriteLockValue(), objectDescriptor.getReadTime(), descriptor);
            descriptor.getObjectBuilder().fixObjectReferences(object, identityHashtable, identityHashtable2, objectLevelReadQuery, this);
            object2 = object;
        } else if (objectLevelReadQuery == null || objectLevelReadQuery.shouldRefreshRemoteIdentityMapResult() || this.getDescriptor(object2).shouldAlwaysRefreshCacheOnRemote()) {
            MergeManager mergeManager = new MergeManager(this);
            mergeManager.refreshRemoteObject();
            mergeManager.setObjectDescriptors(identityHashtable);
            if (objectLevelReadQuery == null) {
                mergeManager.cascadePrivateParts();
            } else {
                mergeManager.setCascadePolicy(objectLevelReadQuery.getCascadePolicy());
            }
            object2 = mergeManager.mergeChanges(object, null);
        }
        return object2;
    }

    public Object getObjectsCorrespondingToAll(Object object, IdentityHashtable identityHashtable, IdentityHashtable identityHashtable2, ObjectLevelReadQuery objectLevelReadQuery, ContainerPolicy containerPolicy) {
        Object object2 = containerPolicy.containerInstance(containerPolicy.sizeFor(object));
        Object object3 = containerPolicy.iteratorFor(object);
        while (containerPolicy.hasNext(object3)) {
            Object object4 = containerPolicy.next(object3, this);
            containerPolicy.addInto(this.getObjectCorrespondingTo(object4, identityHashtable, identityHashtable2, objectLevelReadQuery), object2, this);
        }
        return object2;
    }

    public Object instantiateRemoteValueHolderOnServer(RemoteValueHolder remoteValueHolder) {
        Transporter transporter = this.getRemoteConnection().instantiateRemoteValueHolderOnServer(remoteValueHolder);
        return remoteValueHolder.getMapping().getObjectCorrespondingTo(transporter.getObject(), this, transporter.getObjectDescriptors(), new IdentityHashtable(), remoteValueHolder.getQuery());
    }

    public boolean isRemoteSession() {
        return true;
    }

    public Sequencing getSequencing() {
        return this.sequencing;
    }

    public void initializeSequencing() {
        this.sequencing = SequencingFactory.createSequencing(this);
    }
}

