/*
 * Decompiled with CFR 0.152.
 */
package oracle.toplink.remote;

import java.lang.reflect.Constructor;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import oracle.toplink.exceptions.CacheSynchCommunicationException;
import oracle.toplink.exceptions.CacheSynchronizationException;
import oracle.toplink.exceptions.CommunicationException;
import oracle.toplink.exceptions.SynchronizationException;
import oracle.toplink.exceptions.TopLinkException;
import oracle.toplink.internal.remote.ChangeSetPropagator;
import oracle.toplink.internal.remote.ConnectToSessionCommand;
import oracle.toplink.internal.remote.RemoteConnection;
import oracle.toplink.internal.remote.SynchronizeCacheCommand;
import oracle.toplink.internal.security.PrivilegedAccessController;
import oracle.toplink.internal.sessions.UnitOfWorkChangeSet;
import oracle.toplink.publicinterface.Session;
import oracle.toplink.remote.AbstractClusteringService;

public class CacheSynchronizationManager {
    protected Hashtable remoteConnections;
    protected Object remoteSessionController;
    protected RemoteConnection remoteSessionConnection;
    protected oracle.toplink.sessions.Session session;
    protected boolean isAsynchronous;
    protected boolean shouldRemoveConnectionOnError;
    protected String localHostURL;
    protected Class clusteringServiceClassType;
    protected AbstractClusteringService clusteringService;
    static /* synthetic */ Class class$oracle$toplink$sessions$Session;

    public CacheSynchronizationManager() {
        this.remoteConnections = new Hashtable(3);
        this.isAsynchronous = true;
        this.shouldRemoveConnectionOnError = true;
    }

    public CacheSynchronizationManager(Class clazz) {
        this.remoteConnections = new Hashtable(3);
        this.isAsynchronous = true;
        this.shouldRemoveConnectionOnError = true;
        this.clusteringServiceClassType = clazz;
    }

    public CacheSynchronizationManager(Object object) {
        this.remoteSessionController = object;
        this.remoteConnections = new Hashtable(3);
        this.isAsynchronous = true;
        this.shouldRemoveConnectionOnError = true;
    }

    public void initialize() {
        if (this.clusteringServiceClassType == null && this.clusteringService == null) {
            return;
        }
        this.getRemoteConnections().clear();
        try {
            Class[] classArray = new Class[]{class$oracle$toplink$sessions$Session == null ? (class$oracle$toplink$sessions$Session = CacheSynchronizationManager.class$("oracle.toplink.sessions.Session")) : class$oracle$toplink$sessions$Session};
            Object[] objectArray = new Object[]{this.getSession()};
            if (this.clusteringService == null) {
                Constructor constructor = PrivilegedAccessController.getConstructorFor(this.clusteringServiceClassType, classArray, false);
                this.clusteringService = (AbstractClusteringService)PrivilegedAccessController.invokeConstructor(constructor, objectArray);
            }
            if (this.localHostURL != null && this.clusteringService.getLocalHostURL() == null) {
                this.clusteringService.setLocalHostURL(this.localHostURL);
            }
            this.clusteringService.initialize();
        }
        catch (Exception exception) {
            throw SynchronizationException.errorGettingSyncService(exception);
        }
    }

    public String getclusteringServiceClassTypeName() {
        return this.getClusteringServiceClassType().getName();
    }

    public void setClusteringServiceClassTypeName(String string) {
        try {
            this.setClusteringServiceClassType(PrivilegedAccessController.getClassForName(string));
        }
        catch (Exception exception) {
            System.out.println("Error setting clusteringServiceClassType " + exception);
        }
    }

    public void addRemoteConnection(RemoteConnection remoteConnection) {
        block10: {
            if (remoteConnection == null) {
                return;
            }
            if (remoteConnection.getServiceName() == "") {
                remoteConnection.setServiceName(String.valueOf(System.identityHashCode(remoteConnection)));
            }
            try {
                if (this.getClusteringService() == null) {
                    if (this.getSessionRemoteController() != null) {
                        remoteConnection.addRemoteControllerForSynchronization(this.getSessionRemoteController());
                    } else {
                        ConnectToSessionCommand connectToSessionCommand = new ConnectToSessionCommand();
                        connectToSessionCommand.setRemoteConnection(this.getSessionRemoteConnection());
                        remoteConnection.processCommand(connectToSessionCommand);
                    }
                } else {
                    this.getClusteringService().connectBackToRemote(remoteConnection);
                }
                this.getRemoteConnections().put(remoteConnection.getServiceName(), remoteConnection);
                ((Session)this.getSession()).log(1, "propagation", "received_connection_from", remoteConnection.getServiceName());
            }
            catch (Exception exception) {
                try {
                    this.getSession().handleException(CommunicationException.errorSendingConnectionService(remoteConnection.getServiceName(), exception));
                }
                catch (RuntimeException runtimeException) {
                    ((Session)this.getSession()).log(6, "propagation", "problem_adding_remote_connection", runtimeException);
                    if (this.shouldRemoveConnectionOnError()) break block10;
                    throw runtimeException;
                }
            }
        }
    }

    public void connectToAllRemoteServers() {
        Enumeration enumeration = this.getRemoteConnections().elements();
        while (enumeration.hasMoreElements()) {
            RemoteConnection remoteConnection = (RemoteConnection)enumeration.nextElement();
            try {
                remoteConnection.addRemoteControllerForSynchronization(this.getSessionRemoteController());
            }
            catch (Exception exception) {
                this.getSession().handleException(CommunicationException.unableToConnect(remoteConnection.getServiceName(), exception));
            }
        }
    }

    public Hashtable getRemoteConnections() {
        return this.remoteConnections;
    }

    public oracle.toplink.sessions.Session getSession() {
        return this.session;
    }

    public Object getSessionRemoteController() {
        return this.remoteSessionController;
    }

    public RemoteConnection getSessionRemoteConnection() {
        return this.remoteSessionConnection;
    }

    public void propagateChanges(UnitOfWorkChangeSet unitOfWorkChangeSet) {
        Vector<TopLinkException> vector = new Vector<TopLinkException>(4);
        if (!unitOfWorkChangeSet.hasChanges()) {
            return;
        }
        ((Session)this.getSession()).log(1, "propagation", "sending_changeset_to_network");
        SynchronizeCacheCommand synchronizeCacheCommand = new SynchronizeCacheCommand();
        synchronizeCacheCommand.setChangeSet(unitOfWorkChangeSet);
        synchronizeCacheCommand.setSourceSessionId(this.getClusteringService().getSessionId());
        if (this.isAsynchronous) {
            ChangeSetPropagator changeSetPropagator = new ChangeSetPropagator(this, synchronizeCacheCommand);
            changeSetPropagator.start();
            return;
        }
        Enumeration enumeration = this.getRemoteConnections().elements();
        while (enumeration.hasMoreElements()) {
            RemoteConnection remoteConnection = (RemoteConnection)enumeration.nextElement();
            try {
                remoteConnection.processCommand(synchronizeCacheCommand);
            }
            catch (Exception exception) {
                try {
                    RemoteConnection remoteConnection2 = this.getClusteringService().reconnect(remoteConnection);
                    this.addRemoteConnection(remoteConnection2);
                    remoteConnection.processCommand(synchronizeCacheCommand);
                }
                catch (Exception exception2) {
                    ((Session)this.getSession()).log(2, "propagation", "failed_to_reconnect_remote_connection");
                    try {
                        this.getSession().handleException(CacheSynchCommunicationException.failedToReconnect(remoteConnection.getServiceName(), exception2));
                    }
                    catch (CacheSynchCommunicationException cacheSynchCommunicationException) {
                        vector.addElement(cacheSynchCommunicationException);
                    }
                    if (this.shouldRemoveConnectionOnError()) {
                        this.removeRemoteConnection(remoteConnection);
                        ((Session)this.getSession()).log(2, "propagation", "dropping_connection", remoteConnection.getServiceName());
                    }
                    try {
                        this.getSession().handleException(CacheSynchCommunicationException.unableToPropagateChanges(remoteConnection.getServiceName(), exception2));
                        this.getSession().handleException(CommunicationException.unableToPropagateChanges(remoteConnection.getServiceName(), exception));
                    }
                    catch (CacheSynchCommunicationException cacheSynchCommunicationException) {
                        vector.addElement(cacheSynchCommunicationException);
                    }
                    catch (CommunicationException communicationException) {
                        vector.addElement(communicationException);
                    }
                }
            }
        }
        if (!vector.isEmpty()) {
            throw new CacheSynchronizationException(vector, unitOfWorkChangeSet);
        }
    }

    public void removeAllRemoteConnections() {
        this.remoteConnections = new Hashtable(3);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeRemoteConnection(RemoteConnection remoteConnection) {
        Hashtable hashtable = this.getRemoteConnections();
        synchronized (hashtable) {
            this.getRemoteConnections().remove(remoteConnection.getServiceName());
        }
    }

    public void setIsAsynchronous(boolean bl) {
        this.isAsynchronous = bl;
    }

    public boolean isAsynchronous() {
        return this.isAsynchronous;
    }

    public void setSession(oracle.toplink.sessions.Session session) {
        this.session = session;
    }

    public void setSessionRemoteController(Object object) {
        this.remoteSessionController = object;
    }

    public void setSessionRemoteConnection(RemoteConnection remoteConnection) {
        this.remoteSessionConnection = remoteConnection;
    }

    public void setShouldRemoveConnectionOnError(boolean bl) {
        this.shouldRemoveConnectionOnError = bl;
    }

    public boolean shouldRemoveConnectionOnError() {
        return this.shouldRemoveConnectionOnError;
    }

    public AbstractClusteringService getClusteringService() {
        return this.clusteringService;
    }

    public void setClusteringService(AbstractClusteringService abstractClusteringService) {
        this.clusteringService = abstractClusteringService;
        if (abstractClusteringService != null) {
            this.setClusteringServiceClassType(abstractClusteringService.getClass());
            if (this.localHostURL != null && this.getClusteringService().getLocalHostURL() == null) {
                this.setLocalHostURL(this.localHostURL);
            }
        }
    }

    public void setClusteringServiceClassType(Class clazz) {
        this.clusteringServiceClassType = clazz;
    }

    public Class getClusteringServiceClassType() {
        return this.clusteringServiceClassType;
    }

    public String getLocalHostURL() {
        if (this.getClusteringService() != null) {
            return this.getClusteringService().getLocalHostURL();
        }
        return this.localHostURL;
    }

    public void setLocalHostURL(String string) {
        if (this.getClusteringService() != null) {
            this.getClusteringService().setLocalHostURL(string);
        } else {
            this.localHostURL = string;
        }
    }

    public void stopListening() {
        if (this.getClusteringService() != null) {
            this.getClusteringService().stopListening();
            this.getClusteringService().deregisterDispatcher();
        }
        this.getRemoteConnections().clear();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

