/*
 * Decompiled with CFR 0.152.
 */
package oracle.toplink.queryframework;

import oracle.toplink.exceptions.DatabaseException;
import oracle.toplink.exceptions.OptimisticLockException;
import oracle.toplink.exceptions.QueryException;
import oracle.toplink.publicinterface.UnitOfWork;
import oracle.toplink.queryframework.Call;
import oracle.toplink.queryframework.DoesExistQuery;
import oracle.toplink.queryframework.ObjectLevelModifyQuery;

public class WriteObjectQuery
extends ObjectLevelModifyQuery {
    public WriteObjectQuery() {
    }

    public WriteObjectQuery(Object object) {
        this();
        this.setObject(object);
    }

    public WriteObjectQuery(Call call) {
        this();
        this.setCall(call);
    }

    public Object executeDatabaseQuery() throws DatabaseException, OptimisticLockException {
        if (this.getObjectChangeSet() != null) {
            return this.getQueryMechanism().executeWriteWithChangeSet();
        }
        return this.getQueryMechanism().executeWrite();
    }

    public void executeCommit() throws DatabaseException, OptimisticLockException {
        boolean bl;
        if (this.getSession().isUnitOfWork()) {
            boolean bl2 = bl = !((UnitOfWork)this.getSession()).isCloneNewObject(this.getObject());
            if (bl) {
                bl = ((UnitOfWork)this.getSession()).isObjectRegistered(this.getObject());
            }
        } else {
            DoesExistQuery doesExistQuery = (DoesExistQuery)this.getDescriptor().getQueryManager().getDoesExistQuery().clone();
            doesExistQuery.setObject(this.getObject());
            doesExistQuery.setPrimaryKey(this.getPrimaryKey());
            doesExistQuery.setDescriptor(this.getDescriptor());
            doesExistQuery.setTranslationRow(this.getTranslationRow());
            bl = (Boolean)this.getSession().executeQuery(doesExistQuery);
        }
        if (bl) {
            this.getQueryMechanism().updateObjectForWrite();
        } else {
            this.getQueryMechanism().insertObjectForWrite();
        }
    }

    public void executeCommitWithChangeSet() throws DatabaseException, OptimisticLockException {
        if (!this.getObjectChangeSet().isNew()) {
            if (!this.getSession().getCommitManager().isCommitInPreModify(this.getObject())) {
                this.getQueryMechanism().updateObjectForWriteWithChangeSet();
            }
        } else if (this.getSession().getCommitManager().isCommitInPreModify(this.getObject())) {
            this.dontCascadeParts();
            this.getQueryMechanism().insertObjectForWrite();
            this.getSession().getCommitManager().markShallowCommit(this.object);
        } else {
            this.getQueryMechanism().insertObjectForWrite();
        }
    }

    public boolean isWriteObjectQuery() {
        return true;
    }

    public void prepareForExecution() throws QueryException {
        super.prepareForExecution();
        if (!this.isInsertObjectQuery() && (this.getTranslationRow() == null || this.getTranslationRow().isEmpty())) {
            this.setTranslationRow(this.getDescriptor().getObjectBuilder().buildRowForTranslation(this.getObject(), this.getSession()));
        }
    }
}

