/*
 * Decompiled with CFR 0.152.
 */
package oracle.toplink.queryframework;

import java.sql.SQLException;
import java.util.ListIterator;
import java.util.Vector;
import oracle.toplink.exceptions.DatabaseException;
import oracle.toplink.exceptions.QueryException;
import oracle.toplink.internal.databaseaccess.DatabaseCall;
import oracle.toplink.internal.helper.InvalidObject;
import oracle.toplink.publicinterface.DatabaseRow;
import oracle.toplink.queryframework.Cursor;
import oracle.toplink.queryframework.ScrollableCursorPolicy;

public class ScrollableCursor
extends Cursor
implements ListIterator {
    protected transient Object nextObject;
    protected transient Object previousObject;

    public ScrollableCursor() {
    }

    public ScrollableCursor(DatabaseCall databaseCall, ScrollableCursorPolicy scrollableCursorPolicy) {
        super(databaseCall, scrollableCursorPolicy);
        this.setPosition(-1);
    }

    public boolean absolute(int n) throws DatabaseException {
        this.clearNextAndPrevious();
        try {
            boolean bl = false;
            int n2 = this.getObjectCollection().size();
            if (n >= 0 && n <= n2) {
                this.getResultSet().beforeFirst();
                this.setPosition(n);
                return true;
            }
            if (n > n2) {
                bl = this.getResultSet().absolute(n - n2);
                if (bl) {
                    this.setPosition(n2 + n);
                } else {
                    this.setPosition(this.size() + 1);
                }
                return bl;
            }
            return this.absolute(this.size() + n);
        }
        catch (SQLException sQLException) {
            throw DatabaseException.sqlException(sQLException);
        }
    }

    public void add(Object object) throws QueryException {
        QueryException.invalidOperation("add");
    }

    public void afterLast() throws DatabaseException {
        this.clearNextAndPrevious();
        try {
            this.getResultSet().afterLast();
            this.setPosition(this.size() + 1);
        }
        catch (SQLException sQLException) {
            throw DatabaseException.sqlException(sQLException);
        }
    }

    public void beforeFirst() throws DatabaseException {
        this.clearNextAndPrevious();
        try {
            this.getResultSet().beforeFirst();
            this.setPosition(0);
        }
        catch (SQLException sQLException) {
            throw DatabaseException.sqlException(sQLException);
        }
    }

    protected void clearNextAndPrevious() {
        this.setNextObject(null);
        this.setPreviousObject(null);
    }

    public int currentIndex() throws DatabaseException {
        return this.getPosition();
    }

    public boolean first() throws DatabaseException {
        this.clearNextAndPrevious();
        try {
            if (this.getObjectCollection().size() > 0) {
                this.setPosition(1);
                this.getResultSet().beforeFirst();
                return true;
            }
            return this.getResultSet().first();
        }
        catch (SQLException sQLException) {
            throw DatabaseException.sqlException(sQLException);
        }
    }

    protected int getCursorSize() throws DatabaseException {
        if (this.getKnownCursorSize() != -1) {
            return this.getKnownCursorSize();
        }
        int n = 0;
        boolean bl = false;
        try {
            bl = this.getResultSet().isAfterLast();
            n = this.getResultSet().getRow();
            this.getResultSet().last();
        }
        catch (SQLException sQLException) {
            throw DatabaseException.sqlException(sQLException);
        }
        int n2 = 0;
        try {
            n2 = this.getResultSet().getRow();
            if (bl) {
                this.getResultSet().afterLast();
            } else if (n == 0) {
                this.getResultSet().beforeFirst();
            } else {
                this.getResultSet().absolute(n);
            }
        }
        catch (SQLException sQLException) {
            throw DatabaseException.sqlException(sQLException);
        }
        return n2;
    }

    protected int getKnownCursorSize() {
        if (this.size == -1) {
            return this.size;
        }
        return this.size - this.getObjectCollection().size();
    }

    protected Object getNextObject() {
        return this.nextObject;
    }

    public int getPosition() throws DatabaseException {
        try {
            if (this.position == -1) {
                this.position = this.getResultSet().getRow();
                if (this.position == 0) {
                    if (this.isAfterLast()) {
                        this.position = this.size() + 1;
                    }
                } else {
                    this.position += this.getObjectCollection().size();
                }
            }
            return this.position;
        }
        catch (SQLException sQLException) {
            throw DatabaseException.sqlException(sQLException);
        }
    }

    protected Object getPreviousObject() {
        return this.previousObject;
    }

    public boolean hasMoreElements() throws DatabaseException {
        return this.hasNext();
    }

    public boolean hasNext() throws DatabaseException {
        if (this.isClosed()) {
            return false;
        }
        this.loadNext();
        return this.getNextObject() != null;
    }

    public boolean hasNextElement() throws DatabaseException {
        return this.hasNext();
    }

    public boolean hasPrevious() throws DatabaseException {
        if (this.isClosed()) {
            return false;
        }
        this.loadPrevious();
        return this.getPreviousObject() != null;
    }

    public boolean isAfterLast() throws DatabaseException {
        try {
            if (this.getNextObject() != null) {
                return false;
            }
            if (this.getObjectCollection().size() > 0 && this.getPosition() <= this.getObjectCollection().size()) {
                return false;
            }
            return this.getResultSet().isAfterLast();
        }
        catch (SQLException sQLException) {
            throw DatabaseException.sqlException(sQLException);
        }
    }

    public boolean isBeforeFirst() throws DatabaseException {
        if (this.getPreviousObject() != null) {
            return false;
        }
        return this.getPosition() == 0;
    }

    public boolean isFirst() throws DatabaseException {
        if (this.getPreviousObject() != null) {
            return false;
        }
        try {
            if (this.getObjectCollection().size() > 0) {
                return this.getPosition() == 1;
            }
            return this.getResultSet().isFirst();
        }
        catch (SQLException sQLException) {
            throw DatabaseException.sqlException(sQLException);
        }
    }

    public boolean isLast() throws DatabaseException {
        if (this.getNextObject() != null) {
            return false;
        }
        try {
            return this.getResultSet().isLast();
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            try {
                return this.getResultSet().getRow() == this.getCursorSize();
            }
            catch (SQLException sQLException) {
                throw DatabaseException.sqlException(sQLException);
            }
        }
        catch (SQLException sQLException) {
            throw DatabaseException.sqlException(sQLException);
        }
    }

    public boolean last() throws DatabaseException {
        this.clearNextAndPrevious();
        try {
            boolean bl = this.getResultSet().last();
            if (!bl) {
                if (this.getObjectCollection().size() > 0) {
                    this.setPosition(this.getObjectCollection().size());
                    bl = true;
                }
            } else {
                this.setSize(this.getObjectCollection().size() + this.getResultSet().getRow());
                this.setPosition(this.size);
            }
            return bl;
        }
        catch (SQLException sQLException) {
            throw DatabaseException.sqlException(sQLException);
        }
    }

    protected void loadNext() {
        if (this.getNextObject() == null) {
            Object object = this.retrieveNextObject();
            this.setNextObject(object);
        }
    }

    protected void loadPrevious() {
        if (this.getPreviousObject() == null) {
            this.setPreviousObject(this.retrievePreviousObject());
        }
    }

    public Object next() throws DatabaseException, QueryException {
        this.loadNext();
        if (this.getNextObject() == null) {
            throw QueryException.readBeyondStream(this.getQuery());
        }
        Object object = this.getNextObject();
        this.clearNextAndPrevious();
        return object;
    }

    public Vector next(int n) throws DatabaseException {
        Vector<Object> vector = new Vector<Object>(n);
        for (int i = 0; i < n; ++i) {
            vector.addElement(this.next());
        }
        return vector;
    }

    public Object nextElement() throws DatabaseException, QueryException {
        return this.next();
    }

    public int nextIndex() throws DatabaseException {
        return this.currentIndex() + 1;
    }

    public Object previous() throws DatabaseException, QueryException {
        this.loadPrevious();
        if (this.getPreviousObject() == null) {
            throw QueryException.readBeyondStream(this.getQuery());
        }
        Object object = this.getPreviousObject();
        this.clearNextAndPrevious();
        return object;
    }

    public int previousIndex() throws DatabaseException {
        return this.currentIndex() - 1;
    }

    public boolean relative(int n) throws DatabaseException {
        this.clearNextAndPrevious();
        try {
            boolean bl = false;
            int n2 = this.getPosition();
            int n3 = this.getPosition() + n;
            int n4 = this.getObjectCollection().size();
            if (n3 <= n4) {
                this.setPosition(n3);
                if (n2 > n4) {
                    this.getResultSet().beforeFirst();
                }
                if (n3 < 0) {
                    this.setPosition(0);
                }
                bl = n3 > 0;
            } else {
                bl = this.getResultSet().relative(n);
                if (!bl) {
                    this.setPosition(this.size() + 1);
                } else {
                    this.setPosition(n3);
                }
            }
            return bl;
        }
        catch (SQLException sQLException) {
            throw DatabaseException.sqlException(sQLException);
        }
    }

    public void remove() throws QueryException {
        QueryException.invalidOperation("remove");
    }

    protected Object retrieveNextObject() throws DatabaseException {
        Object object;
        do {
            if (this.getPosition() < this.getObjectCollection().size()) {
                this.setPosition(this.getPosition() + 1);
                return this.getObjectCollection().elementAt(this.getPosition() - 1);
            }
            if (this.isClosed()) {
                return null;
            }
            DatabaseRow databaseRow = this.getAccessor().cursorRetrieveNextRow(this.getFields(), this.getResultSet(), this.getExecutionSession());
            if (databaseRow == null) {
                this.setPosition(this.size() + 1);
                return null;
            }
            this.setPosition(this.getPosition() + 1);
            object = this.buildAndRegisterObject(databaseRow);
        } while (object == InvalidObject.instance);
        return object;
    }

    protected Object retrievePreviousObject() throws DatabaseException {
        Object object;
        do {
            if (this.getPosition() <= this.getObjectCollection().size() + 1) {
                if (this.getPosition() == this.getObjectCollection().size() + 1 && !this.isClosed()) {
                    this.getAccessor().cursorRetrievePreviousRow(this.getFields(), this.getResultSet(), this.getExecutionSession());
                }
                if (this.getPosition() <= 1) {
                    this.setPosition(0);
                    return null;
                }
                this.setPosition(this.getPosition() - 1);
                return this.getObjectCollection().elementAt(this.getPosition() - 1);
            }
            if (this.isClosed()) {
                return null;
            }
            DatabaseRow databaseRow = this.getAccessor().cursorRetrievePreviousRow(this.getFields(), this.getResultSet(), this.getExecutionSession());
            if (databaseRow == null) {
                return null;
            }
            this.setPosition(this.getPosition() - 1);
            object = this.buildAndRegisterObject(databaseRow);
        } while (object == InvalidObject.instance);
        return object;
    }

    public void set(Object object) throws QueryException {
        QueryException.invalidOperation("set");
    }

    protected void setNextObject(Object object) {
        this.nextObject = object;
    }

    protected void setPreviousObject(Object object) {
        this.previousObject = object;
    }
}

