/*
 * Decompiled with CFR 0.152.
 */
package oracle.toplink.queryframework;

import java.util.Vector;
import oracle.toplink.exceptions.DatabaseException;
import oracle.toplink.exceptions.QueryException;
import oracle.toplink.internal.helper.NonSynchronizedVector;
import oracle.toplink.publicinterface.DatabaseRow;
import oracle.toplink.publicinterface.Session;
import oracle.toplink.queryframework.DatabaseQuery;
import oracle.toplink.queryframework.QueryResultsCachePolicy;

public abstract class ReadQuery
extends DatabaseQuery {
    protected int maxRows = 0;
    protected int firstResult = 0;
    protected long queryId = 0L;
    protected int fetchSize;
    protected QueryResultsCachePolicy queryResultCachingPolicy = null;
    protected transient Object temporaryCachedQueryResults = null;

    public Object buildObject(DatabaseRow databaseRow) {
        return databaseRow;
    }

    public void cacheQueryResults() {
        this.setQueryResultsCachePolicy(new QueryResultsCachePolicy());
    }

    public abstract void cacheResult(Object var1);

    public void clearQueryResults() {
        throw QueryException.clearQueryResultsNotSupported(this);
    }

    protected void clonedQueryExecutionComplete(DatabaseQuery databaseQuery, Session session) {
        if (this.shouldCacheQueryResults()) {
            this.setQueryResults(((ReadQuery)databaseQuery).getTemporaryCachedQueryResults(), databaseQuery.getTranslationRow(), databaseQuery.getSession());
        }
    }

    public void clearQueryResults(Session session) {
        session.getIdentityMapAccessor().clearQueryCache(this);
    }

    public void doNotCacheQueryResults() {
        this.setQueryResultsCachePolicy(null);
    }

    public QueryResultsCachePolicy getQueryResultsCachePolicy() {
        return this.queryResultCachingPolicy;
    }

    public int getFirstResult() {
        return this.firstResult;
    }

    public long getQueryId() {
        return this.queryId;
    }

    public int getMaxRows() {
        return this.maxRows;
    }

    public int getFetchSize() {
        return this.fetchSize;
    }

    protected Object getQueryResults(Session session) {
        return this.getQueryResults(session, this.getTranslationRow(), true);
    }

    protected Object getQueryResults(Session session, boolean bl) {
        return this.getQueryResults(session, this.getTranslationRow(), bl);
    }

    protected Object getQueryResults(Session session, DatabaseRow databaseRow, boolean bl) {
        Vector vector = null;
        vector = databaseRow == null ? new NonSynchronizedVector(1) : databaseRow.getValues();
        return session.getIdentityMapAccessorInstance().getQueryResult(this, vector, bl);
    }

    public Object getTemporaryCachedQueryResults() {
        return this.temporaryCachedQueryResults;
    }

    public boolean isReadQuery() {
        return true;
    }

    protected void prepare() throws QueryException {
        super.prepare();
        if (this.shouldCacheQueryResults()) {
            this.clearQueryResults(this.getSession());
        }
    }

    public Object remoteExecute(Session session) throws DatabaseException {
        if (this.shouldCacheQueryResults()) {
            Object object;
            DatabaseRow databaseRow = new DatabaseRow();
            if (this.translationRow != null) {
                databaseRow = this.translationRow;
            }
            if ((object = this.getQueryResults(session, databaseRow, true)) != null) {
                return object;
            }
            object = super.remoteExecute(session);
            if (object != null) {
                this.setQueryResults(object, databaseRow, session);
            }
            return object;
        }
        return super.remoteExecute(session);
    }

    public void setQueryResultsCachePolicy(QueryResultsCachePolicy queryResultsCachePolicy) {
        this.queryResultCachingPolicy = queryResultsCachePolicy;
        this.setIsPrepared(false);
    }

    public void setFirstResult(int n) {
        this.firstResult = n;
        this.setIsPrepared(false);
    }

    public void setQueryId(long l) {
        this.queryId = l;
    }

    public void setMaxRows(int n) {
        this.maxRows = n;
        this.setIsPrepared(false);
    }

    public void setFetchSize(int n) {
        this.fetchSize = n;
    }

    protected void setQueryResults(Object object, Session session) {
        session.getIdentityMapAccessorInstance().putQueryResult(this, this.getTranslationRow().getValues(), object);
    }

    protected void setQueryResults(Object object, DatabaseRow databaseRow, Session session) {
        Vector vector = null;
        vector = databaseRow == null ? new NonSynchronizedVector(1) : databaseRow.getValues();
        session.getIdentityMapAccessorInstance().putQueryResult(this, vector, object);
    }

    public void setShouldCacheQueryResults(boolean bl) {
        if (bl) {
            this.setQueryResultsCachePolicy(new QueryResultsCachePolicy());
        } else {
            this.setQueryResultsCachePolicy(null);
        }
    }

    public boolean shouldCacheQueryResults() {
        return this.queryResultCachingPolicy != null;
    }

    public void setTemporaryCachedQueryResults(Object object) {
        this.temporaryCachedQueryResults = object;
    }
}

