/*
 * Decompiled with CFR 0.152.
 */
package oracle.toplink.queryframework;

import java.util.Enumeration;
import java.util.Vector;
import oracle.toplink.exceptions.DatabaseException;
import oracle.toplink.exceptions.QueryException;
import oracle.toplink.internal.helper.DatabaseField;
import oracle.toplink.publicinterface.DatabaseRow;
import oracle.toplink.publicinterface.Session;
import oracle.toplink.publicinterface.UnitOfWork;
import oracle.toplink.queryframework.Call;
import oracle.toplink.queryframework.DatabaseQuery;

public class DoesExistQuery
extends DatabaseQuery {
    public static final int AssumeNonExistence = 1;
    public static final int AssumeExistence = 2;
    public static final int CheckCache = 3;
    public static final int CheckDatabase = 4;
    protected Vector primaryKey;
    protected Object object;
    protected int existencePolicy = 3;

    public DoesExistQuery() {
    }

    public DoesExistQuery(Object object) {
        this();
        this.object = object;
    }

    public DoesExistQuery(Call call) {
        this();
        this.setCall(call);
    }

    public void assumeExistenceForDoesExist() {
        this.setExistencePolicy(2);
    }

    public void assumeNonExistenceForDoesExist() {
        this.setExistencePolicy(1);
    }

    public void checkCacheForDoesExist() {
        this.setExistencePolicy(3);
    }

    public void checkDatabaseForDoesExist() {
        this.setExistencePolicy(4);
    }

    public Object checkEarlyReturn(Object object, Vector vector, Session session, DatabaseRow databaseRow) {
        this.buildSelectionCriteria(session);
        if (object == null) {
            return Boolean.FALSE;
        }
        if (this.shouldAssumeNonExistenceForDoesExist()) {
            return Boolean.FALSE;
        }
        if (vector != null) {
            Enumeration enumeration = vector.elements();
            while (enumeration.hasMoreElements()) {
                if (enumeration.nextElement() != null) continue;
                return Boolean.FALSE;
            }
        }
        if (this.shouldAssumeExistenceForDoesExist()) {
            return Boolean.TRUE;
        }
        if (this.shouldCheckCacheForDoesExist()) {
            if (session.getIdentityMapAccessorInstance().getFromIdentityMap(vector, object.getClass(), this.getDescriptor()) == null) {
                return Boolean.FALSE;
            }
            return Boolean.TRUE;
        }
        return null;
    }

    public Object checkEarlyReturn(Session session, DatabaseRow databaseRow) {
        return this.checkEarlyReturn(this.getObject(), this.getPrimaryKey(), session, databaseRow);
    }

    public Object executeInUnitOfWork(UnitOfWork unitOfWork, DatabaseRow databaseRow) {
        if (!unitOfWork.getCommitManager().isActive()) {
            return unitOfWork.getParent().executeQuery((DatabaseQuery)this, databaseRow);
        }
        return super.execute(unitOfWork, databaseRow);
    }

    public Object executeDatabaseQuery() throws DatabaseException {
        DatabaseField databaseField = this.getDoesExistField();
        DatabaseRow databaseRow = this.getQueryMechanism().selectRowForDoesExist(databaseField);
        return new Boolean(databaseRow != null);
    }

    protected DatabaseField getDoesExistField() {
        return (DatabaseField)this.getDescriptor().getPrimaryKeyFields().get(0);
    }

    public int getExistencePolicy() {
        return this.existencePolicy;
    }

    public Object getObject() {
        return this.object;
    }

    public Vector getPrimaryKey() {
        return this.primaryKey;
    }

    public Class getReferenceClass() {
        if (this.getObject() == null) {
            return null;
        }
        return this.getObject().getClass();
    }

    public String getReferenceClassName() {
        return this.getReferenceClass().getName();
    }

    protected void prepare() throws QueryException {
        if (this.getDescriptor() == null) {
            this.setDescriptor(this.getSession().getDescriptor(this.getObject()));
        }
        if (this.getObject() != null) {
            this.setObject(this.getDescriptor().getObjectBuilder().unwrapObject(this.getObject(), this.getSession()));
        }
        super.prepare();
        this.getQueryMechanism().prepareDoesExist(this.getDoesExistField());
    }

    public void prepareForExecution() throws QueryException {
        super.prepareForExecution();
        if (this.getObject() == null) {
            throw QueryException.objectToModifyNotSpecified(this);
        }
        this.setObject(this.getDescriptor().getObjectBuilder().unwrapObject(this.getObject(), this.getSession()));
        if (this.getDescriptor() == null) {
            this.setDescriptor(this.getSession().getDescriptor(this.getObject().getClass()));
        }
        if (this.getPrimaryKey() == null) {
            this.setPrimaryKey(this.getDescriptor().getObjectBuilder().extractPrimaryKeyFromObject(this.getObject(), this.getSession()));
        }
        if (this.getTranslationRow() == null || this.getTranslationRow().isEmpty()) {
            this.setTranslationRow(this.getDescriptor().getObjectBuilder().buildRowForTranslation(this.getObject(), this.getSession()));
        }
    }

    public void setExistencePolicy(int n) {
        this.existencePolicy = n;
    }

    public void setObject(Object object) {
        this.object = object;
    }

    public void setPrimaryKey(Vector vector) {
        this.primaryKey = vector;
    }

    public boolean shouldAssumeExistenceForDoesExist() {
        return this.existencePolicy == 2;
    }

    public boolean shouldAssumeNonExistenceForDoesExist() {
        return this.existencePolicy == 1;
    }

    public boolean shouldCheckCacheForDoesExist() {
        return this.existencePolicy == 3;
    }

    public boolean shouldCheckDatabaseForDoesExist() {
        return this.existencePolicy == 4;
    }
}

