/*
 * Decompiled with CFR 0.152.
 */
package oracle.toplink.queryframework;

import java.io.Serializable;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import oracle.toplink.exceptions.DatabaseException;
import oracle.toplink.exceptions.OptimisticLockException;
import oracle.toplink.exceptions.QueryException;
import oracle.toplink.expressions.Expression;
import oracle.toplink.internal.databaseaccess.Accessor;
import oracle.toplink.internal.databaseaccess.DatabaseCall;
import oracle.toplink.internal.expressions.SQLStatement;
import oracle.toplink.internal.helper.ConversionManager;
import oracle.toplink.internal.helper.DatabaseField;
import oracle.toplink.internal.helper.FalseUndefinedTrue;
import oracle.toplink.internal.helper.Helper;
import oracle.toplink.internal.helper.IdentityHashtable;
import oracle.toplink.internal.helper.NonSynchronizedVector;
import oracle.toplink.internal.parsing.ejbql.EJBQLCallQueryMechanism;
import oracle.toplink.internal.queryframework.CallQueryMechanism;
import oracle.toplink.internal.queryframework.DatabaseQueryMechanism;
import oracle.toplink.internal.queryframework.DatasourceCallQueryMechanism;
import oracle.toplink.internal.queryframework.ExpressionQueryMechanism;
import oracle.toplink.internal.queryframework.StatementQueryMechanism;
import oracle.toplink.internal.remote.RemoteSessionController;
import oracle.toplink.internal.remote.Transporter;
import oracle.toplink.publicinterface.DatabaseRow;
import oracle.toplink.publicinterface.Descriptor;
import oracle.toplink.publicinterface.Session;
import oracle.toplink.publicinterface.UnitOfWork;
import oracle.toplink.queryframework.Call;
import oracle.toplink.queryframework.EJBQLCall;
import oracle.toplink.queryframework.QueryRedirector;
import oracle.toplink.queryframework.ReadObjectQuery;
import oracle.toplink.queryframework.SQLCall;
import oracle.toplink.remote.RemoteSession;
import oracle.toplink.sessions.DatabaseRecord;
import oracle.toplink.sessions.Record;

public abstract class DatabaseQuery
implements Cloneable,
Serializable,
FalseUndefinedTrue {
    protected String name;
    protected Vector arguments;
    protected Vector argumentValues;
    protected Vector argumentTypes;
    protected Vector argumentTypeNames;
    protected transient Descriptor descriptor;
    protected DatabaseQueryMechanism queryMechanism;
    protected QueryRedirector redirector;
    protected boolean shouldMaintainCache = true;
    protected Hashtable properties;
    protected transient Session session;
    protected transient Session executionSession;
    protected transient Accessor accessor;
    protected DatabaseRow translationRow;
    protected boolean isUserDefined = false;
    protected int cascadePolicy = 1;
    protected String sessionName;
    protected boolean isPrepared = false;
    protected boolean shouldPrepare = true;
    protected int shouldBindAllParameters = 0;
    protected int shouldCacheStatement = 0;
    protected boolean shouldUseWrapperPolicy = true;
    protected int queryTimeout = -1;
    public static final int NoCascading = 1;
    public static final int CascadePrivateParts = 2;
    public static final int CascadeAllParts = 3;
    public static final int CascadeDependentParts = 4;
    public static final int CascadeAggregateDelete = 5;
    public static final int CascadeByMapping = 6;
    protected String hintString;
    protected boolean isExecutionClone = false;
    protected Boolean isCustomQueryUsed;
    static /* synthetic */ Class class$java$lang$Object;

    public void addArgument(String string) {
        this.addArgument(string, class$java$lang$Object == null ? (class$java$lang$Object = DatabaseQuery.class$("java.lang.Object")) : class$java$lang$Object);
    }

    public void addArgument(String string, Class clazz) {
        this.getArguments().addElement(string);
        this.getArgumentTypes().addElement(clazz);
        this.getArgumentTypeNames().addElement(clazz.getName());
    }

    public void addArgument(String string, String string2) {
        this.getArguments().addElement(string);
        this.getArgumentTypes().addElement(Helper.getObjectClass(ConversionManager.loadClass(string2)));
        this.getArgumentTypeNames().addElement(string2);
    }

    public void addArgumentByTypeName(String string, String string2) {
        this.getArguments().addElement(string);
        this.getArgumentTypeNames().addElement(string2);
    }

    public void addArgumentValue(Object object) {
        this.getArgumentValues().addElement(object);
    }

    public void addArgumentValues(Vector vector) {
        this.setArgumentValues(vector);
    }

    public void addCall(Call call) {
        this.setQueryMechanism(call.buildQueryMechanism(this, this.getQueryMechanism()));
        this.setIsPrepared(false);
    }

    public void addStatement(SQLStatement sQLStatement) {
        if (!this.hasQueryMechanism()) {
            this.setQueryMechanism(new StatementQueryMechanism(this));
        } else if (!this.getQueryMechanism().isStatementQueryMechanism()) {
            this.setQueryMechanism(new StatementQueryMechanism(this));
        }
        ((StatementQueryMechanism)this.getQueryMechanism()).getSQLStatements().addElement(sQLStatement);
        this.setIsPrepared(false);
    }

    public void bindAllParameters() {
        this.setShouldBindAllParameters(true);
    }

    protected void buildSelectionCriteria(Session session) {
        this.getQueryMechanism().buildSelectionCriteria(session);
    }

    public void cacheStatement() {
        this.setShouldCacheStatement(true);
    }

    public void cascadeAllParts() {
        this.setCascadePolicy(3);
    }

    public void cascadeByMapping() {
        this.setCascadePolicy(6);
    }

    public void cascadeOnlyDependentParts() {
        this.setCascadePolicy(4);
    }

    public void cascadePrivateParts() {
        this.setCascadePolicy(2);
    }

    public void checkDescriptor(Session session) throws QueryException {
    }

    public Object checkEarlyReturn(Session session, DatabaseRow databaseRow) {
        return null;
    }

    protected DatabaseQuery checkForCustomQuery(Session session, DatabaseRow databaseRow) {
        return null;
    }

    public void checkPrepare(Session session, DatabaseRow databaseRow) {
        this.checkPrepare(session, databaseRow, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void checkPrepare(Session session, DatabaseRow databaseRow, boolean bl) {
        if (!this.isPrepared()) {
            if (!bl && this.shouldPrepare() && this.checkForCustomQuery(session, databaseRow) != null) {
                return;
            }
            DatabaseQuery databaseQuery = this;
            synchronized (databaseQuery) {
                if (!this.isPrepared()) {
                    if ((this.isReadQuery() || this.isDataModifyQuery()) && this.isCallQuery() && this.getQueryMechanism() instanceof CallQueryMechanism && (databaseRow == null || databaseRow.isEmpty())) {
                        if (this.isReadObjectQuery() || this.isUserDefined()) {
                            ((CallQueryMechanism)this.getQueryMechanism()).setCallHasCustomSQLArguments();
                        }
                    } else if (this.isCallQuery() && this.getQueryMechanism() instanceof CallQueryMechanism) {
                        ((CallQueryMechanism)this.getQueryMechanism()).setCallHasCustomSQLArguments();
                    }
                    this.setSession(session);
                    this.prepare();
                    this.setSession(null);
                    this.setIsPrepared(true);
                }
            }
        }
    }

    public Object clone() {
        try {
            DatabaseQuery databaseQuery = (DatabaseQuery)super.clone();
            if (databaseQuery.properties != null) {
                if (databaseQuery.properties.isEmpty()) {
                    databaseQuery.setProperties(null);
                } else {
                    databaseQuery.setProperties((Hashtable)this.getProperties().clone());
                }
            }
            if (this.hasQueryMechanism()) {
                databaseQuery.setQueryMechanism(this.getQueryMechanism().clone(databaseQuery));
            }
            databaseQuery.setIsPrepared(this.isPrepared());
            return databaseQuery;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return null;
        }
    }

    protected void clonedQueryExecutionComplete(DatabaseQuery databaseQuery, Session session) {
    }

    public void deploymentSetShouldMaintainCache(int n) {
        if (n == 1) {
            this.setShouldMaintainCache(true);
        } else if (n == -1) {
            this.setShouldMaintainCache(false);
        }
    }

    public int deploymentShouldMaintainCache() {
        if (this.shouldMaintainCache()) {
            return 1;
        }
        return -1;
    }

    public void dontBindAllParameters() {
        this.setShouldBindAllParameters(false);
    }

    public void dontCacheStatement() {
        this.setShouldCacheStatement(false);
    }

    public void dontCascadeParts() {
        this.setCascadePolicy(1);
    }

    public void dontMaintainCache() {
        this.setShouldMaintainCache(false);
    }

    public abstract Object executeDatabaseQuery() throws DatabaseException, OptimisticLockException;

    public Object executeInUnitOfWork(UnitOfWork unitOfWork, DatabaseRow databaseRow) throws DatabaseException, OptimisticLockException {
        return this.execute(unitOfWork, databaseRow);
    }

    public Object execute(Session session, DatabaseRow databaseRow) throws DatabaseException, OptimisticLockException {
        Object object;
        Object object2 = this;
        if (this.getRedirector() != null) {
            return this.redirectQuery((DatabaseQuery)object2, session, databaseRow);
        }
        Object object3 = ((DatabaseQuery)object2).checkEarlyReturn(session, databaseRow);
        if (object3 != null || this.isReadObjectQuery() && ((ReadObjectQuery)this).shouldCheckCacheOnly()) {
            return object3;
        }
        session.startOperationProfile("query prepare");
        boolean bl = false;
        if (!this.isPrepared() && this.shouldPrepare() && (object = this.checkForCustomQuery(session, databaseRow)) != null) {
            bl = true;
            object2 = object;
            if (((DatabaseQuery)object2).getRedirector() != null) {
                session.endOperationProfile("query prepare");
                return this.redirectQuery((DatabaseQuery)object2, session, databaseRow);
            }
        }
        if (((DatabaseQuery)(object2 = session.prepareDatabaseQuery((DatabaseQuery)object2))).shouldPrepare()) {
            ((DatabaseQuery)object2).checkPrepare(session, databaseRow);
        }
        if (!((DatabaseQuery)object2).isExecutionClone()) {
            object2 = (DatabaseQuery)((DatabaseQuery)object2).clone();
        }
        ((DatabaseQuery)object2).setTranslationRow(databaseRow);
        if (!((DatabaseQuery)object2).shouldPrepare()) {
            ((DatabaseQuery)object2).checkPrepare(session, databaseRow);
        }
        ((DatabaseQuery)object2).setSession(session);
        if (bl) {
            this.prepareCustomQuery((DatabaseQuery)object2);
        }
        ((DatabaseQuery)object2).prepareForExecution();
        session.endOperationProfile("query prepare");
        object = ((DatabaseQuery)object2).executeDatabaseQuery();
        this.clonedQueryExecutionComplete((DatabaseQuery)object2, session);
        return object;
    }

    public Object extractRemoteResult(Transporter transporter) {
        return transporter.getObject();
    }

    public Accessor getAccessor() {
        return this.accessor;
    }

    public Vector getArguments() {
        if (this.arguments == null) {
            this.arguments = NonSynchronizedVector.newInstance();
        }
        return this.arguments;
    }

    public Vector getArgumentTypes() {
        if (this.argumentTypes == null || this.argumentTypes.isEmpty()) {
            this.argumentTypes = new Vector();
            if (this.argumentTypeNames != null) {
                Iterator iterator = this.argumentTypeNames.iterator();
                while (iterator.hasNext()) {
                    String string = (String)iterator.next();
                    this.argumentTypes.addElement(Helper.getObjectClass(ConversionManager.loadClass(string)));
                }
            }
        }
        return this.argumentTypes;
    }

    public Vector getArgumentTypeNames() {
        if (this.argumentTypeNames == null) {
            this.argumentTypeNames = NonSynchronizedVector.newInstance();
        }
        return this.argumentTypeNames;
    }

    public void setArgumentTypes(Vector vector) {
        this.argumentTypes = vector;
        this.getArgumentTypeNames().clear();
        Iterator iterator = vector.iterator();
        while (iterator.hasNext()) {
            this.argumentTypeNames.addElement(((Class)iterator.next()).getName());
        }
    }

    public void setArgumentTypeNames(Vector vector) {
        this.argumentTypeNames = vector;
    }

    public void setArguments(Vector vector) {
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            this.addArgument((String)enumeration.nextElement());
        }
    }

    public Vector getArgumentValues() {
        if (this.argumentValues == null) {
            this.argumentValues = NonSynchronizedVector.newInstance();
        }
        return this.argumentValues;
    }

    public void setArgumentValues(Vector vector) {
        this.argumentValues = vector;
    }

    public DatabaseCall getCall() {
        Call call = this.getDatasourceCall();
        if (call instanceof DatabaseCall) {
            return (DatabaseCall)call;
        }
        return null;
    }

    public List getCalls() {
        return this.getDatasourceCalls();
    }

    public Call getDatasourceCall() {
        Call call = null;
        if (this.getQueryMechanism() instanceof DatasourceCallQueryMechanism) {
            DatasourceCallQueryMechanism datasourceCallQueryMechanism = (DatasourceCallQueryMechanism)this.getQueryMechanism();
            call = datasourceCallQueryMechanism.getCall();
            if (datasourceCallQueryMechanism.hasMultipleCalls()) {
                call = (Call)datasourceCallQueryMechanism.getCalls().get(0);
            }
        }
        if (call == null && this.getQueryMechanism().isEJBQLCallQueryMechanism()) {
            call = ((EJBQLCallQueryMechanism)this.getQueryMechanism()).getEJBQLCall();
        }
        return call;
    }

    public List getDatasourceCalls() {
        Vector vector = new Vector();
        if (this.getQueryMechanism() instanceof DatasourceCallQueryMechanism) {
            DatasourceCallQueryMechanism datasourceCallQueryMechanism = (DatasourceCallQueryMechanism)this.getQueryMechanism();
            if (datasourceCallQueryMechanism.hasMultipleCalls()) {
                vector = datasourceCallQueryMechanism.getCalls();
            } else {
                vector.add(datasourceCallQueryMechanism.getCall());
            }
        }
        if (vector.isEmpty() && this.getQueryMechanism().isEJBQLCallQueryMechanism()) {
            vector.add(((EJBQLCallQueryMechanism)this.getQueryMechanism()).getEJBQLCall());
        }
        return vector;
    }

    public int getCascadePolicy() {
        return this.cascadePolicy;
    }

    public Descriptor getDescriptor() {
        return this.descriptor;
    }

    public String getName() {
        return this.name;
    }

    public Hashtable getProperties() {
        if (this.properties == null) {
            this.properties = new Hashtable(5);
        }
        return this.properties;
    }

    public synchronized Object getProperty(Object object) {
        if (this.properties == null) {
            return null;
        }
        return this.getProperties().get(object);
    }

    public DatabaseQueryMechanism getQueryMechanism() {
        if (this.queryMechanism == null) {
            this.queryMechanism = new ExpressionQueryMechanism(this);
        }
        return this.queryMechanism;
    }

    public boolean hasQueryMechanism() {
        return this.queryMechanism != null;
    }

    public int getQueryTimeout() {
        return this.queryTimeout;
    }

    public QueryRedirector getRedirector() {
        return this.redirector;
    }

    public Class getReferenceClass() {
        return null;
    }

    public String getReferenceClassName() {
        return null;
    }

    public Expression getSelectionCriteria() {
        return this.getQueryMechanism().getSelectionCriteria();
    }

    public Session getSession() {
        return this.session;
    }

    public Session getExecutionSession() {
        if (this.executionSession == null && this.getSession() != null) {
            this.executionSession = this.getSession().getExecutionSession(this);
        }
        return this.executionSession;
    }

    protected void setExecutionSession(Session session) {
        this.executionSession = session;
    }

    public String getSessionName() {
        return this.sessionName;
    }

    public SQLStatement getSQLStatement() {
        return ((StatementQueryMechanism)this.getQueryMechanism()).getSQLStatement();
    }

    public String getEJBQLString() {
        if (!this.getQueryMechanism().isEJBQLCallQueryMechanism()) {
            return null;
        }
        EJBQLCall eJBQLCall = ((EJBQLCallQueryMechanism)this.getQueryMechanism()).getEJBQLCall();
        return eJBQLCall.getEjbqlString();
    }

    public String getHintString() {
        return this.hintString;
    }

    public String getSQLString() {
        Call call = this.getDatasourceCall();
        if (call == null) {
            return null;
        }
        if (!(call instanceof SQLCall)) {
            return null;
        }
        return ((SQLCall)call).getSQLString();
    }

    public List getSQLStrings() {
        List list = this.getDatasourceCalls();
        if (list == null || list.isEmpty()) {
            return null;
        }
        Vector<String> vector = new Vector<String>(list.size());
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            Call call = (Call)iterator.next();
            if (!(call instanceof SQLCall)) {
                return null;
            }
            vector.addElement(((SQLCall)call).getSQLString());
        }
        return vector;
    }

    public int getShouldBindAllParameters() {
        return this.shouldBindAllParameters;
    }

    public String getTranslatedSQLString(oracle.toplink.sessions.Session session, Record record) {
        CallQueryMechanism callQueryMechanism = (CallQueryMechanism)this.getQueryMechanism();
        if (callQueryMechanism.getCall() == null) {
            return null;
        }
        SQLCall sQLCall = (SQLCall)callQueryMechanism.getCall().clone();
        sQLCall.translate((DatabaseRow)record, callQueryMechanism.getModifyRow(), (Session)session);
        return sQLCall.getSQLString();
    }

    public List getTranslatedSQLStrings(oracle.toplink.sessions.Session session, Record record) {
        CallQueryMechanism callQueryMechanism = (CallQueryMechanism)this.getQueryMechanism();
        if (callQueryMechanism.getCalls() == null || callQueryMechanism.getCalls().isEmpty()) {
            return null;
        }
        Vector<String> vector = new Vector<String>(callQueryMechanism.getCalls().size());
        Iterator iterator = callQueryMechanism.getCalls().iterator();
        while (iterator.hasNext()) {
            SQLCall sQLCall = (SQLCall)iterator.next();
            sQLCall = (SQLCall)sQLCall.clone();
            sQLCall.translate((DatabaseRow)record, callQueryMechanism.getModifyRow(), (Session)session);
            vector.addElement(sQLCall.getSQLString());
        }
        return vector;
    }

    public DatabaseRow getTranslationRow() {
        return this.translationRow;
    }

    public boolean hasAccessor() {
        return this.accessor != null;
    }

    public boolean hasProperties() {
        return this.properties != null && !this.properties.isEmpty();
    }

    public boolean hasSessionName() {
        return this.sessionName != null;
    }

    public void ignoreBindAllParameters() {
        this.shouldBindAllParameters = 0;
    }

    public void ignoreCacheStatement() {
        this.shouldCacheStatement = 0;
    }

    public boolean isCallQuery() {
        return this.getQueryMechanism().isCallQueryMechanism();
    }

    public boolean isCascadeOfAggregateDelete() {
        return this.getCascadePolicy() == 5;
    }

    public boolean isDataModifyQuery() {
        return false;
    }

    public boolean isDataReadQuery() {
        return false;
    }

    public boolean isDeleteObjectQuery() {
        return false;
    }

    public boolean isExpressionQuery() {
        return this.getQueryMechanism().isExpressionQueryMechanism();
    }

    public boolean isModifyQuery() {
        return false;
    }

    public boolean isUpdateAllQuery() {
        return false;
    }

    public boolean isUpdateObjectQuery() {
        return false;
    }

    public boolean isInsertObjectQuery() {
        return false;
    }

    public boolean isObjectLevelModifyQuery() {
        return false;
    }

    public boolean isObjectLevelReadQuery() {
        return false;
    }

    public boolean isPrepared() {
        return this.isPrepared;
    }

    public boolean isReadAllQuery() {
        return false;
    }

    public boolean isReadObjectQuery() {
        return false;
    }

    public boolean isReadQuery() {
        return false;
    }

    public boolean isReportQuery() {
        return false;
    }

    public boolean isSQLCallQuery() {
        Call call = this.getDatasourceCall();
        return call != null && call instanceof SQLCall;
    }

    public boolean isUserDefined() {
        return this.isUserDefined;
    }

    public boolean isWriteObjectQuery() {
        return false;
    }

    public void maintainCache() {
        this.setShouldMaintainCache(true);
    }

    protected void prepare() throws QueryException {
        if (this.getQueryTimeout() == -1) {
            if (this.getDescriptor() == null) {
                this.setQueryTimeout(0);
            } else {
                this.setQueryTimeout(this.getDescriptor().getQueryManager().getQueryTimeout());
            }
        }
        this.getQueryMechanism().prepare();
    }

    public void prepareCall(oracle.toplink.sessions.Session session, Record record) throws QueryException {
        this.checkPrepare((Session)session, (DatabaseRow)record, true);
    }

    protected void prepareCustomQuery(DatabaseQuery databaseQuery) {
    }

    public void prepareForExecution() throws QueryException {
    }

    protected void prepareForRemoteExecution() {
    }

    public Object redirectQuery(DatabaseQuery databaseQuery, Session session, DatabaseRow databaseRow) {
        if (databaseQuery.getRedirector() == null) {
            return null;
        }
        DatabaseQuery databaseQuery2 = (DatabaseQuery)databaseQuery.clone();
        databaseQuery2.setRedirector(null);
        Object object = databaseQuery.getRedirector().invokeQuery(databaseQuery2, databaseRow, session);
        this.setDescriptor(databaseQuery2.getDescriptor());
        return object;
    }

    protected Object remoteExecute() {
        Transporter transporter = ((RemoteSession)this.getSession()).getRemoteConnection().remoteExecute((DatabaseQuery)this.clone());
        return this.extractRemoteResult(transporter);
    }

    public Object remoteExecute(Session session) {
        this.setSession(session);
        this.prepareForRemoteExecution();
        return this.remoteExecute();
    }

    public void removeProperty(Object object) {
        this.getProperties().remove(object);
    }

    public IdentityHashtable replaceValueHoldersIn(Object object, RemoteSessionController remoteSessionController) {
        return null;
    }

    public DatabaseRow rowFromArguments(Vector vector) throws QueryException {
        Vector vector2 = this.getArguments();
        if (vector2.size() != vector.size()) {
            throw QueryException.argumentSizeMismatchInQueryAndQueryDefinition(this);
        }
        DatabaseRecord databaseRecord = new DatabaseRecord();
        for (int i = 0; i < vector2.size(); ++i) {
            String string = (String)vector2.elementAt(i);
            Object e = vector.elementAt(i);
            databaseRecord.put(new DatabaseField(string), e);
        }
        return databaseRecord;
    }

    public void setAccessor(Accessor accessor) {
        this.accessor = accessor;
    }

    public void setDatasourceCall(Call call) {
        if (call == null) {
            return;
        }
        this.setQueryMechanism(call.buildNewQueryMechanism(this));
    }

    public void setCall(Call call) {
        this.setDatasourceCall(call);
    }

    public void setCascadePolicy(int n) {
        this.cascadePolicy = n;
    }

    public void setDescriptor(Descriptor descriptor) {
        if (this.descriptor != descriptor) {
            this.setIsPrepared(false);
        }
        this.descriptor = descriptor;
    }

    public void setEJBQLString(String string) {
        if (string != null && !string.equals("")) {
            EJBQLCallQueryMechanism eJBQLCallQueryMechanism = new EJBQLCallQueryMechanism(this, new EJBQLCall(string));
            this.setQueryMechanism(eJBQLCallQueryMechanism);
        }
    }

    public void setHintString(String string) {
        this.hintString = string;
        this.setIsPrepared(false);
    }

    public void setIsPrepared(boolean bl) {
        this.isPrepared = bl;
        this.isCustomQueryUsed = null;
    }

    public boolean isExecutionClone() {
        return this.isExecutionClone;
    }

    public void setIsExecutionClone(boolean bl) {
        this.isExecutionClone = bl;
    }

    public Boolean isCustomQueryUsed() {
        return this.isCustomQueryUsed;
    }

    protected void setIsCustomQueryUsed(boolean bl) {
        this.isCustomQueryUsed = bl ? Boolean.TRUE : Boolean.FALSE;
    }

    public void setIsUserDefined(boolean bl) {
        this.isUserDefined = bl;
    }

    public void setName(String string) {
        this.name = string;
    }

    public void setProperties(Hashtable hashtable) {
        this.properties = hashtable;
    }

    public synchronized void setProperty(Object object, Object object2) {
        this.getProperties().put(object, object2);
    }

    protected void setQueryMechanism(DatabaseQueryMechanism databaseQueryMechanism) {
        this.queryMechanism = databaseQueryMechanism;
        this.setIsPrepared(false);
    }

    public void setQueryTimeout(int n) {
        this.queryTimeout = n;
    }

    public void setRedirector(QueryRedirector queryRedirector) {
        this.redirector = queryRedirector;
    }

    public void setSelectionCriteria(Expression expression) {
        if (expression == null && !this.getQueryMechanism().isExpressionQueryMechanism()) {
            return;
        }
        if (!this.getQueryMechanism().isExpressionQueryMechanism()) {
            this.setQueryMechanism(new ExpressionQueryMechanism(this, expression));
        } else {
            ((ExpressionQueryMechanism)this.getQueryMechanism()).setSelectionCriteria(expression);
        }
        this.setIsPrepared(false);
    }

    public void setSession(Session session) {
        this.session = session;
        this.executionSession = null;
    }

    public void setSessionName(String string) {
        this.sessionName = string;
    }

    public void setShouldBindAllParameters(boolean bl) {
        this.shouldBindAllParameters = bl ? 1 : -1;
        this.setIsPrepared(false);
    }

    public void setShouldBindAllParameters(int n) {
        this.shouldBindAllParameters = n;
    }

    public void setShouldCacheStatement(boolean bl) {
        this.shouldCacheStatement = bl ? 1 : -1;
        this.setIsPrepared(false);
    }

    public void setShouldMaintainCache(boolean bl) {
        this.shouldMaintainCache = bl;
    }

    public void setShouldPrepare(boolean bl) {
        this.shouldPrepare = bl;
        this.setIsPrepared(false);
    }

    public void setShouldUseWrapperPolicy(boolean bl) {
        this.shouldUseWrapperPolicy = bl;
    }

    public void setSQLStatement(SQLStatement sQLStatement) {
        this.setQueryMechanism(new StatementQueryMechanism(this, sQLStatement));
    }

    public void setSQLString(String string) {
        if (string != null && !string.equals("")) {
            this.setCall(new SQLCall(string));
        }
    }

    public void setTranslationRow(DatabaseRow databaseRow) {
        this.translationRow = databaseRow;
    }

    public boolean shouldBindAllParameters() {
        return this.shouldBindAllParameters == 1;
    }

    public boolean shouldCacheStatement() {
        return this.shouldCacheStatement == 1;
    }

    public boolean shouldCascadeAllParts() {
        return this.getCascadePolicy() == 3;
    }

    public boolean shouldCascadeByMapping() {
        return this.getCascadePolicy() == 6;
    }

    public boolean shouldCascadeOnlyDependentParts() {
        return this.getCascadePolicy() == 4;
    }

    public boolean shouldCascadeParts() {
        return this.getCascadePolicy() != 1;
    }

    public boolean shouldCascadePrivateParts() {
        return this.getCascadePolicy() == 2 || this.getCascadePolicy() == 3;
    }

    public boolean shouldIgnoreBindAllParameters() {
        return this.shouldBindAllParameters == 0;
    }

    public boolean shouldIgnoreCacheStatement() {
        return this.shouldCacheStatement == 0;
    }

    public boolean shouldMaintainCache() {
        return this.shouldMaintainCache;
    }

    public boolean shouldPrepare() {
        return this.shouldPrepare;
    }

    public boolean shouldUseWrapperPolicy() {
        return this.shouldUseWrapperPolicy;
    }

    public String toString() {
        return Helper.getShortClassName(this.getClass()) + "()";
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

