/*
 * Decompiled with CFR 0.152.
 */
package oracle.toplink.queryframework;

import java.io.Serializable;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Enumeration;
import java.util.Vector;
import oracle.toplink.exceptions.DatabaseException;
import oracle.toplink.exceptions.QueryException;
import oracle.toplink.expressions.Expression;
import oracle.toplink.internal.databaseaccess.DatabaseAccessor;
import oracle.toplink.internal.databaseaccess.DatabaseCall;
import oracle.toplink.internal.helper.IdentityHashtable;
import oracle.toplink.internal.helper.InvalidObject;
import oracle.toplink.publicinterface.DatabaseRow;
import oracle.toplink.publicinterface.Session;
import oracle.toplink.publicinterface.UnitOfWork;
import oracle.toplink.queryframework.CursorPolicy;
import oracle.toplink.queryframework.ObjectLevelReadQuery;
import oracle.toplink.queryframework.ReadQuery;
import oracle.toplink.queryframework.ScrollableCursor;

public abstract class Cursor
implements Enumeration,
Serializable {
    protected transient Statement statement;
    protected transient ResultSet resultSet;
    protected transient Session session;
    protected transient Session executionSession;
    protected transient Vector fields;
    protected int size = -1;
    public transient CursorPolicy policy;
    protected Vector objectCollection;
    protected IdentityHashtable initiallyConformingIndex;
    protected Expression selectionCriteriaClone;
    protected DatabaseRow translationRow;
    protected int position;

    public Cursor() {
    }

    public Cursor(DatabaseCall databaseCall, CursorPolicy cursorPolicy) {
        this.session = cursorPolicy.getQuery().getSession();
        this.executionSession = this.session.getExecutionSession(cursorPolicy.getQuery());
        this.statement = databaseCall.getStatement();
        this.fields = databaseCall.getFields();
        this.resultSet = databaseCall.getResult();
        this.policy = cursorPolicy;
        this.setObjectCollection(new Vector());
        if (this.getQuery().getSession().isUnitOfWork() && this.getQuery().isObjectLevelReadQuery()) {
            ObjectLevelReadQuery objectLevelReadQuery = (ObjectLevelReadQuery)this.getQuery();
            objectLevelReadQuery.registerResultInUnitOfWork(this, (UnitOfWork)this.session, this.getQuery().getTranslationRow(), false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public void close() throws DatabaseException {
        RuntimeException runtimeException = null;
        try {
            block17: {
                block14: {
                    if (this.isClosed()) {
                        return;
                    }
                    this.getAccessor().closeCursor(this.getResultSet());
                    this.getAccessor().closeStatement(this.getStatement(), this.getSession());
                    Object var4_2 = null;
                    try {
                        this.getSession().releaseReadConnection(this.getQuery().getAccessor());
                    }
                    catch (RuntimeException runtimeException2) {
                        if (runtimeException != null) break block14;
                        throw runtimeException2;
                    }
                }
                if (runtimeException != null) {
                    throw runtimeException;
                }
                break block17;
                {
                    catch (RuntimeException runtimeException3) {
                        block15: {
                            runtimeException = runtimeException3;
                            Object var4_3 = null;
                            try {
                                this.getSession().releaseReadConnection(this.getQuery().getAccessor());
                            }
                            catch (RuntimeException runtimeException4) {
                                if (runtimeException != null) break block15;
                                throw runtimeException4;
                            }
                        }
                        if (runtimeException != null) {
                            throw runtimeException;
                        }
                    }
                }
                catch (Throwable throwable) {
                    block16: {
                        Object var4_4 = null;
                        try {
                            this.getSession().releaseReadConnection(this.getQuery().getAccessor());
                        }
                        catch (RuntimeException runtimeException5) {
                            if (runtimeException != null) break block16;
                            throw runtimeException5;
                        }
                    }
                    if (runtimeException != null) {
                        throw runtimeException;
                    }
                    throw throwable;
                }
            }
            this.setResultSet(null);
        }
        catch (SQLException sQLException) {
            throw DatabaseException.sqlException(sQLException);
        }
    }

    protected void finalize() throws DatabaseException {
        this.close();
    }

    protected DatabaseAccessor getAccessor() {
        try {
            return (DatabaseAccessor)this.getQuery().getAccessor();
        }
        catch (ClassCastException classCastException) {
            throw QueryException.invalidDatabaseAccessor(this.getQuery().getAccessor());
        }
    }

    protected abstract int getCursorSize() throws DatabaseException, QueryException;

    protected Vector getFields() {
        return this.fields;
    }

    public IdentityHashtable getInitiallyConformingIndex() {
        return this.initiallyConformingIndex;
    }

    public Vector getObjectCollection() {
        return this.objectCollection;
    }

    public int getPageSize() {
        return this.getPolicy().getPageSize();
    }

    public CursorPolicy getPolicy() {
        return this.policy;
    }

    public abstract int getPosition();

    public ReadQuery getQuery() {
        return this.getPolicy().getQuery();
    }

    public ResultSet getResultSet() {
        return this.resultSet;
    }

    public Expression getSelectionCriteriaClone() {
        return this.selectionCriteriaClone;
    }

    public Session getSession() {
        return this.session;
    }

    protected Session getExecutionSession() {
        return this.executionSession;
    }

    protected Statement getStatement() {
        return this.statement;
    }

    protected DatabaseRow getTranslationRow() {
        return this.translationRow;
    }

    public boolean isClosed() {
        return this.getResultSet() == null;
    }

    protected Object buildAndRegisterObject(DatabaseRow databaseRow) {
        Object object = null;
        if (this.getSession().isUnitOfWork() && !this.getQuery().isReportQuery() && this.getQuery().shouldMaintainCache() && this.getQuery().isObjectLevelReadQuery()) {
            UnitOfWork unitOfWork = (UnitOfWork)this.getSession();
            ObjectLevelReadQuery objectLevelReadQuery = (ObjectLevelReadQuery)this.getQuery();
            if (objectLevelReadQuery.shouldConformResultsInUnitOfWork() || objectLevelReadQuery.getDescriptor().shouldAlwaysConformResultsInUnitOfWork()) {
                object = objectLevelReadQuery.conformIndividualResult(databaseRow, unitOfWork, this.getTranslationRow(), this.getSelectionCriteriaClone(), this.getInitiallyConformingIndex(), true);
                if (object == null) {
                    return InvalidObject.instance;
                }
            } else {
                object = objectLevelReadQuery.buildObject(databaseRow);
            }
        } else {
            object = this.getQuery().buildObject(databaseRow);
        }
        return object;
    }

    protected Object retrieveNextObject() throws DatabaseException {
        DatabaseRow databaseRow;
        Object object;
        do {
            if (this.isClosed()) {
                return null;
            }
            databaseRow = this.getAccessor().cursorRetrieveNextRow(this.getFields(), this.getResultSet(), this.getExecutionSession());
            if (databaseRow != null) continue;
            if (!(this instanceof ScrollableCursor)) {
                this.close();
            }
            return null;
        } while ((object = this.buildAndRegisterObject(databaseRow)) == InvalidObject.instance);
        return object;
    }

    protected Object retrievePreviousObject() throws DatabaseException {
        DatabaseRow databaseRow;
        Object object;
        do {
            if (this.isClosed()) {
                return null;
            }
            databaseRow = this.getAccessor().cursorRetrievePreviousRow(this.getFields(), this.getResultSet(), this.getExecutionSession());
            if (databaseRow != null) continue;
            if (!(this instanceof ScrollableCursor)) {
                this.close();
            }
            return null;
        } while ((object = this.buildAndRegisterObject(databaseRow)) == InvalidObject.instance);
        return object;
    }

    protected void setFields(Vector vector) {
        this.fields = vector;
    }

    public void setInitiallyConformingIndex(IdentityHashtable identityHashtable) {
        this.initiallyConformingIndex = identityHashtable;
    }

    public void setObjectCollection(Vector vector) {
        this.objectCollection = vector;
    }

    public void setPolicy(CursorPolicy cursorPolicy) {
        this.policy = cursorPolicy;
    }

    protected void setPosition(int n) {
        this.position = n;
    }

    protected void setResultSet(ResultSet resultSet) {
        this.resultSet = resultSet;
    }

    public void setSelectionCriteriaClone(Expression expression) {
        this.selectionCriteriaClone = expression;
    }

    public void setSession(Session session) {
        this.session = session;
    }

    protected void setExecutionSession(Session session) {
        this.executionSession = session;
    }

    public void setSize(int n) {
        this.size = n;
    }

    public void setTranslationRow(DatabaseRow databaseRow) {
        this.translationRow = databaseRow;
    }

    public int size() throws DatabaseException {
        if (this.size == -1) {
            this.size = this.getCursorSize();
            if (this.getInitiallyConformingIndex() != null) {
                this.size += this.getInitiallyConformingIndex().size();
            }
        }
        return this.size;
    }
}

