/*
 * Decompiled with CFR 0.152.
 */
package oracle.toplink.publicinterface;

import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Vector;
import oracle.toplink.descriptors.CMPPolicy;
import oracle.toplink.descriptors.ClassExtractor;
import oracle.toplink.descriptors.MethodClassExtractor;
import oracle.toplink.descriptors.PessimisticLockingPolicy;
import oracle.toplink.descriptors.ReturningPolicy;
import oracle.toplink.exceptions.DatabaseException;
import oracle.toplink.exceptions.DescriptorException;
import oracle.toplink.exceptions.QueryException;
import oracle.toplink.expressions.Expression;
import oracle.toplink.expressions.ExpressionBuilder;
import oracle.toplink.internal.descriptors.OptimisticLockingPolicy;
import oracle.toplink.internal.expressions.SQLSelectStatement;
import oracle.toplink.internal.helper.ClassConstants;
import oracle.toplink.internal.helper.ConversionManager;
import oracle.toplink.internal.helper.DatabaseField;
import oracle.toplink.internal.helper.DatabaseTable;
import oracle.toplink.internal.helper.Helper;
import oracle.toplink.internal.helper.IdentityHashtable;
import oracle.toplink.internal.helper.NonSynchronizedVector;
import oracle.toplink.internal.queryframework.ExpressionQueryMechanism;
import oracle.toplink.mappings.Association;
import oracle.toplink.mappings.TypedAssociation;
import oracle.toplink.publicinterface.DatabaseRow;
import oracle.toplink.publicinterface.Descriptor;
import oracle.toplink.publicinterface.Session;
import oracle.toplink.queryframework.DatabaseQuery;
import oracle.toplink.queryframework.ObjectLevelReadQuery;
import oracle.toplink.queryframework.ReadAllQuery;
import oracle.toplink.queryframework.ReadObjectQuery;
import oracle.toplink.remote.DistributedSession;

public class InheritancePolicy
implements Serializable,
Cloneable {
    protected Class parentClass;
    protected String parentClassName;
    protected Descriptor parentDescriptor;
    protected Vector childDescriptors;
    protected transient DatabaseField classIndicatorField;
    protected transient Map classIndicatorMapping = new HashMap(10);
    protected transient Map classNameIndicatorMapping = new HashMap(10);
    protected transient boolean shouldUseClassNameAsIndicator = false;
    protected transient Boolean shouldReadSubclasses;
    protected transient boolean hasMultipleTableChild;
    protected transient DatabaseTable readAllSubclassesView;
    protected transient Vector allChildClassIndicators = NonSynchronizedVector.newInstance();
    protected transient Expression onlyInstancesExpression;
    protected transient Expression withAllSubclassesExpression;
    protected transient ClassExtractor classExtractor;
    protected Descriptor descriptor;
    protected boolean shouldAlwaysUseOuterJoin;
    protected boolean useDescriptorsToValidateInheritedObjects;

    public InheritancePolicy() {
        this.childDescriptors = NonSynchronizedVector.newInstance(5);
    }

    public InheritancePolicy(Descriptor descriptor) {
        this();
        this.descriptor = descriptor;
    }

    public void addChildDescriptor(Descriptor descriptor) {
        this.getChildDescriptors().addElement(descriptor);
    }

    public void addClassIndicator(Class clazz, Object object) {
        this.getClassIndicatorMapping().put(object, clazz);
        this.getClassIndicatorMapping().put(clazz, object);
    }

    public void addClassNameIndicator(String string, Object object) {
        this.getClassNameIndicatorMapping().put(string, object);
    }

    public void addClassIndicatorFieldToInsertRow(DatabaseRow databaseRow) {
        if (this.hasClassExtractor()) {
            return;
        }
        DatabaseField databaseField = this.getClassIndicatorField();
        databaseRow.put(databaseField, (Object)null);
    }

    public void addClassIndicatorFieldToRow(DatabaseRow databaseRow) {
        if (this.hasClassExtractor()) {
            return;
        }
        DatabaseField databaseField = this.getClassIndicatorField();
        Object object = this.getClassIndicatorValue();
        databaseRow.put(databaseField, object);
    }

    protected void addClassIndicatorTypeToParent(Object object) {
        Descriptor descriptor = this.getDescriptor().getInheritancePolicy().getParentDescriptor();
        if (descriptor.getInheritancePolicy().isChildDescriptor()) {
            if (descriptor.getInheritancePolicy().shouldReadSubclasses()) {
                descriptor.getInheritancePolicy().getAllChildClassIndicators().addElement(object);
            }
            descriptor.getInheritancePolicy().addClassIndicatorTypeToParent(object);
        }
    }

    protected void addFieldsToParent(Vector vector) {
        if (this.isChildDescriptor()) {
            if (this.getParentDescriptor().isInvalid()) {
                return;
            }
            Descriptor descriptor = this.getParentDescriptor();
            if (descriptor.getInheritancePolicy().shouldReadSubclasses()) {
                Helper.addAllUniqueToVector(descriptor.getAllFields(), vector);
            }
            descriptor.getInheritancePolicy().addFieldsToParent(vector);
        }
    }

    public SQLSelectStatement buildClassIndicatorSelectStatement(ObjectLevelReadQuery objectLevelReadQuery) {
        Cloneable cloneable;
        SQLSelectStatement sQLSelectStatement = new SQLSelectStatement();
        sQLSelectStatement.useDistinct();
        sQLSelectStatement.addTable(this.classIndicatorField.getTable());
        sQLSelectStatement.addField(this.getClassIndicatorField());
        IdentityHashtable identityHashtable = new IdentityHashtable();
        sQLSelectStatement.setWhereClause(((ExpressionQueryMechanism)objectLevelReadQuery.getQueryMechanism()).buildBaseSelectionCriteria(false, identityHashtable));
        this.appendWithAllSubclassesExpression(sQLSelectStatement);
        sQLSelectStatement.setTranslationRow(objectLevelReadQuery.getTranslationRow());
        if (objectLevelReadQuery.isReadAllQuery() && ((ReadAllQuery)objectLevelReadQuery).hasHierarchicalExpressions()) {
            cloneable = (ReadAllQuery)objectLevelReadQuery;
            sQLSelectStatement.setHierarchicalQueryExpressions(cloneable.getStartWithExpression(), cloneable.getConnectByExpression(), cloneable.getOrderSiblingsByExpressions());
        }
        sQLSelectStatement.setHintString(objectLevelReadQuery.getHintString());
        sQLSelectStatement.normalize(objectLevelReadQuery.getSession(), this.getDescriptor(), identityHashtable);
        cloneable = (ExpressionQueryMechanism)objectLevelReadQuery.getQueryMechanism();
        return sQLSelectStatement;
    }

    public void appendWithAllSubclassesExpression(SQLSelectStatement sQLSelectStatement) {
        if (this.getWithAllSubclassesExpression() != null) {
            if (sQLSelectStatement.getWhereClause() == null) {
                sQLSelectStatement.setWhereClause((Expression)this.getWithAllSubclassesExpression().clone());
            } else {
                sQLSelectStatement.setWhereClause(sQLSelectStatement.getWhereClause().and(this.getWithAllSubclassesExpression()));
            }
        }
    }

    public SQLSelectStatement buildViewSelectStatement(ObjectLevelReadQuery objectLevelReadQuery) {
        Expression expression;
        IdentityHashtable identityHashtable = new IdentityHashtable();
        ExpressionQueryMechanism expressionQueryMechanism = (ExpressionQueryMechanism)objectLevelReadQuery.getQueryMechanism();
        SQLSelectStatement sQLSelectStatement = expressionQueryMechanism.buildBaseSelectStatement(false, identityHashtable);
        sQLSelectStatement.setTables(NonSynchronizedVector.newInstance(1));
        sQLSelectStatement.addTable(this.getReadAllSubclassesView());
        if (this.getWithAllSubclassesExpression() != null && (expression = (Expression)this.getWithAllSubclassesExpression().clone()) != null) {
            sQLSelectStatement.setWhereClause(expression.and(sQLSelectStatement.getWhereClause()));
        }
        sQLSelectStatement.setFields(expressionQueryMechanism.getSelectionFields(sQLSelectStatement, true));
        sQLSelectStatement.normalizeForView(objectLevelReadQuery.getSession(), this.getDescriptor(), identityHashtable);
        objectLevelReadQuery.computeJoiningMappingIndexes(false);
        return sQLSelectStatement;
    }

    public Class classFromRow(DatabaseRow databaseRow, Session session) throws DescriptorException {
        Class<?> clazz;
        if (this.hasClassExtractor()) {
            return this.getClassExtractor().extractClassFromRow(databaseRow, session);
        }
        Object object = session.getDatasourcePlatform().getConversionManager().convertObject(databaseRow.get(this.getClassIndicatorField()), this.getClassIndicatorField().getType());
        if (object == null) {
            throw DescriptorException.missingClassIndicatorField(databaseRow, this.getDescriptor());
        }
        if (!this.shouldUseClassNameAsIndicator()) {
            clazz = (Class<?>)this.getClassIndicatorMapping().get(object);
            if (clazz == null) {
                throw DescriptorException.missingClassForIndicatorFieldValue(object, this.getDescriptor());
            }
        } else {
            try {
                String string = (String)object;
                clazz = this.getDescriptor().getJavaClass().getClassLoader().loadClass(string);
                if (clazz == null) {
                    throw DescriptorException.missingClassForIndicatorFieldValue(object, this.getDescriptor());
                }
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw DescriptorException.missingClassForIndicatorFieldValue(object, this.getDescriptor());
            }
            catch (ClassCastException classCastException) {
                throw DescriptorException.missingClassForIndicatorFieldValue(object, this.getDescriptor());
            }
        }
        return clazz;
    }

    public Object clone() {
        InheritancePolicy inheritancePolicy = null;
        try {
            inheritancePolicy = (InheritancePolicy)super.clone();
            if (this.hasClassIndicator()) {
                inheritancePolicy.setClassIndicatorField((DatabaseField)inheritancePolicy.getClassIndicatorField().clone());
            }
        }
        catch (Exception exception) {
            throw new InternalError("clone failed");
        }
        return inheritancePolicy;
    }

    public void dontReadSubclassesOnQueries() {
        this.setShouldReadSubclasses(false);
    }

    public void dontUseClassNameAsIndicator() {
        this.setShouldUseClassNameAsIndicator(false);
    }

    protected Vector getAllChildClassIndicators() {
        return this.allChildClassIndicators;
    }

    public Vector getAllChildDescriptors() {
        Vector vector = new Vector(this.getAllChildClassIndicators().size());
        return this.getAllChildDescriptors(vector);
    }

    private Vector getAllChildDescriptors(Vector vector) {
        Enumeration enumeration = this.getChildDescriptors().elements();
        while (enumeration.hasMoreElements()) {
            Descriptor descriptor = (Descriptor)enumeration.nextElement();
            vector.addElement(descriptor);
            descriptor.getInheritancePolicyOrNull().getAllChildDescriptors(vector);
        }
        return vector;
    }

    public Vector getChildDescriptors() {
        return this.childDescriptors;
    }

    protected Method getClassExtractionMethod() {
        if (this.classExtractor instanceof MethodClassExtractor) {
            return ((MethodClassExtractor)this.classExtractor).getClassExtractionMethod();
        }
        return null;
    }

    public String getClassExtractionMethodName() {
        if (this.classExtractor instanceof MethodClassExtractor) {
            return ((MethodClassExtractor)this.classExtractor).getClassExtractionMethodName();
        }
        return null;
    }

    public ClassExtractor getClassExtractor() {
        return this.classExtractor;
    }

    public void setClassExtractor(ClassExtractor classExtractor) {
        this.classExtractor = classExtractor;
    }

    public Vector getClassIndicatorAssociations() {
        Vector<TypedAssociation> vector = new Vector<TypedAssociation>(this.getClassNameIndicatorMapping().size() / 2);
        Iterator iterator = this.getClassNameIndicatorMapping().keySet().iterator();
        Iterator iterator2 = this.getClassNameIndicatorMapping().values().iterator();
        while (iterator.hasNext()) {
            Object object = iterator.next();
            if (object instanceof Class) {
                object = ((Class)object).getName();
            }
            Object v = iterator2.next();
            vector.addElement(new TypedAssociation(object, v));
        }
        return vector;
    }

    public DatabaseField getClassIndicatorField() {
        return this.classIndicatorField;
    }

    public String getClassIndicatorFieldName() {
        if (this.getClassIndicatorField() == null) {
            return null;
        }
        return this.getClassIndicatorField().getQualifiedName();
    }

    public Map getClassIndicatorMapping() {
        if (this.classIndicatorMapping.isEmpty() && !this.classNameIndicatorMapping.isEmpty()) {
            Iterator iterator = this.classNameIndicatorMapping.keySet().iterator();
            Iterator iterator2 = this.classNameIndicatorMapping.values().iterator();
            while (iterator.hasNext()) {
                Object k = iterator.next();
                Object v = iterator2.next();
                Class clazz = (Class)ConversionManager.getDefaultManager().convertObject((String)k, ClassConstants.CLASS);
                this.classIndicatorMapping.put(clazz, v);
                this.classIndicatorMapping.put(v, clazz);
            }
        }
        return this.classIndicatorMapping;
    }

    public Map getClassNameIndicatorMapping() {
        if (this.classNameIndicatorMapping.isEmpty() && !this.classIndicatorMapping.isEmpty()) {
            Iterator iterator = this.classIndicatorMapping.keySet().iterator();
            Iterator iterator2 = this.classIndicatorMapping.values().iterator();
            while (iterator.hasNext()) {
                Object k = iterator.next();
                Object v = iterator2.next();
                if (!(k instanceof Class)) continue;
                String string = ((Class)k).getName();
                this.classNameIndicatorMapping.put(string, v);
            }
        }
        return this.classNameIndicatorMapping;
    }

    protected Object getClassIndicatorValue() {
        return this.getClassIndicatorValue(this.getDescriptor().getJavaClass());
    }

    protected Object getClassIndicatorValue(Class clazz) {
        if (this.shouldUseClassNameAsIndicator()) {
            return clazz.getName();
        }
        return this.getClassIndicatorMapping().get(clazz);
    }

    protected Descriptor getDescriptor() {
        return this.descriptor;
    }

    public Expression getOnlyInstancesExpression() {
        return this.onlyInstancesExpression;
    }

    public Class getParentClass() {
        return this.parentClass;
    }

    public String getParentClassName() {
        if (this.parentClassName == null && this.parentClass != null) {
            this.parentClassName = this.parentClass.getName();
        }
        return this.parentClassName;
    }

    public Descriptor getParentDescriptor() {
        return this.parentDescriptor;
    }

    public DatabaseTable getReadAllSubclassesView() {
        return this.readAllSubclassesView;
    }

    public String getReadAllSubclassesViewName() {
        if (this.getReadAllSubclassesView() == null) {
            return null;
        }
        return this.getReadAllSubclassesView().getName();
    }

    public Descriptor getRootParentDescriptor() {
        if (this.isRootParentDescriptor()) {
            return this.getDescriptor();
        }
        return this.getParentDescriptor().getInheritancePolicy().getRootParentDescriptor();
    }

    public Descriptor getSubclassDescriptor(Class clazz) {
        if (this.hasChildren()) {
            Enumeration enumeration = this.getChildDescriptors().elements();
            while (enumeration.hasMoreElements()) {
                Descriptor descriptor = (Descriptor)enumeration.nextElement();
                if (descriptor.getJavaClass().equals(clazz)) {
                    return descriptor;
                }
                Descriptor descriptor2 = descriptor.getInheritancePolicy().getSubclassDescriptor(clazz);
                if (descriptor2 == null) continue;
                return descriptor2;
            }
        }
        return null;
    }

    public boolean getUseDescriptorsToValidateInheritedObjects() {
        return this.useDescriptorsToValidateInheritedObjects;
    }

    public Expression getWithAllSubclassesExpression() {
        return this.withAllSubclassesExpression;
    }

    public boolean hasChildren() {
        return !this.getChildDescriptors().isEmpty();
    }

    public boolean hasClassExtractor() {
        return this.getClassExtractor() != null;
    }

    public boolean hasClassIndicator() {
        return this.getClassIndicatorField() != null;
    }

    public boolean hasMultipleTableChild() {
        return this.hasMultipleTableChild;
    }

    public boolean hasView() {
        return this.getReadAllSubclassesView() != null;
    }

    public void initialize(Session session) {
        if (this.shouldReadSubclasses == null || this.shouldReadSubclasses()) {
            this.setShouldReadSubclasses(!this.getChildDescriptors().isEmpty());
        }
        if (this.isChildDescriptor()) {
            CMPPolicy cMPPolicy;
            this.getDescriptor().setMappings(Helper.concatenateVectors(this.getParentDescriptor().getMappings(), this.getDescriptor().getMappings()));
            this.getDescriptor().setQueryKeys(Helper.concatenateMaps(this.getParentDescriptor().getQueryKeys(), this.getDescriptor().getQueryKeys()));
            this.addFieldsToParent(this.getDescriptor().getFields());
            Vector vector = (Vector)this.getParentDescriptor().getFields().clone();
            Helper.addAllUniqueToVector(vector, this.getDescriptor().getFields());
            this.getDescriptor().setFields(vector);
            if (this.getClassIndicatorValue() != null) {
                if (this.shouldReadSubclasses()) {
                    this.getAllChildClassIndicators().addElement(this.getClassIndicatorValue());
                }
                this.addClassIndicatorTypeToParent(this.getClassIndicatorValue());
            }
            if (!this.getDescriptor().usesOptimisticLocking() && this.getParentDescriptor().usesOptimisticLocking()) {
                this.getDescriptor().setOptimisticLockingPolicy((OptimisticLockingPolicy)this.getParentDescriptor().getOptimisticLockingPolicy().clone());
                this.getDescriptor().getOptimisticLockingPolicy().setDescriptor(this.getDescriptor());
            }
            if (!this.getDescriptor().hasReturningPolicy() && this.getParentDescriptor().hasReturningPolicy()) {
                this.getDescriptor().setReturningPolicy(new ReturningPolicy());
            }
            if ((cMPPolicy = this.getDescriptor().getInheritancePolicy().getParentDescriptor().getCMPPolicy()) != null) {
                CMPPolicy cMPPolicy2 = this.getDescriptor().getCMPPolicy();
                if (cMPPolicy2 == null) {
                    cMPPolicy2 = new CMPPolicy();
                    this.getDescriptor().setCMPPolicy(cMPPolicy2);
                }
                if (cMPPolicy.hasPessimisticLockingPolicy() && !cMPPolicy2.hasPessimisticLockingPolicy()) {
                    cMPPolicy2.setPessimisticLockingPolicy((PessimisticLockingPolicy)cMPPolicy.getPessimisticLockingPolicy().clone());
                }
                if (cMPPolicy2.internalGetForceUpdate() == 0) {
                    cMPPolicy2.internalSetForceUpdate(cMPPolicy.internalGetForceUpdate());
                }
                if (cMPPolicy2.internalGetUpdateAllFields() == 0) {
                    cMPPolicy2.internalSetUpdateAllFields(cMPPolicy.internalGetUpdateAllFields());
                }
            }
        }
        this.initializeOnlyInstancesExpression();
        this.initializeWithAllSubclassesExpression();
    }

    protected void initializeClassExtractor(Session session) throws DescriptorException {
        if (this.getClassExtractor() == null) {
            if (this.isChildDescriptor()) {
                this.setClassExtractor(this.getParentDescriptor().getInheritancePolicy().getClassExtractor());
            }
        } else {
            this.getClassExtractor().initialize(this.getDescriptor(), session);
        }
    }

    protected void initializeOnlyInstancesExpression() throws DescriptorException {
        if (this.getOnlyInstancesExpression() == null) {
            if (this.hasClassExtractor()) {
                return;
            }
            Object object = this.getClassIndicatorValue();
            if (object == null) {
                if (this.shouldReadSubclasses()) {
                    return;
                }
                throw DescriptorException.valueNotFoundInClassIndicatorMapping(this.getParentDescriptor(), this.getDescriptor());
            }
            DatabaseField databaseField = this.getClassIndicatorField();
            if (databaseField == null) {
                throw DescriptorException.classIndicatorFieldNotFound(this.getParentDescriptor(), this.getDescriptor());
            }
            if (this.shouldAlwaysUseOuterJoin()) {
                this.setOnlyInstancesExpression(new ExpressionBuilder().getField(databaseField).equalOuterJoin(object));
            } else {
                this.setOnlyInstancesExpression(new ExpressionBuilder().getField(databaseField).equal(object));
            }
        }
        if (!this.shouldReadSubclasses()) {
            this.getDescriptor().getQueryManager().setAdditionalJoinExpression(this.getOnlyInstancesExpression().and(this.getDescriptor().getQueryManager().getAdditionalJoinExpression()));
        }
    }

    protected void initializeWithAllSubclassesExpression() throws DescriptorException {
        if (this.getWithAllSubclassesExpression() == null) {
            if (this.hasClassExtractor()) {
                return;
            }
            if (this.isChildDescriptor() && this.shouldReadSubclasses()) {
                this.setWithAllSubclassesExpression(new ExpressionBuilder().getField(this.getClassIndicatorField()).in(this.getAllChildClassIndicators()));
            }
        }
    }

    public boolean isChildDescriptor() {
        return this.getParentClassName() != null;
    }

    public boolean isRootParentDescriptor() {
        return this.getParentDescriptor() == null;
    }

    public void postInitialize(Session session) {
        this.setHasMultipleTableChild(false);
        if (this.hasChildren()) {
            Enumeration enumeration = this.getChildDescriptors().elements();
            while (enumeration.hasMoreElements()) {
                Descriptor descriptor = (Descriptor)enumeration.nextElement();
                if (descriptor.getTables().size() <= this.getDescriptor().getTables().size() && !descriptor.getInheritancePolicy().hasMultipleTableChild()) continue;
                this.setHasMultipleTableChild(true);
            }
        }
    }

    public void preInitialize(Session session) throws DescriptorException {
        Object object;
        Object object2;
        Serializable serializable;
        if (this.isChildDescriptor()) {
            this.getDescriptor().setTables(Helper.concatenateUniqueVectors(this.getParentDescriptor().getTables(), this.getDescriptor().getTables()));
            this.setClassIndicatorMapping(this.getParentDescriptor().getInheritancePolicy().getClassIndicatorMapping());
            this.setShouldUseClassNameAsIndicator(this.getParentDescriptor().getInheritancePolicy().shouldUseClassNameAsIndicator());
            this.getDescriptor().setPrimaryKeyFields(this.getParentDescriptor().getPrimaryKeyFields());
            this.getDescriptor().setAdditionalTablePrimaryKeyFields(Helper.concatenateMaps(this.getParentDescriptor().getAdditionalTablePrimaryKeyFields(), this.getDescriptor().getAdditionalTablePrimaryKeyFields()));
            serializable = this.getDescriptor().getQueryManager().getMultipleTableJoinExpression();
            object2 = this.getParentDescriptor().getQueryManager().getMultipleTableJoinExpression();
            if (serializable != null) {
                this.getDescriptor().getQueryManager().setInternalMultipleTableJoinExpression(((Expression)serializable).and((Expression)object2));
            } else if (object2 != null) {
                this.getDescriptor().getQueryManager().setInternalMultipleTableJoinExpression((Expression)object2);
            }
            object = this.getDescriptor().getQueryManager().getAdditionalJoinExpression();
            Expression expression = this.getParentDescriptor().getQueryManager().getAdditionalJoinExpression();
            if (object != null) {
                this.getDescriptor().getQueryManager().setAdditionalJoinExpression(((Expression)object).and(expression));
            } else if (expression != null) {
                this.getDescriptor().getQueryManager().setAdditionalJoinExpression(expression);
            }
            this.setClassIndicatorField(this.getParentDescriptor().getInheritancePolicy().getClassIndicatorField());
            if (!this.getDescriptor().usesSequenceNumbers()) {
                this.getDescriptor().setSequenceNumberField(this.getParentDescriptor().getSequenceNumberField());
                this.getDescriptor().setSequenceNumberName(this.getParentDescriptor().getSequenceNumberName());
            }
        }
        this.initializeClassExtractor(session);
        if (!this.isChildDescriptor()) {
            if (this.getClassIndicatorField() == null && !this.hasClassExtractor()) {
                session.getIntegrityChecker().handleError(DescriptorException.classIndicatorFieldNotFound(this.getDescriptor(), this.getDescriptor()));
            }
            if (this.getClassIndicatorField() != null) {
                this.getDescriptor().buildField(this.getClassIndicatorField());
                if (this.shouldUseClassNameAsIndicator()) {
                    this.getClassIndicatorField().setType(ClassConstants.STRING);
                } else if (!this.getClassIndicatorMapping().isEmpty()) {
                    serializable = null;
                    object2 = this.getClassIndicatorMapping().values().iterator();
                    while (object2.hasNext() && serializable == null) {
                        object = object2.next();
                        if (object.getClass() == this.getClass().getClass()) continue;
                        serializable = object.getClass();
                    }
                    this.getClassIndicatorField().setType((Class)serializable);
                }
                this.getDescriptor().getFields().addElement(this.getClassIndicatorField());
            }
        }
    }

    public void readSubclassesOnQueries() {
        this.setShouldReadSubclasses(true);
    }

    public void remoteInitialization(DistributedSession distributedSession) {
        if (this.isChildDescriptor()) {
            if (distributedSession.hasCorrespondingDescriptor(this.getParentDescriptor())) {
                this.setParentDescriptor(distributedSession.getDescriptor(this.getParentClass()));
            } else {
                distributedSession.privilegedAddDescriptor(this.getParentDescriptor());
                this.getParentDescriptor().remoteInitialization(distributedSession);
            }
        }
        Vector<Descriptor> vector = new Vector<Descriptor>(this.getChildDescriptors().size());
        Enumeration enumeration = this.getChildDescriptors().elements();
        while (enumeration.hasMoreElements()) {
            Descriptor descriptor = (Descriptor)enumeration.nextElement();
            if (distributedSession.hasCorrespondingDescriptor(descriptor)) {
                vector.addElement(distributedSession.getDescriptor(descriptor.getJavaClass()));
                continue;
            }
            distributedSession.privilegedAddDescriptor(descriptor);
            descriptor.remoteInitialization(distributedSession);
            vector.addElement(descriptor);
        }
        this.setChildDescriptors(vector);
    }

    public boolean requiresMultipleTableSubclassRead() {
        return this.hasMultipleTableChild() && this.shouldReadSubclasses();
    }

    protected Vector selectAllRowUsingCustomMultipleTableSubclassRead(ReadAllQuery readAllQuery) throws DatabaseException {
        Cloneable cloneable;
        Object object;
        Vector vector = new Vector();
        if (this.getOnlyInstancesExpression() != null || !this.shouldReadSubclasses()) {
            object = (ReadAllQuery)readAllQuery.clone();
            ((ObjectLevelReadQuery)object).setReferenceClass(this.getDescriptor().getJavaClass());
            ((DatabaseQuery)object).setDescriptor(this.getDescriptor());
            cloneable = ((ExpressionQueryMechanism)((DatabaseQuery)object).getQueryMechanism()).selectAllRowsFromConcreteTable();
            vector = Helper.concatenateVectors(vector, (Vector)cloneable);
        }
        object = this.getChildDescriptors().elements();
        while (object.hasMoreElements()) {
            cloneable = (Descriptor)object.nextElement();
            Vector vector2 = cloneable.getInheritancePolicy().selectAllRowUsingCustomMultipleTableSubclassRead(readAllQuery);
            vector = Helper.concatenateVectors(vector, vector2);
        }
        return vector;
    }

    protected Vector selectAllRowUsingDefaultMultipleTableSubclassRead(ReadAllQuery readAllQuery) throws DatabaseException, QueryException {
        Class clazz;
        Object object;
        Vector vector = ((ExpressionQueryMechanism)readAllQuery.getQueryMechanism()).selectAllRowsFromTable();
        Vector<Class> vector2 = new Vector<Class>();
        Object object2 = vector.elements();
        while (object2.hasMoreElements()) {
            object = (DatabaseRow)object2.nextElement();
            clazz = this.classFromRow((DatabaseRow)object, readAllQuery.getSession());
            if (vector2.contains(clazz)) continue;
            vector2.addElement(clazz);
        }
        object2 = new Vector();
        object = vector2.elements();
        while (object.hasMoreElements()) {
            clazz = (Class)object.nextElement();
            Descriptor descriptor = readAllQuery.getSession().getDescriptor(clazz);
            if (descriptor == null) {
                throw QueryException.noDescriptorForClassFromInheritancePolicy(readAllQuery, clazz);
            }
            ReadAllQuery readAllQuery2 = (ReadAllQuery)readAllQuery.clone();
            readAllQuery2.setReferenceClass(clazz);
            readAllQuery2.setDescriptor(descriptor);
            Vector vector3 = ((ExpressionQueryMechanism)readAllQuery2.getQueryMechanism()).selectAllRowsFromConcreteTable();
            object2 = Helper.concatenateVectors((Vector)object2, vector3);
        }
        return object2;
    }

    public Vector selectAllRowUsingMultipleTableSubclassRead(ReadAllQuery readAllQuery) throws DatabaseException {
        if (this.hasClassExtractor()) {
            return this.selectAllRowUsingCustomMultipleTableSubclassRead(readAllQuery);
        }
        return this.selectAllRowUsingDefaultMultipleTableSubclassRead(readAllQuery);
    }

    protected DatabaseRow selectOneRowUsingCustomMultipleTableSubclassRead(ReadObjectQuery readObjectQuery) throws DatabaseException {
        Cloneable cloneable;
        Object object;
        if (this.getOnlyInstancesExpression() != null || !this.shouldReadSubclasses()) {
            object = (ReadObjectQuery)readObjectQuery.clone();
            ((ObjectLevelReadQuery)object).setReferenceClass(this.getDescriptor().getJavaClass());
            ((DatabaseQuery)object).setDescriptor(this.getDescriptor());
            cloneable = ((ExpressionQueryMechanism)((DatabaseQuery)object).getQueryMechanism()).selectOneRowFromConcreteTable();
            if (cloneable != null) {
                return cloneable;
            }
        }
        object = this.getChildDescriptors().elements();
        while (object.hasMoreElements()) {
            cloneable = (Descriptor)object.nextElement();
            DatabaseRow databaseRow = cloneable.getInheritancePolicy().selectOneRowUsingCustomMultipleTableSubclassRead(readObjectQuery);
            if (databaseRow == null) continue;
            return databaseRow;
        }
        return null;
    }

    protected DatabaseRow selectOneRowUsingDefaultMultipleTableSubclassRead(ReadObjectQuery readObjectQuery) throws DatabaseException, QueryException {
        DatabaseRow databaseRow = ((ExpressionQueryMechanism)readObjectQuery.getQueryMechanism()).selectOneRowFromTable();
        if (databaseRow == null) {
            return null;
        }
        Class clazz = this.classFromRow(databaseRow, readObjectQuery.getSession());
        Descriptor descriptor = readObjectQuery.getSession().getDescriptor(clazz);
        if (descriptor == null) {
            throw QueryException.noDescriptorForClassFromInheritancePolicy(readObjectQuery, clazz);
        }
        ReadObjectQuery readObjectQuery2 = (ReadObjectQuery)readObjectQuery.clone();
        readObjectQuery2.setReferenceClass(clazz);
        readObjectQuery2.setDescriptor(descriptor);
        DatabaseRow databaseRow2 = ((ExpressionQueryMechanism)readObjectQuery2.getQueryMechanism()).selectOneRowFromConcreteTable();
        return databaseRow2;
    }

    public DatabaseRow selectOneRowUsingMultipleTableSubclassRead(ReadObjectQuery readObjectQuery) throws DatabaseException, QueryException {
        if (this.hasClassExtractor()) {
            return this.selectOneRowUsingCustomMultipleTableSubclassRead(readObjectQuery);
        }
        return this.selectOneRowUsingDefaultMultipleTableSubclassRead(readObjectQuery);
    }

    protected void setAllChildClassIndicators(Vector vector) {
        this.allChildClassIndicators = vector;
    }

    public void setChildDescriptors(Vector vector) {
        this.childDescriptors = vector;
    }

    public void setClassExtractionMethodName(String string) {
        if (string == null || string.length() == 0) {
            return;
        }
        if (!(this.getClassExtractor() instanceof MethodClassExtractor)) {
            this.setClassExtractor(new MethodClassExtractor());
        }
        ((MethodClassExtractor)this.getClassExtractor()).setClassExtractionMethodName(string);
    }

    public void setClassIndicatorAssociations(Vector vector) {
        this.setClassNameIndicatorMapping(new HashMap(vector.size() + 1));
        this.setClassIndicatorMapping(new HashMap(vector.size() * 2 + 1));
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            Association association = (Association)enumeration.nextElement();
            Object object = association.getKey();
            if (object instanceof Class) {
                this.addClassIndicator((Class)association.getKey(), association.getValue());
                continue;
            }
            this.addClassNameIndicator((String)association.getKey(), association.getValue());
        }
    }

    public void setClassIndicatorField(DatabaseField databaseField) {
        this.classIndicatorField = databaseField;
    }

    public void setClassIndicatorFieldName(String string) {
        if (string == null) {
            this.setClassIndicatorField(null);
        } else {
            this.setClassIndicatorField(new DatabaseField(string));
        }
    }

    public void setClassIndicatorMapping(Map map) {
        this.classIndicatorMapping = map;
    }

    public void setClassNameIndicatorMapping(Map map) {
        this.classNameIndicatorMapping = map;
    }

    protected void setDescriptor(Descriptor descriptor) {
        this.descriptor = descriptor;
    }

    protected void setHasMultipleTableChild(boolean bl) {
        this.hasMultipleTableChild = bl;
    }

    public void setOnlyInstancesExpression(Expression expression) {
        this.onlyInstancesExpression = expression;
    }

    public void setParentClass(Class clazz) {
        this.parentClass = clazz;
        if (clazz != null) {
            this.setParentClassName(clazz.getName());
        }
    }

    public void setParentClassName(String string) {
        this.parentClassName = string;
    }

    public void setParentDescriptor(Descriptor descriptor) {
        this.parentDescriptor = descriptor;
    }

    protected void setReadAllSubclassesView(DatabaseTable databaseTable) {
        this.readAllSubclassesView = databaseTable;
    }

    public void setReadAllSubclassesViewName(String string) {
        if (string == null) {
            this.setReadAllSubclassesView(null);
        } else {
            this.setReadAllSubclassesView(new DatabaseTable(string));
        }
    }

    public void setShouldReadSubclasses(Boolean bl) {
        this.shouldReadSubclasses = bl;
    }

    public void setShouldReadSubclasses(boolean bl) {
        this.shouldReadSubclasses = new Boolean(bl);
    }

    public void setShouldUseClassNameAsIndicator(boolean bl) {
        this.shouldUseClassNameAsIndicator = bl;
    }

    public void setAlwaysUseOuterJoinForClassType(boolean bl) {
        this.shouldAlwaysUseOuterJoin = bl;
    }

    public void setWithAllSubclassesExpression(Expression expression) {
        this.withAllSubclassesExpression = expression;
    }

    public void setUseDescriptorsToValidateInheritedObjects(boolean bl) {
        this.useDescriptorsToValidateInheritedObjects = bl;
    }

    public boolean shouldReadSubclasses() {
        if (this.shouldReadSubclasses == null) {
            return true;
        }
        return this.shouldReadSubclasses;
    }

    public Boolean shouldReadSubclassesValue() {
        return this.shouldReadSubclasses;
    }

    public boolean shouldAlwaysUseOuterJoin() {
        return this.shouldAlwaysUseOuterJoin;
    }

    public boolean shouldUseClassNameAsIndicator() {
        return this.shouldUseClassNameAsIndicator;
    }

    public String toString() {
        return Helper.getShortClassName(this.getClass()) + "(" + this.getDescriptor() + ")";
    }

    public void useClassNameAsIndicator() {
        this.setShouldUseClassNameAsIndicator(true);
    }
}

