/*
 * Decompiled with CFR 0.152.
 */
package oracle.toplink.publicinterface;

import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Iterator;
import java.util.Vector;
import oracle.toplink.descriptors.DescriptorEvent;
import oracle.toplink.exceptions.DescriptorException;
import oracle.toplink.internal.descriptors.ObsoleteDescriptorEventAdapter;
import oracle.toplink.internal.helper.ClassConstants;
import oracle.toplink.internal.helper.Helper;
import oracle.toplink.internal.helper.NonSynchronizedVector;
import oracle.toplink.internal.security.PrivilegedAccessController;
import oracle.toplink.publicinterface.Descriptor;
import oracle.toplink.publicinterface.DescriptorEventListener;
import oracle.toplink.publicinterface.Session;

public class DescriptorEventManager
implements Cloneable,
Serializable {
    protected Descriptor descriptor;
    protected Vector eventSelectors = NonSynchronizedVector.newInstance(18);
    protected transient Vector eventMethods = NonSynchronizedVector.newInstance(18);
    protected transient Vector eventListeners;
    protected boolean hasAnyEventListeners = false;
    public static final int PreWriteEvent = 0;
    public static final int PostWriteEvent = 1;
    public static final int PreDeleteEvent = 2;
    public static final int PostDeleteEvent = 3;
    public static final int PreInsertEvent = 4;
    public static final int PostInsertEvent = 5;
    public static final int PreUpdateEvent = 6;
    public static final int PostUpdateEvent = 7;
    public static final int PostBuildEvent = 8;
    public static final int PostRefreshEvent = 9;
    public static final int PostCloneEvent = 10;
    public static final int PostMergeEvent = 11;
    public static final int AboutToInsertEvent = 12;
    public static final int AboutToUpdateEvent = 13;
    public static final int AboutToDeleteEvent = 14;
    public static final int PrePersistEvent = 15;
    public static final int PreRemoveEvent = 16;
    public static final int PreUpdateWithChangesEvent = 17;
    protected static final int NumberOfEvents = 18;
    static /* synthetic */ Class class$oracle$toplink$descriptors$DescriptorEventListener;
    static /* synthetic */ Class class$oracle$toplink$publicinterface$DescriptorEventListener;

    public DescriptorEventManager() {
        for (int i = 0; i < 18; ++i) {
            this.eventSelectors.addElement(null);
            this.eventMethods.addElement(null);
        }
    }

    protected void setHasAnyEventListeners(boolean bl) {
        this.hasAnyEventListeners = bl;
    }

    public boolean hasAnyEventListeners() {
        return this.hasAnyEventListeners || this.hasAnyListeners();
    }

    public void addListener(Object object) {
        if (object instanceof oracle.toplink.descriptors.DescriptorEventListener) {
            this.addListener((oracle.toplink.descriptors.DescriptorEventListener)object);
        } else if (object instanceof DescriptorEventListener) {
            this.addListener(new ObsoleteDescriptorEventAdapter((DescriptorEventListener)object));
        }
    }

    public void addListener(oracle.toplink.descriptors.DescriptorEventListener descriptorEventListener) {
        this.getEventListeners().addElement(descriptorEventListener);
        this.setHasAnyEventListeners(true);
    }

    public Object clone() {
        DescriptorEventManager descriptorEventManager = null;
        try {
            descriptorEventManager = (DescriptorEventManager)super.clone();
            descriptorEventManager.setEventSelectors((Vector)this.getEventSelectors().clone());
            descriptorEventManager.setEventMethods((Vector)this.getEventMethods().clone());
            descriptorEventManager.setEventListeners(this.getEventListeners());
        }
        catch (Exception exception) {
            // empty catch block
        }
        return descriptorEventManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void executeEvent(DescriptorEvent descriptorEvent) throws DescriptorException {
        try {
            descriptorEvent.getSession().startOperationProfile("DescriptorEvents");
            descriptorEvent.setDescriptor(this.getDescriptor());
            this.notifyListeners(descriptorEvent);
            if (descriptorEvent.getSource() instanceof oracle.toplink.descriptors.DescriptorEventListener) {
                this.notifyListener((oracle.toplink.descriptors.DescriptorEventListener)descriptorEvent.getSource(), descriptorEvent);
                return;
            }
            if (descriptorEvent.getSource() instanceof DescriptorEventListener) {
                this.notifyListener(new ObsoleteDescriptorEventAdapter((DescriptorEventListener)descriptorEvent.getSource()), descriptorEvent);
                return;
            }
            Method method = (Method)this.getEventMethods().elementAt(descriptorEvent.getEventCode());
            if (method == null) {
                return;
            }
            try {
                Object[] objectArray = new Object[]{descriptorEvent};
                PrivilegedAccessController.invokeMethod(method, descriptorEvent.getSource(), objectArray);
            }
            catch (IllegalAccessException illegalAccessException) {
                throw DescriptorException.illegalAccessWhileEventExecution(method.getName(), this.getDescriptor(), illegalAccessException);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                this.executeObsoleteEvent(descriptorEvent);
                descriptorEvent.getSession().endOperationProfile("DescriptorEvents");
                return;
            }
            catch (InvocationTargetException invocationTargetException) {
                throw DescriptorException.targetInvocationWhileEventExecution(method.getName(), this.getDescriptor(), invocationTargetException);
            }
        }
        finally {
            descriptorEvent.getSession().endOperationProfile("DescriptorEvents");
        }
    }

    protected void executeObsoleteEvent(DescriptorEvent descriptorEvent) throws DescriptorException {
        Method method = (Method)this.getEventMethods().elementAt(descriptorEvent.getEventCode());
        if (method == null) {
            return;
        }
        descriptorEvent.getSession().startOperationProfile("DescriptorEvents");
        try {
            Object[] objectArray = new Object[]{descriptorEvent.getSession()};
            PrivilegedAccessController.invokeMethod(method, descriptorEvent.getSource(), objectArray);
            descriptorEvent.getSession().endOperationProfile("DescriptorEvents");
        }
        catch (IllegalAccessException illegalAccessException) {
            throw DescriptorException.illegalAccessWhileObsoleteEventExecute(method.getName(), this.getDescriptor(), illegalAccessException);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw DescriptorException.illegalArgumentWhileObsoleteEventExecute(method.getName(), this.getDescriptor(), illegalArgumentException);
        }
        catch (InvocationTargetException invocationTargetException) {
            throw DescriptorException.targetInvocationWhileObsoleteEventExecute(method.getName(), this.getDescriptor(), invocationTargetException);
        }
    }

    protected Method findMethod(int n) throws DescriptorException {
        Class[] classArray = new Class[]{ClassConstants.DescriptorEvent_Class};
        String string = (String)this.getEventSelectors().elementAt(n);
        try {
            return Helper.getDeclaredMethod(this.getDescriptor().getJavaClass(), string, classArray);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            classArray[0] = ClassConstants.OldDescriptorEvent_Class;
            try {
                return Helper.getDeclaredMethod(this.getDescriptor().getJavaClass(), string, classArray);
            }
            catch (NoSuchMethodException noSuchMethodException2) {
                return this.findObsoleteMethod(n);
            }
        }
        catch (SecurityException securityException) {
            throw DescriptorException.securityOnFindMethod(string, this.getDescriptor(), securityException);
        }
    }

    protected Method findObsoleteMethod(int n) throws DescriptorException {
        Class[] classArray = new Class[]{ClassConstants.PublicInterfaceSession_Class};
        String string = (String)this.getEventSelectors().elementAt(n);
        try {
            return Helper.getDeclaredMethod(this.getDescriptor().getJavaClass(), string, classArray);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throw DescriptorException.noSuchMethodOnFindObsoleteMethod(string, this.getDescriptor(), noSuchMethodException);
        }
        catch (SecurityException securityException) {
            throw DescriptorException.securityOnFindObsoleteMethod(string, this.getDescriptor(), securityException);
        }
    }

    public String getAboutToInsertSelector() {
        return (String)this.getEventSelectors().elementAt(12);
    }

    public String getAboutToUpdateSelector() {
        return (String)this.getEventSelectors().elementAt(13);
    }

    protected Descriptor getDescriptor() {
        return this.descriptor;
    }

    public Vector getEventListeners() {
        if (this.eventListeners == null) {
            this.eventListeners = NonSynchronizedVector.newInstance(1);
        }
        return this.eventListeners;
    }

    protected Vector getEventMethods() {
        if (this.eventMethods == null) {
            this.eventMethods = NonSynchronizedVector.newInstance(18);
            for (int i = 0; i < 18; ++i) {
                this.eventMethods.addElement(null);
            }
        }
        return this.eventMethods;
    }

    protected Vector getEventSelectors() {
        if (this.eventSelectors == null) {
            this.eventSelectors = NonSynchronizedVector.newInstance(18);
            for (int i = 0; i < 18; ++i) {
                this.eventSelectors.addElement(null);
            }
        }
        return this.eventSelectors;
    }

    public String getPostBuildSelector() {
        return (String)this.getEventSelectors().elementAt(8);
    }

    public String getPostCloneSelector() {
        return (String)this.getEventSelectors().elementAt(10);
    }

    public String getPostDeleteSelector() {
        return (String)this.getEventSelectors().elementAt(3);
    }

    public String getPostInsertSelector() {
        return (String)this.getEventSelectors().elementAt(5);
    }

    public String getPostMergeSelector() {
        return (String)this.getEventSelectors().elementAt(11);
    }

    public String getPostRefreshSelector() {
        return (String)this.getEventSelectors().elementAt(9);
    }

    public String getPostUpdateSelector() {
        return (String)this.getEventSelectors().elementAt(7);
    }

    public String getPostWriteSelector() {
        return (String)this.getEventSelectors().elementAt(1);
    }

    public String getPrePersistSelector() {
        return (String)this.getEventSelectors().elementAt(15);
    }

    public String getPreDeleteSelector() {
        return (String)this.getEventSelectors().elementAt(2);
    }

    public String getPreInsertSelector() {
        return (String)this.getEventSelectors().elementAt(4);
    }

    public String getPreRemoveSelector() {
        return (String)this.getEventSelectors().elementAt(16);
    }

    public String getPreUpdateSelector() {
        return (String)this.getEventSelectors().elementAt(6);
    }

    public String getPreWriteSelector() {
        return (String)this.getEventSelectors().elementAt(0);
    }

    protected boolean hasAnyListeners() {
        return this.eventListeners != null && !this.eventListeners.isEmpty();
    }

    public void initialize(Session session) {
        if (this.hasAnyListeners() || (class$oracle$toplink$descriptors$DescriptorEventListener == null ? (class$oracle$toplink$descriptors$DescriptorEventListener = DescriptorEventManager.class$("oracle.toplink.descriptors.DescriptorEventListener")) : class$oracle$toplink$descriptors$DescriptorEventListener).isAssignableFrom(this.getDescriptor().getJavaClass()) || (class$oracle$toplink$publicinterface$DescriptorEventListener == null ? (class$oracle$toplink$publicinterface$DescriptorEventListener = DescriptorEventManager.class$("oracle.toplink.publicinterface.DescriptorEventListener")) : class$oracle$toplink$publicinterface$DescriptorEventListener).isAssignableFrom(this.getDescriptor().getJavaClass())) {
            this.setHasAnyEventListeners(true);
        }
        for (int i = 0; i < 18; ++i) {
            if (this.getEventSelectors().elementAt(i) == null) continue;
            this.setHasAnyEventListeners(true);
            this.getEventMethods().setElementAt(this.findMethod(i), i);
        }
        if (this.getDescriptor().isChildDescriptor()) {
            DescriptorEventManager descriptorEventManager = this.getDescriptor().getInheritancePolicy().getParentDescriptor().getEventManager();
            for (int i = 0; i < 18; ++i) {
                if (this.getEventSelectors().elementAt(i) != null) continue;
                this.setHasAnyEventListeners(true);
                this.getEventSelectors().setElementAt(descriptorEventManager.getEventSelectors().elementAt(i), i);
                this.getEventMethods().setElementAt(descriptorEventManager.getEventMethods().elementAt(i), i);
            }
        }
    }

    protected void notifyListener(oracle.toplink.descriptors.DescriptorEventListener descriptorEventListener, DescriptorEvent descriptorEvent) throws DescriptorException {
        switch (descriptorEvent.getEventCode()) {
            case 0: {
                descriptorEventListener.preWrite(descriptorEvent);
                break;
            }
            case 1: {
                descriptorEventListener.postWrite(descriptorEvent);
                break;
            }
            case 2: {
                descriptorEventListener.preDelete(descriptorEvent);
                break;
            }
            case 3: {
                descriptorEventListener.postDelete(descriptorEvent);
                break;
            }
            case 4: {
                descriptorEventListener.preInsert(descriptorEvent);
                break;
            }
            case 5: {
                descriptorEventListener.postInsert(descriptorEvent);
                break;
            }
            case 6: {
                descriptorEventListener.preUpdate(descriptorEvent);
                break;
            }
            case 7: {
                descriptorEventListener.postUpdate(descriptorEvent);
                break;
            }
            case 11: {
                descriptorEventListener.postMerge(descriptorEvent);
                break;
            }
            case 10: {
                descriptorEventListener.postClone(descriptorEvent);
                break;
            }
            case 8: {
                descriptorEventListener.postBuild(descriptorEvent);
                break;
            }
            case 9: {
                descriptorEventListener.postRefresh(descriptorEvent);
                break;
            }
            case 12: {
                descriptorEventListener.aboutToInsert(descriptorEvent);
                break;
            }
            case 13: {
                descriptorEventListener.aboutToUpdate(descriptorEvent);
                break;
            }
            case 14: {
                descriptorEventListener.aboutToDelete(descriptorEvent);
                break;
            }
            case 15: {
                descriptorEventListener.prePersist(descriptorEvent);
                break;
            }
            case 16: {
                descriptorEventListener.preRemove(descriptorEvent);
                break;
            }
            case 17: {
                descriptorEventListener.preUpdateWithChanges(descriptorEvent);
                break;
            }
            default: {
                throw DescriptorException.invalidDescriptorEventCode(descriptorEvent, this.getDescriptor());
            }
        }
    }

    public void notifyListeners(DescriptorEvent descriptorEvent) {
        if (this.hasAnyListeners()) {
            for (int i = 0; i < this.getEventListeners().size(); ++i) {
                oracle.toplink.descriptors.DescriptorEventListener descriptorEventListener = (oracle.toplink.descriptors.DescriptorEventListener)this.getEventListeners().get(i);
                this.notifyListener(descriptorEventListener, descriptorEvent);
            }
        }
        if (this.getDescriptor().isChildDescriptor()) {
            this.getDescriptor().getInheritancePolicy().getParentDescriptor().getEventManager().notifyListeners(descriptorEvent);
        }
    }

    public void remoteInitialization(Session session) {
        this.eventMethods = new Vector(18);
        for (int i = 0; i < 18; ++i) {
            this.eventMethods.addElement(null);
        }
        this.initialize(session);
    }

    public void removeListener(oracle.toplink.descriptors.DescriptorEventListener descriptorEventListener) {
        this.getEventListeners().removeElement(descriptorEventListener);
    }

    public void removeListener(Object object) {
        if (object instanceof oracle.toplink.descriptors.DescriptorEventListener) {
            this.removeListener((oracle.toplink.descriptors.DescriptorEventListener)object);
        } else {
            Iterator iterator = this.getEventListeners().iterator();
            while (iterator.hasNext()) {
                Object e = iterator.next();
                if (!(e instanceof ObsoleteDescriptorEventAdapter) || !((ObsoleteDescriptorEventAdapter)e).getListener().equals(object)) continue;
                this.getEventListeners().removeElement(object);
                break;
            }
        }
    }

    public void setAboutToInsertSelector(String string) {
        this.getEventSelectors().setElementAt(string, 12);
    }

    public void setAboutToUpdateSelector(String string) {
        this.getEventSelectors().setElementAt(string, 13);
    }

    public void setDescriptor(Descriptor descriptor) {
        this.descriptor = descriptor;
    }

    protected void setEventListeners(Vector vector) {
        this.eventListeners = vector;
    }

    protected void setEventMethods(Vector vector) {
        this.eventMethods = vector;
    }

    protected void setEventSelectors(Vector vector) {
        this.eventSelectors = vector;
    }

    public void setPostBuildSelector(String string) {
        this.getEventSelectors().setElementAt(string, 8);
    }

    public void setPostCloneSelector(String string) {
        this.getEventSelectors().setElementAt(string, 10);
    }

    public void setPostDeleteSelector(String string) {
        this.getEventSelectors().setElementAt(string, 3);
    }

    public void setPostInsertSelector(String string) {
        this.getEventSelectors().setElementAt(string, 5);
    }

    public void setPostMergeSelector(String string) {
        this.getEventSelectors().setElementAt(string, 11);
    }

    public void setPostRefreshSelector(String string) {
        this.getEventSelectors().setElementAt(string, 9);
    }

    public void setPostUpdateSelector(String string) {
        this.getEventSelectors().setElementAt(string, 7);
    }

    public void setPostWriteSelector(String string) {
        this.getEventSelectors().setElementAt(string, 1);
    }

    public void setPreDeleteSelector(String string) {
        this.getEventSelectors().setElementAt(string, 2);
    }

    public void setPrePersistSelector(String string) {
        this.getEventSelectors().setElementAt(string, 15);
    }

    public void setPreInsertSelector(String string) {
        this.getEventSelectors().setElementAt(string, 4);
    }

    public void setPreRemoveSelector(String string) {
        this.getEventSelectors().setElementAt(string, 16);
    }

    public void setPreUpdateSelector(String string) {
        this.getEventSelectors().setElementAt(string, 6);
    }

    public void setPreWriteSelector(String string) {
        this.getEventSelectors().setElementAt(string, 0);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

