/*
 * Decompiled with CFR 0.152.
 */
package oracle.toplink.publicinterface;

import java.util.EventObject;
import oracle.toplink.exceptions.DescriptorException;
import oracle.toplink.exceptions.ValidationException;
import oracle.toplink.internal.sessions.ObjectChangeSet;
import oracle.toplink.internal.sessions.UnitOfWorkChangeSet;
import oracle.toplink.mappings.DatabaseMapping;
import oracle.toplink.publicinterface.DatabaseRow;
import oracle.toplink.publicinterface.Descriptor;
import oracle.toplink.publicinterface.Session;
import oracle.toplink.publicinterface.UnitOfWork;
import oracle.toplink.queryframework.DatabaseQuery;
import oracle.toplink.queryframework.ObjectLevelModifyQuery;

public class DescriptorEvent
extends EventObject {
    protected int eventCode;
    protected DatabaseQuery query;
    protected DatabaseRow row;
    protected Descriptor descriptor;
    protected Object originalObject;
    protected ObjectChangeSet changeSet;
    protected Session session;
    protected static String[] eventNames = new String[18];

    public DescriptorEvent(int n, ObjectLevelModifyQuery objectLevelModifyQuery) {
        this(objectLevelModifyQuery.getObject());
        this.query = objectLevelModifyQuery;
        this.eventCode = n;
        this.session = objectLevelModifyQuery.getSession();
        this.descriptor = objectLevelModifyQuery.getDescriptor();
    }

    public DescriptorEvent(Object object) {
        super(object);
    }

    public void applyAttributeValuesIntoRow(String string) {
        Descriptor descriptor = this.getSession().getDescriptor(this.getSource());
        DatabaseMapping databaseMapping = descriptor.getMappingForAttributeName(string);
        if (databaseMapping == null) {
            throw ValidationException.missingMappingForAttribute(descriptor, string, this.toString());
        }
        if (this.getRow() != null) {
            databaseMapping.writeFromObjectIntoRow(this.getSource(), this.getRow(), this.getSession());
        }
    }

    public ObjectChangeSet getChangeSet() {
        return this.changeSet;
    }

    public Descriptor getDescriptor() {
        return this.descriptor;
    }

    public int getEventCode() {
        return this.eventCode;
    }

    public Object getObject() {
        return this.getSource();
    }

    public Object getOriginalObject() {
        if (this.originalObject == null && this.getSession().isUnitOfWork() && this.getQuery() != null && this.getQuery().isObjectLevelModifyQuery()) {
            this.setOriginalObject(((UnitOfWork)this.getSession()).getOriginalVersionOfObject(this.getSource()));
        }
        return this.originalObject;
    }

    public DatabaseQuery getQuery() {
        return this.query;
    }

    public DatabaseRow getRow() {
        return this.row;
    }

    public Session getSession() {
        return this.session;
    }

    public void setChangeSet(ObjectChangeSet objectChangeSet) {
        this.changeSet = objectChangeSet;
    }

    public void setDescriptor(Descriptor descriptor) {
        this.descriptor = descriptor;
    }

    public void setEventCode(int n) {
        this.eventCode = n;
    }

    public void setOriginalObject(Object object) {
        this.originalObject = object;
    }

    public void setQuery(DatabaseQuery databaseQuery) {
        this.query = databaseQuery;
    }

    public void setRow(DatabaseRow databaseRow) {
        this.row = databaseRow;
    }

    public void setSession(Session session) {
        this.session = session;
    }

    public String toString() {
        String string = "UnkownEvent";
        if (this.getEventCode() >= 0 && this.getEventCode() < 18) {
            string = eventNames[this.getEventCode()];
        }
        return string + "(" + this.getSource().getClass() + ")";
    }

    public void updateAttributeWithObject(String string, Object object) {
        Descriptor descriptor;
        DatabaseMapping databaseMapping = this.query.getDescriptor().getMappingForAttributeName(string);
        if (databaseMapping == null) {
            throw DescriptorException.mappingForAttributeIsMissing(string, this.getDescriptor());
        }
        Object object2 = this.getObject();
        Object object3 = object;
        Object object4 = null;
        if (this.eventCode == 10 || this.eventCode == 11) {
            object4 = this.getOriginalObject();
        }
        Object object5 = object;
        ObjectChangeSet objectChangeSet = this.getChangeSet();
        Object object6 = object;
        if (this.query != null && this.query.isObjectLevelModifyQuery()) {
            object2 = ((ObjectLevelModifyQuery)this.query).getObject();
            objectChangeSet = ((ObjectLevelModifyQuery)this.query).getObjectChangeSet();
        }
        if ((descriptor = this.getSession().getDescriptor(object.getClass())) != null) {
            if (objectChangeSet != null) {
                object6 = descriptor.getObjectBuilder().createObjectChangeSet(object, (UnitOfWorkChangeSet)objectChangeSet.getUOWChangeSet(), this.getSession());
            }
            if (object4 != null) {
                object5 = ((UnitOfWork)this.getSession()).getOriginalVersionOfObject(object);
            }
        }
        if (object2 != null) {
            databaseMapping.setRealAttributeValueInObject(object2, object3);
        }
        if (object4 != null) {
            databaseMapping.setRealAttributeValueInObject(object4, object5);
        }
        if (this.row != null) {
            DatabaseRow databaseRow = new DatabaseRow();
            databaseMapping.writeFromObjectIntoRow(object2, databaseRow, this.getSession());
            this.row.mergeFrom(databaseRow);
        }
        if (objectChangeSet != null) {
            objectChangeSet.removeChange(string);
            objectChangeSet.addChange(databaseMapping.compareForChange(object2, ((UnitOfWork)this.getSession()).getBackupClone(object2), objectChangeSet, this.getSession()));
        }
    }

    public void updateAttributeAddObjectToCollection(String string, Object object, Object object2) {
        Object object3;
        Descriptor descriptor;
        DatabaseMapping databaseMapping = this.query.getDescriptor().getMappingForAttributeName(string);
        if (databaseMapping == null) {
            throw DescriptorException.mappingForAttributeIsMissing(string, this.getDescriptor());
        }
        Object object4 = this.getObject();
        Object object5 = object2;
        Object object6 = null;
        if (this.eventCode == 10 || this.eventCode == 11) {
            object6 = this.getOriginalObject();
        }
        Object object7 = object2;
        ObjectChangeSet objectChangeSet = this.getChangeSet();
        Object object8 = object2;
        if (this.query != null && this.query.isObjectLevelModifyQuery()) {
            object4 = ((ObjectLevelModifyQuery)this.query).getObject();
            objectChangeSet = ((ObjectLevelModifyQuery)this.query).getObjectChangeSet();
        }
        if ((descriptor = this.getSession().getDescriptor(object2.getClass())) != null) {
            if (objectChangeSet != null) {
                object8 = descriptor.getObjectBuilder().createObjectChangeSet(object2, (UnitOfWorkChangeSet)objectChangeSet.getUOWChangeSet(), this.getSession());
            }
            if (object6 != null) {
                object7 = ((UnitOfWork)this.getSession()).getOriginalVersionOfObject(object2);
            }
        }
        if (object4 != null) {
            object3 = databaseMapping.getRealCollectionAttributeValueFromObject(object4, this.getSession());
            databaseMapping.getContainerPolicy().addInto(object, object5, object3, this.getSession());
        }
        if (object6 != null) {
            object3 = databaseMapping.getRealCollectionAttributeValueFromObject(object6, this.getSession());
            databaseMapping.getContainerPolicy().addInto(object, object7, object3, this.getSession());
        }
        if (this.row != null) {
            object3 = new DatabaseRow();
            databaseMapping.writeFromObjectIntoRow(object4, (DatabaseRow)object3, this.getSession());
            this.row.mergeFrom((DatabaseRow)object3);
        }
        if (objectChangeSet != null) {
            databaseMapping.simpleAddToCollectionChangeRecord(object, object8, objectChangeSet, this.getSession());
        }
    }

    public void updateAttributeRemoveObjectFromCollection(String string, Object object, Object object2) {
        Object object3;
        Descriptor descriptor;
        DatabaseMapping databaseMapping = this.query.getDescriptor().getMappingForAttributeName(string);
        if (databaseMapping == null) {
            throw DescriptorException.mappingForAttributeIsMissing(string, this.getDescriptor());
        }
        Object object4 = this.getObject();
        Object object5 = object2;
        Object object6 = null;
        if (this.eventCode == 10 || this.eventCode == 11) {
            object6 = this.getOriginalObject();
        }
        Object object7 = object2;
        ObjectChangeSet objectChangeSet = this.getChangeSet();
        Object object8 = object2;
        if (this.query != null && this.query.isObjectLevelModifyQuery()) {
            object4 = ((ObjectLevelModifyQuery)this.query).getObject();
            objectChangeSet = ((ObjectLevelModifyQuery)this.query).getObjectChangeSet();
        }
        if ((descriptor = this.getSession().getDescriptor(object2.getClass())) != null) {
            if (objectChangeSet != null) {
                object8 = descriptor.getObjectBuilder().createObjectChangeSet(object2, (UnitOfWorkChangeSet)objectChangeSet.getUOWChangeSet(), this.getSession());
            }
            if (object6 != null) {
                object7 = ((UnitOfWork)this.getSession()).getOriginalVersionOfObject(object2);
            }
        }
        if (object4 != null) {
            object3 = databaseMapping.getRealCollectionAttributeValueFromObject(object4, this.getSession());
            databaseMapping.getContainerPolicy().removeFrom(object, object5, object3, this.getSession());
        }
        if (object6 != null) {
            object3 = databaseMapping.getRealCollectionAttributeValueFromObject(object6, this.getSession());
            databaseMapping.getContainerPolicy().removeFrom(object, object7, object3, this.getSession());
        }
        if (this.row != null) {
            object3 = new DatabaseRow();
            databaseMapping.writeFromObjectIntoRow(object4, (DatabaseRow)object3, this.getSession());
            this.row.mergeFrom((DatabaseRow)object3);
        }
        if (objectChangeSet != null) {
            databaseMapping.simpleRemoveFromCollectionChangeRecord(object, object8, objectChangeSet, this.getSession());
        }
    }

    static {
        DescriptorEvent.eventNames[0] = "PreWriteEvent";
        DescriptorEvent.eventNames[1] = "PostWriteEvent";
        DescriptorEvent.eventNames[2] = "PostDeleteEvent";
        DescriptorEvent.eventNames[3] = "PostDeleteEvent";
        DescriptorEvent.eventNames[4] = "PreInsertEvent";
        DescriptorEvent.eventNames[5] = "PostInsertEvent";
        DescriptorEvent.eventNames[6] = "PreUpdateEvent";
        DescriptorEvent.eventNames[7] = "PostUpdateEvent";
        DescriptorEvent.eventNames[8] = "PostBuildEvent";
        DescriptorEvent.eventNames[9] = "PostRefreshEvent";
        DescriptorEvent.eventNames[10] = "PostCloneEvent";
        DescriptorEvent.eventNames[11] = "PostMergeEvent";
        DescriptorEvent.eventNames[12] = "AboutToInsertEvent";
        DescriptorEvent.eventNames[13] = "AboutToUpdateEvent";
    }
}

