/*
 * Decompiled with CFR 0.152.
 */
package oracle.toplink.platform.xml.jaxp;

import java.io.OutputStream;
import java.io.Writer;
import java.net.URL;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.sax.SAXResult;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import oracle.toplink.platform.xml.XMLPlatformException;
import oracle.toplink.platform.xml.XMLTransformer;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.xml.sax.ContentHandler;

public class JAXPTransformer
implements XMLTransformer {
    private boolean fragment;
    private static final String NO = "no";
    private static final String YES = "yes";
    private Transformer transformer;

    public JAXPTransformer() {
        try {
            TransformerFactory transformerFactory = TransformerFactory.newInstance();
            this.transformer = transformerFactory.newTransformer();
        }
        catch (TransformerConfigurationException transformerConfigurationException) {
            throw XMLPlatformException.xmlPlatformTransformException(transformerConfigurationException);
        }
    }

    public String getEncoding() {
        return this.transformer.getOutputProperty("encoding");
    }

    public void setEncoding(String string) {
        this.transformer.setOutputProperty("encoding", string);
    }

    public boolean isFormattedOutput() {
        return this.transformer.getOutputProperty("indent").equals(YES);
    }

    public void setFormattedOutput(boolean bl) {
        if (bl) {
            this.transformer.setOutputProperty("indent", YES);
        } else {
            this.transformer.setOutputProperty("indent", NO);
        }
    }

    public String getVersion() {
        return this.transformer.getOutputProperty("version");
    }

    public void setVersion(String string) {
        this.transformer.setOutputProperty("version", string);
    }

    public void transform(Node node, OutputStream outputStream) throws XMLPlatformException {
        DOMSource dOMSource = new DOMSource(node);
        StreamResult streamResult = new StreamResult(outputStream);
        if (this.isFragment()) {
            this.transformer.setOutputProperty("omit-xml-declaration", YES);
        }
        this.transform(dOMSource, (Result)streamResult);
    }

    public void transform(Node node, ContentHandler contentHandler) throws XMLPlatformException {
        DOMSource dOMSource = new DOMSource(node);
        SAXResult sAXResult = new SAXResult(contentHandler);
        this.transform(dOMSource, (Result)sAXResult);
    }

    public void transform(Node node, Result result) throws XMLPlatformException {
        DOMSource dOMSource = null;
        if (this.isFragment() && result instanceof SAXResult) {
            if (node instanceof Document) {
                dOMSource = new DOMSource(((Document)node).getDocumentElement());
            }
        } else {
            dOMSource = new DOMSource(node);
        }
        this.transform(dOMSource, result);
    }

    public void transform(Node node, Writer writer) throws XMLPlatformException {
        DOMSource dOMSource = new DOMSource(node);
        StreamResult streamResult = new StreamResult(writer);
        if (this.isFragment()) {
            this.transformer.setOutputProperty("omit-xml-declaration", YES);
        }
        this.transform(dOMSource, (Result)streamResult);
    }

    public void transform(Source source, Result result) throws XMLPlatformException {
        try {
            if (result instanceof StreamResult && this.isFragment()) {
                this.transformer.setOutputProperty("omit-xml-declaration", YES);
            }
            this.transformer.transform(source, result);
        }
        catch (TransformerException transformerException) {
            throw XMLPlatformException.xmlPlatformTransformException(transformerException);
        }
    }

    public void transform(Document document, Node node, URL uRL) throws XMLPlatformException {
        try {
            TransformerFactory transformerFactory = TransformerFactory.newInstance();
            StreamSource streamSource = new StreamSource(uRL.openStream());
            Transformer transformer = transformerFactory.newTransformer(streamSource);
            DOMSource dOMSource = new DOMSource(document);
            DOMResult dOMResult = new DOMResult(node);
            transformer.transform(dOMSource, dOMResult);
        }
        catch (Exception exception) {
            throw XMLPlatformException.xmlPlatformTransformException(exception);
        }
    }

    public void setFragment(boolean bl) {
        this.fragment = bl;
    }

    public boolean isFragment() {
        return this.fragment;
    }
}

