/*
 * Decompiled with CFR 0.152.
 */
package oracle.toplink.ox;

import oracle.toplink.exceptions.XMLMarshalException;
import oracle.toplink.internal.ox.XMLObjectBuilder;
import oracle.toplink.ox.XMLContext;
import oracle.toplink.ox.XMLDescriptor;
import oracle.toplink.ox.XMLMarshaller;
import oracle.toplink.ox.record.XMLRecord;
import oracle.toplink.platform.xml.XMLPlatform;
import oracle.toplink.platform.xml.XMLPlatformException;
import oracle.toplink.platform.xml.XMLPlatformFactory;
import oracle.toplink.publicinterface.Descriptor;
import org.w3c.dom.Document;
import org.xml.sax.ErrorHandler;

public class XMLValidator {
    public static final int NONVALIDATING = 0;
    public static final int SCHEMA_VALIDATION = 3;
    public static final int DTD_VALIDATION = 2;
    private XMLContext xmlContext;
    private XMLMarshaller marshaller;
    private ErrorHandler errorHandler;

    protected XMLValidator(XMLContext xMLContext) {
        this.xmlContext = xMLContext;
        this.marshaller = new XMLMarshaller(xMLContext);
    }

    public boolean validateRoot(Object object) throws XMLMarshalException {
        if (object == null) {
            throw XMLMarshalException.nullArgumentException();
        }
        Document document = this.marshaller.objectToXML(object);
        XMLDescriptor xMLDescriptor = (XMLDescriptor)this.xmlContext.getSession(object).getDescriptor(object);
        if (xMLDescriptor.getSchemaReference() == null) {
            throw XMLMarshalException.schemaReferenceNotSet(xMLDescriptor);
        }
        return xMLDescriptor.getSchemaReference().isValid(document, this.getErrorHandler());
    }

    public boolean validate(Object object) throws XMLMarshalException {
        if (object == null) {
            throw XMLMarshalException.nullArgumentException();
        }
        try {
            Object object2;
            String string = ((XMLDescriptor)this.xmlContext.getSession(object).getDescriptor(object)).getDefaultRootElement();
            if (string == null) {
                object2 = object.getClass().getName();
                int n = ((String)object2).lastIndexOf(46);
                string = ((String)object2).substring(n + 1);
            }
            object2 = this.marshaller.getDescriptor(object);
            XMLObjectBuilder xMLObjectBuilder = (XMLObjectBuilder)((Descriptor)object2).getObjectBuilder();
            XMLRecord xMLRecord = (XMLRecord)xMLObjectBuilder.createRecord(string);
            Document document = this.marshaller.objectToXML(object, (XMLDescriptor)object2, xMLRecord);
            XMLPlatform xMLPlatform = XMLPlatformFactory.getInstance().getXMLPlatform();
            return xMLPlatform.validate(xMLRecord.getDOM(), (XMLDescriptor)object2, this.getErrorHandler());
        }
        catch (XMLPlatformException xMLPlatformException) {
            throw XMLMarshalException.validateException(xMLPlatformException);
        }
    }

    public void setErrorHandler(ErrorHandler errorHandler) {
        this.errorHandler = errorHandler;
    }

    public ErrorHandler getErrorHandler() {
        return this.errorHandler;
    }
}

