/*
 * Decompiled with CFR 0.152.
 */
package oracle.toplink.ox;

import java.util.Vector;
import oracle.toplink.descriptors.ClassDescriptor;
import oracle.toplink.exceptions.DatabaseException;
import oracle.toplink.exceptions.DescriptorException;
import oracle.toplink.internal.helper.DatabaseField;
import oracle.toplink.internal.helper.DatabaseTable;
import oracle.toplink.internal.ox.QNameInheritancePolicy;
import oracle.toplink.internal.ox.TreeObjectBuilder;
import oracle.toplink.internal.ox.XMLObjectBuilder;
import oracle.toplink.mappings.DatabaseMapping;
import oracle.toplink.ox.NamespaceResolver;
import oracle.toplink.ox.XMLField;
import oracle.toplink.ox.mappings.XMLDirectMapping;
import oracle.toplink.ox.record.XMLRecord;
import oracle.toplink.ox.schema.XMLSchemaReference;
import oracle.toplink.publicinterface.DatabaseRow;
import oracle.toplink.publicinterface.InheritancePolicy;
import oracle.toplink.publicinterface.Session;
import oracle.toplink.sessions.Record;

public class XMLDescriptor
extends ClassDescriptor {
    private NamespaceResolver namespaceResolver;
    private XMLSchemaReference schemaReference;
    private boolean shouldPreserveDocument = false;

    public XMLDescriptor() {
        this.shouldOrderMappings = false;
        this.descriptorIsAggregate();
    }

    public String getDefaultRootElement() {
        if (this.getTables().isEmpty()) {
            return null;
        }
        return ((DatabaseTable)this.getTables().firstElement()).getName();
    }

    public boolean shouldPreserveDocument() {
        return this.shouldPreserveDocument;
    }

    public void setShouldPreserveDocument(boolean bl) {
        this.shouldPreserveDocument = bl;
    }

    public void setDefaultRootElement(String string) {
        if (string != null) {
            this.getTables().clear();
            this.addTableName(string);
        }
    }

    public NamespaceResolver getNamespaceResolver() {
        return this.namespaceResolver;
    }

    public InheritancePolicy getInheritancePolicy() {
        if (this.inheritancePolicy == null) {
            this.setInheritancePolicy(new QNameInheritancePolicy(this));
        }
        return this.inheritancePolicy;
    }

    public void setNamespaceResolver(NamespaceResolver namespaceResolver) {
        this.namespaceResolver = namespaceResolver;
    }

    public XMLSchemaReference getSchemaReference() {
        return this.schemaReference;
    }

    public void setSchemaReference(XMLSchemaReference xMLSchemaReference) {
        this.schemaReference = xMLSchemaReference;
    }

    protected void validateMappingType(DatabaseMapping databaseMapping) {
        if (!databaseMapping.isXMLMapping()) {
            throw DescriptorException.invalidMappingType(databaseMapping);
        }
    }

    public DatabaseRow buildNestedRowFromFieldValue(Object object) {
        if (object instanceof XMLRecord) {
            return (XMLRecord)object;
        }
        if (!(object instanceof Vector)) {
            return this.getObjectBuilder().createRecord();
        }
        Vector vector = (Vector)object;
        if (vector.isEmpty()) {
            return this.getObjectBuilder().createRecord();
        }
        if (!(vector.firstElement() instanceof Record)) {
            return this.getObjectBuilder().createRecord();
        }
        return (XMLRecord)vector.firstElement();
    }

    public Vector buildNestedRowsFromFieldValue(Object object, Session session) {
        if (!(object instanceof Vector)) {
            return new Vector(0);
        }
        return (Vector)object;
    }

    public DatabaseMapping addDirectMapping(String string, String string2) {
        XMLDirectMapping xMLDirectMapping = new XMLDirectMapping();
        xMLDirectMapping.setAttributeName(string);
        xMLDirectMapping.setXPath(string2);
        return this.addMapping(xMLDirectMapping);
    }

    public DatabaseMapping addDirectMapping(String string, String string2, String string3, String string4) {
        XMLDirectMapping xMLDirectMapping = new XMLDirectMapping();
        xMLDirectMapping.setAttributeName(string);
        xMLDirectMapping.setSetMethodName(string3);
        xMLDirectMapping.setGetMethodName(string2);
        xMLDirectMapping.setXPath(string4);
        return this.addMapping(xMLDirectMapping);
    }

    public Vector buildDirectValuesFromFieldValue(Object object) throws DatabaseException {
        if (!(object instanceof Vector)) {
            Vector<Object> vector = new Vector<Object>(1);
            vector.add(object);
            return vector;
        }
        return (Vector)object;
    }

    public Object buildFieldValueFromDirectValues(Vector vector, String string, Session session) throws DatabaseException {
        return vector;
    }

    public Object buildFieldValueFromNestedRows(Vector vector, String string, Session session) throws DatabaseException {
        return vector;
    }

    public DatabaseField buildField(String string) {
        XMLField xMLField = new XMLField(string);
        xMLField.setNamespaceResolver(this.getNamespaceResolver());
        return xMLField;
    }

    public void buildField(DatabaseField databaseField) {
        try {
            XMLField xMLField = (XMLField)databaseField;
            xMLField.setNamespaceResolver(this.getNamespaceResolver());
        }
        catch (ClassCastException classCastException) {
            return;
        }
    }

    public void initializeAggregateInheritancePolicy(Session session) {
    }

    public void initialize(Session session) throws DescriptorException {
        if (this.hasInheritance()) {
            ((QNameInheritancePolicy)this.getInheritancePolicy()).setNamespaceResolver(this.getNamespaceResolver());
        }
        if (this.shouldPreserveDocument()) {
            this.objectBuilder = new XMLObjectBuilder(this);
            super.initialize(session);
        } else {
            super.initialize(session);
            this.objectBuilder = new TreeObjectBuilder(this);
            this.objectBuilder.initialize(session);
        }
    }

    public boolean requiresInitialization() {
        return !this.isDescriptorForInterface();
    }

    protected DatabaseTable extractDefaultTable() {
        return new DatabaseTable();
    }
}

